/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Owners
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamOwnersType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamOwners extends VdmEntity<TeamOwners> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamOwnersType";
    /**
     * Selector for all available fields of TeamOwners.
     * 
     */
    public final static SimpleProperty<TeamOwners> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @return Global Team ID in Responsibility Mgmt.
     */
    @Nullable
    @ElementName( "RespyMgmtGlobalTeamID" )
    private java.lang.String respyMgmtGlobalTeamID;
    public final static SimpleProperty.String<TeamOwners> RESPY_MGMT_GLOBAL_TEAM_ID =
        new SimpleProperty.String<TeamOwners>(TeamOwners.class, "RespyMgmtGlobalTeamID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamOwnerType</b>
     * </p>
     * 
     * @return Team Owner Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamOwnerType" )
    private java.lang.String respyMgmtTeamOwnerType;
    public final static SimpleProperty.String<TeamOwners> RESPY_MGMT_TEAM_OWNER_TYPE =
        new SimpleProperty.String<TeamOwners>(TeamOwners.class, "RespyMgmtTeamOwnerType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamOwner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "ResponsibilityTeamOwner" )
    private java.lang.String responsibilityTeamOwner;
    public final static SimpleProperty.String<TeamOwners> RESPONSIBILITY_TEAM_OWNER =
        new SimpleProperty.String<TeamOwners>(TeamOwners.class, "ResponsibilityTeamOwner");
    /**
     * Navigation property <b>_TeamHeader</b> for <b>TeamOwners</b> to single <b>TeamHeaders</b>.
     * 
     */
    @ElementName( "_TeamHeader" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamHeaders to_TeamHeader;
    /**
     * Use with available request builders to apply the <b>_TeamHeader</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamOwners, TeamHeaders> TO__TEAM_HEADER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamOwners, TeamHeaders>(
            TeamOwners.class,
            "_TeamHeader",
            TeamHeaders.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamOwners> getType()
    {
        return TeamOwners.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final java.lang.String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamOwnerType</b>
     * </p>
     * 
     * @param respyMgmtTeamOwnerType
     *            Team Owner Type
     */
    public void setRespyMgmtTeamOwnerType( @Nullable final java.lang.String respyMgmtTeamOwnerType )
    {
        rememberChangedField("RespyMgmtTeamOwnerType", this.respyMgmtTeamOwnerType);
        this.respyMgmtTeamOwnerType = respyMgmtTeamOwnerType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibilityTeamOwner</b>
     * </p>
     * 
     * @param responsibilityTeamOwner
     *            Business Partner Number
     */
    public void setResponsibilityTeamOwner( @Nullable final java.lang.String responsibilityTeamOwner )
    {
        rememberChangedField("ResponsibilityTeamOwner", this.responsibilityTeamOwner);
        this.responsibilityTeamOwner = responsibilityTeamOwner;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamOwners";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        entityKey.addKeyProperty("RespyMgmtTeamOwnerType", getRespyMgmtTeamOwnerType());
        entityKey.addKeyProperty("ResponsibilityTeamOwner", getResponsibilityTeamOwner());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("RespyMgmtTeamOwnerType", getRespyMgmtTeamOwnerType());
        values.put("ResponsibilityTeamOwner", getResponsibilityTeamOwner());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamOwnerType") ) {
                final Object value = values.remove("RespyMgmtTeamOwnerType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamOwnerType())) ) {
                    setRespyMgmtTeamOwnerType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ResponsibilityTeamOwner") ) {
                final Object value = values.remove("ResponsibilityTeamOwner");
                if( (value == null) || (!value.equals(getResponsibilityTeamOwner())) ) {
                    setResponsibilityTeamOwner(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamHeader") ) {
                final Object value = (values).remove("_TeamHeader");
                if( value instanceof Map ) {
                    if( to_TeamHeader == null ) {
                        to_TeamHeader = new TeamHeaders();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamHeader.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamHeader != null ) {
            (values).put("_TeamHeader", to_TeamHeader);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamHeaders</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamHeader</b>.
     * <p>
     * If the navigation property for an entity <b>TeamOwners</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamHeader</b> is already loaded, the result will contain
     *         the <b>TeamHeaders</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamHeaders> getTeamHeaderIfPresent()
    {
        return Option.of(to_TeamHeader);
    }

    /**
     * Overwrites the associated <b>TeamHeaders</b> entity for the loaded navigation property <b>_TeamHeader</b>.
     * 
     * @param value
     *            New <b>TeamHeaders</b> entity.
     */
    public void setTeamHeader( final TeamHeaders value )
    {
        to_TeamHeader = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamOwners instances.
     * 
     */
    public final static class TeamOwnersBuilder
    {

        private TeamHeaders to_TeamHeader;

        private TeamOwners.TeamOwnersBuilder to_TeamHeader( final TeamHeaders value )
        {
            to_TeamHeader = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamHeader</b> for <b>TeamOwners</b> to single <b>TeamHeaders</b>.
         * 
         * @param value
         *            The TeamHeaders to build this TeamOwners with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamOwners.TeamOwnersBuilder teamHeader( final TeamHeaders value )
        {
            return to_TeamHeader(value);
        }

    }

}
