/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Team Status Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamStatusTextsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamStatusTexts extends VdmEntity<TeamStatusTexts> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamStatusTextsType";
    /**
     * Selector for all available fields of TeamStatusTexts.
     * 
     */
    public final static SimpleProperty<TeamStatusTexts> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatus</b>
     * </p>
     * 
     * @return Values for Domains: Single Value/Lower Limit
     */
    @Nullable
    @ElementName( "RespyMgmtTeamStatus" )
    private java.lang.String respyMgmtTeamStatus;
    public final static SimpleProperty.String<TeamStatusTexts> RESPY_MGMT_TEAM_STATUS =
        new SimpleProperty.String<TeamStatusTexts>(TeamStatusTexts.class, "RespyMgmtTeamStatus");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<TeamStatusTexts> LANGUAGE =
        new SimpleProperty.String<TeamStatusTexts>(TeamStatusTexts.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatusText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "RespyMgmtTeamStatusText" )
    private java.lang.String respyMgmtTeamStatusText;
    public final static SimpleProperty.String<TeamStatusTexts> RESPY_MGMT_TEAM_STATUS_TEXT =
        new SimpleProperty.String<TeamStatusTexts>(TeamStatusTexts.class, "RespyMgmtTeamStatusText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamStatusTexts> getType()
    {
        return TeamStatusTexts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatus</b>
     * </p>
     * 
     * @param respyMgmtTeamStatus
     *            Values for Domains: Single Value/Lower Limit
     */
    public void setRespyMgmtTeamStatus( @Nullable final java.lang.String respyMgmtTeamStatus )
    {
        rememberChangedField("RespyMgmtTeamStatus", this.respyMgmtTeamStatus);
        this.respyMgmtTeamStatus = respyMgmtTeamStatus;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamStatusText</b>
     * </p>
     * 
     * @param respyMgmtTeamStatusText
     *            Short Text for Fixed Values
     */
    public void setRespyMgmtTeamStatusText( @Nullable final java.lang.String respyMgmtTeamStatusText )
    {
        rememberChangedField("RespyMgmtTeamStatusText", this.respyMgmtTeamStatusText);
        this.respyMgmtTeamStatusText = respyMgmtTeamStatusText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamStatusTexts";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamStatus", getRespyMgmtTeamStatus());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamStatus", getRespyMgmtTeamStatus());
        values.put("Language", getLanguage());
        values.put("RespyMgmtTeamStatusText", getRespyMgmtTeamStatusText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamStatus") ) {
                final Object value = values.remove("RespyMgmtTeamStatus");
                if( (value == null) || (!value.equals(getRespyMgmtTeamStatus())) ) {
                    setRespyMgmtTeamStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamStatusText") ) {
                final Object value = values.remove("RespyMgmtTeamStatusText");
                if( (value == null) || (!value.equals(getRespyMgmtTeamStatusText())) ) {
                    setRespyMgmtTeamStatusText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

}
