/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Team Type Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamTypeTextsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamTypeTexts extends VdmEntity<TeamTypeTexts> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_respym_team_srv.v0001.TeamTypeTextsType";
    /**
     * Selector for all available fields of TeamTypeTexts.
     * 
     */
    public final static SimpleProperty<TeamTypeTexts> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @return Team Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamType" )
    private java.lang.String respyMgmtTeamType;
    public final static SimpleProperty.String<TeamTypeTexts> RESPY_MGMT_TEAM_TYPE =
        new SimpleProperty.String<TeamTypeTexts>(TeamTypeTexts.class, "RespyMgmtTeamType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<TeamTypeTexts> LANGUAGE =
        new SimpleProperty.String<TeamTypeTexts>(TeamTypeTexts.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamTypeText</b>
     * </p>
     * 
     * @return Team Type Description
     */
    @Nullable
    @ElementName( "RespyMgmtTeamTypeText" )
    private java.lang.String respyMgmtTeamTypeText;
    public final static SimpleProperty.String<TeamTypeTexts> RESPY_MGMT_TEAM_TYPE_TEXT =
        new SimpleProperty.String<TeamTypeTexts>(TeamTypeTexts.class, "RespyMgmtTeamTypeText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamTypeTexts> getType()
    {
        return TeamTypeTexts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @param respyMgmtTeamType
     *            Team Type
     */
    public void setRespyMgmtTeamType( @Nullable final java.lang.String respyMgmtTeamType )
    {
        rememberChangedField("RespyMgmtTeamType", this.respyMgmtTeamType);
        this.respyMgmtTeamType = respyMgmtTeamType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamTypeText</b>
     * </p>
     * 
     * @param respyMgmtTeamTypeText
     *            Team Type Description
     */
    public void setRespyMgmtTeamTypeText( @Nullable final java.lang.String respyMgmtTeamTypeText )
    {
        rememberChangedField("RespyMgmtTeamTypeText", this.respyMgmtTeamTypeText);
        this.respyMgmtTeamTypeText = respyMgmtTeamTypeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamTypeTexts";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamType", getRespyMgmtTeamType());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamType", getRespyMgmtTeamType());
        values.put("Language", getLanguage());
        values.put("RespyMgmtTeamTypeText", getRespyMgmtTeamTypeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamType") ) {
                final Object value = values.remove("RespyMgmtTeamType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamType())) ) {
                    setRespyMgmtTeamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamTypeText") ) {
                final Object value = values.remove("RespyMgmtTeamTypeText");
                if( (value == null) || (!value.equals(getRespyMgmtTeamTypeText())) ) {
                    setRespyMgmtTeamTypeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamService.DEFAULT_SERVICE_PATH;
    }

}
