/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Team Category Function Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamCategoryFunctionTextsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamCategoryFunctionTexts extends VdmEntity<TeamCategoryFunctionTexts> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamCategoryFunctionTextsType";
    /**
     * Selector for all available fields of TeamCategoryFunctionTexts.
     * 
     */
    public final static SimpleProperty<TeamCategoryFunctionTexts> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamCategoryFunctionTexts> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamCategoryFunctionTexts>(TeamCategoryFunctionTexts.class, "RespyMgmtTeamCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @return Function
     */
    @Nullable
    @ElementName( "RespyMgmtFunction" )
    private java.lang.String respyMgmtFunction;
    public final static SimpleProperty.String<TeamCategoryFunctionTexts> RESPY_MGMT_FUNCTION =
        new SimpleProperty.String<TeamCategoryFunctionTexts>(TeamCategoryFunctionTexts.class, "RespyMgmtFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<TeamCategoryFunctionTexts> LANGUAGE =
        new SimpleProperty.String<TeamCategoryFunctionTexts>(TeamCategoryFunctionTexts.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunctionText</b>
     * </p>
     * 
     * @return Function Description
     */
    @Nullable
    @ElementName( "RespyMgmtFunctionText" )
    private java.lang.String respyMgmtFunctionText;
    public final static SimpleProperty.String<TeamCategoryFunctionTexts> RESPY_MGMT_FUNCTION_TEXT =
        new SimpleProperty.String<TeamCategoryFunctionTexts>(TeamCategoryFunctionTexts.class, "RespyMgmtFunctionText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamCategoryFunctionTexts> getType()
    {
        return TeamCategoryFunctionTexts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @param respyMgmtFunction
     *            Function
     */
    public void setRespyMgmtFunction( @Nullable final java.lang.String respyMgmtFunction )
    {
        rememberChangedField("RespyMgmtFunction", this.respyMgmtFunction);
        this.respyMgmtFunction = respyMgmtFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunctionText</b>
     * </p>
     * 
     * @param respyMgmtFunctionText
     *            Function Description
     */
    public void setRespyMgmtFunctionText( @Nullable final java.lang.String respyMgmtFunctionText )
    {
        rememberChangedField("RespyMgmtFunctionText", this.respyMgmtFunctionText);
        this.respyMgmtFunctionText = respyMgmtFunctionText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamCategoryFunctionTexts";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        entityKey.addKeyProperty("RespyMgmtFunction", getRespyMgmtFunction());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        values.put("RespyMgmtFunction", getRespyMgmtFunction());
        values.put("Language", getLanguage());
        values.put("RespyMgmtFunctionText", getRespyMgmtFunctionText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtFunction") ) {
                final Object value = values.remove("RespyMgmtFunction");
                if( (value == null) || (!value.equals(getRespyMgmtFunction())) ) {
                    setRespyMgmtFunction(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtFunctionText") ) {
                final Object value = values.remove("RespyMgmtFunctionText");
                if( (value == null) || (!value.equals(getRespyMgmtFunctionText())) ) {
                    setRespyMgmtFunctionText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

}
