/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Team Category Responsibility Attribute Texts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamCategoryRespyAttributeTxtsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamCategoryRespyAttributeTxts extends VdmEntity<TeamCategoryRespyAttributeTxts> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamCategoryRespyAttributeTxtsType";
    /**
     * Selector for all available fields of TeamCategoryRespyAttributeTxts.
     * 
     */
    public final static SimpleProperty<TeamCategoryRespyAttributeTxts> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamCategoryRespyAttributeTxts> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamCategoryRespyAttributeTxts>(
            TeamCategoryRespyAttributeTxts.class,
            "RespyMgmtTeamCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @return Responsibility Definition Name
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeName" )
    private java.lang.String respyMgmtAttributeName;
    public final static SimpleProperty.String<TeamCategoryRespyAttributeTxts> RESPY_MGMT_ATTRIBUTE_NAME =
        new SimpleProperty.String<TeamCategoryRespyAttributeTxts>(
            TeamCategoryRespyAttributeTxts.class,
            "RespyMgmtAttributeName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<TeamCategoryRespyAttributeTxts> LANGUAGE =
        new SimpleProperty.String<TeamCategoryRespyAttributeTxts>(TeamCategoryRespyAttributeTxts.class, "Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeText</b>
     * </p>
     * 
     * @return Responsibility Definition Description
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeText" )
    private java.lang.String respyMgmtAttributeText;
    public final static SimpleProperty.String<TeamCategoryRespyAttributeTxts> RESPY_MGMT_ATTRIBUTE_TEXT =
        new SimpleProperty.String<TeamCategoryRespyAttributeTxts>(
            TeamCategoryRespyAttributeTxts.class,
            "RespyMgmtAttributeText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamCategoryRespyAttributeTxts> getType()
    {
        return TeamCategoryRespyAttributeTxts.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     */
    public void setRespyMgmtAttributeName( @Nullable final java.lang.String respyMgmtAttributeName )
    {
        rememberChangedField("RespyMgmtAttributeName", this.respyMgmtAttributeName);
        this.respyMgmtAttributeName = respyMgmtAttributeName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeText</b>
     * </p>
     * 
     * @param respyMgmtAttributeText
     *            Responsibility Definition Description
     */
    public void setRespyMgmtAttributeText( @Nullable final java.lang.String respyMgmtAttributeText )
    {
        rememberChangedField("RespyMgmtAttributeText", this.respyMgmtAttributeText);
        this.respyMgmtAttributeText = respyMgmtAttributeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamCategoryRespyAttributeTxts";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        entityKey.addKeyProperty("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        entityKey.addKeyProperty("Language", getLanguage());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        values.put("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        values.put("Language", getLanguage());
        values.put("RespyMgmtAttributeText", getRespyMgmtAttributeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeName") ) {
                final Object value = values.remove("RespyMgmtAttributeName");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeName())) ) {
                    setRespyMgmtAttributeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeText") ) {
                final Object value = values.remove("RespyMgmtAttributeText");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeText())) ) {
                    setRespyMgmtAttributeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

}
