/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Category Responsibility Attributes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamCategoryRespyAttributesType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamCategoryRespyAttributes extends VdmEntity<TeamCategoryRespyAttributes> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamCategoryRespyAttributesType";
    /**
     * Selector for all available fields of TeamCategoryRespyAttributes.
     * 
     */
    public final static SimpleProperty<TeamCategoryRespyAttributes> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamCategoryRespyAttributes> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamCategoryRespyAttributes>(
            TeamCategoryRespyAttributes.class,
            "RespyMgmtTeamCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @return Responsibility Definition Name
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeName" )
    private java.lang.String respyMgmtAttributeName;
    public final static SimpleProperty.String<TeamCategoryRespyAttributes> RESPY_MGMT_ATTRIBUTE_NAME =
        new SimpleProperty.String<TeamCategoryRespyAttributes>(
            TeamCategoryRespyAttributes.class,
            "RespyMgmtAttributeName");
    /**
     * Navigation property <b>_ResponsibilityAttributeTexts</b> for <b>TeamCategoryRespyAttributes</b> to multiple
     * <b>TeamCategoryRespyAttributeTxts</b>.
     * 
     */
    @ElementName( "_ResponsibilityAttributeTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamCategoryRespyAttributeTxts> to_ResponsibilityAttributeTexts;
    /**
     * Navigation property <b>_TeamCategory</b> for <b>TeamCategoryRespyAttributes</b> to single <b>TeamCategories</b>.
     * 
     */
    @ElementName( "_TeamCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamCategories to_TeamCategory;
    /**
     * Use with available request builders to apply the <b>_ResponsibilityAttributeTexts</b> navigation property to
     * query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategoryRespyAttributes, TeamCategoryRespyAttributeTxts> TO__RESPONSIBILITY_ATTRIBUTE_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamCategoryRespyAttributes, TeamCategoryRespyAttributeTxts>(
            TeamCategoryRespyAttributes.class,
            "_ResponsibilityAttributeTexts",
            TeamCategoryRespyAttributeTxts.class);
    /**
     * Use with available request builders to apply the <b>_TeamCategory</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamCategoryRespyAttributes, TeamCategories> TO__TEAM_CATEGORY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamCategoryRespyAttributes, TeamCategories>(
            TeamCategoryRespyAttributes.class,
            "_TeamCategory",
            TeamCategories.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamCategoryRespyAttributes> getType()
    {
        return TeamCategoryRespyAttributes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     */
    public void setRespyMgmtAttributeName( @Nullable final java.lang.String respyMgmtAttributeName )
    {
        rememberChangedField("RespyMgmtAttributeName", this.respyMgmtAttributeName);
        this.respyMgmtAttributeName = respyMgmtAttributeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamCategoryRespyAttributes";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        entityKey.addKeyProperty("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        values.put("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeName") ) {
                final Object value = values.remove("RespyMgmtAttributeName");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeName())) ) {
                    setRespyMgmtAttributeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ResponsibilityAttributeTexts") ) {
                final Object value = (values).remove("_ResponsibilityAttributeTexts");
                if( value instanceof Iterable ) {
                    if( to_ResponsibilityAttributeTexts == null ) {
                        to_ResponsibilityAttributeTexts = Lists.newArrayList();
                    } else {
                        to_ResponsibilityAttributeTexts = Lists.newArrayList(to_ResponsibilityAttributeTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamCategoryRespyAttributeTxts entity;
                        if( to_ResponsibilityAttributeTexts.size() > i ) {
                            entity = to_ResponsibilityAttributeTexts.get(i);
                        } else {
                            entity = new TeamCategoryRespyAttributeTxts();
                            to_ResponsibilityAttributeTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamCategory") ) {
                final Object value = (values).remove("_TeamCategory");
                if( value instanceof Map ) {
                    if( to_TeamCategory == null ) {
                        to_TeamCategory = new TeamCategories();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamCategory.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ResponsibilityAttributeTexts != null ) {
            (values).put("_ResponsibilityAttributeTexts", to_ResponsibilityAttributeTexts);
        }
        if( to_TeamCategory != null ) {
            (values).put("_TeamCategory", to_TeamCategory);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamCategoryRespyAttributeTxts</b> entities (one to many). This corresponds to the
     * OData navigation property <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamCategoryRespyAttributes</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ResponsibilityAttributeTexts</b> is already loaded, the
     *         result will contain the <b>TeamCategoryRespyAttributeTxts</b> entities. If not, an <code>Option</code>
     *         with result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamCategoryRespyAttributeTxts>> getResponsibilityAttributeTextsIfPresent()
    {
        return Option.of(to_ResponsibilityAttributeTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamCategoryRespyAttributeTxts</b> entities for the loaded navigation
     * property <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property <b>_ResponsibilityAttributeTexts</b> of a queried <b>TeamCategoryRespyAttributes</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamCategoryRespyAttributeTxts</b> entities.
     */
    public void setResponsibilityAttributeTexts( @Nonnull final List<TeamCategoryRespyAttributeTxts> value )
    {
        if( to_ResponsibilityAttributeTexts == null ) {
            to_ResponsibilityAttributeTexts = Lists.newArrayList();
        }
        to_ResponsibilityAttributeTexts.clear();
        to_ResponsibilityAttributeTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamCategoryRespyAttributeTxts</b> entities. This corresponds to the
     * OData navigation property <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property <b>_ResponsibilityAttributeTexts</b> of a queried <b>TeamCategoryRespyAttributes</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamCategoryRespyAttributeTxts</b> entities.
     */
    public void addResponsibilityAttributeTexts( TeamCategoryRespyAttributeTxts... entity )
    {
        if( to_ResponsibilityAttributeTexts == null ) {
            to_ResponsibilityAttributeTexts = Lists.newArrayList();
        }
        to_ResponsibilityAttributeTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamCategories</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_TeamCategory</b>.
     * <p>
     * If the navigation property for an entity <b>TeamCategoryRespyAttributes</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamCategory</b> is already loaded, the result will
     *         contain the <b>TeamCategories</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<TeamCategories> getTeamCategoryIfPresent()
    {
        return Option.of(to_TeamCategory);
    }

    /**
     * Overwrites the associated <b>TeamCategories</b> entity for the loaded navigation property <b>_TeamCategory</b>.
     * 
     * @param value
     *            New <b>TeamCategories</b> entity.
     */
    public void setTeamCategory( final TeamCategories value )
    {
        to_TeamCategory = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamCategoryRespyAttributes instances.
     * 
     */
    public final static class TeamCategoryRespyAttributesBuilder
    {

        private List<TeamCategoryRespyAttributeTxts> to_ResponsibilityAttributeTexts = Lists.newArrayList();
        private TeamCategories to_TeamCategory;

        private TeamCategoryRespyAttributes.TeamCategoryRespyAttributesBuilder to_ResponsibilityAttributeTexts(
            final List<TeamCategoryRespyAttributeTxts> value )
        {
            to_ResponsibilityAttributeTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ResponsibilityAttributeTexts</b> for <b>TeamCategoryRespyAttributes</b> to multiple
         * <b>TeamCategoryRespyAttributeTxts</b>.
         * 
         * @param value
         *            The TeamCategoryRespyAttributeTxtss to build this TeamCategoryRespyAttributes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamCategoryRespyAttributes.TeamCategoryRespyAttributesBuilder responsibilityAttributeTexts(
            TeamCategoryRespyAttributeTxts... value )
        {
            return to_ResponsibilityAttributeTexts(Lists.newArrayList(value));
        }

        private TeamCategoryRespyAttributes.TeamCategoryRespyAttributesBuilder to_TeamCategory(
            final TeamCategories value )
        {
            to_TeamCategory = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamCategory</b> for <b>TeamCategoryRespyAttributes</b> to single
         * <b>TeamCategories</b>.
         * 
         * @param value
         *            The TeamCategories to build this TeamCategoryRespyAttributes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamCategoryRespyAttributes.TeamCategoryRespyAttributesBuilder teamCategory( final TeamCategories value )
        {
            return to_TeamCategory(value);
        }

    }

}
