/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Type Functions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamTypeFunctionsType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamTypeFunctions extends VdmEntity<TeamTypeFunctions> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamTypeFunctionsType";
    /**
     * Selector for all available fields of TeamTypeFunctions.
     * 
     */
    public final static SimpleProperty<TeamTypeFunctions> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @return Team Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamType" )
    private java.lang.String respyMgmtTeamType;
    public final static SimpleProperty.String<TeamTypeFunctions> RESPY_MGMT_TEAM_TYPE =
        new SimpleProperty.String<TeamTypeFunctions>(TeamTypeFunctions.class, "RespyMgmtTeamType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @return Function
     */
    @Nullable
    @ElementName( "RespyMgmtFunction" )
    private java.lang.String respyMgmtFunction;
    public final static SimpleProperty.String<TeamTypeFunctions> RESPY_MGMT_FUNCTION =
        new SimpleProperty.String<TeamTypeFunctions>(TeamTypeFunctions.class, "RespyMgmtFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamTypeFunctions> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamTypeFunctions>(TeamTypeFunctions.class, "RespyMgmtTeamCategory");
    /**
     * Navigation property <b>_FunctionTexts</b> for <b>TeamTypeFunctions</b> to multiple <b>TeamTypeFunctionTexts</b>.
     * 
     */
    @ElementName( "_FunctionTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypeFunctionTexts> to_FunctionTexts;
    /**
     * Navigation property <b>_TeamType</b> for <b>TeamTypeFunctions</b> to single <b>TeamTypes</b>.
     * 
     */
    @ElementName( "_TeamType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamTypes to_TeamType;
    /**
     * Use with available request builders to apply the <b>_FunctionTexts</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypeFunctions, TeamTypeFunctionTexts> TO__FUNCTION_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypeFunctions, TeamTypeFunctionTexts>(
            TeamTypeFunctions.class,
            "_FunctionTexts",
            TeamTypeFunctionTexts.class);
    /**
     * Use with available request builders to apply the <b>_TeamType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypeFunctions, TeamTypes> TO__TEAM_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypeFunctions, TeamTypes>(
            TeamTypeFunctions.class,
            "_TeamType",
            TeamTypes.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamTypeFunctions> getType()
    {
        return TeamTypeFunctions.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @param respyMgmtTeamType
     *            Team Type
     */
    public void setRespyMgmtTeamType( @Nullable final java.lang.String respyMgmtTeamType )
    {
        rememberChangedField("RespyMgmtTeamType", this.respyMgmtTeamType);
        this.respyMgmtTeamType = respyMgmtTeamType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtFunction</b>
     * </p>
     * 
     * @param respyMgmtFunction
     *            Function
     */
    public void setRespyMgmtFunction( @Nullable final java.lang.String respyMgmtFunction )
    {
        rememberChangedField("RespyMgmtFunction", this.respyMgmtFunction);
        this.respyMgmtFunction = respyMgmtFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamTypeFunctions";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamType", getRespyMgmtTeamType());
        entityKey.addKeyProperty("RespyMgmtFunction", getRespyMgmtFunction());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamType", getRespyMgmtTeamType());
        values.put("RespyMgmtFunction", getRespyMgmtFunction());
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamType") ) {
                final Object value = values.remove("RespyMgmtTeamType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamType())) ) {
                    setRespyMgmtTeamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtFunction") ) {
                final Object value = values.remove("RespyMgmtFunction");
                if( (value == null) || (!value.equals(getRespyMgmtFunction())) ) {
                    setRespyMgmtFunction(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_FunctionTexts") ) {
                final Object value = (values).remove("_FunctionTexts");
                if( value instanceof Iterable ) {
                    if( to_FunctionTexts == null ) {
                        to_FunctionTexts = Lists.newArrayList();
                    } else {
                        to_FunctionTexts = Lists.newArrayList(to_FunctionTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypeFunctionTexts entity;
                        if( to_FunctionTexts.size() > i ) {
                            entity = to_FunctionTexts.get(i);
                        } else {
                            entity = new TeamTypeFunctionTexts();
                            to_FunctionTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamType") ) {
                final Object value = (values).remove("_TeamType");
                if( value instanceof Map ) {
                    if( to_TeamType == null ) {
                        to_TeamType = new TeamTypes();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_FunctionTexts != null ) {
            (values).put("_FunctionTexts", to_FunctionTexts);
        }
        if( to_TeamType != null ) {
            (values).put("_TeamType", to_TeamType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamTypeFunctionTexts</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_FunctionTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypeFunctions</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_FunctionTexts</b> is already loaded, the result will
     *         contain the <b>TeamTypeFunctionTexts</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamTypeFunctionTexts>> getFunctionTextsIfPresent()
    {
        return Option.of(to_FunctionTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamTypeFunctionTexts</b> entities for the loaded navigation property
     * <b>_FunctionTexts</b>.
     * <p>
     * If the navigation property <b>_FunctionTexts</b> of a queried <b>TeamTypeFunctions</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypeFunctionTexts</b> entities.
     */
    public void setFunctionTexts( @Nonnull final List<TeamTypeFunctionTexts> value )
    {
        if( to_FunctionTexts == null ) {
            to_FunctionTexts = Lists.newArrayList();
        }
        to_FunctionTexts.clear();
        to_FunctionTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypeFunctionTexts</b> entities. This corresponds to the OData
     * navigation property <b>_FunctionTexts</b>.
     * <p>
     * If the navigation property <b>_FunctionTexts</b> of a queried <b>TeamTypeFunctions</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypeFunctionTexts</b> entities.
     */
    public void addFunctionTexts( TeamTypeFunctionTexts... entity )
    {
        if( to_FunctionTexts == null ) {
            to_FunctionTexts = Lists.newArrayList();
        }
        to_FunctionTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypes</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamType</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypeFunctions</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamType</b> is already loaded, the result will contain
     *         the <b>TeamTypes</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamTypes> getTeamTypeIfPresent()
    {
        return Option.of(to_TeamType);
    }

    /**
     * Overwrites the associated <b>TeamTypes</b> entity for the loaded navigation property <b>_TeamType</b>.
     * 
     * @param value
     *            New <b>TeamTypes</b> entity.
     */
    public void setTeamType( final TeamTypes value )
    {
        to_TeamType = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamTypeFunctions instances.
     * 
     */
    public final static class TeamTypeFunctionsBuilder
    {

        private List<TeamTypeFunctionTexts> to_FunctionTexts = Lists.newArrayList();
        private TeamTypes to_TeamType;

        private TeamTypeFunctions.TeamTypeFunctionsBuilder to_FunctionTexts( final List<TeamTypeFunctionTexts> value )
        {
            to_FunctionTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_FunctionTexts</b> for <b>TeamTypeFunctions</b> to multiple
         * <b>TeamTypeFunctionTexts</b>.
         * 
         * @param value
         *            The TeamTypeFunctionTextss to build this TeamTypeFunctions with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypeFunctions.TeamTypeFunctionsBuilder functionTexts( TeamTypeFunctionTexts... value )
        {
            return to_FunctionTexts(Lists.newArrayList(value));
        }

        private TeamTypeFunctions.TeamTypeFunctionsBuilder to_TeamType( final TeamTypes value )
        {
            to_TeamType = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamType</b> for <b>TeamTypeFunctions</b> to single <b>TeamTypes</b>.
         * 
         * @param value
         *            The TeamTypes to build this TeamTypeFunctions with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypeFunctions.TeamTypeFunctionsBuilder teamType( final TeamTypes value )
        {
            return to_TeamType(value);
        }

    }

}
