/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Type Responsibility Attributes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamTypeRespyAttributesType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamTypeRespyAttributes extends VdmEntity<TeamTypeRespyAttributes> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamTypeRespyAttributesType";
    /**
     * Selector for all available fields of TeamTypeRespyAttributes.
     * 
     */
    public final static SimpleProperty<TeamTypeRespyAttributes> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @return Team Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamType" )
    private java.lang.String respyMgmtTeamType;
    public final static SimpleProperty.String<TeamTypeRespyAttributes> RESPY_MGMT_TEAM_TYPE =
        new SimpleProperty.String<TeamTypeRespyAttributes>(TeamTypeRespyAttributes.class, "RespyMgmtTeamType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @return Responsibility Definition Name
     */
    @Nullable
    @ElementName( "RespyMgmtAttributeName" )
    private java.lang.String respyMgmtAttributeName;
    public final static SimpleProperty.String<TeamTypeRespyAttributes> RESPY_MGMT_ATTRIBUTE_NAME =
        new SimpleProperty.String<TeamTypeRespyAttributes>(TeamTypeRespyAttributes.class, "RespyMgmtAttributeName");
    /**
     * Navigation property <b>_ResponsibilityAttributeTexts</b> for <b>TeamTypeRespyAttributes</b> to multiple
     * <b>TeamTypeRespyAttributeTexts</b>.
     * 
     */
    @ElementName( "_ResponsibilityAttributeTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypeRespyAttributeTexts> to_ResponsibilityAttributeTexts;
    /**
     * Navigation property <b>_TeamType</b> for <b>TeamTypeRespyAttributes</b> to single <b>TeamTypes</b>.
     * 
     */
    @ElementName( "_TeamType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamTypes to_TeamType;
    /**
     * Use with available request builders to apply the <b>_ResponsibilityAttributeTexts</b> navigation property to
     * query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypeRespyAttributes, TeamTypeRespyAttributeTexts> TO__RESPONSIBILITY_ATTRIBUTE_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypeRespyAttributes, TeamTypeRespyAttributeTexts>(
            TeamTypeRespyAttributes.class,
            "_ResponsibilityAttributeTexts",
            TeamTypeRespyAttributeTexts.class);
    /**
     * Use with available request builders to apply the <b>_TeamType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypeRespyAttributes, TeamTypes> TO__TEAM_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypeRespyAttributes, TeamTypes>(
            TeamTypeRespyAttributes.class,
            "_TeamType",
            TeamTypes.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamTypeRespyAttributes> getType()
    {
        return TeamTypeRespyAttributes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @param respyMgmtTeamType
     *            Team Type
     */
    public void setRespyMgmtTeamType( @Nullable final java.lang.String respyMgmtTeamType )
    {
        rememberChangedField("RespyMgmtTeamType", this.respyMgmtTeamType);
        this.respyMgmtTeamType = respyMgmtTeamType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtAttributeName</b>
     * </p>
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     */
    public void setRespyMgmtAttributeName( @Nullable final java.lang.String respyMgmtAttributeName )
    {
        rememberChangedField("RespyMgmtAttributeName", this.respyMgmtAttributeName);
        this.respyMgmtAttributeName = respyMgmtAttributeName;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamTypeRespyAttributes";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamType", getRespyMgmtTeamType());
        entityKey.addKeyProperty("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamType", getRespyMgmtTeamType());
        values.put("RespyMgmtAttributeName", getRespyMgmtAttributeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamType") ) {
                final Object value = values.remove("RespyMgmtTeamType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamType())) ) {
                    setRespyMgmtTeamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtAttributeName") ) {
                final Object value = values.remove("RespyMgmtAttributeName");
                if( (value == null) || (!value.equals(getRespyMgmtAttributeName())) ) {
                    setRespyMgmtAttributeName(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ResponsibilityAttributeTexts") ) {
                final Object value = (values).remove("_ResponsibilityAttributeTexts");
                if( value instanceof Iterable ) {
                    if( to_ResponsibilityAttributeTexts == null ) {
                        to_ResponsibilityAttributeTexts = Lists.newArrayList();
                    } else {
                        to_ResponsibilityAttributeTexts = Lists.newArrayList(to_ResponsibilityAttributeTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypeRespyAttributeTexts entity;
                        if( to_ResponsibilityAttributeTexts.size() > i ) {
                            entity = to_ResponsibilityAttributeTexts.get(i);
                        } else {
                            entity = new TeamTypeRespyAttributeTexts();
                            to_ResponsibilityAttributeTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamType") ) {
                final Object value = (values).remove("_TeamType");
                if( value instanceof Map ) {
                    if( to_TeamType == null ) {
                        to_TeamType = new TeamTypes();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ResponsibilityAttributeTexts != null ) {
            (values).put("_ResponsibilityAttributeTexts", to_ResponsibilityAttributeTexts);
        }
        if( to_TeamType != null ) {
            (values).put("_TeamType", to_TeamType);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamTypeRespyAttributeTexts</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypeRespyAttributes</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ResponsibilityAttributeTexts</b> is already loaded, the
     *         result will contain the <b>TeamTypeRespyAttributeTexts</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamTypeRespyAttributeTexts>> getResponsibilityAttributeTextsIfPresent()
    {
        return Option.of(to_ResponsibilityAttributeTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamTypeRespyAttributeTexts</b> entities for the loaded navigation property
     * <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property <b>_ResponsibilityAttributeTexts</b> of a queried <b>TeamTypeRespyAttributes</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypeRespyAttributeTexts</b> entities.
     */
    public void setResponsibilityAttributeTexts( @Nonnull final List<TeamTypeRespyAttributeTexts> value )
    {
        if( to_ResponsibilityAttributeTexts == null ) {
            to_ResponsibilityAttributeTexts = Lists.newArrayList();
        }
        to_ResponsibilityAttributeTexts.clear();
        to_ResponsibilityAttributeTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypeRespyAttributeTexts</b> entities. This corresponds to the
     * OData navigation property <b>_ResponsibilityAttributeTexts</b>.
     * <p>
     * If the navigation property <b>_ResponsibilityAttributeTexts</b> of a queried <b>TeamTypeRespyAttributes</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypeRespyAttributeTexts</b> entities.
     */
    public void addResponsibilityAttributeTexts( TeamTypeRespyAttributeTexts... entity )
    {
        if( to_ResponsibilityAttributeTexts == null ) {
            to_ResponsibilityAttributeTexts = Lists.newArrayList();
        }
        to_ResponsibilityAttributeTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypes</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_TeamType</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypeRespyAttributes</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamType</b> is already loaded, the result will contain
     *         the <b>TeamTypes</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<TeamTypes> getTeamTypeIfPresent()
    {
        return Option.of(to_TeamType);
    }

    /**
     * Overwrites the associated <b>TeamTypes</b> entity for the loaded navigation property <b>_TeamType</b>.
     * 
     * @param value
     *            New <b>TeamTypes</b> entity.
     */
    public void setTeamType( final TeamTypes value )
    {
        to_TeamType = value;
    }

    /**
     * Helper class to allow for fluent creation of TeamTypeRespyAttributes instances.
     * 
     */
    public final static class TeamTypeRespyAttributesBuilder
    {

        private List<TeamTypeRespyAttributeTexts> to_ResponsibilityAttributeTexts = Lists.newArrayList();
        private TeamTypes to_TeamType;

        private TeamTypeRespyAttributes.TeamTypeRespyAttributesBuilder to_ResponsibilityAttributeTexts(
            final List<TeamTypeRespyAttributeTexts> value )
        {
            to_ResponsibilityAttributeTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_ResponsibilityAttributeTexts</b> for <b>TeamTypeRespyAttributes</b> to multiple
         * <b>TeamTypeRespyAttributeTexts</b>.
         * 
         * @param value
         *            The TeamTypeRespyAttributeTextss to build this TeamTypeRespyAttributes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypeRespyAttributes.TeamTypeRespyAttributesBuilder responsibilityAttributeTexts(
            TeamTypeRespyAttributeTexts... value )
        {
            return to_ResponsibilityAttributeTexts(Lists.newArrayList(value));
        }

        private TeamTypeRespyAttributes.TeamTypeRespyAttributesBuilder to_TeamType( final TeamTypes value )
        {
            to_TeamType = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamType</b> for <b>TeamTypeRespyAttributes</b> to single <b>TeamTypes</b>.
         * 
         * @param value
         *            The TeamTypes to build this TeamTypeRespyAttributes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypeRespyAttributes.TeamTypeRespyAttributesBuilder teamType( final TeamTypes value )
        {
            return to_TeamType(value);
        }

    }

}
