/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ResponsibilityManagementTeamConfigurationService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Team Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TeamTypesType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class TeamTypes extends VdmEntity<TeamTypes> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_respym_team_config_srv.v0001.TeamTypesType";
    /**
     * Selector for all available fields of TeamTypes.
     * 
     */
    public final static SimpleProperty<TeamTypes> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @return Team Type
     */
    @Nullable
    @ElementName( "RespyMgmtTeamType" )
    private java.lang.String respyMgmtTeamType;
    public final static SimpleProperty.String<TeamTypes> RESPY_MGMT_TEAM_TYPE =
        new SimpleProperty.String<TeamTypes>(TeamTypes.class, "RespyMgmtTeamType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @return Custom Team Category
     */
    @Nullable
    @ElementName( "RespyMgmtTeamCategory" )
    private java.lang.String respyMgmtTeamCategory;
    public final static SimpleProperty.String<TeamTypes> RESPY_MGMT_TEAM_CATEGORY =
        new SimpleProperty.String<TeamTypes>(TeamTypes.class, "RespyMgmtTeamCategory");
    /**
     * Navigation property <b>_TeamCategory</b> for <b>TeamTypes</b> to single <b>TeamCategories</b>.
     * 
     */
    @ElementName( "_TeamCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TeamCategories to_TeamCategory;
    /**
     * Navigation property <b>_TeamTypeFunctions</b> for <b>TeamTypes</b> to multiple <b>TeamTypeFunctions</b>.
     * 
     */
    @ElementName( "_TeamTypeFunctions" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypeFunctions> to_TeamTypeFunctions;
    /**
     * Navigation property <b>_TeamTypeRespyAttributes</b> for <b>TeamTypes</b> to multiple
     * <b>TeamTypeRespyAttributes</b>.
     * 
     */
    @ElementName( "_TeamTypeRespyAttributes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypeRespyAttributes> to_TeamTypeRespyAttributes;
    /**
     * Navigation property <b>_TeamTypeTexts</b> for <b>TeamTypes</b> to multiple <b>TeamTypeTexts</b>.
     * 
     */
    @ElementName( "_TeamTypeTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TeamTypeTexts> to_TeamTypeTexts;
    /**
     * Use with available request builders to apply the <b>_TeamCategory</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypes, TeamCategories> TO__TEAM_CATEGORY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<TeamTypes, TeamCategories>(
            TeamTypes.class,
            "_TeamCategory",
            TeamCategories.class);
    /**
     * Use with available request builders to apply the <b>_TeamTypeFunctions</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeFunctions> TO__TEAM_TYPE_FUNCTIONS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeFunctions>(
            TeamTypes.class,
            "_TeamTypeFunctions",
            TeamTypeFunctions.class);
    /**
     * Use with available request builders to apply the <b>_TeamTypeRespyAttributes</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeRespyAttributes> TO__TEAM_TYPE_RESPY_ATTRIBUTES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeRespyAttributes>(
            TeamTypes.class,
            "_TeamTypeRespyAttributes",
            TeamTypeRespyAttributes.class);
    /**
     * Use with available request builders to apply the <b>_TeamTypeTexts</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeTexts> TO__TEAM_TYPE_TEXTS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<TeamTypes, TeamTypeTexts>(
            TeamTypes.class,
            "_TeamTypeTexts",
            TeamTypeTexts.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<TeamTypes> getType()
    {
        return TeamTypes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamType</b>
     * </p>
     * 
     * @param respyMgmtTeamType
     *            Team Type
     */
    public void setRespyMgmtTeamType( @Nullable final java.lang.String respyMgmtTeamType )
    {
        rememberChangedField("RespyMgmtTeamType", this.respyMgmtTeamType);
        this.respyMgmtTeamType = respyMgmtTeamType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtTeamCategory</b>
     * </p>
     * 
     * @param respyMgmtTeamCategory
     *            Custom Team Category
     */
    public void setRespyMgmtTeamCategory( @Nullable final java.lang.String respyMgmtTeamCategory )
    {
        rememberChangedField("RespyMgmtTeamCategory", this.respyMgmtTeamCategory);
        this.respyMgmtTeamCategory = respyMgmtTeamCategory;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "TeamTypes";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("RespyMgmtTeamType", getRespyMgmtTeamType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("RespyMgmtTeamType", getRespyMgmtTeamType());
        values.put("RespyMgmtTeamCategory", getRespyMgmtTeamCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RespyMgmtTeamType") ) {
                final Object value = values.remove("RespyMgmtTeamType");
                if( (value == null) || (!value.equals(getRespyMgmtTeamType())) ) {
                    setRespyMgmtTeamType(((java.lang.String) value));
                }
            }
            if( values.containsKey("RespyMgmtTeamCategory") ) {
                final Object value = values.remove("RespyMgmtTeamCategory");
                if( (value == null) || (!value.equals(getRespyMgmtTeamCategory())) ) {
                    setRespyMgmtTeamCategory(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_TeamCategory") ) {
                final Object value = (values).remove("_TeamCategory");
                if( value instanceof Map ) {
                    if( to_TeamCategory == null ) {
                        to_TeamCategory = new TeamCategories();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_TeamCategory.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_TeamTypeFunctions") ) {
                final Object value = (values).remove("_TeamTypeFunctions");
                if( value instanceof Iterable ) {
                    if( to_TeamTypeFunctions == null ) {
                        to_TeamTypeFunctions = Lists.newArrayList();
                    } else {
                        to_TeamTypeFunctions = Lists.newArrayList(to_TeamTypeFunctions);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypeFunctions entity;
                        if( to_TeamTypeFunctions.size() > i ) {
                            entity = to_TeamTypeFunctions.get(i);
                        } else {
                            entity = new TeamTypeFunctions();
                            to_TeamTypeFunctions.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamTypeRespyAttributes") ) {
                final Object value = (values).remove("_TeamTypeRespyAttributes");
                if( value instanceof Iterable ) {
                    if( to_TeamTypeRespyAttributes == null ) {
                        to_TeamTypeRespyAttributes = Lists.newArrayList();
                    } else {
                        to_TeamTypeRespyAttributes = Lists.newArrayList(to_TeamTypeRespyAttributes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypeRespyAttributes entity;
                        if( to_TeamTypeRespyAttributes.size() > i ) {
                            entity = to_TeamTypeRespyAttributes.get(i);
                        } else {
                            entity = new TeamTypeRespyAttributes();
                            to_TeamTypeRespyAttributes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_TeamTypeTexts") ) {
                final Object value = (values).remove("_TeamTypeTexts");
                if( value instanceof Iterable ) {
                    if( to_TeamTypeTexts == null ) {
                        to_TeamTypeTexts = Lists.newArrayList();
                    } else {
                        to_TeamTypeTexts = Lists.newArrayList(to_TeamTypeTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TeamTypeTexts entity;
                        if( to_TeamTypeTexts.size() > i ) {
                            entity = to_TeamTypeTexts.get(i);
                        } else {
                            entity = new TeamTypeTexts();
                            to_TeamTypeTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_TeamCategory != null ) {
            (values).put("_TeamCategory", to_TeamCategory);
        }
        if( to_TeamTypeFunctions != null ) {
            (values).put("_TeamTypeFunctions", to_TeamTypeFunctions);
        }
        if( to_TeamTypeRespyAttributes != null ) {
            (values).put("_TeamTypeRespyAttributes", to_TeamTypeRespyAttributes);
        }
        if( to_TeamTypeTexts != null ) {
            (values).put("_TeamTypeTexts", to_TeamTypeTexts);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>TeamCategories</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_TeamCategory</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypes</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamCategory</b> is already loaded, the result will
     *         contain the <b>TeamCategories</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<TeamCategories> getTeamCategoryIfPresent()
    {
        return Option.of(to_TeamCategory);
    }

    /**
     * Overwrites the associated <b>TeamCategories</b> entity for the loaded navigation property <b>_TeamCategory</b>.
     * 
     * @param value
     *            New <b>TeamCategories</b> entity.
     */
    public void setTeamCategory( final TeamCategories value )
    {
        to_TeamCategory = value;
    }

    /**
     * Retrieval of associated <b>TeamTypeFunctions</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamTypeFunctions</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypes</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamTypeFunctions</b> is already loaded, the result will
     *         contain the <b>TeamTypeFunctions</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamTypeFunctions>> getTeamTypeFunctionsIfPresent()
    {
        return Option.of(to_TeamTypeFunctions);
    }

    /**
     * Overwrites the list of associated <b>TeamTypeFunctions</b> entities for the loaded navigation property
     * <b>_TeamTypeFunctions</b>.
     * <p>
     * If the navigation property <b>_TeamTypeFunctions</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypeFunctions</b> entities.
     */
    public void setTeamTypeFunctions( @Nonnull final List<TeamTypeFunctions> value )
    {
        if( to_TeamTypeFunctions == null ) {
            to_TeamTypeFunctions = Lists.newArrayList();
        }
        to_TeamTypeFunctions.clear();
        to_TeamTypeFunctions.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypeFunctions</b> entities. This corresponds to the OData
     * navigation property <b>_TeamTypeFunctions</b>.
     * <p>
     * If the navigation property <b>_TeamTypeFunctions</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypeFunctions</b> entities.
     */
    public void addTeamTypeFunctions( TeamTypeFunctions... entity )
    {
        if( to_TeamTypeFunctions == null ) {
            to_TeamTypeFunctions = Lists.newArrayList();
        }
        to_TeamTypeFunctions.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypeRespyAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_TeamTypeRespyAttributes</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypes</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamTypeRespyAttributes</b> is already loaded, the result
     *         will contain the <b>TeamTypeRespyAttributes</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamTypeRespyAttributes>> getTeamTypeRespyAttributesIfPresent()
    {
        return Option.of(to_TeamTypeRespyAttributes);
    }

    /**
     * Overwrites the list of associated <b>TeamTypeRespyAttributes</b> entities for the loaded navigation property
     * <b>_TeamTypeRespyAttributes</b>.
     * <p>
     * If the navigation property <b>_TeamTypeRespyAttributes</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypeRespyAttributes</b> entities.
     */
    public void setTeamTypeRespyAttributes( @Nonnull final List<TeamTypeRespyAttributes> value )
    {
        if( to_TeamTypeRespyAttributes == null ) {
            to_TeamTypeRespyAttributes = Lists.newArrayList();
        }
        to_TeamTypeRespyAttributes.clear();
        to_TeamTypeRespyAttributes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypeRespyAttributes</b> entities. This corresponds to the OData
     * navigation property <b>_TeamTypeRespyAttributes</b>.
     * <p>
     * If the navigation property <b>_TeamTypeRespyAttributes</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypeRespyAttributes</b> entities.
     */
    public void addTeamTypeRespyAttributes( TeamTypeRespyAttributes... entity )
    {
        if( to_TeamTypeRespyAttributes == null ) {
            to_TeamTypeRespyAttributes = Lists.newArrayList();
        }
        to_TeamTypeRespyAttributes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>TeamTypeTexts</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_TeamTypeTexts</b>.
     * <p>
     * If the navigation property for an entity <b>TeamTypes</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_TeamTypeTexts</b> is already loaded, the result will
     *         contain the <b>TeamTypeTexts</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TeamTypeTexts>> getTeamTypeTextsIfPresent()
    {
        return Option.of(to_TeamTypeTexts);
    }

    /**
     * Overwrites the list of associated <b>TeamTypeTexts</b> entities for the loaded navigation property
     * <b>_TeamTypeTexts</b>.
     * <p>
     * If the navigation property <b>_TeamTypeTexts</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>TeamTypeTexts</b> entities.
     */
    public void setTeamTypeTexts( @Nonnull final List<TeamTypeTexts> value )
    {
        if( to_TeamTypeTexts == null ) {
            to_TeamTypeTexts = Lists.newArrayList();
        }
        to_TeamTypeTexts.clear();
        to_TeamTypeTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TeamTypeTexts</b> entities. This corresponds to the OData navigation
     * property <b>_TeamTypeTexts</b>.
     * <p>
     * If the navigation property <b>_TeamTypeTexts</b> of a queried <b>TeamTypes</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>TeamTypeTexts</b> entities.
     */
    public void addTeamTypeTexts( TeamTypeTexts... entity )
    {
        if( to_TeamTypeTexts == null ) {
            to_TeamTypeTexts = Lists.newArrayList();
        }
        to_TeamTypeTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of TeamTypes instances.
     * 
     */
    public final static class TeamTypesBuilder
    {

        private TeamCategories to_TeamCategory;
        private List<TeamTypeFunctions> to_TeamTypeFunctions = Lists.newArrayList();
        private List<TeamTypeRespyAttributes> to_TeamTypeRespyAttributes = Lists.newArrayList();
        private List<TeamTypeTexts> to_TeamTypeTexts = Lists.newArrayList();

        private TeamTypes.TeamTypesBuilder to_TeamCategory( final TeamCategories value )
        {
            to_TeamCategory = value;
            return this;
        }

        /**
         * Navigation property <b>_TeamCategory</b> for <b>TeamTypes</b> to single <b>TeamCategories</b>.
         * 
         * @param value
         *            The TeamCategories to build this TeamTypes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypes.TeamTypesBuilder teamCategory( final TeamCategories value )
        {
            return to_TeamCategory(value);
        }

        private TeamTypes.TeamTypesBuilder to_TeamTypeFunctions( final List<TeamTypeFunctions> value )
        {
            to_TeamTypeFunctions.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamTypeFunctions</b> for <b>TeamTypes</b> to multiple <b>TeamTypeFunctions</b>.
         * 
         * @param value
         *            The TeamTypeFunctionss to build this TeamTypes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypes.TeamTypesBuilder teamTypeFunctions( TeamTypeFunctions... value )
        {
            return to_TeamTypeFunctions(Lists.newArrayList(value));
        }

        private TeamTypes.TeamTypesBuilder to_TeamTypeRespyAttributes( final List<TeamTypeRespyAttributes> value )
        {
            to_TeamTypeRespyAttributes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamTypeRespyAttributes</b> for <b>TeamTypes</b> to multiple
         * <b>TeamTypeRespyAttributes</b>.
         * 
         * @param value
         *            The TeamTypeRespyAttributess to build this TeamTypes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypes.TeamTypesBuilder teamTypeRespyAttributes( TeamTypeRespyAttributes... value )
        {
            return to_TeamTypeRespyAttributes(Lists.newArrayList(value));
        }

        private TeamTypes.TeamTypesBuilder to_TeamTypeTexts( final List<TeamTypeTexts> value )
        {
            to_TeamTypeTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_TeamTypeTexts</b> for <b>TeamTypes</b> to multiple <b>TeamTypeTexts</b>.
         * 
         * @param value
         *            The TeamTypeTextss to build this TeamTypes with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TeamTypes.TeamTypesBuilder teamTypeTexts( TeamTypeTexts... value )
        {
            return to_TeamTypeTexts(Lists.newArrayList(value));
        }

    }

}
