/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.salesprice;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SalesPriceService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Sales Price
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPriceType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPrice extends VdmEntity<SalesPrice> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_salesprice.v0001.SalesPriceType";
    /**
     * Selector for all available fields of SalesPrice.
     * 
     */
    public final static SimpleProperty<SalesPrice> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesPriceRetrieveDummy</b>
     * </p>
     * 
     * @return Dummy for Sales Price Retrieve Entity
     */
    @Nullable
    @ElementName( "SalesPriceRetrieveDummy" )
    private java.lang.String salesPriceRetrieveDummy;
    public final static SimpleProperty.String<SalesPrice> SALES_PRICE_RETRIEVE_DUMMY =
        new SimpleProperty.String<SalesPrice>(SalesPrice.class, "SalesPriceRetrieveDummy");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SalesPrice, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SalesPrice, SAP__Message>(
            SalesPrice.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPrice> getType()
    {
        return SalesPrice.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesPriceRetrieveDummy</b>
     * </p>
     * 
     * @param salesPriceRetrieveDummy
     *            Dummy for Sales Price Retrieve Entity
     */
    public void setSalesPriceRetrieveDummy( @Nullable final java.lang.String salesPriceRetrieveDummy )
    {
        rememberChangedField("SalesPriceRetrieveDummy", this.salesPriceRetrieveDummy);
        this.salesPriceRetrieveDummy = salesPriceRetrieveDummy;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPrice";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SalesPriceRetrieveDummy", getSalesPriceRetrieveDummy());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SalesPriceRetrieveDummy", getSalesPriceRetrieveDummy());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesPriceRetrieveDummy") ) {
                final Object value = values.remove("SalesPriceRetrieveDummy");
                if( (value == null) || (!value.equals(getSalesPriceRetrieveDummy())) ) {
                    setSalesPriceRetrieveDummy(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SalesPriceService.DEFAULT_SERVICE_PATH;
    }

}
