/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Customer Pricing Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CustItmPricingElementType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CustItmPricingElement extends VdmEntity<CustItmPricingElement> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.CustItmPricingElementType";
    /**
     * Selector for all available fields of CustItmPricingElement.
     * 
     */
    public final static SimpleProperty<CustItmPricingElement> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @return Settlement Document Number
     */
    @Nullable
    @ElementName( "SettlmtDoc" )
    private java.lang.String settlmtDoc;
    public final static SimpleProperty.String<CustItmPricingElement> SETTLMT_DOC =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "SettlmtDoc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItem</b>
     * </p>
     * 
     * @return Document Item
     */
    @Nullable
    @ElementName( "SettlmtDocItem" )
    private java.lang.String settlmtDocItem;
    public final static SimpleProperty.String<CustItmPricingElement> SETTLMT_DOC_ITEM =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "SettlmtDocItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     * 
     * @return Step Number
     */
    @Nullable
    @ElementName( "PricingProcedureStep" )
    private java.lang.String pricingProcedureStep;
    public final static SimpleProperty.String<CustItmPricingElement> PRICING_PROCEDURE_STEP =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     * 
     * @return Pricing Procedure Counter
     */
    @Nullable
    @ElementName( "PricingProcedureCounter" )
    private java.lang.String pricingProcedureCounter;
    public final static SimpleProperty.String<CustItmPricingElement> PRICING_PROCEDURE_COUNTER =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_APPLICATION =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_TYPE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PriceConditionDeterminationDte</b>
     * </p>
     * 
     * @return The priceConditionDeterminationDte contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PriceConditionDeterminationDte" )
    private LocalDate priceConditionDeterminationDte;
    public final static SimpleProperty.Date<CustItmPricingElement> PRICE_CONDITION_DETERMINATION_DTE =
        new SimpleProperty.Date<CustItmPricingElement>(CustItmPricingElement.class, "PriceConditionDeterminationDte");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @return Calculation Type for Condition
     */
    @Nullable
    @ElementName( "ConditionCalculationType" )
    private java.lang.String conditionCalculationType;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_CALCULATION_TYPE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionCalculationType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "ConditionCurrency" )
    private java.lang.String conditionCurrency;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_CURRENCY =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @return Condition Pricing Unit
     */
    @Nullable
    @ElementName( "ConditionQuantity" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal conditionQuantity;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_QUANTITY =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @return Condition Unit in the Document
     */
    @Nullable
    @ElementName( "ConditionQuantityUnit" )
    private java.lang.String conditionQuantityUnit;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_QUANTITY_UNIT =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in ISO code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitISOCode" )
    private java.lang.String conditionQuantityUnitISOCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in SAP code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitSAPCode" )
    private java.lang.String conditionQuantityUnitSAPCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     * 
     * @return Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    @Nullable
    @ElementName( "ConditionCategory" )
    private java.lang.String conditionCategory;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_CATEGORY =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionCategory");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     * 
     * @return Condition is used for statistics
     */
    @Nullable
    @ElementName( "ConditionIsForStatistics" )
    private java.lang.Boolean conditionIsForStatistics;
    public final static SimpleProperty.Boolean<CustItmPricingElement> CONDITION_IS_FOR_STATISTICS =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "ConditionIsForStatistics");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @return Scale Type
     */
    @Nullable
    @ElementName( "PricingScaleType" )
    private java.lang.String pricingScaleType;
    public final static SimpleProperty.String<CustItmPricingElement> PRICING_SCALE_TYPE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "PricingScaleType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     * 
     * @return Condition is Relevant for Accrual (e.g. Freight)
     */
    @Nullable
    @ElementName( "IsRelevantForAccrual" )
    private java.lang.Boolean isRelevantForAccrual;
    public final static SimpleProperty.Boolean<CustItmPricingElement> IS_RELEVANT_FOR_ACCRUAL =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "IsRelevantForAccrual");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     * 
     * @return Condition for Invoice List
     */
    @Nullable
    @ElementName( "CndnIsRelevantForInvoiceList" )
    private java.lang.Boolean cndnIsRelevantForInvoiceList;
    public final static SimpleProperty.Boolean<CustItmPricingElement> CNDN_IS_RELEVANT_FOR_INVOICE_LIST =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "CndnIsRelevantForInvoiceList");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     * 
     * @return Origin of the Condition
     */
    @Nullable
    @ElementName( "ConditionOrigin" )
    private java.lang.String conditionOrigin;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_ORIGIN =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionOrigin");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     * 
     * @return Group Condition
     */
    @Nullable
    @ElementName( "IsGroupCondition" )
    private java.lang.Boolean isGroupCondition;
    public final static SimpleProperty.Boolean<CustItmPricingElement> IS_GROUP_CONDITION =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "IsGroupCondition");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @return Number of the Condition Record
     */
    @Nullable
    @ElementName( "ConditionRecord" )
    private java.lang.String conditionRecord;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_RECORD =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     * 
     * @return Sequential Number of the Condition
     */
    @Nullable
    @ElementName( "ConditionSequentialNumber" )
    private java.lang.String conditionSequentialNumber;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_SEQUENTIAL_NUMBER =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionSequentialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @return Tax on Sales/Purchases Code
     */
    @Nullable
    @ElementName( "TaxCode" )
    private java.lang.String taxCode;
    public final static SimpleProperty.String<CustItmPricingElement> TAX_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "TaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     * 
     * @return Withholding Tax Code
     */
    @Nullable
    @ElementName( "WithholdingTaxCode" )
    private java.lang.String withholdingTaxCode;
    public final static SimpleProperty.String<CustItmPricingElement> WITHHOLDING_TAX_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "WithholdingTaxCode");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     * 
     * @return The cndnRoundingOffDiffAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CndnRoundingOffDiffAmount" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal cndnRoundingOffDiffAmount;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CNDN_ROUNDING_OFF_DIFF_AMOUNT =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(
            CustItmPricingElement.class,
            "CndnRoundingOffDiffAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     * 
     * @return The conditionAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal conditionAmount;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_AMOUNT =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return SD Document Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<CustItmPricingElement> TRANSACTION_CURRENCY =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     * 
     * @return Condition Control
     */
    @Nullable
    @ElementName( "ConditionControl" )
    private java.lang.String conditionControl;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_CONTROL =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionControl");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     * 
     * @return Condition is Inactive
     */
    @Nullable
    @ElementName( "ConditionInactiveReason" )
    private java.lang.String conditionInactiveReason;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_INACTIVE_REASON =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionInactiveReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     * 
     * @return Condition Class
     */
    @Nullable
    @ElementName( "ConditionClass" )
    private java.lang.String conditionClass;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_CLASS =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     * 
     * @return Pricing Procedure Counter for Header
     */
    @Nullable
    @ElementName( "PrcgProcedureCounterForHeader" )
    private java.lang.String prcgProcedureCounterForHeader;
    public final static SimpleProperty.String<CustItmPricingElement> PRCG_PROCEDURE_COUNTER_FOR_HEADER =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "PrcgProcedureCounterForHeader");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     * 
     * @return Factor for Condition Basis Value
     */
    @Nullable
    @ElementName( "FactorForConditionBasisValue" )
    private Double factorForConditionBasisValue;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> FACTOR_FOR_CONDITION_BASIS_VALUE =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(
            CustItmPricingElement.class,
            "FactorForConditionBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     * 
     * @return Structure Condition
     */
    @Nullable
    @ElementName( "StructureCondition" )
    private java.lang.String structureCondition;
    public final static SimpleProperty.String<CustItmPricingElement> STRUCTURE_CONDITION =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "StructureCondition");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     * 
     * @return Period Factor for Condition Basis Value
     */
    @Nullable
    @ElementName( "PeriodFactorForCndnBasisValue" )
    private Double periodFactorForCndnBasisValue;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(
            CustItmPricingElement.class,
            "PeriodFactorForCndnBasisValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @return Scale Basis Indicator
     */
    @Nullable
    @ElementName( "PricingScaleBasis" )
    private java.lang.String pricingScaleBasis;
    public final static SimpleProperty.String<CustItmPricingElement> PRICING_SCALE_BASIS =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "PricingScaleBasis");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure
     */
    @Nullable
    @ElementName( "ConditionScaleBasisUnit" )
    private java.lang.String conditionScaleBasisUnit;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_SCALE_BASIS_UNIT =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionScaleBasisUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnitISOCode</b>
     * </p>
     * 
     * @return Condition Scale Basis Unit in ISO code
     */
    @Nullable
    @ElementName( "ConditionScaleBasisUnitISOCode" )
    private java.lang.String conditionScaleBasisUnitISOCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_SCALE_BASIS_UNIT_ISO_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionScaleBasisUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Scale Basis Unit in SAP code
     */
    @Nullable
    @ElementName( "ConditionScaleBasisUnitSAPCode" )
    private java.lang.String conditionScaleBasisUnitSAPCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_SCALE_BASIS_UNIT_SAP_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionScaleBasisUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     * 
     * @return Scale Currency
     */
    @Nullable
    @ElementName( "ConditionScaleBasisCurrency" )
    private java.lang.String conditionScaleBasisCurrency;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_SCALE_BASIS_CURRENCY =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionScaleBasisCurrency");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     * 
     * @return Condition Changed Manually
     */
    @Nullable
    @ElementName( "ConditionIsManuallyChanged" )
    private java.lang.Boolean conditionIsManuallyChanged;
    public final static SimpleProperty.Boolean<CustItmPricingElement> CONDITION_IS_MANUALLY_CHANGED =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "ConditionIsManuallyChanged");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     * 
     * @return Condition Used for Variant Configuration
     */
    @Nullable
    @ElementName( "ConditionIsForConfiguration" )
    private java.lang.Boolean conditionIsForConfiguration;
    public final static SimpleProperty.Boolean<CustItmPricingElement> CONDITION_IS_FOR_CONFIGURATION =
        new SimpleProperty.Boolean<CustItmPricingElement>(CustItmPricingElement.class, "ConditionIsForConfiguration");
    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     * 
     * @return Variant Condition Key
     */
    @Nullable
    @ElementName( "VariantCondition" )
    private java.lang.String variantCondition;
    public final static SimpleProperty.String<CustItmPricingElement> VARIANT_CONDITION =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "VariantCondition");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @return The conditionRateAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionRateAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateAmount;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_RATE_AMOUNT =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRateAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseAmount</b>
     * </p>
     * 
     * @return The conditionBaseAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionBaseAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionBaseAmount;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_BASE_AMOUNT =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseQuantity</b>
     * </p>
     * 
     * @return Quantity of the Condition Basis
     */
    @Nullable
    @ElementName( "ConditionBaseQuantity" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionBaseQuantity;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_BASE_QUANTITY =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionBaseQuantity");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @Nullable
    @ElementName( "ConditionRateRatio" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateRatio;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_RATE_RATIO =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @return Unit of Measurement
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnit" )
    private java.lang.String conditionRateRatioUnit;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_RATE_RATIO_UNIT =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @return Condition Rate Ratio Unit in ISO code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitISOCode" )
    private java.lang.String conditionRateRatioUnitISOCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_RATE_RATIO_UNIT_ISO_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRateRatioUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Rate Ratio Unit in SAP code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitSAPCode" )
    private java.lang.String conditionRateRatioUnitSAPCode;
    public final static SimpleProperty.String<CustItmPricingElement> CONDITION_RATE_RATIO_UNIT_SAP_CODE =
        new SimpleProperty.String<CustItmPricingElement>(CustItmPricingElement.class, "ConditionRateRatioUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBaseAmount</b>
     * </p>
     * 
     * @return The conditionScaleBaseAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionScaleBaseAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionScaleBaseAmount;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_SCALE_BASE_AMOUNT =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(
            CustItmPricingElement.class,
            "ConditionScaleBaseAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBaseQuantity</b>
     * </p>
     * 
     * @return Scale Base Quantity
     */
    @Nullable
    @ElementName( "ConditionScaleBaseQuantity" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionScaleBaseQuantity;
    public final static SimpleProperty.NumericDecimal<CustItmPricingElement> CONDITION_SCALE_BASE_QUANTITY =
        new SimpleProperty.NumericDecimal<CustItmPricingElement>(
            CustItmPricingElement.class,
            "ConditionScaleBaseQuantity");
    /**
     * Navigation property <b>_SettlmtDoc</b> for <b>CustItmPricingElement</b> to single <b>SetlDoc</b>.
     * 
     */
    @ElementName( "_SettlmtDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SetlDoc to_SettlmtDoc;
    /**
     * Navigation property <b>_SettlmtDocItem</b> for <b>CustItmPricingElement</b> to single <b>SetlDocItm</b>.
     * 
     */
    @ElementName( "_SettlmtDocItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SetlDocItm to_SettlmtDocItem;
    /**
     * Use with available request builders to apply the <b>_SettlmtDoc</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CustItmPricingElement, SetlDoc> TO__SETTLMT_DOC =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CustItmPricingElement, SetlDoc>(
            CustItmPricingElement.class,
            "_SettlmtDoc",
            SetlDoc.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocItem</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CustItmPricingElement, SetlDocItm> TO__SETTLMT_DOC_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CustItmPricingElement, SetlDocItm>(
            CustItmPricingElement.class,
            "_SettlmtDocItem",
            SetlDocItm.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CustItmPricingElement> getType()
    {
        return CustItmPricingElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @param settlmtDoc
     *            Settlement Document Number
     */
    public void setSettlmtDoc( @Nullable final java.lang.String settlmtDoc )
    {
        rememberChangedField("SettlmtDoc", this.settlmtDoc);
        this.settlmtDoc = settlmtDoc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItem</b>
     * </p>
     * 
     * @param settlmtDocItem
     *            Document Item
     */
    public void setSettlmtDocItem( @Nullable final java.lang.String settlmtDocItem )
    {
        rememberChangedField("SettlmtDocItem", this.settlmtDocItem);
        this.settlmtDocItem = settlmtDocItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     * 
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final java.lang.String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     * 
     * @param pricingProcedureCounter
     *            Pricing Procedure Counter
     */
    public void setPricingProcedureCounter( @Nullable final java.lang.String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PriceConditionDeterminationDte</b>
     * </p>
     * 
     * @param priceConditionDeterminationDte
     *            The priceConditionDeterminationDte to set.
     */
    public void setPriceConditionDeterminationDte( @Nullable final LocalDate priceConditionDeterminationDte )
    {
        rememberChangedField("PriceConditionDeterminationDte", this.priceConditionDeterminationDte);
        this.priceConditionDeterminationDte = priceConditionDeterminationDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final java.lang.String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final java.lang.String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final java.lang.String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitISOCode
     *            Condition Quantity Unit in ISO code
     */
    public void setConditionQuantityUnitISOCode( @Nullable final java.lang.String conditionQuantityUnitISOCode )
    {
        rememberChangedField("ConditionQuantityUnitISOCode", this.conditionQuantityUnitISOCode);
        this.conditionQuantityUnitISOCode = conditionQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitSAPCode
     *            Condition Quantity Unit in SAP code
     */
    public void setConditionQuantityUnitSAPCode( @Nullable final java.lang.String conditionQuantityUnitSAPCode )
    {
        rememberChangedField("ConditionQuantityUnitSAPCode", this.conditionQuantityUnitSAPCode);
        this.conditionQuantityUnitSAPCode = conditionQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCategory</b>
     * </p>
     * 
     * @param conditionCategory
     *            Condition Category (Examples: Tax, Freight, Price, Cost)
     */
    public void setConditionCategory( @Nullable final java.lang.String conditionCategory )
    {
        rememberChangedField("ConditionCategory", this.conditionCategory);
        this.conditionCategory = conditionCategory;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     * 
     * @param conditionIsForStatistics
     *            Condition is used for statistics
     */
    public void setConditionIsForStatistics( @Nullable final java.lang.Boolean conditionIsForStatistics )
    {
        rememberChangedField("ConditionIsForStatistics", this.conditionIsForStatistics);
        this.conditionIsForStatistics = conditionIsForStatistics;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final java.lang.String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsRelevantForAccrual</b>
     * </p>
     * 
     * @param isRelevantForAccrual
     *            Condition is Relevant for Accrual (e.g. Freight)
     */
    public void setIsRelevantForAccrual( @Nullable final java.lang.Boolean isRelevantForAccrual )
    {
        rememberChangedField("IsRelevantForAccrual", this.isRelevantForAccrual);
        this.isRelevantForAccrual = isRelevantForAccrual;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsRelevantForInvoiceList</b>
     * </p>
     * 
     * @param cndnIsRelevantForInvoiceList
     *            Condition for Invoice List
     */
    public void setCndnIsRelevantForInvoiceList( @Nullable final java.lang.Boolean cndnIsRelevantForInvoiceList )
    {
        rememberChangedField("CndnIsRelevantForInvoiceList", this.cndnIsRelevantForInvoiceList);
        this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionOrigin</b>
     * </p>
     * 
     * @param conditionOrigin
     *            Origin of the Condition
     */
    public void setConditionOrigin( @Nullable final java.lang.String conditionOrigin )
    {
        rememberChangedField("ConditionOrigin", this.conditionOrigin);
        this.conditionOrigin = conditionOrigin;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsGroupCondition</b>
     * </p>
     * 
     * @param isGroupCondition
     *            Group Condition
     */
    public void setIsGroupCondition( @Nullable final java.lang.Boolean isGroupCondition )
    {
        rememberChangedField("IsGroupCondition", this.isGroupCondition);
        this.isGroupCondition = isGroupCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @param conditionRecord
     *            Number of the Condition Record
     */
    public void setConditionRecord( @Nullable final java.lang.String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionSequentialNumber</b>
     * </p>
     * 
     * @param conditionSequentialNumber
     *            Sequential Number of the Condition
     */
    public void setConditionSequentialNumber( @Nullable final java.lang.String conditionSequentialNumber )
    {
        rememberChangedField("ConditionSequentialNumber", this.conditionSequentialNumber);
        this.conditionSequentialNumber = conditionSequentialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>TaxCode</b>
     * </p>
     * 
     * @param taxCode
     *            Tax on Sales/Purchases Code
     */
    public void setTaxCode( @Nullable final java.lang.String taxCode )
    {
        rememberChangedField("TaxCode", this.taxCode);
        this.taxCode = taxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WithholdingTaxCode</b>
     * </p>
     * 
     * @param withholdingTaxCode
     *            Withholding Tax Code
     */
    public void setWithholdingTaxCode( @Nullable final java.lang.String withholdingTaxCode )
    {
        rememberChangedField("WithholdingTaxCode", this.withholdingTaxCode);
        this.withholdingTaxCode = withholdingTaxCode;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CndnRoundingOffDiffAmount</b>
     * </p>
     * 
     * @param cndnRoundingOffDiffAmount
     *            The cndnRoundingOffDiffAmount to set.
     */
    public void setCndnRoundingOffDiffAmount( @Nullable final BigDecimal cndnRoundingOffDiffAmount )
    {
        rememberChangedField("CndnRoundingOffDiffAmount", this.cndnRoundingOffDiffAmount);
        this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAmount</b>
     * </p>
     * 
     * @param conditionAmount
     *            The conditionAmount to set.
     */
    public void setConditionAmount( @Nullable final BigDecimal conditionAmount )
    {
        rememberChangedField("ConditionAmount", this.conditionAmount);
        this.conditionAmount = conditionAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionControl</b>
     * </p>
     * 
     * @param conditionControl
     *            Condition Control
     */
    public void setConditionControl( @Nullable final java.lang.String conditionControl )
    {
        rememberChangedField("ConditionControl", this.conditionControl);
        this.conditionControl = conditionControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     * 
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final java.lang.String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionClass</b>
     * </p>
     * 
     * @param conditionClass
     *            Condition Class
     */
    public void setConditionClass( @Nullable final java.lang.String conditionClass )
    {
        rememberChangedField("ConditionClass", this.conditionClass);
        this.conditionClass = conditionClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedureCounterForHeader</b>
     * </p>
     * 
     * @param prcgProcedureCounterForHeader
     *            Pricing Procedure Counter for Header
     */
    public void setPrcgProcedureCounterForHeader( @Nullable final java.lang.String prcgProcedureCounterForHeader )
    {
        rememberChangedField("PrcgProcedureCounterForHeader", this.prcgProcedureCounterForHeader);
        this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FactorForConditionBasisValue</b>
     * </p>
     * 
     * @param factorForConditionBasisValue
     *            Factor for Condition Basis Value
     */
    public void setFactorForConditionBasisValue( @Nullable final Double factorForConditionBasisValue )
    {
        rememberChangedField("FactorForConditionBasisValue", this.factorForConditionBasisValue);
        this.factorForConditionBasisValue = factorForConditionBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>StructureCondition</b>
     * </p>
     * 
     * @param structureCondition
     *            Structure Condition
     */
    public void setStructureCondition( @Nullable final java.lang.String structureCondition )
    {
        rememberChangedField("StructureCondition", this.structureCondition);
        this.structureCondition = structureCondition;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PeriodFactorForCndnBasisValue</b>
     * </p>
     * 
     * @param periodFactorForCndnBasisValue
     *            Period Factor for Condition Basis Value
     */
    public void setPeriodFactorForCndnBasisValue( @Nullable final Double periodFactorForCndnBasisValue )
    {
        rememberChangedField("PeriodFactorForCndnBasisValue", this.periodFactorForCndnBasisValue);
        this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final java.lang.String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnit</b>
     * </p>
     * 
     * @param conditionScaleBasisUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleBasisUnit( @Nullable final java.lang.String conditionScaleBasisUnit )
    {
        rememberChangedField("ConditionScaleBasisUnit", this.conditionScaleBasisUnit);
        this.conditionScaleBasisUnit = conditionScaleBasisUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnitISOCode</b>
     * </p>
     * 
     * @param conditionScaleBasisUnitISOCode
     *            Condition Scale Basis Unit in ISO code
     */
    public void setConditionScaleBasisUnitISOCode( @Nullable final java.lang.String conditionScaleBasisUnitISOCode )
    {
        rememberChangedField("ConditionScaleBasisUnitISOCode", this.conditionScaleBasisUnitISOCode);
        this.conditionScaleBasisUnitISOCode = conditionScaleBasisUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisUnitSAPCode</b>
     * </p>
     * 
     * @param conditionScaleBasisUnitSAPCode
     *            Condition Scale Basis Unit in SAP code
     */
    public void setConditionScaleBasisUnitSAPCode( @Nullable final java.lang.String conditionScaleBasisUnitSAPCode )
    {
        rememberChangedField("ConditionScaleBasisUnitSAPCode", this.conditionScaleBasisUnitSAPCode);
        this.conditionScaleBasisUnitSAPCode = conditionScaleBasisUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBasisCurrency</b>
     * </p>
     * 
     * @param conditionScaleBasisCurrency
     *            Scale Currency
     */
    public void setConditionScaleBasisCurrency( @Nullable final java.lang.String conditionScaleBasisCurrency )
    {
        rememberChangedField("ConditionScaleBasisCurrency", this.conditionScaleBasisCurrency);
        this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyChanged</b>
     * </p>
     * 
     * @param conditionIsManuallyChanged
     *            Condition Changed Manually
     */
    public void setConditionIsManuallyChanged( @Nullable final java.lang.Boolean conditionIsManuallyChanged )
    {
        rememberChangedField("ConditionIsManuallyChanged", this.conditionIsManuallyChanged);
        this.conditionIsManuallyChanged = conditionIsManuallyChanged;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForConfiguration</b>
     * </p>
     * 
     * @param conditionIsForConfiguration
     *            Condition Used for Variant Configuration
     */
    public void setConditionIsForConfiguration( @Nullable final java.lang.Boolean conditionIsForConfiguration )
    {
        rememberChangedField("ConditionIsForConfiguration", this.conditionIsForConfiguration);
        this.conditionIsForConfiguration = conditionIsForConfiguration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 26
     * <p>
     * Original property name from the Odata EDM: <b>VariantCondition</b>
     * </p>
     * 
     * @param variantCondition
     *            Variant Condition Key
     */
    public void setVariantCondition( @Nullable final java.lang.String variantCondition )
    {
        rememberChangedField("VariantCondition", this.variantCondition);
        this.variantCondition = variantCondition;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @param conditionRateAmount
     *            The conditionRateAmount to set.
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseAmount</b>
     * </p>
     * 
     * @param conditionBaseAmount
     *            The conditionBaseAmount to set.
     */
    public void setConditionBaseAmount( @Nullable final BigDecimal conditionBaseAmount )
    {
        rememberChangedField("ConditionBaseAmount", this.conditionBaseAmount);
        this.conditionBaseAmount = conditionBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionBaseQuantity</b>
     * </p>
     * 
     * @param conditionBaseQuantity
     *            Quantity of the Condition Basis
     */
    public void setConditionBaseQuantity( @Nullable final BigDecimal conditionBaseQuantity )
    {
        rememberChangedField("ConditionBaseQuantity", this.conditionBaseQuantity);
        this.conditionBaseQuantity = conditionBaseQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @param conditionRateRatioUnit
     *            Unit of Measurement
     */
    public void setConditionRateRatioUnit( @Nullable final java.lang.String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitISOCode
     *            Condition Rate Ratio Unit in ISO code
     */
    public void setConditionRateRatioUnitISOCode( @Nullable final java.lang.String conditionRateRatioUnitISOCode )
    {
        rememberChangedField("ConditionRateRatioUnitISOCode", this.conditionRateRatioUnitISOCode);
        this.conditionRateRatioUnitISOCode = conditionRateRatioUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitSAPCode
     *            Condition Rate Ratio Unit in SAP code
     */
    public void setConditionRateRatioUnitSAPCode( @Nullable final java.lang.String conditionRateRatioUnitSAPCode )
    {
        rememberChangedField("ConditionRateRatioUnitSAPCode", this.conditionRateRatioUnitSAPCode);
        this.conditionRateRatioUnitSAPCode = conditionRateRatioUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBaseAmount</b>
     * </p>
     * 
     * @param conditionScaleBaseAmount
     *            The conditionScaleBaseAmount to set.
     */
    public void setConditionScaleBaseAmount( @Nullable final BigDecimal conditionScaleBaseAmount )
    {
        rememberChangedField("ConditionScaleBaseAmount", this.conditionScaleBaseAmount);
        this.conditionScaleBaseAmount = conditionScaleBaseAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleBaseQuantity</b>
     * </p>
     * 
     * @param conditionScaleBaseQuantity
     *            Scale Base Quantity
     */
    public void setConditionScaleBaseQuantity( @Nullable final BigDecimal conditionScaleBaseQuantity )
    {
        rememberChangedField("ConditionScaleBaseQuantity", this.conditionScaleBaseQuantity);
        this.conditionScaleBaseQuantity = conditionScaleBaseQuantity;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CustItmPricingElement";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtDoc", getSettlmtDoc());
        entityKey.addKeyProperty("SettlmtDocItem", getSettlmtDocItem());
        entityKey.addKeyProperty("PricingProcedureStep", getPricingProcedureStep());
        entityKey.addKeyProperty("PricingProcedureCounter", getPricingProcedureCounter());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtDoc", getSettlmtDoc());
        values.put("SettlmtDocItem", getSettlmtDocItem());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("PriceConditionDeterminationDte", getPriceConditionDeterminationDte());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionQuantityUnitISOCode", getConditionQuantityUnitISOCode());
        values.put("ConditionQuantityUnitSAPCode", getConditionQuantityUnitSAPCode());
        values.put("ConditionCategory", getConditionCategory());
        values.put("ConditionIsForStatistics", getConditionIsForStatistics());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("IsRelevantForAccrual", getIsRelevantForAccrual());
        values.put("CndnIsRelevantForInvoiceList", getCndnIsRelevantForInvoiceList());
        values.put("ConditionOrigin", getConditionOrigin());
        values.put("IsGroupCondition", getIsGroupCondition());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionSequentialNumber", getConditionSequentialNumber());
        values.put("TaxCode", getTaxCode());
        values.put("WithholdingTaxCode", getWithholdingTaxCode());
        values.put("CndnRoundingOffDiffAmount", getCndnRoundingOffDiffAmount());
        values.put("ConditionAmount", getConditionAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ConditionControl", getConditionControl());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        values.put("ConditionClass", getConditionClass());
        values.put("PrcgProcedureCounterForHeader", getPrcgProcedureCounterForHeader());
        values.put("FactorForConditionBasisValue", getFactorForConditionBasisValue());
        values.put("StructureCondition", getStructureCondition());
        values.put("PeriodFactorForCndnBasisValue", getPeriodFactorForCndnBasisValue());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionScaleBasisUnit", getConditionScaleBasisUnit());
        values.put("ConditionScaleBasisUnitISOCode", getConditionScaleBasisUnitISOCode());
        values.put("ConditionScaleBasisUnitSAPCode", getConditionScaleBasisUnitSAPCode());
        values.put("ConditionScaleBasisCurrency", getConditionScaleBasisCurrency());
        values.put("ConditionIsManuallyChanged", getConditionIsManuallyChanged());
        values.put("ConditionIsForConfiguration", getConditionIsForConfiguration());
        values.put("VariantCondition", getVariantCondition());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionBaseAmount", getConditionBaseAmount());
        values.put("ConditionBaseQuantity", getConditionBaseQuantity());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateRatioUnitISOCode", getConditionRateRatioUnitISOCode());
        values.put("ConditionRateRatioUnitSAPCode", getConditionRateRatioUnitSAPCode());
        values.put("ConditionScaleBaseAmount", getConditionScaleBaseAmount());
        values.put("ConditionScaleBaseQuantity", getConditionScaleBaseQuantity());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtDoc") ) {
                final Object value = values.remove("SettlmtDoc");
                if( (value == null) || (!value.equals(getSettlmtDoc())) ) {
                    setSettlmtDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocItem") ) {
                final Object value = values.remove("SettlmtDocItem");
                if( (value == null) || (!value.equals(getSettlmtDocItem())) ) {
                    setSettlmtDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriceConditionDeterminationDte") ) {
                final Object value = values.remove("PriceConditionDeterminationDte");
                if( (value == null) || (!value.equals(getPriceConditionDeterminationDte())) ) {
                    setPriceConditionDeterminationDte(((LocalDate) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitISOCode") ) {
                final Object value = values.remove("ConditionQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitISOCode())) ) {
                    setConditionQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitSAPCode") ) {
                final Object value = values.remove("ConditionQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitSAPCode())) ) {
                    setConditionQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionCategory") ) {
                final Object value = values.remove("ConditionCategory");
                if( (value == null) || (!value.equals(getConditionCategory())) ) {
                    setConditionCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionIsForStatistics") ) {
                final Object value = values.remove("ConditionIsForStatistics");
                if( (value == null) || (!value.equals(getConditionIsForStatistics())) ) {
                    setConditionIsForStatistics(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsRelevantForAccrual") ) {
                final Object value = values.remove("IsRelevantForAccrual");
                if( (value == null) || (!value.equals(getIsRelevantForAccrual())) ) {
                    setIsRelevantForAccrual(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CndnIsRelevantForInvoiceList") ) {
                final Object value = values.remove("CndnIsRelevantForInvoiceList");
                if( (value == null) || (!value.equals(getCndnIsRelevantForInvoiceList())) ) {
                    setCndnIsRelevantForInvoiceList(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("ConditionOrigin") ) {
                final Object value = values.remove("ConditionOrigin");
                if( (value == null) || (!value.equals(getConditionOrigin())) ) {
                    setConditionOrigin(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsGroupCondition") ) {
                final Object value = values.remove("IsGroupCondition");
                if( (value == null) || (!value.equals(getIsGroupCondition())) ) {
                    setIsGroupCondition(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionSequentialNumber") ) {
                final Object value = values.remove("ConditionSequentialNumber");
                if( (value == null) || (!value.equals(getConditionSequentialNumber())) ) {
                    setConditionSequentialNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCode") ) {
                final Object value = values.remove("TaxCode");
                if( (value == null) || (!value.equals(getTaxCode())) ) {
                    setTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("WithholdingTaxCode") ) {
                final Object value = values.remove("WithholdingTaxCode");
                if( (value == null) || (!value.equals(getWithholdingTaxCode())) ) {
                    setWithholdingTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnRoundingOffDiffAmount") ) {
                final Object value = values.remove("CndnRoundingOffDiffAmount");
                if( (value == null) || (!value.equals(getCndnRoundingOffDiffAmount())) ) {
                    setCndnRoundingOffDiffAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAmount") ) {
                final Object value = values.remove("ConditionAmount");
                if( (value == null) || (!value.equals(getConditionAmount())) ) {
                    setConditionAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionControl") ) {
                final Object value = values.remove("ConditionControl");
                if( (value == null) || (!value.equals(getConditionControl())) ) {
                    setConditionControl(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionClass") ) {
                final Object value = values.remove("ConditionClass");
                if( (value == null) || (!value.equals(getConditionClass())) ) {
                    setConditionClass(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgProcedureCounterForHeader") ) {
                final Object value = values.remove("PrcgProcedureCounterForHeader");
                if( (value == null) || (!value.equals(getPrcgProcedureCounterForHeader())) ) {
                    setPrcgProcedureCounterForHeader(((java.lang.String) value));
                }
            }
            if( values.containsKey("FactorForConditionBasisValue") ) {
                final Object value = values.remove("FactorForConditionBasisValue");
                if( (value == null) || (!value.equals(getFactorForConditionBasisValue())) ) {
                    setFactorForConditionBasisValue(((Double) value));
                }
            }
            if( values.containsKey("StructureCondition") ) {
                final Object value = values.remove("StructureCondition");
                if( (value == null) || (!value.equals(getStructureCondition())) ) {
                    setStructureCondition(((java.lang.String) value));
                }
            }
            if( values.containsKey("PeriodFactorForCndnBasisValue") ) {
                final Object value = values.remove("PeriodFactorForCndnBasisValue");
                if( (value == null) || (!value.equals(getPeriodFactorForCndnBasisValue())) ) {
                    setPeriodFactorForCndnBasisValue(((Double) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnit") ) {
                final Object value = values.remove("ConditionScaleBasisUnit");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnit())) ) {
                    setConditionScaleBasisUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnitISOCode") ) {
                final Object value = values.remove("ConditionScaleBasisUnitISOCode");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnitISOCode())) ) {
                    setConditionScaleBasisUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisUnitSAPCode") ) {
                final Object value = values.remove("ConditionScaleBasisUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionScaleBasisUnitSAPCode())) ) {
                    setConditionScaleBasisUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleBasisCurrency") ) {
                final Object value = values.remove("ConditionScaleBasisCurrency");
                if( (value == null) || (!value.equals(getConditionScaleBasisCurrency())) ) {
                    setConditionScaleBasisCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionIsManuallyChanged") ) {
                final Object value = values.remove("ConditionIsManuallyChanged");
                if( (value == null) || (!value.equals(getConditionIsManuallyChanged())) ) {
                    setConditionIsManuallyChanged(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("ConditionIsForConfiguration") ) {
                final Object value = values.remove("ConditionIsForConfiguration");
                if( (value == null) || (!value.equals(getConditionIsForConfiguration())) ) {
                    setConditionIsForConfiguration(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("VariantCondition") ) {
                final Object value = values.remove("VariantCondition");
                if( (value == null) || (!value.equals(getVariantCondition())) ) {
                    setVariantCondition(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionBaseAmount") ) {
                final Object value = values.remove("ConditionBaseAmount");
                if( (value == null) || (!value.equals(getConditionBaseAmount())) ) {
                    setConditionBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionBaseQuantity") ) {
                final Object value = values.remove("ConditionBaseQuantity");
                if( (value == null) || (!value.equals(getConditionBaseQuantity())) ) {
                    setConditionBaseQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitISOCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitISOCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitISOCode())) ) {
                    setConditionRateRatioUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitSAPCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitSAPCode())) ) {
                    setConditionRateRatioUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleBaseAmount") ) {
                final Object value = values.remove("ConditionScaleBaseAmount");
                if( (value == null) || (!value.equals(getConditionScaleBaseAmount())) ) {
                    setConditionScaleBaseAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleBaseQuantity") ) {
                final Object value = values.remove("ConditionScaleBaseQuantity");
                if( (value == null) || (!value.equals(getConditionScaleBaseQuantity())) ) {
                    setConditionScaleBaseQuantity(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SettlmtDoc") ) {
                final Object value = (values).remove("_SettlmtDoc");
                if( value instanceof Map ) {
                    if( to_SettlmtDoc == null ) {
                        to_SettlmtDoc = new SetlDoc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_SettlmtDocItem") ) {
                final Object value = (values).remove("_SettlmtDocItem");
                if( value instanceof Map ) {
                    if( to_SettlmtDocItem == null ) {
                        to_SettlmtDocItem = new SetlDocItm();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDocItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SettlmtDoc != null ) {
            (values).put("_SettlmtDoc", to_SettlmtDoc);
        }
        if( to_SettlmtDocItem != null ) {
            (values).put("_SettlmtDocItem", to_SettlmtDocItem);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SetlDoc</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_SettlmtDoc</b>.
     * <p>
     * If the navigation property for an entity <b>CustItmPricingElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDoc</b> is already loaded, the result will contain
     *         the <b>SetlDoc</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SetlDoc> getSettlmtDocIfPresent()
    {
        return Option.of(to_SettlmtDoc);
    }

    /**
     * Overwrites the associated <b>SetlDoc</b> entity for the loaded navigation property <b>_SettlmtDoc</b>.
     * 
     * @param value
     *            New <b>SetlDoc</b> entity.
     */
    public void setSettlmtDoc( final SetlDoc value )
    {
        to_SettlmtDoc = value;
    }

    /**
     * Retrieval of associated <b>SetlDocItm</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_SettlmtDocItem</b>.
     * <p>
     * If the navigation property for an entity <b>CustItmPricingElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocItem</b> is already loaded, the result will
     *         contain the <b>SetlDocItm</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SetlDocItm> getSettlmtDocItemIfPresent()
    {
        return Option.of(to_SettlmtDocItem);
    }

    /**
     * Overwrites the associated <b>SetlDocItm</b> entity for the loaded navigation property <b>_SettlmtDocItem</b>.
     * 
     * @param value
     *            New <b>SetlDocItm</b> entity.
     */
    public void setSettlmtDocItem( final SetlDocItm value )
    {
        to_SettlmtDocItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CustItmPricingElement instances.
     * 
     */
    public final static class CustItmPricingElementBuilder
    {

        private SetlDoc to_SettlmtDoc;
        private java.lang.String settlmtDoc = null;
        private SetlDocItm to_SettlmtDocItem;
        private java.lang.String settlmtDocItem = null;

        private CustItmPricingElement.CustItmPricingElementBuilder to_SettlmtDoc( final SetlDoc value )
        {
            to_SettlmtDoc = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDoc</b> for <b>CustItmPricingElement</b> to single <b>SetlDoc</b>.
         * 
         * @param value
         *            The SetlDoc to build this CustItmPricingElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustItmPricingElement.CustItmPricingElementBuilder settlmtDoc( final SetlDoc value )
        {
            return to_SettlmtDoc(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDoc</b>
         * </p>
         * 
         * @param value
         *            The settlmtDoc to build this CustItmPricingElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustItmPricingElement.CustItmPricingElementBuilder settlmtDoc( final java.lang.String value )
        {
            settlmtDoc = value;
            return this;
        }

        private CustItmPricingElement.CustItmPricingElementBuilder to_SettlmtDocItem( final SetlDocItm value )
        {
            to_SettlmtDocItem = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocItem</b> for <b>CustItmPricingElement</b> to single <b>SetlDocItm</b>.
         * 
         * @param value
         *            The SetlDocItm to build this CustItmPricingElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustItmPricingElement.CustItmPricingElementBuilder settlmtDocItem( final SetlDocItm value )
        {
            return to_SettlmtDocItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDocItem</b>
         * </p>
         * 
         * @param value
         *            The settlmtDocItem to build this CustItmPricingElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CustItmPricingElement.CustItmPricingElementBuilder settlmtDocItem( final java.lang.String value )
        {
            settlmtDocItem = value;
            return this;
        }

    }

}
