/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Settlement Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SetlDocType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SetlDoc extends VdmEntity<SetlDoc> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.SetlDocType";
    /**
     * Selector for all available fields of SetlDoc.
     * 
     */
    public final static SimpleProperty<SetlDoc> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @return Settlement Document Number
     */
    @Nullable
    @ElementName( "SettlmtDoc" )
    private java.lang.String settlmtDoc;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_DOC =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtDoc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @return Settlement Document Type
     */
    @Nullable
    @ElementName( "SettlmtDocType" )
    private java.lang.String settlmtDocType;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_DOC_TYPE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtDocType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @return Settlement Process Type
     */
    @Nullable
    @ElementName( "SettlmtProcessType" )
    private java.lang.String settlmtProcessType;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_PROCESS_TYPE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtProcessType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     * 
     * @return Posting Date
     */
    @Nullable
    @ElementName( "PostingDate" )
    private LocalDate postingDate;
    public final static SimpleProperty.Date<SetlDoc> POSTING_DATE =
        new SimpleProperty.Date<SetlDoc>(SetlDoc.class, "PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     * 
     * @return Different Invoicing Party
     */
    @Nullable
    @ElementName( "InvoicingParty" )
    private java.lang.String invoicingParty;
    public final static SimpleProperty.String<SetlDoc> INVOICING_PARTY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "InvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayeeParty</b>
     * </p>
     * 
     * @return Payee
     */
    @Nullable
    @ElementName( "PayeeParty" )
    private java.lang.String payeeParty;
    public final static SimpleProperty.String<SetlDoc> PAYEE_PARTY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "PayeeParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     * 
     * @return Bill-to Party
     */
    @Nullable
    @ElementName( "BillToParty" )
    private java.lang.String billToParty;
    public final static SimpleProperty.String<SetlDoc> BILL_TO_PARTY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     * 
     * @return Payer
     */
    @Nullable
    @ElementName( "PayerParty" )
    private java.lang.String payerParty;
    public final static SimpleProperty.String<SetlDoc> PAYER_PARTY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<SetlDoc> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @return Purchasing Group
     */
    @Nullable
    @ElementName( "PurchasingGroup" )
    private java.lang.String purchasingGroup;
    public final static SimpleProperty.String<SetlDoc> PURCHASING_GROUP =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @return Sales Organization
     */
    @Nullable
    @ElementName( "SalesOrganization" )
    private java.lang.String salesOrganization;
    public final static SimpleProperty.String<SetlDoc> SALES_ORGANIZATION =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @return Distribution Channel
     */
    @Nullable
    @ElementName( "DistributionChannel" )
    private java.lang.String distributionChannel;
    public final static SimpleProperty.String<SetlDoc> DISTRIBUTION_CHANNEL =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<SetlDoc> DIVISION =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtCompanyCode</b>
     * </p>
     * 
     * @return Supplier Company Code
     */
    @Nullable
    @ElementName( "SuplrSettlmtCompanyCode" )
    private java.lang.String suplrSettlmtCompanyCode;
    public final static SimpleProperty.String<SetlDoc> SUPLR_SETTLMT_COMPANY_CODE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SuplrSettlmtCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtCompanyCode</b>
     * </p>
     * 
     * @return Customer Company Code
     */
    @Nullable
    @ElementName( "CustSettlmtCompanyCode" )
    private java.lang.String custSettlmtCompanyCode;
    public final static SimpleProperty.String<SetlDoc> CUST_SETTLMT_COMPANY_CODE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CustSettlmtCompanyCode");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @return Document Date in Settlement Management Document
     */
    @Nullable
    @ElementName( "DocumentDate" )
    private LocalDate documentDate;
    public final static SimpleProperty.Date<SetlDoc> DOCUMENT_DATE =
        new SimpleProperty.Date<SetlDoc>(SetlDoc.class, "DocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     * 
     * @return Reference Document Number
     */
    @Nullable
    @ElementName( "DocumentReferenceID" )
    private java.lang.String documentReferenceID;
    public final static SimpleProperty.String<SetlDoc> DOCUMENT_REFERENCE_ID =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "DocumentReferenceID");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     * 
     * @return Assignment Number
     */
    @Nullable
    @ElementName( "AssignmentReference" )
    private java.lang.String assignmentReference;
    public final static SimpleProperty.String<SetlDoc> ASSIGNMENT_REFERENCE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrency</b>
     * </p>
     * 
     * @return Currency of Settlement Document
     */
    @Nullable
    @ElementName( "SettlmtDocCurrency" )
    private java.lang.String settlmtDocCurrency;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_DOC_CURRENCY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrencyISOCode</b>
     * </p>
     * 
     * @return ISO Code Currency
     */
    @Nullable
    @ElementName( "SettlmtDocCurrencyISOCode" )
    private java.lang.String settlmtDocCurrencyISOCode;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_DOC_CURRENCY_ISO_CODE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtDocCurrencyISOCode");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     * 
     * @return Conversion Rate (Not Converted)
     */
    @Nullable
    @ElementName( "ExchangeRate" )
    @DecimalDescriptor( precision = 9, scale = 5 )
    private BigDecimal exchangeRate;
    public final static SimpleProperty.NumericDecimal<SetlDoc> EXCHANGE_RATE =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "ExchangeRate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     * 
     * @return Indicator for Fixed Exchange Rate
     */
    @Nullable
    @ElementName( "ExchangeRateIsFixed" )
    private java.lang.Boolean exchangeRateIsFixed;
    public final static SimpleProperty.Boolean<SetlDoc> EXCHANGE_RATE_IS_FIXED =
        new SimpleProperty.Boolean<SetlDoc>(SetlDoc.class, "ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalGrossAmount</b>
     * </p>
     * 
     * @return The supplierTotalGrossAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierTotalGrossAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal supplierTotalGrossAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_TOTAL_GROSS_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierTotalGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalNetAmount</b>
     * </p>
     * 
     * @return The supplierTotalNetAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierTotalNetAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal supplierTotalNetAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_TOTAL_NET_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierTotalNetAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalTaxAmount</b>
     * </p>
     * 
     * @return The supplierTotalTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierTotalTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal supplierTotalTaxAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_TOTAL_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierTotalTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalGrossAmount</b>
     * </p>
     * 
     * @return The customerTotalGrossAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerTotalGrossAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal customerTotalGrossAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_TOTAL_GROSS_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerTotalGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalNetAmount</b>
     * </p>
     * 
     * @return The customerTotalNetAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerTotalNetAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal customerTotalNetAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_TOTAL_NET_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerTotalNetAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalTaxAmount</b>
     * </p>
     * 
     * @return The customerTotalTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerTotalTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal customerTotalTaxAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_TOTAL_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerTotalTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPaymentTerms</b>
     * </p>
     * 
     * @return Terms of Payment Key for Supplier
     */
    @Nullable
    @ElementName( "SupplierPaymentTerms" )
    private java.lang.String supplierPaymentTerms;
    public final static SimpleProperty.String<SetlDoc> SUPPLIER_PAYMENT_TERMS =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SupplierPaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount1Days</b>
     * </p>
     * 
     * @return Supplier Cash Discount First Payment in Days
     */
    @Nullable
    @ElementName( "SupplierCashDiscount1Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal supplierCashDiscount1Days;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_CASH_DISCOUNT1_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierCashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount2Days</b>
     * </p>
     * 
     * @return Supplier Cash Discount Second Payment in Days
     */
    @Nullable
    @ElementName( "SupplierCashDiscount2Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal supplierCashDiscount2Days;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_CASH_DISCOUNT2_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierCashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierNetPaymentDays</b>
     * </p>
     * 
     * @return Supplier Cash Discount Days
     */
    @Nullable
    @ElementName( "SupplierNetPaymentDays" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal supplierNetPaymentDays;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_NET_PAYMENT_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierNetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount1Percent</b>
     * </p>
     * 
     * @return Supplier Cash Discount for First Payment in %
     */
    @Nullable
    @ElementName( "SupplierCashDiscount1Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal supplierCashDiscount1Percent;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_CASH_DISCOUNT1_PERCENT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierCashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount2Percent</b>
     * </p>
     * 
     * @return Supplier Cash Discount for Second Payment in %
     */
    @Nullable
    @ElementName( "SupplierCashDiscount2Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal supplierCashDiscount2Percent;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPPLIER_CASH_DISCOUNT2_PERCENT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SupplierCashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPaymentMethod</b>
     * </p>
     * 
     * @return Supplier Payment Method
     */
    @Nullable
    @ElementName( "SupplierPaymentMethod" )
    private java.lang.String supplierPaymentMethod;
    public final static SimpleProperty.String<SetlDoc> SUPPLIER_PAYMENT_METHOD =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SupplierPaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     * 
     * @return Terms of Payment Key for Customer
     */
    @Nullable
    @ElementName( "CustomerPaymentTerms" )
    private java.lang.String customerPaymentTerms;
    public final static SimpleProperty.String<SetlDoc> CUSTOMER_PAYMENT_TERMS =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount1Days</b>
     * </p>
     * 
     * @return Customer Cash Discount First Payment in Days
     */
    @Nullable
    @ElementName( "CustomerCashDiscount1Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal customerCashDiscount1Days;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_CASH_DISCOUNT1_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerCashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount2Days</b>
     * </p>
     * 
     * @return Customer Cash Discount Second Payment in Days
     */
    @Nullable
    @ElementName( "CustomerCashDiscount2Days" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal customerCashDiscount2Days;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_CASH_DISCOUNT2_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerCashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerNetPaymentDays</b>
     * </p>
     * 
     * @return Customer Cash Discount Days
     */
    @Nullable
    @ElementName( "CustomerNetPaymentDays" )
    @DecimalDescriptor( precision = 3, scale = 0 )
    private BigDecimal customerNetPaymentDays;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_NET_PAYMENT_DAYS =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerNetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount1Percent</b>
     * </p>
     * 
     * @return Customer Cash Discount for First Payment in %
     */
    @Nullable
    @ElementName( "CustomerCashDiscount1Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal customerCashDiscount1Percent;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_CASH_DISCOUNT1_PERCENT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerCashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount2Percent</b>
     * </p>
     * 
     * @return Custromer Cash Discount for Second Payment in %
     */
    @Nullable
    @ElementName( "CustomerCashDiscount2Percent" )
    @DecimalDescriptor( precision = 5, scale = 3 )
    private BigDecimal customerCashDiscount2Percent;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUSTOMER_CASH_DISCOUNT2_PERCENT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustomerCashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentMethod</b>
     * </p>
     * 
     * @return Customer Payment Method
     */
    @Nullable
    @ElementName( "CustomerPaymentMethod" )
    private java.lang.String customerPaymentMethod;
    public final static SimpleProperty.String<SetlDoc> CUSTOMER_PAYMENT_METHOD =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CustomerPaymentMethod");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrTotEligibleAmtForCshDisc</b>
     * </p>
     * 
     * @return The suplrTotEligibleAmtForCshDisc contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SuplrTotEligibleAmtForCshDisc" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal suplrTotEligibleAmtForCshDisc;
    public final static SimpleProperty.NumericDecimal<SetlDoc> SUPLR_TOT_ELIGIBLE_AMT_FOR_CSH_DISC =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "SuplrTotEligibleAmtForCshDisc");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustTotEligibleAmtForCshDisc</b>
     * </p>
     * 
     * @return The custTotEligibleAmtForCshDisc contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustTotEligibleAmtForCshDisc" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal custTotEligibleAmtForCshDisc;
    public final static SimpleProperty.NumericDecimal<SetlDoc> CUST_TOT_ELIGIBLE_AMT_FOR_CSH_DISC =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "CustTotEligibleAmtForCshDisc");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocIsCanceled</b>
     * </p>
     * 
     * @return Settlement Document is Reversed
     */
    @Nullable
    @ElementName( "SettlmtDocIsCanceled" )
    private java.lang.Boolean settlmtDocIsCanceled;
    public final static SimpleProperty.Boolean<SetlDoc> SETTLMT_DOC_IS_CANCELED =
        new SimpleProperty.Boolean<SetlDoc>(SetlDoc.class, "SettlmtDocIsCanceled");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CanceledSettlmtDoc</b>
     * </p>
     * 
     * @return Reversed Document
     */
    @Nullable
    @ElementName( "CanceledSettlmtDoc" )
    private java.lang.String canceledSettlmtDoc;
    public final static SimpleProperty.String<SetlDoc> CANCELED_SETTLMT_DOC =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CanceledSettlmtDoc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocActivityReason</b>
     * </p>
     * 
     * @return Header Activity Reason for Document Creation
     */
    @Nullable
    @ElementName( "SettlmtDocActivityReason" )
    private java.lang.String settlmtDocActivityReason;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_DOC_ACTIVITY_REASON =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtDocActivityReason");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     * 
     * @return Payment Reference
     */
    @Nullable
    @ElementName( "PaymentReference" )
    private java.lang.String paymentReference;
    public final static SimpleProperty.String<SetlDoc> PAYMENT_REFERENCE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "PaymentReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplSts</b>
     * </p>
     * 
     * @return Application Status for a Settlement Management Document
     */
    @Nullable
    @ElementName( "SettlmtApplSts" )
    private java.lang.String settlmtApplSts;
    public final static SimpleProperty.String<SetlDoc> SETTLMT_APPL_STS =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SettlmtApplSts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @return Sales Office
     */
    @Nullable
    @ElementName( "SalesOffice" )
    private java.lang.String salesOffice;
    public final static SimpleProperty.String<SetlDoc> SALES_OFFICE =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @return Sales Group
     */
    @Nullable
    @ElementName( "SalesGroup" )
    private java.lang.String salesGroup;
    public final static SimpleProperty.String<SetlDoc> SALES_GROUP =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSettlmtBlkgReason</b>
     * </p>
     * 
     * @return Reason for Supplier Settlement Block
     */
    @Nullable
    @ElementName( "SupplierSettlmtBlkgReason" )
    private java.lang.String supplierSettlmtBlkgReason;
    public final static SimpleProperty.String<SetlDoc> SUPPLIER_SETTLMT_BLKG_REASON =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SupplierSettlmtBlkgReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSettlmtBlkgReason</b>
     * </p>
     * 
     * @return Reason for Customer Settlement Block
     */
    @Nullable
    @ElementName( "CustomerSettlmtBlkgReason" )
    private java.lang.String customerSettlmtBlkgReason;
    public final static SimpleProperty.String<SetlDoc> CUSTOMER_SETTLMT_BLKG_REASON =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CustomerSettlmtBlkgReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     * 
     * @return Tax Departure Country/Region
     */
    @Nullable
    @ElementName( "TaxDepartureCountry" )
    private java.lang.String taxDepartureCountry;
    public final static SimpleProperty.String<SetlDoc> TAX_DEPARTURE_COUNTRY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "TaxDepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDestinationCountry</b>
     * </p>
     * 
     * @return Tax Destination Country/Region
     */
    @Nullable
    @ElementName( "TaxDestinationCountry" )
    private java.lang.String taxDestinationCountry;
    public final static SimpleProperty.String<SetlDoc> TAX_DESTINATION_COUNTRY =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "TaxDestinationCountry");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     * 
     * @return Indicator: Triangular Deal Within the EU
     */
    @Nullable
    @ElementName( "IsEUTriangularDeal" )
    private java.lang.Boolean isEUTriangularDeal;
    public final static SimpleProperty.Boolean<SetlDoc> IS_EU_TRIANGULAR_DEAL =
        new SimpleProperty.Boolean<SetlDoc>(SetlDoc.class, "IsEUTriangularDeal");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierVATRegistration</b>
     * </p>
     * 
     * @return Supplier VAT Registration Number
     */
    @Nullable
    @ElementName( "SupplierVATRegistration" )
    private java.lang.String supplierVATRegistration;
    public final static SimpleProperty.String<SetlDoc> SUPPLIER_VAT_REGISTRATION =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "SupplierVATRegistration");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerVATRegistration</b>
     * </p>
     * 
     * @return Customer VAT Registration Number
     */
    @Nullable
    @ElementName( "CustomerVATRegistration" )
    private java.lang.String customerVATRegistration;
    public final static SimpleProperty.String<SetlDoc> CUSTOMER_VAT_REGISTRATION =
        new SimpleProperty.String<SetlDoc>(SetlDoc.class, "CustomerVATRegistration");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     * 
     * @return The totalGrossAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "TotalGrossAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal totalGrossAmount;
    public final static SimpleProperty.NumericDecimal<SetlDoc> TOTAL_GROSS_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDoc>(SetlDoc.class, "TotalGrossAmount");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SetlDoc, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SetlDoc, SAP__Message>(
            SetlDoc.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_CustomerPricingElement</b> for <b>SetlDoc</b> to multiple <b>CustPricingElement</b>.
     * 
     */
    @ElementName( "_CustomerPricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustPricingElement> to_CustomerPricingElement;
    /**
     * Navigation property <b>_SettlmtDocItem</b> for <b>SetlDoc</b> to multiple <b>SetlDocItm</b>.
     * 
     */
    @ElementName( "_SettlmtDocItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SetlDocItm> to_SettlmtDocItem;
    /**
     * Navigation property <b>_SupplierPricingElement</b> for <b>SetlDoc</b> to multiple <b>SuplrPricingElement</b>.
     * 
     */
    @ElementName( "_SupplierPricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrPricingElement> to_SupplierPricingElement;
    /**
     * Use with available request builders to apply the <b>_CustomerPricingElement</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, CustPricingElement> TO__CUSTOMER_PRICING_ELEMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, CustPricingElement>(
            SetlDoc.class,
            "_CustomerPricingElement",
            CustPricingElement.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocItem</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, SetlDocItm> TO__SETTLMT_DOC_ITEM =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, SetlDocItm>(
            SetlDoc.class,
            "_SettlmtDocItem",
            SetlDocItm.class);
    /**
     * Use with available request builders to apply the <b>_SupplierPricingElement</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, SuplrPricingElement> TO__SUPPLIER_PRICING_ELEMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDoc, SuplrPricingElement>(
            SetlDoc.class,
            "_SupplierPricingElement",
            SuplrPricingElement.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SetlDoc> getType()
    {
        return SetlDoc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @param settlmtDoc
     *            Settlement Document Number
     */
    public void setSettlmtDoc( @Nullable final java.lang.String settlmtDoc )
    {
        rememberChangedField("SettlmtDoc", this.settlmtDoc);
        this.settlmtDoc = settlmtDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     */
    public void setSettlmtDocType( @Nullable final java.lang.String settlmtDocType )
    {
        rememberChangedField("SettlmtDocType", this.settlmtDocType);
        this.settlmtDocType = settlmtDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @param settlmtProcessType
     *            Settlement Process Type
     */
    public void setSettlmtProcessType( @Nullable final java.lang.String settlmtProcessType )
    {
        rememberChangedField("SettlmtProcessType", this.settlmtProcessType);
        this.settlmtProcessType = settlmtProcessType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     * 
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDate postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     * 
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final java.lang.String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayeeParty</b>
     * </p>
     * 
     * @param payeeParty
     *            Payee
     */
    public void setPayeeParty( @Nullable final java.lang.String payeeParty )
    {
        rememberChangedField("PayeeParty", this.payeeParty);
        this.payeeParty = payeeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     * 
     * @param billToParty
     *            Bill-to Party
     */
    public void setBillToParty( @Nullable final java.lang.String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     * 
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final java.lang.String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final java.lang.String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final java.lang.String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final java.lang.String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtCompanyCode</b>
     * </p>
     * 
     * @param suplrSettlmtCompanyCode
     *            Supplier Company Code
     */
    public void setSuplrSettlmtCompanyCode( @Nullable final java.lang.String suplrSettlmtCompanyCode )
    {
        rememberChangedField("SuplrSettlmtCompanyCode", this.suplrSettlmtCompanyCode);
        this.suplrSettlmtCompanyCode = suplrSettlmtCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtCompanyCode</b>
     * </p>
     * 
     * @param custSettlmtCompanyCode
     *            Customer Company Code
     */
    public void setCustSettlmtCompanyCode( @Nullable final java.lang.String custSettlmtCompanyCode )
    {
        rememberChangedField("CustSettlmtCompanyCode", this.custSettlmtCompanyCode);
        this.custSettlmtCompanyCode = custSettlmtCompanyCode;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     * 
     * @param documentDate
     *            Document Date in Settlement Management Document
     */
    public void setDocumentDate( @Nullable final LocalDate documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentReferenceID</b>
     * </p>
     * 
     * @param documentReferenceID
     *            Reference Document Number
     */
    public void setDocumentReferenceID( @Nullable final java.lang.String documentReferenceID )
    {
        rememberChangedField("DocumentReferenceID", this.documentReferenceID);
        this.documentReferenceID = documentReferenceID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     * 
     * @param assignmentReference
     *            Assignment Number
     */
    public void setAssignmentReference( @Nullable final java.lang.String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrency</b>
     * </p>
     * 
     * @param settlmtDocCurrency
     *            Currency of Settlement Document
     */
    public void setSettlmtDocCurrency( @Nullable final java.lang.String settlmtDocCurrency )
    {
        rememberChangedField("SettlmtDocCurrency", this.settlmtDocCurrency);
        this.settlmtDocCurrency = settlmtDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrencyISOCode</b>
     * </p>
     * 
     * @param settlmtDocCurrencyISOCode
     *            ISO Code Currency
     */
    public void setSettlmtDocCurrencyISOCode( @Nullable final java.lang.String settlmtDocCurrencyISOCode )
    {
        rememberChangedField("SettlmtDocCurrencyISOCode", this.settlmtDocCurrencyISOCode);
        this.settlmtDocCurrencyISOCode = settlmtDocCurrencyISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     * 
     * @param exchangeRate
     *            Conversion Rate (Not Converted)
     */
    public void setExchangeRate( @Nullable final BigDecimal exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     * 
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final java.lang.Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalGrossAmount</b>
     * </p>
     * 
     * @param supplierTotalGrossAmount
     *            The supplierTotalGrossAmount to set.
     */
    public void setSupplierTotalGrossAmount( @Nullable final BigDecimal supplierTotalGrossAmount )
    {
        rememberChangedField("SupplierTotalGrossAmount", this.supplierTotalGrossAmount);
        this.supplierTotalGrossAmount = supplierTotalGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalNetAmount</b>
     * </p>
     * 
     * @param supplierTotalNetAmount
     *            The supplierTotalNetAmount to set.
     */
    public void setSupplierTotalNetAmount( @Nullable final BigDecimal supplierTotalNetAmount )
    {
        rememberChangedField("SupplierTotalNetAmount", this.supplierTotalNetAmount);
        this.supplierTotalNetAmount = supplierTotalNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTotalTaxAmount</b>
     * </p>
     * 
     * @param supplierTotalTaxAmount
     *            The supplierTotalTaxAmount to set.
     */
    public void setSupplierTotalTaxAmount( @Nullable final BigDecimal supplierTotalTaxAmount )
    {
        rememberChangedField("SupplierTotalTaxAmount", this.supplierTotalTaxAmount);
        this.supplierTotalTaxAmount = supplierTotalTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalGrossAmount</b>
     * </p>
     * 
     * @param customerTotalGrossAmount
     *            The customerTotalGrossAmount to set.
     */
    public void setCustomerTotalGrossAmount( @Nullable final BigDecimal customerTotalGrossAmount )
    {
        rememberChangedField("CustomerTotalGrossAmount", this.customerTotalGrossAmount);
        this.customerTotalGrossAmount = customerTotalGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalNetAmount</b>
     * </p>
     * 
     * @param customerTotalNetAmount
     *            The customerTotalNetAmount to set.
     */
    public void setCustomerTotalNetAmount( @Nullable final BigDecimal customerTotalNetAmount )
    {
        rememberChangedField("CustomerTotalNetAmount", this.customerTotalNetAmount);
        this.customerTotalNetAmount = customerTotalNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTotalTaxAmount</b>
     * </p>
     * 
     * @param customerTotalTaxAmount
     *            The customerTotalTaxAmount to set.
     */
    public void setCustomerTotalTaxAmount( @Nullable final BigDecimal customerTotalTaxAmount )
    {
        rememberChangedField("CustomerTotalTaxAmount", this.customerTotalTaxAmount);
        this.customerTotalTaxAmount = customerTotalTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPaymentTerms</b>
     * </p>
     * 
     * @param supplierPaymentTerms
     *            Terms of Payment Key for Supplier
     */
    public void setSupplierPaymentTerms( @Nullable final java.lang.String supplierPaymentTerms )
    {
        rememberChangedField("SupplierPaymentTerms", this.supplierPaymentTerms);
        this.supplierPaymentTerms = supplierPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount1Days</b>
     * </p>
     * 
     * @param supplierCashDiscount1Days
     *            Supplier Cash Discount First Payment in Days
     */
    public void setSupplierCashDiscount1Days( @Nullable final BigDecimal supplierCashDiscount1Days )
    {
        rememberChangedField("SupplierCashDiscount1Days", this.supplierCashDiscount1Days);
        this.supplierCashDiscount1Days = supplierCashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount2Days</b>
     * </p>
     * 
     * @param supplierCashDiscount2Days
     *            Supplier Cash Discount Second Payment in Days
     */
    public void setSupplierCashDiscount2Days( @Nullable final BigDecimal supplierCashDiscount2Days )
    {
        rememberChangedField("SupplierCashDiscount2Days", this.supplierCashDiscount2Days);
        this.supplierCashDiscount2Days = supplierCashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierNetPaymentDays</b>
     * </p>
     * 
     * @param supplierNetPaymentDays
     *            Supplier Cash Discount Days
     */
    public void setSupplierNetPaymentDays( @Nullable final BigDecimal supplierNetPaymentDays )
    {
        rememberChangedField("SupplierNetPaymentDays", this.supplierNetPaymentDays);
        this.supplierNetPaymentDays = supplierNetPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount1Percent</b>
     * </p>
     * 
     * @param supplierCashDiscount1Percent
     *            Supplier Cash Discount for First Payment in %
     */
    public void setSupplierCashDiscount1Percent( @Nullable final BigDecimal supplierCashDiscount1Percent )
    {
        rememberChangedField("SupplierCashDiscount1Percent", this.supplierCashDiscount1Percent);
        this.supplierCashDiscount1Percent = supplierCashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupplierCashDiscount2Percent</b>
     * </p>
     * 
     * @param supplierCashDiscount2Percent
     *            Supplier Cash Discount for Second Payment in %
     */
    public void setSupplierCashDiscount2Percent( @Nullable final BigDecimal supplierCashDiscount2Percent )
    {
        rememberChangedField("SupplierCashDiscount2Percent", this.supplierCashDiscount2Percent);
        this.supplierCashDiscount2Percent = supplierCashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPaymentMethod</b>
     * </p>
     * 
     * @param supplierPaymentMethod
     *            Supplier Payment Method
     */
    public void setSupplierPaymentMethod( @Nullable final java.lang.String supplierPaymentMethod )
    {
        rememberChangedField("SupplierPaymentMethod", this.supplierPaymentMethod);
        this.supplierPaymentMethod = supplierPaymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     * 
     * @param customerPaymentTerms
     *            Terms of Payment Key for Customer
     */
    public void setCustomerPaymentTerms( @Nullable final java.lang.String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount1Days</b>
     * </p>
     * 
     * @param customerCashDiscount1Days
     *            Customer Cash Discount First Payment in Days
     */
    public void setCustomerCashDiscount1Days( @Nullable final BigDecimal customerCashDiscount1Days )
    {
        rememberChangedField("CustomerCashDiscount1Days", this.customerCashDiscount1Days);
        this.customerCashDiscount1Days = customerCashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount2Days</b>
     * </p>
     * 
     * @param customerCashDiscount2Days
     *            Customer Cash Discount Second Payment in Days
     */
    public void setCustomerCashDiscount2Days( @Nullable final BigDecimal customerCashDiscount2Days )
    {
        rememberChangedField("CustomerCashDiscount2Days", this.customerCashDiscount2Days);
        this.customerCashDiscount2Days = customerCashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerNetPaymentDays</b>
     * </p>
     * 
     * @param customerNetPaymentDays
     *            Customer Cash Discount Days
     */
    public void setCustomerNetPaymentDays( @Nullable final BigDecimal customerNetPaymentDays )
    {
        rememberChangedField("CustomerNetPaymentDays", this.customerNetPaymentDays);
        this.customerNetPaymentDays = customerNetPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount1Percent</b>
     * </p>
     * 
     * @param customerCashDiscount1Percent
     *            Customer Cash Discount for First Payment in %
     */
    public void setCustomerCashDiscount1Percent( @Nullable final BigDecimal customerCashDiscount1Percent )
    {
        rememberChangedField("CustomerCashDiscount1Percent", this.customerCashDiscount1Percent);
        this.customerCashDiscount1Percent = customerCashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerCashDiscount2Percent</b>
     * </p>
     * 
     * @param customerCashDiscount2Percent
     *            Custromer Cash Discount for Second Payment in %
     */
    public void setCustomerCashDiscount2Percent( @Nullable final BigDecimal customerCashDiscount2Percent )
    {
        rememberChangedField("CustomerCashDiscount2Percent", this.customerCashDiscount2Percent);
        this.customerCashDiscount2Percent = customerCashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentMethod</b>
     * </p>
     * 
     * @param customerPaymentMethod
     *            Customer Payment Method
     */
    public void setCustomerPaymentMethod( @Nullable final java.lang.String customerPaymentMethod )
    {
        rememberChangedField("CustomerPaymentMethod", this.customerPaymentMethod);
        this.customerPaymentMethod = customerPaymentMethod;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SuplrTotEligibleAmtForCshDisc</b>
     * </p>
     * 
     * @param suplrTotEligibleAmtForCshDisc
     *            The suplrTotEligibleAmtForCshDisc to set.
     */
    public void setSuplrTotEligibleAmtForCshDisc( @Nullable final BigDecimal suplrTotEligibleAmtForCshDisc )
    {
        rememberChangedField("SuplrTotEligibleAmtForCshDisc", this.suplrTotEligibleAmtForCshDisc);
        this.suplrTotEligibleAmtForCshDisc = suplrTotEligibleAmtForCshDisc;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustTotEligibleAmtForCshDisc</b>
     * </p>
     * 
     * @param custTotEligibleAmtForCshDisc
     *            The custTotEligibleAmtForCshDisc to set.
     */
    public void setCustTotEligibleAmtForCshDisc( @Nullable final BigDecimal custTotEligibleAmtForCshDisc )
    {
        rememberChangedField("CustTotEligibleAmtForCshDisc", this.custTotEligibleAmtForCshDisc);
        this.custTotEligibleAmtForCshDisc = custTotEligibleAmtForCshDisc;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocIsCanceled</b>
     * </p>
     * 
     * @param settlmtDocIsCanceled
     *            Settlement Document is Reversed
     */
    public void setSettlmtDocIsCanceled( @Nullable final java.lang.Boolean settlmtDocIsCanceled )
    {
        rememberChangedField("SettlmtDocIsCanceled", this.settlmtDocIsCanceled);
        this.settlmtDocIsCanceled = settlmtDocIsCanceled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CanceledSettlmtDoc</b>
     * </p>
     * 
     * @param canceledSettlmtDoc
     *            Reversed Document
     */
    public void setCanceledSettlmtDoc( @Nullable final java.lang.String canceledSettlmtDoc )
    {
        rememberChangedField("CanceledSettlmtDoc", this.canceledSettlmtDoc);
        this.canceledSettlmtDoc = canceledSettlmtDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocActivityReason</b>
     * </p>
     * 
     * @param settlmtDocActivityReason
     *            Header Activity Reason for Document Creation
     */
    public void setSettlmtDocActivityReason( @Nullable final java.lang.String settlmtDocActivityReason )
    {
        rememberChangedField("SettlmtDocActivityReason", this.settlmtDocActivityReason);
        this.settlmtDocActivityReason = settlmtDocActivityReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PaymentReference</b>
     * </p>
     * 
     * @param paymentReference
     *            Payment Reference
     */
    public void setPaymentReference( @Nullable final java.lang.String paymentReference )
    {
        rememberChangedField("PaymentReference", this.paymentReference);
        this.paymentReference = paymentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplSts</b>
     * </p>
     * 
     * @param settlmtApplSts
     *            Application Status for a Settlement Management Document
     */
    public void setSettlmtApplSts( @Nullable final java.lang.String settlmtApplSts )
    {
        rememberChangedField("SettlmtApplSts", this.settlmtApplSts);
        this.settlmtApplSts = settlmtApplSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final java.lang.String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final java.lang.String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSettlmtBlkgReason</b>
     * </p>
     * 
     * @param supplierSettlmtBlkgReason
     *            Reason for Supplier Settlement Block
     */
    public void setSupplierSettlmtBlkgReason( @Nullable final java.lang.String supplierSettlmtBlkgReason )
    {
        rememberChangedField("SupplierSettlmtBlkgReason", this.supplierSettlmtBlkgReason);
        this.supplierSettlmtBlkgReason = supplierSettlmtBlkgReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSettlmtBlkgReason</b>
     * </p>
     * 
     * @param customerSettlmtBlkgReason
     *            Reason for Customer Settlement Block
     */
    public void setCustomerSettlmtBlkgReason( @Nullable final java.lang.String customerSettlmtBlkgReason )
    {
        rememberChangedField("CustomerSettlmtBlkgReason", this.customerSettlmtBlkgReason);
        this.customerSettlmtBlkgReason = customerSettlmtBlkgReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     * 
     * @param taxDepartureCountry
     *            Tax Departure Country/Region
     */
    public void setTaxDepartureCountry( @Nullable final java.lang.String taxDepartureCountry )
    {
        rememberChangedField("TaxDepartureCountry", this.taxDepartureCountry);
        this.taxDepartureCountry = taxDepartureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDestinationCountry</b>
     * </p>
     * 
     * @param taxDestinationCountry
     *            Tax Destination Country/Region
     */
    public void setTaxDestinationCountry( @Nullable final java.lang.String taxDestinationCountry )
    {
        rememberChangedField("TaxDestinationCountry", this.taxDestinationCountry);
        this.taxDestinationCountry = taxDestinationCountry;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsEUTriangularDeal</b>
     * </p>
     * 
     * @param isEUTriangularDeal
     *            Indicator: Triangular Deal Within the EU
     */
    public void setIsEUTriangularDeal( @Nullable final java.lang.Boolean isEUTriangularDeal )
    {
        rememberChangedField("IsEUTriangularDeal", this.isEUTriangularDeal);
        this.isEUTriangularDeal = isEUTriangularDeal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupplierVATRegistration</b>
     * </p>
     * 
     * @param supplierVATRegistration
     *            Supplier VAT Registration Number
     */
    public void setSupplierVATRegistration( @Nullable final java.lang.String supplierVATRegistration )
    {
        rememberChangedField("SupplierVATRegistration", this.supplierVATRegistration);
        this.supplierVATRegistration = supplierVATRegistration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CustomerVATRegistration</b>
     * </p>
     * 
     * @param customerVATRegistration
     *            Customer VAT Registration Number
     */
    public void setCustomerVATRegistration( @Nullable final java.lang.String customerVATRegistration )
    {
        rememberChangedField("CustomerVATRegistration", this.customerVATRegistration);
        this.customerVATRegistration = customerVATRegistration;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>TotalGrossAmount</b>
     * </p>
     * 
     * @param totalGrossAmount
     *            The totalGrossAmount to set.
     */
    public void setTotalGrossAmount( @Nullable final BigDecimal totalGrossAmount )
    {
        rememberChangedField("TotalGrossAmount", this.totalGrossAmount);
        this.totalGrossAmount = totalGrossAmount;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SetlDoc";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtDoc", getSettlmtDoc());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtDoc", getSettlmtDoc());
        values.put("SettlmtDocType", getSettlmtDocType());
        values.put("SettlmtProcessType", getSettlmtProcessType());
        values.put("PostingDate", getPostingDate());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("PayeeParty", getPayeeParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SuplrSettlmtCompanyCode", getSuplrSettlmtCompanyCode());
        values.put("CustSettlmtCompanyCode", getCustSettlmtCompanyCode());
        values.put("DocumentDate", getDocumentDate());
        values.put("DocumentReferenceID", getDocumentReferenceID());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("SettlmtDocCurrency", getSettlmtDocCurrency());
        values.put("SettlmtDocCurrencyISOCode", getSettlmtDocCurrencyISOCode());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("SupplierTotalGrossAmount", getSupplierTotalGrossAmount());
        values.put("SupplierTotalNetAmount", getSupplierTotalNetAmount());
        values.put("SupplierTotalTaxAmount", getSupplierTotalTaxAmount());
        values.put("CustomerTotalGrossAmount", getCustomerTotalGrossAmount());
        values.put("CustomerTotalNetAmount", getCustomerTotalNetAmount());
        values.put("CustomerTotalTaxAmount", getCustomerTotalTaxAmount());
        values.put("SupplierPaymentTerms", getSupplierPaymentTerms());
        values.put("SupplierCashDiscount1Days", getSupplierCashDiscount1Days());
        values.put("SupplierCashDiscount2Days", getSupplierCashDiscount2Days());
        values.put("SupplierNetPaymentDays", getSupplierNetPaymentDays());
        values.put("SupplierCashDiscount1Percent", getSupplierCashDiscount1Percent());
        values.put("SupplierCashDiscount2Percent", getSupplierCashDiscount2Percent());
        values.put("SupplierPaymentMethod", getSupplierPaymentMethod());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("CustomerCashDiscount1Days", getCustomerCashDiscount1Days());
        values.put("CustomerCashDiscount2Days", getCustomerCashDiscount2Days());
        values.put("CustomerNetPaymentDays", getCustomerNetPaymentDays());
        values.put("CustomerCashDiscount1Percent", getCustomerCashDiscount1Percent());
        values.put("CustomerCashDiscount2Percent", getCustomerCashDiscount2Percent());
        values.put("CustomerPaymentMethod", getCustomerPaymentMethod());
        values.put("SuplrTotEligibleAmtForCshDisc", getSuplrTotEligibleAmtForCshDisc());
        values.put("CustTotEligibleAmtForCshDisc", getCustTotEligibleAmtForCshDisc());
        values.put("SettlmtDocIsCanceled", getSettlmtDocIsCanceled());
        values.put("CanceledSettlmtDoc", getCanceledSettlmtDoc());
        values.put("SettlmtDocActivityReason", getSettlmtDocActivityReason());
        values.put("PaymentReference", getPaymentReference());
        values.put("SettlmtApplSts", getSettlmtApplSts());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SupplierSettlmtBlkgReason", getSupplierSettlmtBlkgReason());
        values.put("CustomerSettlmtBlkgReason", getCustomerSettlmtBlkgReason());
        values.put("TaxDepartureCountry", getTaxDepartureCountry());
        values.put("TaxDestinationCountry", getTaxDestinationCountry());
        values.put("IsEUTriangularDeal", getIsEUTriangularDeal());
        values.put("SupplierVATRegistration", getSupplierVATRegistration());
        values.put("CustomerVATRegistration", getCustomerVATRegistration());
        values.put("TotalGrossAmount", getTotalGrossAmount());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtDoc") ) {
                final Object value = values.remove("SettlmtDoc");
                if( (value == null) || (!value.equals(getSettlmtDoc())) ) {
                    setSettlmtDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocType") ) {
                final Object value = values.remove("SettlmtDocType");
                if( (value == null) || (!value.equals(getSettlmtDocType())) ) {
                    setSettlmtDocType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtProcessType") ) {
                final Object value = values.remove("SettlmtProcessType");
                if( (value == null) || (!value.equals(getSettlmtProcessType())) ) {
                    setSettlmtProcessType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("PayeeParty") ) {
                final Object value = values.remove("PayeeParty");
                if( (value == null) || (!value.equals(getPayeeParty())) ) {
                    setPayeeParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuplrSettlmtCompanyCode") ) {
                final Object value = values.remove("SuplrSettlmtCompanyCode");
                if( (value == null) || (!value.equals(getSuplrSettlmtCompanyCode())) ) {
                    setSuplrSettlmtCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustSettlmtCompanyCode") ) {
                final Object value = values.remove("CustSettlmtCompanyCode");
                if( (value == null) || (!value.equals(getCustSettlmtCompanyCode())) ) {
                    setCustSettlmtCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDate) value));
                }
            }
            if( values.containsKey("DocumentReferenceID") ) {
                final Object value = values.remove("DocumentReferenceID");
                if( (value == null) || (!value.equals(getDocumentReferenceID())) ) {
                    setDocumentReferenceID(((java.lang.String) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocCurrency") ) {
                final Object value = values.remove("SettlmtDocCurrency");
                if( (value == null) || (!value.equals(getSettlmtDocCurrency())) ) {
                    setSettlmtDocCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocCurrencyISOCode") ) {
                final Object value = values.remove("SettlmtDocCurrencyISOCode");
                if( (value == null) || (!value.equals(getSettlmtDocCurrencyISOCode())) ) {
                    setSettlmtDocCurrencyISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SupplierTotalGrossAmount") ) {
                final Object value = values.remove("SupplierTotalGrossAmount");
                if( (value == null) || (!value.equals(getSupplierTotalGrossAmount())) ) {
                    setSupplierTotalGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierTotalNetAmount") ) {
                final Object value = values.remove("SupplierTotalNetAmount");
                if( (value == null) || (!value.equals(getSupplierTotalNetAmount())) ) {
                    setSupplierTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierTotalTaxAmount") ) {
                final Object value = values.remove("SupplierTotalTaxAmount");
                if( (value == null) || (!value.equals(getSupplierTotalTaxAmount())) ) {
                    setSupplierTotalTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerTotalGrossAmount") ) {
                final Object value = values.remove("CustomerTotalGrossAmount");
                if( (value == null) || (!value.equals(getCustomerTotalGrossAmount())) ) {
                    setCustomerTotalGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerTotalNetAmount") ) {
                final Object value = values.remove("CustomerTotalNetAmount");
                if( (value == null) || (!value.equals(getCustomerTotalNetAmount())) ) {
                    setCustomerTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerTotalTaxAmount") ) {
                final Object value = values.remove("CustomerTotalTaxAmount");
                if( (value == null) || (!value.equals(getCustomerTotalTaxAmount())) ) {
                    setCustomerTotalTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierPaymentTerms") ) {
                final Object value = values.remove("SupplierPaymentTerms");
                if( (value == null) || (!value.equals(getSupplierPaymentTerms())) ) {
                    setSupplierPaymentTerms(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierCashDiscount1Days") ) {
                final Object value = values.remove("SupplierCashDiscount1Days");
                if( (value == null) || (!value.equals(getSupplierCashDiscount1Days())) ) {
                    setSupplierCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierCashDiscount2Days") ) {
                final Object value = values.remove("SupplierCashDiscount2Days");
                if( (value == null) || (!value.equals(getSupplierCashDiscount2Days())) ) {
                    setSupplierCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierNetPaymentDays") ) {
                final Object value = values.remove("SupplierNetPaymentDays");
                if( (value == null) || (!value.equals(getSupplierNetPaymentDays())) ) {
                    setSupplierNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierCashDiscount1Percent") ) {
                final Object value = values.remove("SupplierCashDiscount1Percent");
                if( (value == null) || (!value.equals(getSupplierCashDiscount1Percent())) ) {
                    setSupplierCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierCashDiscount2Percent") ) {
                final Object value = values.remove("SupplierCashDiscount2Percent");
                if( (value == null) || (!value.equals(getSupplierCashDiscount2Percent())) ) {
                    setSupplierCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierPaymentMethod") ) {
                final Object value = values.remove("SupplierPaymentMethod");
                if( (value == null) || (!value.equals(getSupplierPaymentMethod())) ) {
                    setSupplierPaymentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerCashDiscount1Days") ) {
                final Object value = values.remove("CustomerCashDiscount1Days");
                if( (value == null) || (!value.equals(getCustomerCashDiscount1Days())) ) {
                    setCustomerCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerCashDiscount2Days") ) {
                final Object value = values.remove("CustomerCashDiscount2Days");
                if( (value == null) || (!value.equals(getCustomerCashDiscount2Days())) ) {
                    setCustomerCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerNetPaymentDays") ) {
                final Object value = values.remove("CustomerNetPaymentDays");
                if( (value == null) || (!value.equals(getCustomerNetPaymentDays())) ) {
                    setCustomerNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerCashDiscount1Percent") ) {
                final Object value = values.remove("CustomerCashDiscount1Percent");
                if( (value == null) || (!value.equals(getCustomerCashDiscount1Percent())) ) {
                    setCustomerCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerCashDiscount2Percent") ) {
                final Object value = values.remove("CustomerCashDiscount2Percent");
                if( (value == null) || (!value.equals(getCustomerCashDiscount2Percent())) ) {
                    setCustomerCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerPaymentMethod") ) {
                final Object value = values.remove("CustomerPaymentMethod");
                if( (value == null) || (!value.equals(getCustomerPaymentMethod())) ) {
                    setCustomerPaymentMethod(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuplrTotEligibleAmtForCshDisc") ) {
                final Object value = values.remove("SuplrTotEligibleAmtForCshDisc");
                if( (value == null) || (!value.equals(getSuplrTotEligibleAmtForCshDisc())) ) {
                    setSuplrTotEligibleAmtForCshDisc(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustTotEligibleAmtForCshDisc") ) {
                final Object value = values.remove("CustTotEligibleAmtForCshDisc");
                if( (value == null) || (!value.equals(getCustTotEligibleAmtForCshDisc())) ) {
                    setCustTotEligibleAmtForCshDisc(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlmtDocIsCanceled") ) {
                final Object value = values.remove("SettlmtDocIsCanceled");
                if( (value == null) || (!value.equals(getSettlmtDocIsCanceled())) ) {
                    setSettlmtDocIsCanceled(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CanceledSettlmtDoc") ) {
                final Object value = values.remove("CanceledSettlmtDoc");
                if( (value == null) || (!value.equals(getCanceledSettlmtDoc())) ) {
                    setCanceledSettlmtDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocActivityReason") ) {
                final Object value = values.remove("SettlmtDocActivityReason");
                if( (value == null) || (!value.equals(getSettlmtDocActivityReason())) ) {
                    setSettlmtDocActivityReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentReference") ) {
                final Object value = values.remove("PaymentReference");
                if( (value == null) || (!value.equals(getPaymentReference())) ) {
                    setPaymentReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtApplSts") ) {
                final Object value = values.remove("SettlmtApplSts");
                if( (value == null) || (!value.equals(getSettlmtApplSts())) ) {
                    setSettlmtApplSts(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierSettlmtBlkgReason") ) {
                final Object value = values.remove("SupplierSettlmtBlkgReason");
                if( (value == null) || (!value.equals(getSupplierSettlmtBlkgReason())) ) {
                    setSupplierSettlmtBlkgReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerSettlmtBlkgReason") ) {
                final Object value = values.remove("CustomerSettlmtBlkgReason");
                if( (value == null) || (!value.equals(getCustomerSettlmtBlkgReason())) ) {
                    setCustomerSettlmtBlkgReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxDepartureCountry") ) {
                final Object value = values.remove("TaxDepartureCountry");
                if( (value == null) || (!value.equals(getTaxDepartureCountry())) ) {
                    setTaxDepartureCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxDestinationCountry") ) {
                final Object value = values.remove("TaxDestinationCountry");
                if( (value == null) || (!value.equals(getTaxDestinationCountry())) ) {
                    setTaxDestinationCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsEUTriangularDeal") ) {
                final Object value = values.remove("IsEUTriangularDeal");
                if( (value == null) || (!value.equals(getIsEUTriangularDeal())) ) {
                    setIsEUTriangularDeal(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SupplierVATRegistration") ) {
                final Object value = values.remove("SupplierVATRegistration");
                if( (value == null) || (!value.equals(getSupplierVATRegistration())) ) {
                    setSupplierVATRegistration(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerVATRegistration") ) {
                final Object value = values.remove("CustomerVATRegistration");
                if( (value == null) || (!value.equals(getCustomerVATRegistration())) ) {
                    setCustomerVATRegistration(((java.lang.String) value));
                }
            }
            if( values.containsKey("TotalGrossAmount") ) {
                final Object value = values.remove("TotalGrossAmount");
                if( (value == null) || (!value.equals(getTotalGrossAmount())) ) {
                    setTotalGrossAmount(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_CustomerPricingElement") ) {
                final Object value = (values).remove("_CustomerPricingElement");
                if( value instanceof Iterable ) {
                    if( to_CustomerPricingElement == null ) {
                        to_CustomerPricingElement = Lists.newArrayList();
                    } else {
                        to_CustomerPricingElement = Lists.newArrayList(to_CustomerPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustPricingElement entity;
                        if( to_CustomerPricingElement.size() > i ) {
                            entity = to_CustomerPricingElement.get(i);
                        } else {
                            entity = new CustPricingElement();
                            to_CustomerPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SettlmtDocItem") ) {
                final Object value = (values).remove("_SettlmtDocItem");
                if( value instanceof Iterable ) {
                    if( to_SettlmtDocItem == null ) {
                        to_SettlmtDocItem = Lists.newArrayList();
                    } else {
                        to_SettlmtDocItem = Lists.newArrayList(to_SettlmtDocItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SetlDocItm entity;
                        if( to_SettlmtDocItem.size() > i ) {
                            entity = to_SettlmtDocItem.get(i);
                        } else {
                            entity = new SetlDocItm();
                            to_SettlmtDocItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SupplierPricingElement") ) {
                final Object value = (values).remove("_SupplierPricingElement");
                if( value instanceof Iterable ) {
                    if( to_SupplierPricingElement == null ) {
                        to_SupplierPricingElement = Lists.newArrayList();
                    } else {
                        to_SupplierPricingElement = Lists.newArrayList(to_SupplierPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrPricingElement entity;
                        if( to_SupplierPricingElement.size() > i ) {
                            entity = to_SupplierPricingElement.get(i);
                        } else {
                            entity = new SuplrPricingElement();
                            to_SupplierPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CustomerPricingElement != null ) {
            (values).put("_CustomerPricingElement", to_CustomerPricingElement);
        }
        if( to_SettlmtDocItem != null ) {
            (values).put("_SettlmtDocItem", to_SettlmtDocItem);
        }
        if( to_SupplierPricingElement != null ) {
            (values).put("_SupplierPricingElement", to_SupplierPricingElement);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CustPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDoc</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CustomerPricingElement</b> is already loaded, the result
     *         will contain the <b>CustPricingElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustPricingElement>> getCustomerPricingElementIfPresent()
    {
        return Option.of(to_CustomerPricingElement);
    }

    /**
     * Overwrites the list of associated <b>CustPricingElement</b> entities for the loaded navigation property
     * <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property <b>_CustomerPricingElement</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CustPricingElement</b> entities.
     */
    public void setCustomerPricingElement( @Nonnull final List<CustPricingElement> value )
    {
        if( to_CustomerPricingElement == null ) {
            to_CustomerPricingElement = Lists.newArrayList();
        }
        to_CustomerPricingElement.clear();
        to_CustomerPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustPricingElement</b> entities. This corresponds to the OData
     * navigation property <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property <b>_CustomerPricingElement</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CustPricingElement</b> entities.
     */
    public void addCustomerPricingElement( CustPricingElement... entity )
    {
        if( to_CustomerPricingElement == null ) {
            to_CustomerPricingElement = Lists.newArrayList();
        }
        to_CustomerPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SetlDocItm</b> entities (one to many). This corresponds to the OData navigation
     * property <b>_SettlmtDocItem</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDoc</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocItem</b> is already loaded, the result will
     *         contain the <b>SetlDocItm</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SetlDocItm>> getSettlmtDocItemIfPresent()
    {
        return Option.of(to_SettlmtDocItem);
    }

    /**
     * Overwrites the list of associated <b>SetlDocItm</b> entities for the loaded navigation property
     * <b>_SettlmtDocItem</b>.
     * <p>
     * If the navigation property <b>_SettlmtDocItem</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SetlDocItm</b> entities.
     */
    public void setSettlmtDocItem( @Nonnull final List<SetlDocItm> value )
    {
        if( to_SettlmtDocItem == null ) {
            to_SettlmtDocItem = Lists.newArrayList();
        }
        to_SettlmtDocItem.clear();
        to_SettlmtDocItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SetlDocItm</b> entities. This corresponds to the OData navigation
     * property <b>_SettlmtDocItem</b>.
     * <p>
     * If the navigation property <b>_SettlmtDocItem</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SetlDocItm</b> entities.
     */
    public void addSettlmtDocItem( SetlDocItm... entity )
    {
        if( to_SettlmtDocItem == null ) {
            to_SettlmtDocItem = Lists.newArrayList();
        }
        to_SettlmtDocItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SuplrPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDoc</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplierPricingElement</b> is already loaded, the result
     *         will contain the <b>SuplrPricingElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrPricingElement>> getSupplierPricingElementIfPresent()
    {
        return Option.of(to_SupplierPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SuplrPricingElement</b> entities for the loaded navigation property
     * <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property <b>_SupplierPricingElement</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SuplrPricingElement</b> entities.
     */
    public void setSupplierPricingElement( @Nonnull final List<SuplrPricingElement> value )
    {
        if( to_SupplierPricingElement == null ) {
            to_SupplierPricingElement = Lists.newArrayList();
        }
        to_SupplierPricingElement.clear();
        to_SupplierPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrPricingElement</b> entities. This corresponds to the OData
     * navigation property <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property <b>_SupplierPricingElement</b> of a queried <b>SetlDoc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SuplrPricingElement</b> entities.
     */
    public void addSupplierPricingElement( SuplrPricingElement... entity )
    {
        if( to_SupplierPricingElement == null ) {
            to_SupplierPricingElement = Lists.newArrayList();
        }
        to_SupplierPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>
        completeSettlmtDoc()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>(
            SetlDoc.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.CompleteSettlmtDoc",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void> release()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>(
            SetlDoc.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.Release",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>
        revokeCompletionSettlmtDoc()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>(
            SetlDoc.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.RevokeCompletionSettlmtDoc",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void> reverse()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SetlDoc, Void>(
            SetlDoc.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.Reverse",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of SetlDoc instances.
     * 
     */
    public final static class SetlDocBuilder
    {

        private List<CustPricingElement> to_CustomerPricingElement = Lists.newArrayList();
        private List<SetlDocItm> to_SettlmtDocItem = Lists.newArrayList();
        private List<SuplrPricingElement> to_SupplierPricingElement = Lists.newArrayList();

        private SetlDoc.SetlDocBuilder to_CustomerPricingElement( final List<CustPricingElement> value )
        {
            to_CustomerPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CustomerPricingElement</b> for <b>SetlDoc</b> to multiple <b>CustPricingElement</b>.
         * 
         * @param value
         *            The CustPricingElements to build this SetlDoc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDoc.SetlDocBuilder customerPricingElement( CustPricingElement... value )
        {
            return to_CustomerPricingElement(Lists.newArrayList(value));
        }

        private SetlDoc.SetlDocBuilder to_SettlmtDocItem( final List<SetlDocItm> value )
        {
            to_SettlmtDocItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocItem</b> for <b>SetlDoc</b> to multiple <b>SetlDocItm</b>.
         * 
         * @param value
         *            The SetlDocItms to build this SetlDoc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDoc.SetlDocBuilder settlmtDocItem( SetlDocItm... value )
        {
            return to_SettlmtDocItem(Lists.newArrayList(value));
        }

        private SetlDoc.SetlDocBuilder to_SupplierPricingElement( final List<SuplrPricingElement> value )
        {
            to_SupplierPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SupplierPricingElement</b> for <b>SetlDoc</b> to multiple <b>SuplrPricingElement</b>.
         * 
         * @param value
         *            The SuplrPricingElements to build this SetlDoc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDoc.SetlDocBuilder supplierPricingElement( SuplrPricingElement... value )
        {
            return to_SupplierPricingElement(Lists.newArrayList(value));
        }

    }

}
