/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Settlement Document Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SetlDocItmType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SetlDocItm extends VdmEntity<SetlDocItm> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_settlmt_doc.v0001.SetlDocItmType";
    /**
     * Selector for all available fields of SetlDocItm.
     * 
     */
    public final static SimpleProperty<SetlDocItm> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @return Settlement Document Number
     */
    @Nullable
    @ElementName( "SettlmtDoc" )
    private java.lang.String settlmtDoc;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_DOC =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtDoc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItem</b>
     * </p>
     * 
     * @return Document Item
     */
    @Nullable
    @ElementName( "SettlmtDocItem" )
    private java.lang.String settlmtDocItem;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_DOC_ITEM =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrency</b>
     * </p>
     * 
     * @return Currency of Settlement Document
     */
    @Nullable
    @ElementName( "SettlmtDocCurrency" )
    private java.lang.String settlmtDocCurrency;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_DOC_CURRENCY =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<SetlDocItm> PRODUCT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @return Product Group
     */
    @Nullable
    @ElementName( "ProductGroup" )
    private java.lang.String productGroup;
    public final static SimpleProperty.String<SetlDocItm> PRODUCT_GROUP =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<SetlDocItm> PLANT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTaxCode</b>
     * </p>
     * 
     * @return Supplier Tax Code
     */
    @Nullable
    @ElementName( "SupplierTaxCode" )
    private java.lang.String supplierTaxCode;
    public final static SimpleProperty.String<SetlDocItm> SUPPLIER_TAX_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SupplierTaxCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCode</b>
     * </p>
     * 
     * @return Customer Tax Code
     */
    @Nullable
    @ElementName( "CustomerTaxCode" )
    private java.lang.String customerTaxCode;
    public final static SimpleProperty.String<SetlDocItm> CUSTOMER_TAX_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "CustomerTaxCode");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     * 
     * @return Date for Pricing and Exchange Rate
     */
    @Nullable
    @ElementName( "PricingDate" )
    private LocalDate pricingDate;
    public final static SimpleProperty.Date<SetlDocItm> PRICING_DATE =
        new SimpleProperty.Date<SetlDocItm>(SetlDocItm.class, "PricingDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantity</b>
     * </p>
     * 
     * @return Quantity of Settlement Management Document Item
     */
    @Nullable
    @ElementName( "SettlmtQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal settlmtQuantity;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SETTLMT_QUANTITY =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SettlmtQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnit</b>
     * </p>
     * 
     * @return Unit of Measure of Settlement Management Doc Item Quantity
     */
    @Nullable
    @ElementName( "SettlmtQuantityUnit" )
    private java.lang.String settlmtQuantityUnit;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_QUANTITY_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Settlement Quantity Unit in ISO code
     */
    @Nullable
    @ElementName( "SettlmtQuantityUnitISOCode" )
    private java.lang.String settlmtQuantityUnitISOCode;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Settlement Quantity Unit in SAP code
     */
    @Nullable
    @ElementName( "SettlmtQuantityUnitSAPCode" )
    private java.lang.String settlmtQuantityUnitSAPCode;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     * 
     * @return The netPriceAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "NetPriceAmount" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal netPriceAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> NET_PRICE_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "NetPriceAmount");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     * 
     * @return Price Unit of Settlement Management Document Item
     */
    @Nullable
    @ElementName( "NetPriceQuantity" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal netPriceQuantity;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> NET_PRICE_QUANTITY =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "NetPriceQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     * 
     * @return Settlement Management Document Item Price Unit
     */
    @Nullable
    @ElementName( "NetPriceQuantityUnit" )
    private java.lang.String netPriceQuantityUnit;
    public final static SimpleProperty.String<SetlDocItm> NET_PRICE_QUANTITY_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "NetPriceQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtToBaseQuantityNmrtr</b>
     * </p>
     * 
     * @return Numerator Converting Qty in Settlement Document to Base Unit
     */
    @Nullable
    @ElementName( "SettlmtToBaseQuantityNmrtr" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal settlmtToBaseQuantityNmrtr;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SETTLMT_TO_BASE_QUANTITY_NMRTR =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SettlmtToBaseQuantityNmrtr");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtToBaseQuantityDnmntr</b>
     * </p>
     * 
     * @return Denominator Converting Qty in Settlement Doc. to Base Unit
     */
    @Nullable
    @ElementName( "SettlmtToBaseQuantityDnmntr" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal settlmtToBaseQuantityDnmntr;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SETTLMT_TO_BASE_QUANTITY_DNMNTR =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SettlmtToBaseQuantityDnmntr");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "BaseUnit" )
    private java.lang.String baseUnit;
    public final static SimpleProperty.String<SetlDocItm> BASE_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     * 
     * @return Net Weight
     */
    @Nullable
    @ElementName( "ItemNetWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal itemNetWeight;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> ITEM_NET_WEIGHT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "ItemNetWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     * 
     * @return Gross Weight
     */
    @Nullable
    @ElementName( "ItemGrossWeight" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal itemGrossWeight;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> ITEM_GROSS_WEIGHT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "ItemGrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     * 
     * @return Unit of Weight
     */
    @Nullable
    @ElementName( "ItemWeightUnit" )
    private java.lang.String itemWeightUnit;
    public final static SimpleProperty.String<SetlDocItm> ITEM_WEIGHT_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnitISOCode</b>
     * </p>
     * 
     * @return Unit of weight in ISO code
     */
    @Nullable
    @ElementName( "ItemWeightUnitISOCode" )
    private java.lang.String itemWeightUnitISOCode;
    public final static SimpleProperty.String<SetlDocItm> ITEM_WEIGHT_UNIT_ISO_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemWeightUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnitSAPCode</b>
     * </p>
     * 
     * @return Item Weight Unit in SAP code
     */
    @Nullable
    @ElementName( "ItemWeightUnitSAPCode" )
    private java.lang.String itemWeightUnitSAPCode;
    public final static SimpleProperty.String<SetlDocItm> ITEM_WEIGHT_UNIT_SAP_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemWeightUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     * 
     * @return Volume
     */
    @Nullable
    @ElementName( "ItemVolume" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal itemVolume;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> ITEM_VOLUME =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     * 
     * @return Volume Unit
     */
    @Nullable
    @ElementName( "ItemVolumeUnit" )
    private java.lang.String itemVolumeUnit;
    public final static SimpleProperty.String<SetlDocItm> ITEM_VOLUME_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnitISOCode</b>
     * </p>
     * 
     * @return Volume unit in ISO code
     */
    @Nullable
    @ElementName( "ItemVolumeUnitISOCode" )
    private java.lang.String itemVolumeUnitISOCode;
    public final static SimpleProperty.String<SetlDocItm> ITEM_VOLUME_UNIT_ISO_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemVolumeUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnitSAPCode</b>
     * </p>
     * 
     * @return Item Volume Unit in SAP code
     */
    @Nullable
    @ElementName( "ItemVolumeUnitSAPCode" )
    private java.lang.String itemVolumeUnitSAPCode;
    public final static SimpleProperty.String<SetlDocItm> ITEM_VOLUME_UNIT_SAP_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemVolumeUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemGrossAmount</b>
     * </p>
     * 
     * @return The supplierItemGrossAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierItemGrossAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal supplierItemGrossAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SUPPLIER_ITEM_GROSS_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SupplierItemGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemNetAmount</b>
     * </p>
     * 
     * @return The supplierItemNetAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierItemNetAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal supplierItemNetAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SUPPLIER_ITEM_NET_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SupplierItemNetAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemTaxAmount</b>
     * </p>
     * 
     * @return The supplierItemTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupplierItemTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal supplierItemTaxAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> SUPPLIER_ITEM_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "SupplierItemTaxAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemGrossAmount</b>
     * </p>
     * 
     * @return The customerItemGrossAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerItemGrossAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal customerItemGrossAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> CUSTOMER_ITEM_GROSS_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "CustomerItemGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemNetAmount</b>
     * </p>
     * 
     * @return The customerItemNetAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerItemNetAmount" )
    @DecimalDescriptor( precision = 15, scale = 0 )
    private BigDecimal customerItemNetAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> CUSTOMER_ITEM_NET_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "CustomerItemNetAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemTaxAmount</b>
     * </p>
     * 
     * @return The customerItemTaxAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CustomerItemTaxAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal customerItemTaxAmount;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> CUSTOMER_ITEM_TAX_AMOUNT =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "CustomerItemTaxAmount");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     * 
     * @return Cash Discount Indicator
     */
    @Nullable
    @ElementName( "CashDiscountIsDeductible" )
    private java.lang.Boolean cashDiscountIsDeductible;
    public final static SimpleProperty.Boolean<SetlDocItm> CASH_DISCOUNT_IS_DEDUCTIBLE =
        new SimpleProperty.Boolean<SetlDocItm>(SetlDocItm.class, "CashDiscountIsDeductible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDoc</b>
     * </p>
     * 
     * @return Document Number of the Source Document
     */
    @Nullable
    @ElementName( "SettlmtSourceDoc" )
    private java.lang.String settlmtSourceDoc;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_SOURCE_DOC =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtSourceDoc");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDocItem</b>
     * </p>
     * 
     * @return Item Number of the Source Document Item
     */
    @Nullable
    @ElementName( "SettlmtSourceDocItem" )
    private java.lang.String settlmtSourceDocItem;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_SOURCE_DOC_ITEM =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtSourceDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDocCat</b>
     * </p>
     * 
     * @return Document Category of Source Document
     */
    @Nullable
    @ElementName( "SettlmtSourceDocCat" )
    private java.lang.String settlmtSourceDocCat;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_SOURCE_DOC_CAT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtSourceDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtItemActivityReason</b>
     * </p>
     * 
     * @return Activity Reason for Document Creation
     */
    @Nullable
    @ElementName( "SettlmtItemActivityReason" )
    private java.lang.String settlmtItemActivityReason;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_ITEM_ACTIVITY_REASON =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtItemActivityReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItemText</b>
     * </p>
     * 
     * @return Short Text
     */
    @Nullable
    @ElementName( "SettlmtDocItemText" )
    private java.lang.String settlmtDocItemText;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_DOC_ITEM_TEXT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtDocItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierProductID</b>
     * </p>
     * 
     * @return Material Number Used by Supplier
     */
    @Nullable
    @ElementName( "SupplierProductID" )
    private java.lang.String supplierProductID;
    public final static SimpleProperty.String<SetlDocItm> SUPPLIER_PRODUCT_ID =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SupplierProductID");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @return Tax Jurisdiction
     */
    @Nullable
    @ElementName( "TaxJurisdiction" )
    private java.lang.String taxJurisdiction;
    public final static SimpleProperty.String<SetlDocItm> TAX_JURISDICTION =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQtyUnit</b>
     * </p>
     * 
     * @return Points Unit
     */
    @Nullable
    @ElementName( "ProductPurchasePointsQtyUnit" )
    private java.lang.String productPurchasePointsQtyUnit;
    public final static SimpleProperty.String<SetlDocItm> PRODUCT_PURCHASE_POINTS_QTY_UNIT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ProductPurchasePointsQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdPurPointsQtyUnitISOCode</b>
     * </p>
     * 
     * @return Product Purchase Points Quantity Unit in ISO code
     */
    @Nullable
    @ElementName( "ProdPurPointsQtyUnitISOCode" )
    private java.lang.String prodPurPointsQtyUnitISOCode;
    public final static SimpleProperty.String<SetlDocItm> PROD_PUR_POINTS_QTY_UNIT_ISO_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ProdPurPointsQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdPurPointsQtyUnitSAPCode</b>
     * </p>
     * 
     * @return Product Purchase Points Quantity Unit in SAP code
     */
    @Nullable
    @ElementName( "ProdPurPointsQtyUnitSAPCode" )
    private java.lang.String prodPurPointsQtyUnitSAPCode;
    public final static SimpleProperty.String<SetlDocItm> PROD_PUR_POINTS_QTY_UNIT_SAP_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ProdPurPointsQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQty</b>
     * </p>
     * 
     * @return Number of Points
     */
    @Nullable
    @ElementName( "ProductPurchasePointsQty" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal productPurchasePointsQty;
    public final static SimpleProperty.NumericDecimal<SetlDocItm> PRODUCT_PURCHASE_POINTS_QTY =
        new SimpleProperty.NumericDecimal<SetlDocItm>(SetlDocItm.class, "ProductPurchasePointsQty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtBusinessArea</b>
     * </p>
     * 
     * @return Business Area
     */
    @Nullable
    @ElementName( "SuplrSettlmtBusinessArea" )
    private java.lang.String suplrSettlmtBusinessArea;
    public final static SimpleProperty.String<SetlDocItm> SUPLR_SETTLMT_BUSINESS_AREA =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SuplrSettlmtBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtBusinessArea</b>
     * </p>
     * 
     * @return Customer Business Area
     */
    @Nullable
    @ElementName( "CustSettlmtBusinessArea" )
    private java.lang.String custSettlmtBusinessArea;
    public final static SimpleProperty.String<SetlDocItm> CUST_SETTLMT_BUSINESS_AREA =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "CustSettlmtBusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtCostCenter</b>
     * </p>
     * 
     * @return Cost Center
     */
    @Nullable
    @ElementName( "SuplrSettlmtCostCenter" )
    private java.lang.String suplrSettlmtCostCenter;
    public final static SimpleProperty.String<SetlDocItm> SUPLR_SETTLMT_COST_CENTER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SuplrSettlmtCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtProfitCenter</b>
     * </p>
     * 
     * @return Profit Center
     */
    @Nullable
    @ElementName( "SuplrSettlmtProfitCenter" )
    private java.lang.String suplrSettlmtProfitCenter;
    public final static SimpleProperty.String<SetlDocItm> SUPLR_SETTLMT_PROFIT_CENTER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SuplrSettlmtProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     * 
     * @return Incoterms Version
     */
    @Nullable
    @ElementName( "IncotermsVersion" )
    private java.lang.String incotermsVersion;
    public final static SimpleProperty.String<SetlDocItm> INCOTERMS_VERSION =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     * 
     * @return Incoterms Location 1
     */
    @Nullable
    @ElementName( "IncotermsLocation1" )
    private java.lang.String incotermsLocation1;
    public final static SimpleProperty.String<SetlDocItm> INCOTERMS_LOCATION1 =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     * 
     * @return Incoterms Location 2
     */
    @Nullable
    @ElementName( "IncotermsLocation2" )
    private java.lang.String incotermsLocation2;
    public final static SimpleProperty.String<SetlDocItm> INCOTERMS_LOCATION2 =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtCostCenter</b>
     * </p>
     * 
     * @return Customer Cost Center
     */
    @Nullable
    @ElementName( "CustSettlmtCostCenter" )
    private java.lang.String custSettlmtCostCenter;
    public final static SimpleProperty.String<SetlDocItm> CUST_SETTLMT_COST_CENTER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "CustSettlmtCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtProfitCenter</b>
     * </p>
     * 
     * @return Alternative Customer Profit Center
     */
    @Nullable
    @ElementName( "CustSettlmtProfitCenter" )
    private java.lang.String custSettlmtProfitCenter;
    public final static SimpleProperty.String<SetlDocItm> CUST_SETTLMT_PROFIT_CENTER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "CustSettlmtProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDoc</b>
     * </p>
     * 
     * @return Preceding Document of the Settlement Management Document
     */
    @Nullable
    @ElementName( "SettlmtPrecdgDoc" )
    private java.lang.String settlmtPrecdgDoc;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_PRECDG_DOC =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtPrecdgDoc");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDocItem</b>
     * </p>
     * 
     * @return Preceding Document Item in the Settlement Management Doc.
     */
    @Nullable
    @ElementName( "SettlmtPrecdgDocItem" )
    private java.lang.String settlmtPrecdgDocItem;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_PRECDG_DOC_ITEM =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtPrecdgDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDocCat</b>
     * </p>
     * 
     * @return Document Category of Preceding Document
     */
    @Nullable
    @ElementName( "SettlmtPrecdgDocCat" )
    private java.lang.String settlmtPrecdgDocCat;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_PRECDG_DOC_CAT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtPrecdgDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItemCat</b>
     * </p>
     * 
     * @return Item Category
     */
    @Nullable
    @ElementName( "SettlmtDocItemCat" )
    private java.lang.String settlmtDocItemCat;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_DOC_ITEM_CAT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtDocItemCat");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSettlementOrder</b>
     * </p>
     * 
     * @return Order for Account Assignment
     */
    @Nullable
    @ElementName( "SupplierSettlementOrder" )
    private java.lang.String supplierSettlementOrder;
    public final static SimpleProperty.String<SetlDocItm> SUPPLIER_SETTLEMENT_ORDER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SupplierSettlementOrder");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemSettlmtRelevance</b>
     * </p>
     * 
     * @return Item Settlement Relevance
     */
    @Nullable
    @ElementName( "ItemSettlmtRelevance" )
    private java.lang.String itemSettlmtRelevance;
    public final static SimpleProperty.String<SetlDocItm> ITEM_SETTLMT_RELEVANCE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "ItemSettlmtRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlementFiscalYear</b>
     * </p>
     * 
     * @return CCS: Fiscal Year of Settlement
     */
    @Nullable
    @ElementName( "SettlementFiscalYear" )
    private java.lang.String settlementFiscalYear;
    public final static SimpleProperty.String<SetlDocItm> SETTLEMENT_FISCAL_YEAR =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlementFiscalYear");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDoc</b>
     * </p>
     * 
     * @return Reference Document for Settlement Management
     */
    @Nullable
    @ElementName( "SettlmtRefDoc" )
    private java.lang.String settlmtRefDoc;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_REF_DOC =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtRefDoc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocCompanyCode</b>
     * </p>
     * 
     * @return Company Code of Reference Document for Settlement Management
     */
    @Nullable
    @ElementName( "SettlmtRefDocCompanyCode" )
    private java.lang.String settlmtRefDocCompanyCode;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_REF_DOC_COMPANY_CODE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtRefDocCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocItem</b>
     * </p>
     * 
     * @return Reference Document Item for Settlement Management Document
     */
    @Nullable
    @ElementName( "SettlmtRefDocItem" )
    private java.lang.String settlmtRefDocItem;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_REF_DOC_ITEM =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtRefDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocCat</b>
     * </p>
     * 
     * @return Reference Document Category in Settlement Management
     */
    @Nullable
    @ElementName( "SettlmtRefDocCat" )
    private java.lang.String settlmtRefDocCat;
    public final static SimpleProperty.String<SetlDocItm> SETTLMT_REF_DOC_CAT =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SettlmtRefDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     * 
     * @return Supplier Subrange
     */
    @Nullable
    @ElementName( "SupplierSubrange" )
    private java.lang.String supplierSubrange;
    public final static SimpleProperty.String<SetlDocItm> SUPPLIER_SUBRANGE =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "SupplierSubrange");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyTaxCountry</b>
     * </p>
     * 
     * @return Tax Reporting Country/Region for Intercompany Processes
     */
    @Nullable
    @ElementName( "IntercompanyTaxCountry" )
    private java.lang.String intercompanyTaxCountry;
    public final static SimpleProperty.String<SetlDocItm> INTERCOMPANY_TAX_COUNTRY =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "IntercompanyTaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @return Tax Reporting Country/Region
     */
    @Nullable
    @ElementName( "TaxCountry" )
    private java.lang.String taxCountry;
    public final static SimpleProperty.String<SetlDocItm> TAX_COUNTRY =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "TaxCountry");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @return Prior Supplier
     */
    @Nullable
    @ElementName( "PriorSupplier" )
    private java.lang.String priorSupplier;
    public final static SimpleProperty.String<SetlDocItm> PRIOR_SUPPLIER =
        new SimpleProperty.String<SetlDocItm>(SetlDocItm.class, "PriorSupplier");
    /**
     * Navigation property <b>_CustomerPricingElement</b> for <b>SetlDocItm</b> to multiple
     * <b>CustItmPricingElement</b>.
     * 
     */
    @ElementName( "_CustomerPricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CustItmPricingElement> to_CustomerPricingElement;
    /**
     * Navigation property <b>_SettlmtDoc</b> for <b>SetlDocItm</b> to single <b>SetlDoc</b>.
     * 
     */
    @ElementName( "_SettlmtDoc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SetlDoc to_SettlmtDoc;
    /**
     * Navigation property <b>_SupplierPricingElement</b> for <b>SetlDocItm</b> to multiple
     * <b>SuplrItmPricingElement</b>.
     * 
     */
    @ElementName( "_SupplierPricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SuplrItmPricingElement> to_SupplierPricingElement;
    /**
     * Use with available request builders to apply the <b>_CustomerPricingElement</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDocItm, CustItmPricingElement> TO__CUSTOMER_PRICING_ELEMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDocItm, CustItmPricingElement>(
            SetlDocItm.class,
            "_CustomerPricingElement",
            CustItmPricingElement.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDoc</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SetlDocItm, SetlDoc> TO__SETTLMT_DOC =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SetlDocItm, SetlDoc>(
            SetlDocItm.class,
            "_SettlmtDoc",
            SetlDoc.class);
    /**
     * Use with available request builders to apply the <b>_SupplierPricingElement</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDocItm, SuplrItmPricingElement> TO__SUPPLIER_PRICING_ELEMENT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SetlDocItm, SuplrItmPricingElement>(
            SetlDocItm.class,
            "_SupplierPricingElement",
            SuplrItmPricingElement.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SetlDocItm> getType()
    {
        return SetlDocItm.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDoc</b>
     * </p>
     * 
     * @param settlmtDoc
     *            Settlement Document Number
     */
    public void setSettlmtDoc( @Nullable final java.lang.String settlmtDoc )
    {
        rememberChangedField("SettlmtDoc", this.settlmtDoc);
        this.settlmtDoc = settlmtDoc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItem</b>
     * </p>
     * 
     * @param settlmtDocItem
     *            Document Item
     */
    public void setSettlmtDocItem( @Nullable final java.lang.String settlmtDocItem )
    {
        rememberChangedField("SettlmtDocItem", this.settlmtDocItem);
        this.settlmtDocItem = settlmtDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCurrency</b>
     * </p>
     * 
     * @param settlmtDocCurrency
     *            Currency of Settlement Document
     */
    public void setSettlmtDocCurrency( @Nullable final java.lang.String settlmtDocCurrency )
    {
        rememberChangedField("SettlmtDocCurrency", this.settlmtDocCurrency);
        this.settlmtDocCurrency = settlmtDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final java.lang.String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupplierTaxCode</b>
     * </p>
     * 
     * @param supplierTaxCode
     *            Supplier Tax Code
     */
    public void setSupplierTaxCode( @Nullable final java.lang.String supplierTaxCode )
    {
        rememberChangedField("SupplierTaxCode", this.supplierTaxCode);
        this.supplierTaxCode = supplierTaxCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxCode</b>
     * </p>
     * 
     * @param customerTaxCode
     *            Customer Tax Code
     */
    public void setCustomerTaxCode( @Nullable final java.lang.String customerTaxCode )
    {
        rememberChangedField("CustomerTaxCode", this.customerTaxCode);
        this.customerTaxCode = customerTaxCode;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     * 
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDate pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantity</b>
     * </p>
     * 
     * @param settlmtQuantity
     *            Quantity of Settlement Management Document Item
     */
    public void setSettlmtQuantity( @Nullable final BigDecimal settlmtQuantity )
    {
        rememberChangedField("SettlmtQuantity", this.settlmtQuantity);
        this.settlmtQuantity = settlmtQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnit</b>
     * </p>
     * 
     * @param settlmtQuantityUnit
     *            Unit of Measure of Settlement Management Doc Item Quantity
     */
    public void setSettlmtQuantityUnit( @Nullable final java.lang.String settlmtQuantityUnit )
    {
        rememberChangedField("SettlmtQuantityUnit", this.settlmtQuantityUnit);
        this.settlmtQuantityUnit = settlmtQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnitISOCode</b>
     * </p>
     * 
     * @param settlmtQuantityUnitISOCode
     *            Settlement Quantity Unit in ISO code
     */
    public void setSettlmtQuantityUnitISOCode( @Nullable final java.lang.String settlmtQuantityUnitISOCode )
    {
        rememberChangedField("SettlmtQuantityUnitISOCode", this.settlmtQuantityUnitISOCode);
        this.settlmtQuantityUnitISOCode = settlmtQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param settlmtQuantityUnitSAPCode
     *            Settlement Quantity Unit in SAP code
     */
    public void setSettlmtQuantityUnitSAPCode( @Nullable final java.lang.String settlmtQuantityUnitSAPCode )
    {
        rememberChangedField("SettlmtQuantityUnitSAPCode", this.settlmtQuantityUnitSAPCode);
        this.settlmtQuantityUnitSAPCode = settlmtQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceAmount</b>
     * </p>
     * 
     * @param netPriceAmount
     *            The netPriceAmount to set.
     */
    public void setNetPriceAmount( @Nullable final BigDecimal netPriceAmount )
    {
        rememberChangedField("NetPriceAmount", this.netPriceAmount);
        this.netPriceAmount = netPriceAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantity</b>
     * </p>
     * 
     * @param netPriceQuantity
     *            Price Unit of Settlement Management Document Item
     */
    public void setNetPriceQuantity( @Nullable final BigDecimal netPriceQuantity )
    {
        rememberChangedField("NetPriceQuantity", this.netPriceQuantity);
        this.netPriceQuantity = netPriceQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetPriceQuantityUnit</b>
     * </p>
     * 
     * @param netPriceQuantityUnit
     *            Settlement Management Document Item Price Unit
     */
    public void setNetPriceQuantityUnit( @Nullable final java.lang.String netPriceQuantityUnit )
    {
        rememberChangedField("NetPriceQuantityUnit", this.netPriceQuantityUnit);
        this.netPriceQuantityUnit = netPriceQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtToBaseQuantityNmrtr</b>
     * </p>
     * 
     * @param settlmtToBaseQuantityNmrtr
     *            Numerator Converting Qty in Settlement Document to Base Unit
     */
    public void setSettlmtToBaseQuantityNmrtr( @Nullable final BigDecimal settlmtToBaseQuantityNmrtr )
    {
        rememberChangedField("SettlmtToBaseQuantityNmrtr", this.settlmtToBaseQuantityNmrtr);
        this.settlmtToBaseQuantityNmrtr = settlmtToBaseQuantityNmrtr;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtToBaseQuantityDnmntr</b>
     * </p>
     * 
     * @param settlmtToBaseQuantityDnmntr
     *            Denominator Converting Qty in Settlement Doc. to Base Unit
     */
    public void setSettlmtToBaseQuantityDnmntr( @Nullable final BigDecimal settlmtToBaseQuantityDnmntr )
    {
        rememberChangedField("SettlmtToBaseQuantityDnmntr", this.settlmtToBaseQuantityDnmntr);
        this.settlmtToBaseQuantityDnmntr = settlmtToBaseQuantityDnmntr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     * 
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final java.lang.String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     * 
     * @param itemNetWeight
     *            Net Weight
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     * 
     * @param itemGrossWeight
     *            Gross Weight
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     * 
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final java.lang.String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnitISOCode</b>
     * </p>
     * 
     * @param itemWeightUnitISOCode
     *            Unit of weight in ISO code
     */
    public void setItemWeightUnitISOCode( @Nullable final java.lang.String itemWeightUnitISOCode )
    {
        rememberChangedField("ItemWeightUnitISOCode", this.itemWeightUnitISOCode);
        this.itemWeightUnitISOCode = itemWeightUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnitSAPCode</b>
     * </p>
     * 
     * @param itemWeightUnitSAPCode
     *            Item Weight Unit in SAP code
     */
    public void setItemWeightUnitSAPCode( @Nullable final java.lang.String itemWeightUnitSAPCode )
    {
        rememberChangedField("ItemWeightUnitSAPCode", this.itemWeightUnitSAPCode);
        this.itemWeightUnitSAPCode = itemWeightUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     * 
     * @param itemVolume
     *            Volume
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     * 
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final java.lang.String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnitISOCode</b>
     * </p>
     * 
     * @param itemVolumeUnitISOCode
     *            Volume unit in ISO code
     */
    public void setItemVolumeUnitISOCode( @Nullable final java.lang.String itemVolumeUnitISOCode )
    {
        rememberChangedField("ItemVolumeUnitISOCode", this.itemVolumeUnitISOCode);
        this.itemVolumeUnitISOCode = itemVolumeUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnitSAPCode</b>
     * </p>
     * 
     * @param itemVolumeUnitSAPCode
     *            Item Volume Unit in SAP code
     */
    public void setItemVolumeUnitSAPCode( @Nullable final java.lang.String itemVolumeUnitSAPCode )
    {
        rememberChangedField("ItemVolumeUnitSAPCode", this.itemVolumeUnitSAPCode);
        this.itemVolumeUnitSAPCode = itemVolumeUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemGrossAmount</b>
     * </p>
     * 
     * @param supplierItemGrossAmount
     *            The supplierItemGrossAmount to set.
     */
    public void setSupplierItemGrossAmount( @Nullable final BigDecimal supplierItemGrossAmount )
    {
        rememberChangedField("SupplierItemGrossAmount", this.supplierItemGrossAmount);
        this.supplierItemGrossAmount = supplierItemGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemNetAmount</b>
     * </p>
     * 
     * @param supplierItemNetAmount
     *            The supplierItemNetAmount to set.
     */
    public void setSupplierItemNetAmount( @Nullable final BigDecimal supplierItemNetAmount )
    {
        rememberChangedField("SupplierItemNetAmount", this.supplierItemNetAmount);
        this.supplierItemNetAmount = supplierItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SupplierItemTaxAmount</b>
     * </p>
     * 
     * @param supplierItemTaxAmount
     *            The supplierItemTaxAmount to set.
     */
    public void setSupplierItemTaxAmount( @Nullable final BigDecimal supplierItemTaxAmount )
    {
        rememberChangedField("SupplierItemTaxAmount", this.supplierItemTaxAmount);
        this.supplierItemTaxAmount = supplierItemTaxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemGrossAmount</b>
     * </p>
     * 
     * @param customerItemGrossAmount
     *            The customerItemGrossAmount to set.
     */
    public void setCustomerItemGrossAmount( @Nullable final BigDecimal customerItemGrossAmount )
    {
        rememberChangedField("CustomerItemGrossAmount", this.customerItemGrossAmount);
        this.customerItemGrossAmount = customerItemGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemNetAmount</b>
     * </p>
     * 
     * @param customerItemNetAmount
     *            The customerItemNetAmount to set.
     */
    public void setCustomerItemNetAmount( @Nullable final BigDecimal customerItemNetAmount )
    {
        rememberChangedField("CustomerItemNetAmount", this.customerItemNetAmount);
        this.customerItemNetAmount = customerItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerItemTaxAmount</b>
     * </p>
     * 
     * @param customerItemTaxAmount
     *            The customerItemTaxAmount to set.
     */
    public void setCustomerItemTaxAmount( @Nullable final BigDecimal customerItemTaxAmount )
    {
        rememberChangedField("CustomerItemTaxAmount", this.customerItemTaxAmount);
        this.customerItemTaxAmount = customerItemTaxAmount;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscountIsDeductible</b>
     * </p>
     * 
     * @param cashDiscountIsDeductible
     *            Cash Discount Indicator
     */
    public void setCashDiscountIsDeductible( @Nullable final java.lang.Boolean cashDiscountIsDeductible )
    {
        rememberChangedField("CashDiscountIsDeductible", this.cashDiscountIsDeductible);
        this.cashDiscountIsDeductible = cashDiscountIsDeductible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDoc</b>
     * </p>
     * 
     * @param settlmtSourceDoc
     *            Document Number of the Source Document
     */
    public void setSettlmtSourceDoc( @Nullable final java.lang.String settlmtSourceDoc )
    {
        rememberChangedField("SettlmtSourceDoc", this.settlmtSourceDoc);
        this.settlmtSourceDoc = settlmtSourceDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDocItem</b>
     * </p>
     * 
     * @param settlmtSourceDocItem
     *            Item Number of the Source Document Item
     */
    public void setSettlmtSourceDocItem( @Nullable final java.lang.String settlmtSourceDocItem )
    {
        rememberChangedField("SettlmtSourceDocItem", this.settlmtSourceDocItem);
        this.settlmtSourceDocItem = settlmtSourceDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtSourceDocCat</b>
     * </p>
     * 
     * @param settlmtSourceDocCat
     *            Document Category of Source Document
     */
    public void setSettlmtSourceDocCat( @Nullable final java.lang.String settlmtSourceDocCat )
    {
        rememberChangedField("SettlmtSourceDocCat", this.settlmtSourceDocCat);
        this.settlmtSourceDocCat = settlmtSourceDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtItemActivityReason</b>
     * </p>
     * 
     * @param settlmtItemActivityReason
     *            Activity Reason for Document Creation
     */
    public void setSettlmtItemActivityReason( @Nullable final java.lang.String settlmtItemActivityReason )
    {
        rememberChangedField("SettlmtItemActivityReason", this.settlmtItemActivityReason);
        this.settlmtItemActivityReason = settlmtItemActivityReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItemText</b>
     * </p>
     * 
     * @param settlmtDocItemText
     *            Short Text
     */
    public void setSettlmtDocItemText( @Nullable final java.lang.String settlmtDocItemText )
    {
        rememberChangedField("SettlmtDocItemText", this.settlmtDocItemText);
        this.settlmtDocItemText = settlmtDocItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SupplierProductID</b>
     * </p>
     * 
     * @param supplierProductID
     *            Material Number Used by Supplier
     */
    public void setSupplierProductID( @Nullable final java.lang.String supplierProductID )
    {
        rememberChangedField("SupplierProductID", this.supplierProductID);
        this.supplierProductID = supplierProductID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     * 
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final java.lang.String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQtyUnit</b>
     * </p>
     * 
     * @param productPurchasePointsQtyUnit
     *            Points Unit
     */
    public void setProductPurchasePointsQtyUnit( @Nullable final java.lang.String productPurchasePointsQtyUnit )
    {
        rememberChangedField("ProductPurchasePointsQtyUnit", this.productPurchasePointsQtyUnit);
        this.productPurchasePointsQtyUnit = productPurchasePointsQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdPurPointsQtyUnitISOCode</b>
     * </p>
     * 
     * @param prodPurPointsQtyUnitISOCode
     *            Product Purchase Points Quantity Unit in ISO code
     */
    public void setProdPurPointsQtyUnitISOCode( @Nullable final java.lang.String prodPurPointsQtyUnitISOCode )
    {
        rememberChangedField("ProdPurPointsQtyUnitISOCode", this.prodPurPointsQtyUnitISOCode);
        this.prodPurPointsQtyUnitISOCode = prodPurPointsQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProdPurPointsQtyUnitSAPCode</b>
     * </p>
     * 
     * @param prodPurPointsQtyUnitSAPCode
     *            Product Purchase Points Quantity Unit in SAP code
     */
    public void setProdPurPointsQtyUnitSAPCode( @Nullable final java.lang.String prodPurPointsQtyUnitSAPCode )
    {
        rememberChangedField("ProdPurPointsQtyUnitSAPCode", this.prodPurPointsQtyUnitSAPCode);
        this.prodPurPointsQtyUnitSAPCode = prodPurPointsQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductPurchasePointsQty</b>
     * </p>
     * 
     * @param productPurchasePointsQty
     *            Number of Points
     */
    public void setProductPurchasePointsQty( @Nullable final BigDecimal productPurchasePointsQty )
    {
        rememberChangedField("ProductPurchasePointsQty", this.productPurchasePointsQty);
        this.productPurchasePointsQty = productPurchasePointsQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtBusinessArea</b>
     * </p>
     * 
     * @param suplrSettlmtBusinessArea
     *            Business Area
     */
    public void setSuplrSettlmtBusinessArea( @Nullable final java.lang.String suplrSettlmtBusinessArea )
    {
        rememberChangedField("SuplrSettlmtBusinessArea", this.suplrSettlmtBusinessArea);
        this.suplrSettlmtBusinessArea = suplrSettlmtBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtBusinessArea</b>
     * </p>
     * 
     * @param custSettlmtBusinessArea
     *            Customer Business Area
     */
    public void setCustSettlmtBusinessArea( @Nullable final java.lang.String custSettlmtBusinessArea )
    {
        rememberChangedField("CustSettlmtBusinessArea", this.custSettlmtBusinessArea);
        this.custSettlmtBusinessArea = custSettlmtBusinessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtCostCenter</b>
     * </p>
     * 
     * @param suplrSettlmtCostCenter
     *            Cost Center
     */
    public void setSuplrSettlmtCostCenter( @Nullable final java.lang.String suplrSettlmtCostCenter )
    {
        rememberChangedField("SuplrSettlmtCostCenter", this.suplrSettlmtCostCenter);
        this.suplrSettlmtCostCenter = suplrSettlmtCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SuplrSettlmtProfitCenter</b>
     * </p>
     * 
     * @param suplrSettlmtProfitCenter
     *            Profit Center
     */
    public void setSuplrSettlmtProfitCenter( @Nullable final java.lang.String suplrSettlmtProfitCenter )
    {
        rememberChangedField("SuplrSettlmtProfitCenter", this.suplrSettlmtProfitCenter);
        this.suplrSettlmtProfitCenter = suplrSettlmtProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     * 
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final java.lang.String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     * 
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final java.lang.String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     * 
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final java.lang.String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtCostCenter</b>
     * </p>
     * 
     * @param custSettlmtCostCenter
     *            Customer Cost Center
     */
    public void setCustSettlmtCostCenter( @Nullable final java.lang.String custSettlmtCostCenter )
    {
        rememberChangedField("CustSettlmtCostCenter", this.custSettlmtCostCenter);
        this.custSettlmtCostCenter = custSettlmtCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustSettlmtProfitCenter</b>
     * </p>
     * 
     * @param custSettlmtProfitCenter
     *            Alternative Customer Profit Center
     */
    public void setCustSettlmtProfitCenter( @Nullable final java.lang.String custSettlmtProfitCenter )
    {
        rememberChangedField("CustSettlmtProfitCenter", this.custSettlmtProfitCenter);
        this.custSettlmtProfitCenter = custSettlmtProfitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDoc</b>
     * </p>
     * 
     * @param settlmtPrecdgDoc
     *            Preceding Document of the Settlement Management Document
     */
    public void setSettlmtPrecdgDoc( @Nullable final java.lang.String settlmtPrecdgDoc )
    {
        rememberChangedField("SettlmtPrecdgDoc", this.settlmtPrecdgDoc);
        this.settlmtPrecdgDoc = settlmtPrecdgDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDocItem</b>
     * </p>
     * 
     * @param settlmtPrecdgDocItem
     *            Preceding Document Item in the Settlement Management Doc.
     */
    public void setSettlmtPrecdgDocItem( @Nullable final java.lang.String settlmtPrecdgDocItem )
    {
        rememberChangedField("SettlmtPrecdgDocItem", this.settlmtPrecdgDocItem);
        this.settlmtPrecdgDocItem = settlmtPrecdgDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPrecdgDocCat</b>
     * </p>
     * 
     * @param settlmtPrecdgDocCat
     *            Document Category of Preceding Document
     */
    public void setSettlmtPrecdgDocCat( @Nullable final java.lang.String settlmtPrecdgDocCat )
    {
        rememberChangedField("SettlmtPrecdgDocCat", this.settlmtPrecdgDocCat);
        this.settlmtPrecdgDocCat = settlmtPrecdgDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocItemCat</b>
     * </p>
     * 
     * @param settlmtDocItemCat
     *            Item Category
     */
    public void setSettlmtDocItemCat( @Nullable final java.lang.String settlmtDocItemCat )
    {
        rememberChangedField("SettlmtDocItemCat", this.settlmtDocItemCat);
        this.settlmtDocItemCat = settlmtDocItemCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSettlementOrder</b>
     * </p>
     * 
     * @param supplierSettlementOrder
     *            Order for Account Assignment
     */
    public void setSupplierSettlementOrder( @Nullable final java.lang.String supplierSettlementOrder )
    {
        rememberChangedField("SupplierSettlementOrder", this.supplierSettlementOrder);
        this.supplierSettlementOrder = supplierSettlementOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ItemSettlmtRelevance</b>
     * </p>
     * 
     * @param itemSettlmtRelevance
     *            Item Settlement Relevance
     */
    public void setItemSettlmtRelevance( @Nullable final java.lang.String itemSettlmtRelevance )
    {
        rememberChangedField("ItemSettlmtRelevance", this.itemSettlmtRelevance);
        this.itemSettlmtRelevance = itemSettlmtRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlementFiscalYear</b>
     * </p>
     * 
     * @param settlementFiscalYear
     *            CCS: Fiscal Year of Settlement
     */
    public void setSettlementFiscalYear( @Nullable final java.lang.String settlementFiscalYear )
    {
        rememberChangedField("SettlementFiscalYear", this.settlementFiscalYear);
        this.settlementFiscalYear = settlementFiscalYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDoc</b>
     * </p>
     * 
     * @param settlmtRefDoc
     *            Reference Document for Settlement Management
     */
    public void setSettlmtRefDoc( @Nullable final java.lang.String settlmtRefDoc )
    {
        rememberChangedField("SettlmtRefDoc", this.settlmtRefDoc);
        this.settlmtRefDoc = settlmtRefDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocCompanyCode</b>
     * </p>
     * 
     * @param settlmtRefDocCompanyCode
     *            Company Code of Reference Document for Settlement Management
     */
    public void setSettlmtRefDocCompanyCode( @Nullable final java.lang.String settlmtRefDocCompanyCode )
    {
        rememberChangedField("SettlmtRefDocCompanyCode", this.settlmtRefDocCompanyCode);
        this.settlmtRefDocCompanyCode = settlmtRefDocCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocItem</b>
     * </p>
     * 
     * @param settlmtRefDocItem
     *            Reference Document Item for Settlement Management Document
     */
    public void setSettlmtRefDocItem( @Nullable final java.lang.String settlmtRefDocItem )
    {
        rememberChangedField("SettlmtRefDocItem", this.settlmtRefDocItem);
        this.settlmtRefDocItem = settlmtRefDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtRefDocCat</b>
     * </p>
     * 
     * @param settlmtRefDocCat
     *            Reference Document Category in Settlement Management
     */
    public void setSettlmtRefDocCat( @Nullable final java.lang.String settlmtRefDocCat )
    {
        rememberChangedField("SettlmtRefDocCat", this.settlmtRefDocCat);
        this.settlmtRefDocCat = settlmtRefDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     * 
     * @param supplierSubrange
     *            Supplier Subrange
     */
    public void setSupplierSubrange( @Nullable final java.lang.String supplierSubrange )
    {
        rememberChangedField("SupplierSubrange", this.supplierSubrange);
        this.supplierSubrange = supplierSubrange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IntercompanyTaxCountry</b>
     * </p>
     * 
     * @param intercompanyTaxCountry
     *            Tax Reporting Country/Region for Intercompany Processes
     */
    public void setIntercompanyTaxCountry( @Nullable final java.lang.String intercompanyTaxCountry )
    {
        rememberChangedField("IntercompanyTaxCountry", this.intercompanyTaxCountry);
        this.intercompanyTaxCountry = intercompanyTaxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxCountry</b>
     * </p>
     * 
     * @param taxCountry
     *            Tax Reporting Country/Region
     */
    public void setTaxCountry( @Nullable final java.lang.String taxCountry )
    {
        rememberChangedField("TaxCountry", this.taxCountry);
        this.taxCountry = taxCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @param priorSupplier
     *            Prior Supplier
     */
    public void setPriorSupplier( @Nullable final java.lang.String priorSupplier )
    {
        rememberChangedField("PriorSupplier", this.priorSupplier);
        this.priorSupplier = priorSupplier;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SetlDocItm";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtDoc", getSettlmtDoc());
        entityKey.addKeyProperty("SettlmtDocItem", getSettlmtDocItem());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtDoc", getSettlmtDoc());
        values.put("SettlmtDocItem", getSettlmtDocItem());
        values.put("SettlmtDocCurrency", getSettlmtDocCurrency());
        values.put("Product", getProduct());
        values.put("ProductGroup", getProductGroup());
        values.put("Plant", getPlant());
        values.put("SupplierTaxCode", getSupplierTaxCode());
        values.put("CustomerTaxCode", getCustomerTaxCode());
        values.put("PricingDate", getPricingDate());
        values.put("SettlmtQuantity", getSettlmtQuantity());
        values.put("SettlmtQuantityUnit", getSettlmtQuantityUnit());
        values.put("SettlmtQuantityUnitISOCode", getSettlmtQuantityUnitISOCode());
        values.put("SettlmtQuantityUnitSAPCode", getSettlmtQuantityUnitSAPCode());
        values.put("NetPriceAmount", getNetPriceAmount());
        values.put("NetPriceQuantity", getNetPriceQuantity());
        values.put("NetPriceQuantityUnit", getNetPriceQuantityUnit());
        values.put("SettlmtToBaseQuantityNmrtr", getSettlmtToBaseQuantityNmrtr());
        values.put("SettlmtToBaseQuantityDnmntr", getSettlmtToBaseQuantityDnmntr());
        values.put("BaseUnit", getBaseUnit());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightUnitISOCode", getItemWeightUnitISOCode());
        values.put("ItemWeightUnitSAPCode", getItemWeightUnitSAPCode());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeUnitISOCode", getItemVolumeUnitISOCode());
        values.put("ItemVolumeUnitSAPCode", getItemVolumeUnitSAPCode());
        values.put("SupplierItemGrossAmount", getSupplierItemGrossAmount());
        values.put("SupplierItemNetAmount", getSupplierItemNetAmount());
        values.put("SupplierItemTaxAmount", getSupplierItemTaxAmount());
        values.put("CustomerItemGrossAmount", getCustomerItemGrossAmount());
        values.put("CustomerItemNetAmount", getCustomerItemNetAmount());
        values.put("CustomerItemTaxAmount", getCustomerItemTaxAmount());
        values.put("CashDiscountIsDeductible", getCashDiscountIsDeductible());
        values.put("SettlmtSourceDoc", getSettlmtSourceDoc());
        values.put("SettlmtSourceDocItem", getSettlmtSourceDocItem());
        values.put("SettlmtSourceDocCat", getSettlmtSourceDocCat());
        values.put("SettlmtItemActivityReason", getSettlmtItemActivityReason());
        values.put("SettlmtDocItemText", getSettlmtDocItemText());
        values.put("SupplierProductID", getSupplierProductID());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ProductPurchasePointsQtyUnit", getProductPurchasePointsQtyUnit());
        values.put("ProdPurPointsQtyUnitISOCode", getProdPurPointsQtyUnitISOCode());
        values.put("ProdPurPointsQtyUnitSAPCode", getProdPurPointsQtyUnitSAPCode());
        values.put("ProductPurchasePointsQty", getProductPurchasePointsQty());
        values.put("SuplrSettlmtBusinessArea", getSuplrSettlmtBusinessArea());
        values.put("CustSettlmtBusinessArea", getCustSettlmtBusinessArea());
        values.put("SuplrSettlmtCostCenter", getSuplrSettlmtCostCenter());
        values.put("SuplrSettlmtProfitCenter", getSuplrSettlmtProfitCenter());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("CustSettlmtCostCenter", getCustSettlmtCostCenter());
        values.put("CustSettlmtProfitCenter", getCustSettlmtProfitCenter());
        values.put("SettlmtPrecdgDoc", getSettlmtPrecdgDoc());
        values.put("SettlmtPrecdgDocItem", getSettlmtPrecdgDocItem());
        values.put("SettlmtPrecdgDocCat", getSettlmtPrecdgDocCat());
        values.put("SettlmtDocItemCat", getSettlmtDocItemCat());
        values.put("SupplierSettlementOrder", getSupplierSettlementOrder());
        values.put("ItemSettlmtRelevance", getItemSettlmtRelevance());
        values.put("SettlementFiscalYear", getSettlementFiscalYear());
        values.put("SettlmtRefDoc", getSettlmtRefDoc());
        values.put("SettlmtRefDocCompanyCode", getSettlmtRefDocCompanyCode());
        values.put("SettlmtRefDocItem", getSettlmtRefDocItem());
        values.put("SettlmtRefDocCat", getSettlmtRefDocCat());
        values.put("SupplierSubrange", getSupplierSubrange());
        values.put("IntercompanyTaxCountry", getIntercompanyTaxCountry());
        values.put("TaxCountry", getTaxCountry());
        values.put("PriorSupplier", getPriorSupplier());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtDoc") ) {
                final Object value = values.remove("SettlmtDoc");
                if( (value == null) || (!value.equals(getSettlmtDoc())) ) {
                    setSettlmtDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocItem") ) {
                final Object value = values.remove("SettlmtDocItem");
                if( (value == null) || (!value.equals(getSettlmtDocItem())) ) {
                    setSettlmtDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocCurrency") ) {
                final Object value = values.remove("SettlmtDocCurrency");
                if( (value == null) || (!value.equals(getSettlmtDocCurrency())) ) {
                    setSettlmtDocCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierTaxCode") ) {
                final Object value = values.remove("SupplierTaxCode");
                if( (value == null) || (!value.equals(getSupplierTaxCode())) ) {
                    setSupplierTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerTaxCode") ) {
                final Object value = values.remove("CustomerTaxCode");
                if( (value == null) || (!value.equals(getCustomerTaxCode())) ) {
                    setCustomerTaxCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("SettlmtQuantity") ) {
                final Object value = values.remove("SettlmtQuantity");
                if( (value == null) || (!value.equals(getSettlmtQuantity())) ) {
                    setSettlmtQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlmtQuantityUnit") ) {
                final Object value = values.remove("SettlmtQuantityUnit");
                if( (value == null) || (!value.equals(getSettlmtQuantityUnit())) ) {
                    setSettlmtQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtQuantityUnitISOCode") ) {
                final Object value = values.remove("SettlmtQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getSettlmtQuantityUnitISOCode())) ) {
                    setSettlmtQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtQuantityUnitSAPCode") ) {
                final Object value = values.remove("SettlmtQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getSettlmtQuantityUnitSAPCode())) ) {
                    setSettlmtQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("NetPriceAmount") ) {
                final Object value = values.remove("NetPriceAmount");
                if( (value == null) || (!value.equals(getNetPriceAmount())) ) {
                    setNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantity") ) {
                final Object value = values.remove("NetPriceQuantity");
                if( (value == null) || (!value.equals(getNetPriceQuantity())) ) {
                    setNetPriceQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPriceQuantityUnit") ) {
                final Object value = values.remove("NetPriceQuantityUnit");
                if( (value == null) || (!value.equals(getNetPriceQuantityUnit())) ) {
                    setNetPriceQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtToBaseQuantityNmrtr") ) {
                final Object value = values.remove("SettlmtToBaseQuantityNmrtr");
                if( (value == null) || (!value.equals(getSettlmtToBaseQuantityNmrtr())) ) {
                    setSettlmtToBaseQuantityNmrtr(((BigDecimal) value));
                }
            }
            if( values.containsKey("SettlmtToBaseQuantityDnmntr") ) {
                final Object value = values.remove("SettlmtToBaseQuantityDnmntr");
                if( (value == null) || (!value.equals(getSettlmtToBaseQuantityDnmntr())) ) {
                    setSettlmtToBaseQuantityDnmntr(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemWeightUnitISOCode") ) {
                final Object value = values.remove("ItemWeightUnitISOCode");
                if( (value == null) || (!value.equals(getItemWeightUnitISOCode())) ) {
                    setItemWeightUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemWeightUnitSAPCode") ) {
                final Object value = values.remove("ItemWeightUnitSAPCode");
                if( (value == null) || (!value.equals(getItemWeightUnitSAPCode())) ) {
                    setItemWeightUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemVolumeUnitISOCode") ) {
                final Object value = values.remove("ItemVolumeUnitISOCode");
                if( (value == null) || (!value.equals(getItemVolumeUnitISOCode())) ) {
                    setItemVolumeUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemVolumeUnitSAPCode") ) {
                final Object value = values.remove("ItemVolumeUnitSAPCode");
                if( (value == null) || (!value.equals(getItemVolumeUnitSAPCode())) ) {
                    setItemVolumeUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierItemGrossAmount") ) {
                final Object value = values.remove("SupplierItemGrossAmount");
                if( (value == null) || (!value.equals(getSupplierItemGrossAmount())) ) {
                    setSupplierItemGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierItemNetAmount") ) {
                final Object value = values.remove("SupplierItemNetAmount");
                if( (value == null) || (!value.equals(getSupplierItemNetAmount())) ) {
                    setSupplierItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupplierItemTaxAmount") ) {
                final Object value = values.remove("SupplierItemTaxAmount");
                if( (value == null) || (!value.equals(getSupplierItemTaxAmount())) ) {
                    setSupplierItemTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerItemGrossAmount") ) {
                final Object value = values.remove("CustomerItemGrossAmount");
                if( (value == null) || (!value.equals(getCustomerItemGrossAmount())) ) {
                    setCustomerItemGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerItemNetAmount") ) {
                final Object value = values.remove("CustomerItemNetAmount");
                if( (value == null) || (!value.equals(getCustomerItemNetAmount())) ) {
                    setCustomerItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerItemTaxAmount") ) {
                final Object value = values.remove("CustomerItemTaxAmount");
                if( (value == null) || (!value.equals(getCustomerItemTaxAmount())) ) {
                    setCustomerItemTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscountIsDeductible") ) {
                final Object value = values.remove("CashDiscountIsDeductible");
                if( (value == null) || (!value.equals(getCashDiscountIsDeductible())) ) {
                    setCashDiscountIsDeductible(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SettlmtSourceDoc") ) {
                final Object value = values.remove("SettlmtSourceDoc");
                if( (value == null) || (!value.equals(getSettlmtSourceDoc())) ) {
                    setSettlmtSourceDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtSourceDocItem") ) {
                final Object value = values.remove("SettlmtSourceDocItem");
                if( (value == null) || (!value.equals(getSettlmtSourceDocItem())) ) {
                    setSettlmtSourceDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtSourceDocCat") ) {
                final Object value = values.remove("SettlmtSourceDocCat");
                if( (value == null) || (!value.equals(getSettlmtSourceDocCat())) ) {
                    setSettlmtSourceDocCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtItemActivityReason") ) {
                final Object value = values.remove("SettlmtItemActivityReason");
                if( (value == null) || (!value.equals(getSettlmtItemActivityReason())) ) {
                    setSettlmtItemActivityReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocItemText") ) {
                final Object value = values.remove("SettlmtDocItemText");
                if( (value == null) || (!value.equals(getSettlmtDocItemText())) ) {
                    setSettlmtDocItemText(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierProductID") ) {
                final Object value = values.remove("SupplierProductID");
                if( (value == null) || (!value.equals(getSupplierProductID())) ) {
                    setSupplierProductID(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductPurchasePointsQtyUnit") ) {
                final Object value = values.remove("ProductPurchasePointsQtyUnit");
                if( (value == null) || (!value.equals(getProductPurchasePointsQtyUnit())) ) {
                    setProductPurchasePointsQtyUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdPurPointsQtyUnitISOCode") ) {
                final Object value = values.remove("ProdPurPointsQtyUnitISOCode");
                if( (value == null) || (!value.equals(getProdPurPointsQtyUnitISOCode())) ) {
                    setProdPurPointsQtyUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProdPurPointsQtyUnitSAPCode") ) {
                final Object value = values.remove("ProdPurPointsQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getProdPurPointsQtyUnitSAPCode())) ) {
                    setProdPurPointsQtyUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductPurchasePointsQty") ) {
                final Object value = values.remove("ProductPurchasePointsQty");
                if( (value == null) || (!value.equals(getProductPurchasePointsQty())) ) {
                    setProductPurchasePointsQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("SuplrSettlmtBusinessArea") ) {
                final Object value = values.remove("SuplrSettlmtBusinessArea");
                if( (value == null) || (!value.equals(getSuplrSettlmtBusinessArea())) ) {
                    setSuplrSettlmtBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustSettlmtBusinessArea") ) {
                final Object value = values.remove("CustSettlmtBusinessArea");
                if( (value == null) || (!value.equals(getCustSettlmtBusinessArea())) ) {
                    setCustSettlmtBusinessArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuplrSettlmtCostCenter") ) {
                final Object value = values.remove("SuplrSettlmtCostCenter");
                if( (value == null) || (!value.equals(getSuplrSettlmtCostCenter())) ) {
                    setSuplrSettlmtCostCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("SuplrSettlmtProfitCenter") ) {
                final Object value = values.remove("SuplrSettlmtProfitCenter");
                if( (value == null) || (!value.equals(getSuplrSettlmtProfitCenter())) ) {
                    setSuplrSettlmtProfitCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((java.lang.String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((java.lang.String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustSettlmtCostCenter") ) {
                final Object value = values.remove("CustSettlmtCostCenter");
                if( (value == null) || (!value.equals(getCustSettlmtCostCenter())) ) {
                    setCustSettlmtCostCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustSettlmtProfitCenter") ) {
                final Object value = values.remove("CustSettlmtProfitCenter");
                if( (value == null) || (!value.equals(getCustSettlmtProfitCenter())) ) {
                    setCustSettlmtProfitCenter(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtPrecdgDoc") ) {
                final Object value = values.remove("SettlmtPrecdgDoc");
                if( (value == null) || (!value.equals(getSettlmtPrecdgDoc())) ) {
                    setSettlmtPrecdgDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtPrecdgDocItem") ) {
                final Object value = values.remove("SettlmtPrecdgDocItem");
                if( (value == null) || (!value.equals(getSettlmtPrecdgDocItem())) ) {
                    setSettlmtPrecdgDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtPrecdgDocCat") ) {
                final Object value = values.remove("SettlmtPrecdgDocCat");
                if( (value == null) || (!value.equals(getSettlmtPrecdgDocCat())) ) {
                    setSettlmtPrecdgDocCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocItemCat") ) {
                final Object value = values.remove("SettlmtDocItemCat");
                if( (value == null) || (!value.equals(getSettlmtDocItemCat())) ) {
                    setSettlmtDocItemCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierSettlementOrder") ) {
                final Object value = values.remove("SupplierSettlementOrder");
                if( (value == null) || (!value.equals(getSupplierSettlementOrder())) ) {
                    setSupplierSettlementOrder(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemSettlmtRelevance") ) {
                final Object value = values.remove("ItemSettlmtRelevance");
                if( (value == null) || (!value.equals(getItemSettlmtRelevance())) ) {
                    setItemSettlmtRelevance(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlementFiscalYear") ) {
                final Object value = values.remove("SettlementFiscalYear");
                if( (value == null) || (!value.equals(getSettlementFiscalYear())) ) {
                    setSettlementFiscalYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtRefDoc") ) {
                final Object value = values.remove("SettlmtRefDoc");
                if( (value == null) || (!value.equals(getSettlmtRefDoc())) ) {
                    setSettlmtRefDoc(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtRefDocCompanyCode") ) {
                final Object value = values.remove("SettlmtRefDocCompanyCode");
                if( (value == null) || (!value.equals(getSettlmtRefDocCompanyCode())) ) {
                    setSettlmtRefDocCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtRefDocItem") ) {
                final Object value = values.remove("SettlmtRefDocItem");
                if( (value == null) || (!value.equals(getSettlmtRefDocItem())) ) {
                    setSettlmtRefDocItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtRefDocCat") ) {
                final Object value = values.remove("SettlmtRefDocCat");
                if( (value == null) || (!value.equals(getSettlmtRefDocCat())) ) {
                    setSettlmtRefDocCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierSubrange") ) {
                final Object value = values.remove("SupplierSubrange");
                if( (value == null) || (!value.equals(getSupplierSubrange())) ) {
                    setSupplierSubrange(((java.lang.String) value));
                }
            }
            if( values.containsKey("IntercompanyTaxCountry") ) {
                final Object value = values.remove("IntercompanyTaxCountry");
                if( (value == null) || (!value.equals(getIntercompanyTaxCountry())) ) {
                    setIntercompanyTaxCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("TaxCountry") ) {
                final Object value = values.remove("TaxCountry");
                if( (value == null) || (!value.equals(getTaxCountry())) ) {
                    setTaxCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorSupplier") ) {
                final Object value = values.remove("PriorSupplier");
                if( (value == null) || (!value.equals(getPriorSupplier())) ) {
                    setPriorSupplier(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CustomerPricingElement") ) {
                final Object value = (values).remove("_CustomerPricingElement");
                if( value instanceof Iterable ) {
                    if( to_CustomerPricingElement == null ) {
                        to_CustomerPricingElement = Lists.newArrayList();
                    } else {
                        to_CustomerPricingElement = Lists.newArrayList(to_CustomerPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CustItmPricingElement entity;
                        if( to_CustomerPricingElement.size() > i ) {
                            entity = to_CustomerPricingElement.get(i);
                        } else {
                            entity = new CustItmPricingElement();
                            to_CustomerPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SettlmtDoc") ) {
                final Object value = (values).remove("_SettlmtDoc");
                if( value instanceof Map ) {
                    if( to_SettlmtDoc == null ) {
                        to_SettlmtDoc = new SetlDoc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDoc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_SupplierPricingElement") ) {
                final Object value = (values).remove("_SupplierPricingElement");
                if( value instanceof Iterable ) {
                    if( to_SupplierPricingElement == null ) {
                        to_SupplierPricingElement = Lists.newArrayList();
                    } else {
                        to_SupplierPricingElement = Lists.newArrayList(to_SupplierPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SuplrItmPricingElement entity;
                        if( to_SupplierPricingElement.size() > i ) {
                            entity = to_SupplierPricingElement.get(i);
                        } else {
                            entity = new SuplrItmPricingElement();
                            to_SupplierPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CustomerPricingElement != null ) {
            (values).put("_CustomerPricingElement", to_CustomerPricingElement);
        }
        if( to_SettlmtDoc != null ) {
            (values).put("_SettlmtDoc", to_SettlmtDoc);
        }
        if( to_SupplierPricingElement != null ) {
            (values).put("_SupplierPricingElement", to_SupplierPricingElement);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CustItmPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDocItm</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CustomerPricingElement</b> is already loaded, the result
     *         will contain the <b>CustItmPricingElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CustItmPricingElement>> getCustomerPricingElementIfPresent()
    {
        return Option.of(to_CustomerPricingElement);
    }

    /**
     * Overwrites the list of associated <b>CustItmPricingElement</b> entities for the loaded navigation property
     * <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property <b>_CustomerPricingElement</b> of a queried <b>SetlDocItm</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CustItmPricingElement</b> entities.
     */
    public void setCustomerPricingElement( @Nonnull final List<CustItmPricingElement> value )
    {
        if( to_CustomerPricingElement == null ) {
            to_CustomerPricingElement = Lists.newArrayList();
        }
        to_CustomerPricingElement.clear();
        to_CustomerPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CustItmPricingElement</b> entities. This corresponds to the OData
     * navigation property <b>_CustomerPricingElement</b>.
     * <p>
     * If the navigation property <b>_CustomerPricingElement</b> of a queried <b>SetlDocItm</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CustItmPricingElement</b> entities.
     */
    public void addCustomerPricingElement( CustItmPricingElement... entity )
    {
        if( to_CustomerPricingElement == null ) {
            to_CustomerPricingElement = Lists.newArrayList();
        }
        to_CustomerPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SetlDoc</b> entity (one to one). This corresponds to the OData navigation property
     * <b>_SettlmtDoc</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDocItm</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDoc</b> is already loaded, the result will contain
     *         the <b>SetlDoc</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SetlDoc> getSettlmtDocIfPresent()
    {
        return Option.of(to_SettlmtDoc);
    }

    /**
     * Overwrites the associated <b>SetlDoc</b> entity for the loaded navigation property <b>_SettlmtDoc</b>.
     * 
     * @param value
     *            New <b>SetlDoc</b> entity.
     */
    public void setSettlmtDoc( final SetlDoc value )
    {
        to_SettlmtDoc = value;
    }

    /**
     * Retrieval of associated <b>SuplrItmPricingElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SetlDocItm</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplierPricingElement</b> is already loaded, the result
     *         will contain the <b>SuplrItmPricingElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SuplrItmPricingElement>> getSupplierPricingElementIfPresent()
    {
        return Option.of(to_SupplierPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SuplrItmPricingElement</b> entities for the loaded navigation property
     * <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property <b>_SupplierPricingElement</b> of a queried <b>SetlDocItm</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SuplrItmPricingElement</b> entities.
     */
    public void setSupplierPricingElement( @Nonnull final List<SuplrItmPricingElement> value )
    {
        if( to_SupplierPricingElement == null ) {
            to_SupplierPricingElement = Lists.newArrayList();
        }
        to_SupplierPricingElement.clear();
        to_SupplierPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SuplrItmPricingElement</b> entities. This corresponds to the OData
     * navigation property <b>_SupplierPricingElement</b>.
     * <p>
     * If the navigation property <b>_SupplierPricingElement</b> of a queried <b>SetlDocItm</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SuplrItmPricingElement</b> entities.
     */
    public void addSupplierPricingElement( SuplrItmPricingElement... entity )
    {
        if( to_SupplierPricingElement == null ) {
            to_SupplierPricingElement = Lists.newArrayList();
        }
        to_SupplierPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SetlDocItm instances.
     * 
     */
    public final static class SetlDocItmBuilder
    {

        private List<CustItmPricingElement> to_CustomerPricingElement = Lists.newArrayList();
        private SetlDoc to_SettlmtDoc;
        private java.lang.String settlmtDoc = null;
        private List<SuplrItmPricingElement> to_SupplierPricingElement = Lists.newArrayList();

        private SetlDocItm.SetlDocItmBuilder to_CustomerPricingElement( final List<CustItmPricingElement> value )
        {
            to_CustomerPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CustomerPricingElement</b> for <b>SetlDocItm</b> to multiple
         * <b>CustItmPricingElement</b>.
         * 
         * @param value
         *            The CustItmPricingElements to build this SetlDocItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDocItm.SetlDocItmBuilder customerPricingElement( CustItmPricingElement... value )
        {
            return to_CustomerPricingElement(Lists.newArrayList(value));
        }

        private SetlDocItm.SetlDocItmBuilder to_SettlmtDoc( final SetlDoc value )
        {
            to_SettlmtDoc = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDoc</b> for <b>SetlDocItm</b> to single <b>SetlDoc</b>.
         * 
         * @param value
         *            The SetlDoc to build this SetlDocItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDocItm.SetlDocItmBuilder settlmtDoc( final SetlDoc value )
        {
            return to_SettlmtDoc(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDoc</b>
         * </p>
         * 
         * @param value
         *            The settlmtDoc to build this SetlDocItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDocItm.SetlDocItmBuilder settlmtDoc( final java.lang.String value )
        {
            settlmtDoc = value;
            return this;
        }

        private SetlDocItm.SetlDocItmBuilder to_SupplierPricingElement( final List<SuplrItmPricingElement> value )
        {
            to_SupplierPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SupplierPricingElement</b> for <b>SetlDocItm</b> to multiple
         * <b>SuplrItmPricingElement</b>.
         * 
         * @param value
         *            The SuplrItmPricingElements to build this SetlDocItm with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SetlDocItm.SetlDocItmBuilder supplierPricingElement( SuplrItmPricingElement... value )
        {
            return to_SupplierPricingElement(Lists.newArrayList(value));
        }

    }

}
