/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentTypeService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Header Text Object Type Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SetlMgmtHdrTxtObjTypeAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SetlMgmtHdrTxtObjTypeAssgmt extends VdmEntity<SetlMgmtHdrTxtObjTypeAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_doc_type.v0001.SetlMgmtHdrTxtObjTypeAssgmtType";
    /**
     * Selector for all available fields of SetlMgmtHdrTxtObjTypeAssgmt.
     * 
     */
    public final static SimpleProperty<SetlMgmtHdrTxtObjTypeAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtHdrTxtDetnProced</b>
     * </p>
     * 
     * @return Text Determination Procedure for Header
     */
    @Nullable
    @ElementName( "SettlmtHdrTxtDetnProced" )
    private java.lang.String settlmtHdrTxtDetnProced;
    public final static SimpleProperty.String<SetlMgmtHdrTxtObjTypeAssgmt> SETTLMT_HDR_TXT_DETN_PROCED =
        new SimpleProperty.String<SetlMgmtHdrTxtObjTypeAssgmt>(
            SetlMgmtHdrTxtObjTypeAssgmt.class,
            "SettlmtHdrTxtDetnProced");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtHdrTxtObjType</b>
     * </p>
     * 
     * @return Specific Text ID for a Settlement Management Document Header
     */
    @Nullable
    @ElementName( "SettlmtMgmtHdrTxtObjType" )
    private java.lang.String settlmtMgmtHdrTxtObjType;
    public final static SimpleProperty.String<SetlMgmtHdrTxtObjTypeAssgmt> SETTLMT_MGMT_HDR_TXT_OBJ_TYPE =
        new SimpleProperty.String<SetlMgmtHdrTxtObjTypeAssgmt>(
            SetlMgmtHdrTxtObjTypeAssgmt.class,
            "SettlmtMgmtHdrTxtObjType");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SetlMgmtHdrTxtObjTypeAssgmt> getType()
    {
        return SetlMgmtHdrTxtObjTypeAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtHdrTxtDetnProced</b>
     * </p>
     * 
     * @param settlmtHdrTxtDetnProced
     *            Text Determination Procedure for Header
     */
    public void setSettlmtHdrTxtDetnProced( @Nullable final java.lang.String settlmtHdrTxtDetnProced )
    {
        rememberChangedField("SettlmtHdrTxtDetnProced", this.settlmtHdrTxtDetnProced);
        this.settlmtHdrTxtDetnProced = settlmtHdrTxtDetnProced;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtHdrTxtObjType</b>
     * </p>
     * 
     * @param settlmtMgmtHdrTxtObjType
     *            Specific Text ID for a Settlement Management Document Header
     */
    public void setSettlmtMgmtHdrTxtObjType( @Nullable final java.lang.String settlmtMgmtHdrTxtObjType )
    {
        rememberChangedField("SettlmtMgmtHdrTxtObjType", this.settlmtMgmtHdrTxtObjType);
        this.settlmtMgmtHdrTxtObjType = settlmtMgmtHdrTxtObjType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SetlMgmtHdrTxtObjTypeAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtHdrTxtDetnProced", getSettlmtHdrTxtDetnProced());
        entityKey.addKeyProperty("SettlmtMgmtHdrTxtObjType", getSettlmtMgmtHdrTxtObjType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtHdrTxtDetnProced", getSettlmtHdrTxtDetnProced());
        values.put("SettlmtMgmtHdrTxtObjType", getSettlmtMgmtHdrTxtObjType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtHdrTxtDetnProced") ) {
                final Object value = values.remove("SettlmtHdrTxtDetnProced");
                if( (value == null) || (!value.equals(getSettlmtHdrTxtDetnProced())) ) {
                    setSettlmtHdrTxtDetnProced(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtMgmtHdrTxtObjType") ) {
                final Object value = values.remove("SettlmtMgmtHdrTxtObjType");
                if( (value == null) || (!value.equals(getSettlmtMgmtHdrTxtObjType())) ) {
                    setSettlmtMgmtHdrTxtObjType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentTypeService.DEFAULT_SERVICE_PATH;
    }

}
