/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentTypeService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Text Object Type Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SetlMgmtItmTxtObjTypeAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SetlMgmtItmTxtObjTypeAssgmt extends VdmEntity<SetlMgmtItmTxtObjTypeAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_doc_type.v0001.SetlMgmtItmTxtObjTypeAssgmtType";
    /**
     * Selector for all available fields of SetlMgmtItmTxtObjTypeAssgmt.
     * 
     */
    public final static SimpleProperty<SetlMgmtItmTxtObjTypeAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtItmTxtDetnProced</b>
     * </p>
     * 
     * @return Text Determination Procedure for Item
     */
    @Nullable
    @ElementName( "SettlmtItmTxtDetnProced" )
    private java.lang.String settlmtItmTxtDetnProced;
    public final static SimpleProperty.String<SetlMgmtItmTxtObjTypeAssgmt> SETTLMT_ITM_TXT_DETN_PROCED =
        new SimpleProperty.String<SetlMgmtItmTxtObjTypeAssgmt>(
            SetlMgmtItmTxtObjTypeAssgmt.class,
            "SettlmtItmTxtDetnProced");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtItmTxtObjType</b>
     * </p>
     * 
     * @return Specific Text ID for a Settlement Management Document Item
     */
    @Nullable
    @ElementName( "SettlmtMgmtItmTxtObjType" )
    private java.lang.String settlmtMgmtItmTxtObjType;
    public final static SimpleProperty.String<SetlMgmtItmTxtObjTypeAssgmt> SETTLMT_MGMT_ITM_TXT_OBJ_TYPE =
        new SimpleProperty.String<SetlMgmtItmTxtObjTypeAssgmt>(
            SetlMgmtItmTxtObjTypeAssgmt.class,
            "SettlmtMgmtItmTxtObjType");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SetlMgmtItmTxtObjTypeAssgmt> getType()
    {
        return SetlMgmtItmTxtObjTypeAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtItmTxtDetnProced</b>
     * </p>
     * 
     * @param settlmtItmTxtDetnProced
     *            Text Determination Procedure for Item
     */
    public void setSettlmtItmTxtDetnProced( @Nullable final java.lang.String settlmtItmTxtDetnProced )
    {
        rememberChangedField("SettlmtItmTxtDetnProced", this.settlmtItmTxtDetnProced);
        this.settlmtItmTxtDetnProced = settlmtItmTxtDetnProced;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtItmTxtObjType</b>
     * </p>
     * 
     * @param settlmtMgmtItmTxtObjType
     *            Specific Text ID for a Settlement Management Document Item
     */
    public void setSettlmtMgmtItmTxtObjType( @Nullable final java.lang.String settlmtMgmtItmTxtObjType )
    {
        rememberChangedField("SettlmtMgmtItmTxtObjType", this.settlmtMgmtItmTxtObjType);
        this.settlmtMgmtItmTxtObjType = settlmtMgmtItmTxtObjType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SetlMgmtItmTxtObjTypeAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtItmTxtDetnProced", getSettlmtItmTxtDetnProced());
        entityKey.addKeyProperty("SettlmtMgmtItmTxtObjType", getSettlmtMgmtItmTxtObjType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtItmTxtDetnProced", getSettlmtItmTxtDetnProced());
        values.put("SettlmtMgmtItmTxtObjType", getSettlmtMgmtItmTxtObjType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtItmTxtDetnProced") ) {
                final Object value = values.remove("SettlmtItmTxtDetnProced");
                if( (value == null) || (!value.equals(getSettlmtItmTxtDetnProced())) ) {
                    setSettlmtItmTxtDetnProced(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtMgmtItmTxtObjType") ) {
                final Object value = values.remove("SettlmtMgmtItmTxtObjType");
                if( (value == null) || (!value.equals(getSettlmtMgmtItmTxtObjType())) ) {
                    setSettlmtMgmtItmTxtObjType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentTypeService.DEFAULT_SERVICE_PATH;
    }

}
