/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementDocumentTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Settlement Document Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SettlmtDocTypeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SettlmtDocType extends VdmEntity<SettlmtDocType> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_settlmt_doc_type.v0001.SettlmtDocTypeType";
    /**
     * Selector for all available fields of SettlmtDocType.
     * 
     */
    public final static SimpleProperty<SettlmtDocType> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @return Settlement Document Type
     */
    @Nullable
    @ElementName( "SettlmtDocType" )
    private java.lang.String settlmtDocType;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_DOC_TYPE =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtDocType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCat</b>
     * </p>
     * 
     * @return Settlement Document Category
     */
    @Nullable
    @ElementName( "SettlmtDocCat" )
    private java.lang.String settlmtDocCat;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_DOC_CAT =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtDocCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCat</b>
     * </p>
     * 
     * @return Settlement Category
     */
    @Nullable
    @ElementName( "SettlmtCat" )
    private java.lang.String settlmtCat;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_CAT =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtCat");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtBusProcVar</b>
     * </p>
     * 
     * @return Settlement Management Process Category
     */
    @Nullable
    @ElementName( "SettlmtBusProcVar" )
    private java.lang.String settlmtBusProcVar;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_BUS_PROC_VAR =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtBusProcVar");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtPrcgApplCat</b>
     * </p>
     * 
     * @return Application for Price Determination
     */
    @Nullable
    @ElementName( "SettlmtMgmtPrcgApplCat" )
    private java.lang.String settlmtMgmtPrcgApplCat;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_MGMT_PRCG_APPL_CAT =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtMgmtPrcgApplCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtTxCodeTxTypeChkCat</b>
     * </p>
     * 
     * @return Control of Tax Type Check for Tax Codes
     */
    @Nullable
    @ElementName( "SettlmtTxCodeTxTypeChkCat" )
    private java.lang.String settlmtTxCodeTxTypeChkCat;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_TX_CODE_TX_TYPE_CHK_CAT =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtTxCodeTxTypeChkCat");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryType</b>
     * </p>
     * 
     * @return Journal Entry Type for Settlement Management Document
     */
    @Nullable
    @ElementName( "JournalEntryType" )
    private java.lang.String journalEntryType;
    public final static SimpleProperty.String<SettlmtDocType> JOURNAL_ENTRY_TYPE =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "JournalEntryType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
     * </p>
     * 
     * @return Settlement Doc. Type for Collective Settlement
     */
    @Nullable
    @ElementName( "SettlmtDocTypeOfCollection" )
    private java.lang.String settlmtDocTypeOfCollection;
    public final static SimpleProperty.String<SettlmtDocType> SETTLMT_DOC_TYPE_OF_COLLECTION =
        new SimpleProperty.String<SettlmtDocType>(SettlmtDocType.class, "SettlmtDocTypeOfCollection");
    /**
     * Navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> for <b>SettlmtDocType</b> to multiple
     * <b>SetlMgmtHdrTxtObjTypeAssgmt</b>.
     * 
     */
    @ElementName( "_SetlMgmtHdrTxtObjTypeAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SetlMgmtHdrTxtObjTypeAssgmt> to_SetlMgmtHdrTxtObjTypeAssgmt;
    /**
     * Navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b> for <b>SettlmtDocType</b> to multiple
     * <b>SetlMgmtItmTxtObjTypeAssgmt</b>.
     * 
     */
    @ElementName( "_SetlMgmtItmTxtObjTypeAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SetlMgmtItmTxtObjTypeAssgmt> to_SetlMgmtItmTxtObjTypeAssgmt;
    /**
     * Navigation property <b>_SettlmtDocTypeOfCollection</b> for <b>SettlmtDocType</b> to single <b>SettlmtDocType</b>.
     * 
     */
    @ElementName( "_SettlmtDocTypeOfCollection" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SettlmtDocType to_SettlmtDocTypeOfCollection;
    /**
     * Use with available request builders to apply the <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtDocType, SetlMgmtHdrTxtObjTypeAssgmt> TO__SETL_MGMT_HDR_TXT_OBJ_TYPE_ASSGMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtDocType, SetlMgmtHdrTxtObjTypeAssgmt>(
            SettlmtDocType.class,
            "_SetlMgmtHdrTxtObjTypeAssgmt",
            SetlMgmtHdrTxtObjTypeAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_SetlMgmtItmTxtObjTypeAssgmt</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtDocType, SetlMgmtItmTxtObjTypeAssgmt> TO__SETL_MGMT_ITM_TXT_OBJ_TYPE_ASSGMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtDocType, SetlMgmtItmTxtObjTypeAssgmt>(
            SettlmtDocType.class,
            "_SetlMgmtItmTxtObjTypeAssgmt",
            SetlMgmtItmTxtObjTypeAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocTypeOfCollection</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtDocType, SettlmtDocType> TO__SETTLMT_DOC_TYPE_OF_COLLECTION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtDocType, SettlmtDocType>(
            SettlmtDocType.class,
            "_SettlmtDocTypeOfCollection",
            SettlmtDocType.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SettlmtDocType> getType()
    {
        return SettlmtDocType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     */
    public void setSettlmtDocType( @Nullable final java.lang.String settlmtDocType )
    {
        rememberChangedField("SettlmtDocType", this.settlmtDocType);
        this.settlmtDocType = settlmtDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocCat</b>
     * </p>
     * 
     * @param settlmtDocCat
     *            Settlement Document Category
     */
    public void setSettlmtDocCat( @Nullable final java.lang.String settlmtDocCat )
    {
        rememberChangedField("SettlmtDocCat", this.settlmtDocCat);
        this.settlmtDocCat = settlmtDocCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCat</b>
     * </p>
     * 
     * @param settlmtCat
     *            Settlement Category
     */
    public void setSettlmtCat( @Nullable final java.lang.String settlmtCat )
    {
        rememberChangedField("SettlmtCat", this.settlmtCat);
        this.settlmtCat = settlmtCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtBusProcVar</b>
     * </p>
     * 
     * @param settlmtBusProcVar
     *            Settlement Management Process Category
     */
    public void setSettlmtBusProcVar( @Nullable final java.lang.String settlmtBusProcVar )
    {
        rememberChangedField("SettlmtBusProcVar", this.settlmtBusProcVar);
        this.settlmtBusProcVar = settlmtBusProcVar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtMgmtPrcgApplCat</b>
     * </p>
     * 
     * @param settlmtMgmtPrcgApplCat
     *            Application for Price Determination
     */
    public void setSettlmtMgmtPrcgApplCat( @Nullable final java.lang.String settlmtMgmtPrcgApplCat )
    {
        rememberChangedField("SettlmtMgmtPrcgApplCat", this.settlmtMgmtPrcgApplCat);
        this.settlmtMgmtPrcgApplCat = settlmtMgmtPrcgApplCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtTxCodeTxTypeChkCat</b>
     * </p>
     * 
     * @param settlmtTxCodeTxTypeChkCat
     *            Control of Tax Type Check for Tax Codes
     */
    public void setSettlmtTxCodeTxTypeChkCat( @Nullable final java.lang.String settlmtTxCodeTxTypeChkCat )
    {
        rememberChangedField("SettlmtTxCodeTxTypeChkCat", this.settlmtTxCodeTxTypeChkCat);
        this.settlmtTxCodeTxTypeChkCat = settlmtTxCodeTxTypeChkCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JournalEntryType</b>
     * </p>
     * 
     * @param journalEntryType
     *            Journal Entry Type for Settlement Management Document
     */
    public void setJournalEntryType( @Nullable final java.lang.String journalEntryType )
    {
        rememberChangedField("JournalEntryType", this.journalEntryType);
        this.journalEntryType = journalEntryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
     * </p>
     * 
     * @param settlmtDocTypeOfCollection
     *            Settlement Doc. Type for Collective Settlement
     */
    public void setSettlmtDocTypeOfCollection( @Nullable final java.lang.String settlmtDocTypeOfCollection )
    {
        rememberChangedField("SettlmtDocTypeOfCollection", this.settlmtDocTypeOfCollection);
        this.settlmtDocTypeOfCollection = settlmtDocTypeOfCollection;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SettlmtDocType";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtDocType", getSettlmtDocType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtDocType", getSettlmtDocType());
        values.put("SettlmtDocCat", getSettlmtDocCat());
        values.put("SettlmtCat", getSettlmtCat());
        values.put("SettlmtBusProcVar", getSettlmtBusProcVar());
        values.put("SettlmtMgmtPrcgApplCat", getSettlmtMgmtPrcgApplCat());
        values.put("SettlmtTxCodeTxTypeChkCat", getSettlmtTxCodeTxTypeChkCat());
        values.put("JournalEntryType", getJournalEntryType());
        values.put("SettlmtDocTypeOfCollection", getSettlmtDocTypeOfCollection());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtDocType") ) {
                final Object value = values.remove("SettlmtDocType");
                if( (value == null) || (!value.equals(getSettlmtDocType())) ) {
                    setSettlmtDocType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocCat") ) {
                final Object value = values.remove("SettlmtDocCat");
                if( (value == null) || (!value.equals(getSettlmtDocCat())) ) {
                    setSettlmtDocCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtCat") ) {
                final Object value = values.remove("SettlmtCat");
                if( (value == null) || (!value.equals(getSettlmtCat())) ) {
                    setSettlmtCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtBusProcVar") ) {
                final Object value = values.remove("SettlmtBusProcVar");
                if( (value == null) || (!value.equals(getSettlmtBusProcVar())) ) {
                    setSettlmtBusProcVar(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtMgmtPrcgApplCat") ) {
                final Object value = values.remove("SettlmtMgmtPrcgApplCat");
                if( (value == null) || (!value.equals(getSettlmtMgmtPrcgApplCat())) ) {
                    setSettlmtMgmtPrcgApplCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtTxCodeTxTypeChkCat") ) {
                final Object value = values.remove("SettlmtTxCodeTxTypeChkCat");
                if( (value == null) || (!value.equals(getSettlmtTxCodeTxTypeChkCat())) ) {
                    setSettlmtTxCodeTxTypeChkCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("JournalEntryType") ) {
                final Object value = values.remove("JournalEntryType");
                if( (value == null) || (!value.equals(getJournalEntryType())) ) {
                    setJournalEntryType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocTypeOfCollection") ) {
                final Object value = values.remove("SettlmtDocTypeOfCollection");
                if( (value == null) || (!value.equals(getSettlmtDocTypeOfCollection())) ) {
                    setSettlmtDocTypeOfCollection(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SetlMgmtHdrTxtObjTypeAssgmt") ) {
                final Object value = (values).remove("_SetlMgmtHdrTxtObjTypeAssgmt");
                if( value instanceof Iterable ) {
                    if( to_SetlMgmtHdrTxtObjTypeAssgmt == null ) {
                        to_SetlMgmtHdrTxtObjTypeAssgmt = Lists.newArrayList();
                    } else {
                        to_SetlMgmtHdrTxtObjTypeAssgmt = Lists.newArrayList(to_SetlMgmtHdrTxtObjTypeAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SetlMgmtHdrTxtObjTypeAssgmt entity;
                        if( to_SetlMgmtHdrTxtObjTypeAssgmt.size() > i ) {
                            entity = to_SetlMgmtHdrTxtObjTypeAssgmt.get(i);
                        } else {
                            entity = new SetlMgmtHdrTxtObjTypeAssgmt();
                            to_SetlMgmtHdrTxtObjTypeAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SetlMgmtItmTxtObjTypeAssgmt") ) {
                final Object value = (values).remove("_SetlMgmtItmTxtObjTypeAssgmt");
                if( value instanceof Iterable ) {
                    if( to_SetlMgmtItmTxtObjTypeAssgmt == null ) {
                        to_SetlMgmtItmTxtObjTypeAssgmt = Lists.newArrayList();
                    } else {
                        to_SetlMgmtItmTxtObjTypeAssgmt = Lists.newArrayList(to_SetlMgmtItmTxtObjTypeAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SetlMgmtItmTxtObjTypeAssgmt entity;
                        if( to_SetlMgmtItmTxtObjTypeAssgmt.size() > i ) {
                            entity = to_SetlMgmtItmTxtObjTypeAssgmt.get(i);
                        } else {
                            entity = new SetlMgmtItmTxtObjTypeAssgmt();
                            to_SetlMgmtItmTxtObjTypeAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SettlmtDocTypeOfCollection") ) {
                final Object value = (values).remove("_SettlmtDocTypeOfCollection");
                if( value instanceof Map ) {
                    if( to_SettlmtDocTypeOfCollection == null ) {
                        to_SettlmtDocTypeOfCollection = new SettlmtDocType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDocTypeOfCollection.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementDocumentTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SetlMgmtHdrTxtObjTypeAssgmt != null ) {
            (values).put("_SetlMgmtHdrTxtObjTypeAssgmt", to_SetlMgmtHdrTxtObjTypeAssgmt);
        }
        if( to_SetlMgmtItmTxtObjTypeAssgmt != null ) {
            (values).put("_SetlMgmtItmTxtObjTypeAssgmt", to_SetlMgmtItmTxtObjTypeAssgmt);
        }
        if( to_SettlmtDocTypeOfCollection != null ) {
            (values).put("_SettlmtDocTypeOfCollection", to_SettlmtDocTypeOfCollection);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtDocType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> is already loaded, the
     *         result will contain the <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SetlMgmtHdrTxtObjTypeAssgmt>> getSetlMgmtHdrTxtObjTypeAssgmtIfPresent()
    {
        return Option.of(to_SetlMgmtHdrTxtObjTypeAssgmt);
    }

    /**
     * Overwrites the list of associated <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities for the loaded navigation property
     * <b>_SetlMgmtHdrTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> of a queried <b>SettlmtDocType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities.
     */
    public void setSetlMgmtHdrTxtObjTypeAssgmt( @Nonnull final List<SetlMgmtHdrTxtObjTypeAssgmt> value )
    {
        if( to_SetlMgmtHdrTxtObjTypeAssgmt == null ) {
            to_SetlMgmtHdrTxtObjTypeAssgmt = Lists.newArrayList();
        }
        to_SetlMgmtHdrTxtObjTypeAssgmt.clear();
        to_SetlMgmtHdrTxtObjTypeAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities. This corresponds to the
     * OData navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> of a queried <b>SettlmtDocType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SetlMgmtHdrTxtObjTypeAssgmt</b> entities.
     */
    public void addSetlMgmtHdrTxtObjTypeAssgmt( SetlMgmtHdrTxtObjTypeAssgmt... entity )
    {
        if( to_SetlMgmtHdrTxtObjTypeAssgmt == null ) {
            to_SetlMgmtHdrTxtObjTypeAssgmt = Lists.newArrayList();
        }
        to_SetlMgmtHdrTxtObjTypeAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtDocType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b> is already loaded, the
     *         result will contain the <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SetlMgmtItmTxtObjTypeAssgmt>> getSetlMgmtItmTxtObjTypeAssgmtIfPresent()
    {
        return Option.of(to_SetlMgmtItmTxtObjTypeAssgmt);
    }

    /**
     * Overwrites the list of associated <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities for the loaded navigation property
     * <b>_SetlMgmtItmTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b> of a queried <b>SettlmtDocType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities.
     */
    public void setSetlMgmtItmTxtObjTypeAssgmt( @Nonnull final List<SetlMgmtItmTxtObjTypeAssgmt> value )
    {
        if( to_SetlMgmtItmTxtObjTypeAssgmt == null ) {
            to_SetlMgmtItmTxtObjTypeAssgmt = Lists.newArrayList();
        }
        to_SetlMgmtItmTxtObjTypeAssgmt.clear();
        to_SetlMgmtItmTxtObjTypeAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities. This corresponds to the
     * OData navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b> of a queried <b>SettlmtDocType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SetlMgmtItmTxtObjTypeAssgmt</b> entities.
     */
    public void addSetlMgmtItmTxtObjTypeAssgmt( SetlMgmtItmTxtObjTypeAssgmt... entity )
    {
        if( to_SetlMgmtItmTxtObjTypeAssgmt == null ) {
            to_SetlMgmtItmTxtObjTypeAssgmt = Lists.newArrayList();
        }
        to_SetlMgmtItmTxtObjTypeAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SettlmtDocType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SettlmtDocTypeOfCollection</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtDocType</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocTypeOfCollection</b> is already loaded, the
     *         result will contain the <b>SettlmtDocType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SettlmtDocType> getSettlmtDocTypeOfCollectionIfPresent()
    {
        return Option.of(to_SettlmtDocTypeOfCollection);
    }

    /**
     * Overwrites the associated <b>SettlmtDocType</b> entity for the loaded navigation property
     * <b>_SettlmtDocTypeOfCollection</b>.
     * 
     * @param value
     *            New <b>SettlmtDocType</b> entity.
     */
    public void setSettlmtDocTypeOfCollection( final SettlmtDocType value )
    {
        to_SettlmtDocTypeOfCollection = value;
    }

    /**
     * Helper class to allow for fluent creation of SettlmtDocType instances.
     * 
     */
    public final static class SettlmtDocTypeBuilder
    {

        private List<SetlMgmtHdrTxtObjTypeAssgmt> to_SetlMgmtHdrTxtObjTypeAssgmt = Lists.newArrayList();
        private List<SetlMgmtItmTxtObjTypeAssgmt> to_SetlMgmtItmTxtObjTypeAssgmt = Lists.newArrayList();
        private SettlmtDocType to_SettlmtDocTypeOfCollection;
        private java.lang.String settlmtDocTypeOfCollection = null;

        private SettlmtDocType.SettlmtDocTypeBuilder to_SetlMgmtHdrTxtObjTypeAssgmt(
            final List<SetlMgmtHdrTxtObjTypeAssgmt> value )
        {
            to_SetlMgmtHdrTxtObjTypeAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SetlMgmtHdrTxtObjTypeAssgmt</b> for <b>SettlmtDocType</b> to multiple
         * <b>SetlMgmtHdrTxtObjTypeAssgmt</b>.
         * 
         * @param value
         *            The SetlMgmtHdrTxtObjTypeAssgmts to build this SettlmtDocType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtDocType.SettlmtDocTypeBuilder setlMgmtHdrTxtObjTypeAssgmt( SetlMgmtHdrTxtObjTypeAssgmt... value )
        {
            return to_SetlMgmtHdrTxtObjTypeAssgmt(Lists.newArrayList(value));
        }

        private SettlmtDocType.SettlmtDocTypeBuilder to_SetlMgmtItmTxtObjTypeAssgmt(
            final List<SetlMgmtItmTxtObjTypeAssgmt> value )
        {
            to_SetlMgmtItmTxtObjTypeAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SetlMgmtItmTxtObjTypeAssgmt</b> for <b>SettlmtDocType</b> to multiple
         * <b>SetlMgmtItmTxtObjTypeAssgmt</b>.
         * 
         * @param value
         *            The SetlMgmtItmTxtObjTypeAssgmts to build this SettlmtDocType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtDocType.SettlmtDocTypeBuilder setlMgmtItmTxtObjTypeAssgmt( SetlMgmtItmTxtObjTypeAssgmt... value )
        {
            return to_SetlMgmtItmTxtObjTypeAssgmt(Lists.newArrayList(value));
        }

        private SettlmtDocType.SettlmtDocTypeBuilder to_SettlmtDocTypeOfCollection( final SettlmtDocType value )
        {
            to_SettlmtDocTypeOfCollection = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocTypeOfCollection</b> for <b>SettlmtDocType</b> to single
         * <b>SettlmtDocType</b>.
         * 
         * @param value
         *            The SettlmtDocType to build this SettlmtDocType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtDocType.SettlmtDocTypeBuilder settlmtDocTypeOfCollection( final SettlmtDocType value )
        {
            return to_SettlmtDocTypeOfCollection(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
         * </p>
         * 
         * @param value
         *            The settlmtDocTypeOfCollection to build this SettlmtDocType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtDocType.SettlmtDocTypeBuilder settlmtDocTypeOfCollection( final java.lang.String value )
        {
            settlmtDocTypeOfCollection = value;
            return this;
        }

    }

}
