/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementProcessTypeService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Application Status Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SettlmtApplStsGrpStsAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SettlmtApplStsGrpStsAssgmt extends VdmEntity<SettlmtApplStsGrpStsAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_proc_type.v0001.SettlmtApplStsGrpStsAssgmtType";
    /**
     * Selector for all available fields of SettlmtApplStsGrpStsAssgmt.
     * 
     */
    public final static SimpleProperty<SettlmtApplStsGrpStsAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsGrp</b>
     * </p>
     * 
     * @return Status Group for Settlement Management Documents
     */
    @Nullable
    @ElementName( "SettlmtApplStsGrp" )
    private java.lang.String settlmtApplStsGrp;
    public final static SimpleProperty.String<SettlmtApplStsGrpStsAssgmt> SETTLMT_APPL_STS_GRP =
        new SimpleProperty.String<SettlmtApplStsGrpStsAssgmt>(SettlmtApplStsGrpStsAssgmt.class, "SettlmtApplStsGrp");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplSts</b>
     * </p>
     * 
     * @return Application Status for a Settlement Management Document
     */
    @Nullable
    @ElementName( "SettlmtApplSts" )
    private java.lang.String settlmtApplSts;
    public final static SimpleProperty.String<SettlmtApplStsGrpStsAssgmt> SETTLMT_APPL_STS =
        new SimpleProperty.String<SettlmtApplStsGrpStsAssgmt>(SettlmtApplStsGrpStsAssgmt.class, "SettlmtApplSts");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsAprvd</b>
     * </p>
     * 
     * @return Application Status Approved
     */
    @Nullable
    @ElementName( "SettlmtApplStsAprvd" )
    private java.lang.String settlmtApplStsAprvd;
    public final static SimpleProperty.String<SettlmtApplStsGrpStsAssgmt> SETTLMT_APPL_STS_APRVD =
        new SimpleProperty.String<SettlmtApplStsGrpStsAssgmt>(SettlmtApplStsGrpStsAssgmt.class, "SettlmtApplStsAprvd");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsRjctd</b>
     * </p>
     * 
     * @return Application Status Rejected
     */
    @Nullable
    @ElementName( "SettlmtApplStsRjctd" )
    private java.lang.String settlmtApplStsRjctd;
    public final static SimpleProperty.String<SettlmtApplStsGrpStsAssgmt> SETTLMT_APPL_STS_RJCTD =
        new SimpleProperty.String<SettlmtApplStsGrpStsAssgmt>(SettlmtApplStsGrpStsAssgmt.class, "SettlmtApplStsRjctd");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ApplStsIsRlvtForRelProc</b>
     * </p>
     * 
     * @return Release Process Active for Application Status
     */
    @Nullable
    @ElementName( "ApplStsIsRlvtForRelProc" )
    private java.lang.Boolean applStsIsRlvtForRelProc;
    public final static SimpleProperty.Boolean<SettlmtApplStsGrpStsAssgmt> APPL_STS_IS_RLVT_FOR_REL_PROC =
        new SimpleProperty.Boolean<SettlmtApplStsGrpStsAssgmt>(
            SettlmtApplStsGrpStsAssgmt.class,
            "ApplStsIsRlvtForRelProc");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SettlmtApplStsGrpStsAssgmt> getType()
    {
        return SettlmtApplStsGrpStsAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsGrp</b>
     * </p>
     * 
     * @param settlmtApplStsGrp
     *            Status Group for Settlement Management Documents
     */
    public void setSettlmtApplStsGrp( @Nullable final java.lang.String settlmtApplStsGrp )
    {
        rememberChangedField("SettlmtApplStsGrp", this.settlmtApplStsGrp);
        this.settlmtApplStsGrp = settlmtApplStsGrp;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplSts</b>
     * </p>
     * 
     * @param settlmtApplSts
     *            Application Status for a Settlement Management Document
     */
    public void setSettlmtApplSts( @Nullable final java.lang.String settlmtApplSts )
    {
        rememberChangedField("SettlmtApplSts", this.settlmtApplSts);
        this.settlmtApplSts = settlmtApplSts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsAprvd</b>
     * </p>
     * 
     * @param settlmtApplStsAprvd
     *            Application Status Approved
     */
    public void setSettlmtApplStsAprvd( @Nullable final java.lang.String settlmtApplStsAprvd )
    {
        rememberChangedField("SettlmtApplStsAprvd", this.settlmtApplStsAprvd);
        this.settlmtApplStsAprvd = settlmtApplStsAprvd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtApplStsRjctd</b>
     * </p>
     * 
     * @param settlmtApplStsRjctd
     *            Application Status Rejected
     */
    public void setSettlmtApplStsRjctd( @Nullable final java.lang.String settlmtApplStsRjctd )
    {
        rememberChangedField("SettlmtApplStsRjctd", this.settlmtApplStsRjctd);
        this.settlmtApplStsRjctd = settlmtApplStsRjctd;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ApplStsIsRlvtForRelProc</b>
     * </p>
     * 
     * @param applStsIsRlvtForRelProc
     *            Release Process Active for Application Status
     */
    public void setApplStsIsRlvtForRelProc( @Nullable final java.lang.Boolean applStsIsRlvtForRelProc )
    {
        rememberChangedField("ApplStsIsRlvtForRelProc", this.applStsIsRlvtForRelProc);
        this.applStsIsRlvtForRelProc = applStsIsRlvtForRelProc;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SettlmtApplStsGrpStsAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtApplStsGrp", getSettlmtApplStsGrp());
        entityKey.addKeyProperty("SettlmtApplSts", getSettlmtApplSts());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtApplStsGrp", getSettlmtApplStsGrp());
        values.put("SettlmtApplSts", getSettlmtApplSts());
        values.put("SettlmtApplStsAprvd", getSettlmtApplStsAprvd());
        values.put("SettlmtApplStsRjctd", getSettlmtApplStsRjctd());
        values.put("ApplStsIsRlvtForRelProc", getApplStsIsRlvtForRelProc());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtApplStsGrp") ) {
                final Object value = values.remove("SettlmtApplStsGrp");
                if( (value == null) || (!value.equals(getSettlmtApplStsGrp())) ) {
                    setSettlmtApplStsGrp(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtApplSts") ) {
                final Object value = values.remove("SettlmtApplSts");
                if( (value == null) || (!value.equals(getSettlmtApplSts())) ) {
                    setSettlmtApplSts(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtApplStsAprvd") ) {
                final Object value = values.remove("SettlmtApplStsAprvd");
                if( (value == null) || (!value.equals(getSettlmtApplStsAprvd())) ) {
                    setSettlmtApplStsAprvd(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtApplStsRjctd") ) {
                final Object value = values.remove("SettlmtApplStsRjctd");
                if( (value == null) || (!value.equals(getSettlmtApplStsRjctd())) ) {
                    setSettlmtApplStsRjctd(((java.lang.String) value));
                }
            }
            if( values.containsKey("ApplStsIsRlvtForRelProc") ) {
                final Object value = values.remove("ApplStsIsRlvtForRelProc");
                if( (value == null) || (!value.equals(getApplStsIsRlvtForRelProc())) ) {
                    setApplStsIsRlvtForRelProc(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementProcessTypeService.DEFAULT_SERVICE_PATH;
    }

}
