/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementProcessTypeService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Settlement Document Type Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SettlmtDocProcTypeAssgmtType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SettlmtDocProcTypeAssgmt extends VdmEntity<SettlmtDocProcTypeAssgmt> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_proc_type.v0001.SettlmtDocProcTypeAssgmtType";
    /**
     * Selector for all available fields of SettlmtDocProcTypeAssgmt.
     * 
     */
    public final static SimpleProperty<SettlmtDocProcTypeAssgmt> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @return Settlement Process Type
     */
    @Nullable
    @ElementName( "SettlmtProcessType" )
    private java.lang.String settlmtProcessType;
    public final static SimpleProperty.String<SettlmtDocProcTypeAssgmt> SETTLMT_PROCESS_TYPE =
        new SimpleProperty.String<SettlmtDocProcTypeAssgmt>(SettlmtDocProcTypeAssgmt.class, "SettlmtProcessType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @return Settlement Document Type
     */
    @Nullable
    @ElementName( "SettlmtDocType" )
    private java.lang.String settlmtDocType;
    public final static SimpleProperty.String<SettlmtDocProcTypeAssgmt> SETTLMT_DOC_TYPE =
        new SimpleProperty.String<SettlmtDocProcTypeAssgmt>(SettlmtDocProcTypeAssgmt.class, "SettlmtDocType");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SettlmtDocProcTypeAssgmt> getType()
    {
        return SettlmtDocProcTypeAssgmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @param settlmtProcessType
     *            Settlement Process Type
     */
    public void setSettlmtProcessType( @Nullable final java.lang.String settlmtProcessType )
    {
        rememberChangedField("SettlmtProcessType", this.settlmtProcessType);
        this.settlmtProcessType = settlmtProcessType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     */
    public void setSettlmtDocType( @Nullable final java.lang.String settlmtDocType )
    {
        rememberChangedField("SettlmtDocType", this.settlmtDocType);
        this.settlmtDocType = settlmtDocType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SettlmtDocProcTypeAssgmt";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtProcessType", getSettlmtProcessType());
        entityKey.addKeyProperty("SettlmtDocType", getSettlmtDocType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtProcessType", getSettlmtProcessType());
        values.put("SettlmtDocType", getSettlmtDocType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtProcessType") ) {
                final Object value = values.remove("SettlmtProcessType");
                if( (value == null) || (!value.equals(getSettlmtProcessType())) ) {
                    setSettlmtProcessType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocType") ) {
                final Object value = values.remove("SettlmtDocType");
                if( (value == null) || (!value.equals(getSettlmtDocType())) ) {
                    setSettlmtDocType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementProcessTypeService.DEFAULT_SERVICE_PATH;
    }

}
