/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SettlementProcessTypeService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Settlement Process Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SettlmtProcessTypeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SettlmtProcessType extends VdmEntity<SettlmtProcessType> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_settlmt_proc_type.v0001.SettlmtProcessTypeType";
    /**
     * Selector for all available fields of SettlmtProcessType.
     * 
     */
    public final static SimpleProperty<SettlmtProcessType> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @return Settlement Process Type
     */
    @Nullable
    @ElementName( "SettlmtProcessType" )
    private java.lang.String settlmtProcessType;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_PROCESS_TYPE =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtProcessType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessCat</b>
     * </p>
     * 
     * @return Settlement Process Category
     */
    @Nullable
    @ElementName( "SettlmtProcessCat" )
    private java.lang.String settlmtProcessCat;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_PROCESS_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtProcessCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartnerCat</b>
     * </p>
     * 
     * @return Settlement Partner Category
     */
    @Nullable
    @ElementName( "SettlmtPartnerCat" )
    private java.lang.String settlmtPartnerCat;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_PARTNER_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtPartnerCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CrsCoSettlmtCat</b>
     * </p>
     * 
     * @return Cross-Company Settlement Category
     */
    @Nullable
    @ElementName( "CrsCoSettlmtCat" )
    private java.lang.String crsCoSettlmtCat;
    public final static SimpleProperty.String<SettlmtProcessType> CRS_CO_SETTLMT_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "CrsCoSettlmtCat");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtBusProcVar</b>
     * </p>
     * 
     * @return Settlement Management Process Category
     */
    @Nullable
    @ElementName( "SettlmtBusProcVar" )
    private java.lang.String settlmtBusProcVar;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_BUS_PROC_VAR =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtBusProcVar");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LogisticsDataEntryCat</b>
     * </p>
     * 
     * @return Entry Category for Logistics Data
     */
    @Nullable
    @ElementName( "LogisticsDataEntryCat" )
    private java.lang.String logisticsDataEntryCat;
    public final static SimpleProperty.String<SettlmtProcessType> LOGISTICS_DATA_ENTRY_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "LogisticsDataEntryCat");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtHasFullOrglData</b>
     * </p>
     * 
     * @return Enter Organizational Data for Settlement Partners Completely
     */
    @Nullable
    @ElementName( "SettlmtHasFullOrglData" )
    private java.lang.Boolean settlmtHasFullOrglData;
    public final static SimpleProperty.Boolean<SettlmtProcessType> SETTLMT_HAS_FULL_ORGL_DATA =
        new SimpleProperty.Boolean<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtHasFullOrglData");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtTxCodeDetnCat</b>
     * </p>
     * 
     * @return Tax Code Determination
     */
    @Nullable
    @ElementName( "SettlmtTxCodeDetnCat" )
    private java.lang.String settlmtTxCodeDetnCat;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_TX_CODE_DETN_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtTxCodeDetnCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtNoTxCodeErrHndlgCat</b>
     * </p>
     * 
     * @return Handling of Missing Tax Code
     */
    @Nullable
    @ElementName( "SettlmtNoTxCodeErrHndlgCat" )
    private java.lang.String settlmtNoTxCodeErrHndlgCat;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_NO_TX_CODE_ERR_HNDLG_CAT =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtNoTxCodeErrHndlgCat");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @return Settlement Document Type
     */
    @Nullable
    @ElementName( "SettlmtDocType" )
    private java.lang.String settlmtDocType;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_DOC_TYPE =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtDocType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCollectionCategory</b>
     * </p>
     * 
     * @return Collection Category for Settlement
     */
    @Nullable
    @ElementName( "SettlmtCollectionCategory" )
    private java.lang.String settlmtCollectionCategory;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_COLLECTION_CATEGORY =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtCollectionCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcTypeOfCollection</b>
     * </p>
     * 
     * @return Settlement Process Type for Collective Settlement
     */
    @Nullable
    @ElementName( "SettlmtProcTypeOfCollection" )
    private java.lang.String settlmtProcTypeOfCollection;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_PROC_TYPE_OF_COLLECTION =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtProcTypeOfCollection");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
     * </p>
     * 
     * @return Settlement Doc. Type for Collective Settlement
     */
    @Nullable
    @ElementName( "SettlmtDocTypeOfCollection" )
    private java.lang.String settlmtDocTypeOfCollection;
    public final static SimpleProperty.String<SettlmtProcessType> SETTLMT_DOC_TYPE_OF_COLLECTION =
        new SimpleProperty.String<SettlmtProcessType>(SettlmtProcessType.class, "SettlmtDocTypeOfCollection");
    /**
     * Navigation property <b>_SettlmtApplStsGrpStsAssgmt</b> for <b>SettlmtProcessType</b> to multiple
     * <b>SettlmtApplStsGrpStsAssgmt</b>.
     * 
     */
    @ElementName( "_SettlmtApplStsGrpStsAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SettlmtApplStsGrpStsAssgmt> to_SettlmtApplStsGrpStsAssgmt;
    /**
     * Navigation property <b>_SettlmtDocProcTypeAssgmt</b> for <b>SettlmtProcessType</b> to multiple
     * <b>SettlmtDocProcTypeAssgmt</b>.
     * 
     */
    @ElementName( "_SettlmtDocProcTypeAssgmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SettlmtDocProcTypeAssgmt> to_SettlmtDocProcTypeAssgmt;
    /**
     * Navigation property <b>_SettlmtDocType</b> for <b>SettlmtProcessType</b> to single <b>SettlmtDocType</b>.
     * 
     */
    @ElementName( "_SettlmtDocType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SettlmtDocType to_SettlmtDocType;
    /**
     * Navigation property <b>_SettlmtDocTypeOfCollection</b> for <b>SettlmtProcessType</b> to single
     * <b>SettlmtDocType</b>.
     * 
     */
    @ElementName( "_SettlmtDocTypeOfCollection" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SettlmtDocType to_SettlmtDocTypeOfCollection;
    /**
     * Navigation property <b>_SettlmtProcTypeOfCollection</b> for <b>SettlmtProcessType</b> to single
     * <b>SettlmtProcessType</b>.
     * 
     */
    @ElementName( "_SettlmtProcTypeOfCollection" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SettlmtProcessType to_SettlmtProcTypeOfCollection;
    /**
     * Use with available request builders to apply the <b>_SettlmtApplStsGrpStsAssgmt</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtProcessType, SettlmtApplStsGrpStsAssgmt> TO__SETTLMT_APPL_STS_GRP_STS_ASSGMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtProcessType, SettlmtApplStsGrpStsAssgmt>(
            SettlmtProcessType.class,
            "_SettlmtApplStsGrpStsAssgmt",
            SettlmtApplStsGrpStsAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocProcTypeAssgmt</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtProcessType, SettlmtDocProcTypeAssgmt> TO__SETTLMT_DOC_PROC_TYPE_ASSGMT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SettlmtProcessType, SettlmtDocProcTypeAssgmt>(
            SettlmtProcessType.class,
            "_SettlmtDocProcTypeAssgmt",
            SettlmtDocProcTypeAssgmt.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocType</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtDocType> TO__SETTLMT_DOC_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtDocType>(
            SettlmtProcessType.class,
            "_SettlmtDocType",
            SettlmtDocType.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtDocTypeOfCollection</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtDocType> TO__SETTLMT_DOC_TYPE_OF_COLLECTION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtDocType>(
            SettlmtProcessType.class,
            "_SettlmtDocTypeOfCollection",
            SettlmtDocType.class);
    /**
     * Use with available request builders to apply the <b>_SettlmtProcTypeOfCollection</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtProcessType> TO__SETTLMT_PROC_TYPE_OF_COLLECTION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SettlmtProcessType, SettlmtProcessType>(
            SettlmtProcessType.class,
            "_SettlmtProcTypeOfCollection",
            SettlmtProcessType.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SettlmtProcessType> getType()
    {
        return SettlmtProcessType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessType</b>
     * </p>
     * 
     * @param settlmtProcessType
     *            Settlement Process Type
     */
    public void setSettlmtProcessType( @Nullable final java.lang.String settlmtProcessType )
    {
        rememberChangedField("SettlmtProcessType", this.settlmtProcessType);
        this.settlmtProcessType = settlmtProcessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcessCat</b>
     * </p>
     * 
     * @param settlmtProcessCat
     *            Settlement Process Category
     */
    public void setSettlmtProcessCat( @Nullable final java.lang.String settlmtProcessCat )
    {
        rememberChangedField("SettlmtProcessCat", this.settlmtProcessCat);
        this.settlmtProcessCat = settlmtProcessCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtPartnerCat</b>
     * </p>
     * 
     * @param settlmtPartnerCat
     *            Settlement Partner Category
     */
    public void setSettlmtPartnerCat( @Nullable final java.lang.String settlmtPartnerCat )
    {
        rememberChangedField("SettlmtPartnerCat", this.settlmtPartnerCat);
        this.settlmtPartnerCat = settlmtPartnerCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CrsCoSettlmtCat</b>
     * </p>
     * 
     * @param crsCoSettlmtCat
     *            Cross-Company Settlement Category
     */
    public void setCrsCoSettlmtCat( @Nullable final java.lang.String crsCoSettlmtCat )
    {
        rememberChangedField("CrsCoSettlmtCat", this.crsCoSettlmtCat);
        this.crsCoSettlmtCat = crsCoSettlmtCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtBusProcVar</b>
     * </p>
     * 
     * @param settlmtBusProcVar
     *            Settlement Management Process Category
     */
    public void setSettlmtBusProcVar( @Nullable final java.lang.String settlmtBusProcVar )
    {
        rememberChangedField("SettlmtBusProcVar", this.settlmtBusProcVar);
        this.settlmtBusProcVar = settlmtBusProcVar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LogisticsDataEntryCat</b>
     * </p>
     * 
     * @param logisticsDataEntryCat
     *            Entry Category for Logistics Data
     */
    public void setLogisticsDataEntryCat( @Nullable final java.lang.String logisticsDataEntryCat )
    {
        rememberChangedField("LogisticsDataEntryCat", this.logisticsDataEntryCat);
        this.logisticsDataEntryCat = logisticsDataEntryCat;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtHasFullOrglData</b>
     * </p>
     * 
     * @param settlmtHasFullOrglData
     *            Enter Organizational Data for Settlement Partners Completely
     */
    public void setSettlmtHasFullOrglData( @Nullable final java.lang.Boolean settlmtHasFullOrglData )
    {
        rememberChangedField("SettlmtHasFullOrglData", this.settlmtHasFullOrglData);
        this.settlmtHasFullOrglData = settlmtHasFullOrglData;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtTxCodeDetnCat</b>
     * </p>
     * 
     * @param settlmtTxCodeDetnCat
     *            Tax Code Determination
     */
    public void setSettlmtTxCodeDetnCat( @Nullable final java.lang.String settlmtTxCodeDetnCat )
    {
        rememberChangedField("SettlmtTxCodeDetnCat", this.settlmtTxCodeDetnCat);
        this.settlmtTxCodeDetnCat = settlmtTxCodeDetnCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtNoTxCodeErrHndlgCat</b>
     * </p>
     * 
     * @param settlmtNoTxCodeErrHndlgCat
     *            Handling of Missing Tax Code
     */
    public void setSettlmtNoTxCodeErrHndlgCat( @Nullable final java.lang.String settlmtNoTxCodeErrHndlgCat )
    {
        rememberChangedField("SettlmtNoTxCodeErrHndlgCat", this.settlmtNoTxCodeErrHndlgCat);
        this.settlmtNoTxCodeErrHndlgCat = settlmtNoTxCodeErrHndlgCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocType</b>
     * </p>
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     */
    public void setSettlmtDocType( @Nullable final java.lang.String settlmtDocType )
    {
        rememberChangedField("SettlmtDocType", this.settlmtDocType);
        this.settlmtDocType = settlmtDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtCollectionCategory</b>
     * </p>
     * 
     * @param settlmtCollectionCategory
     *            Collection Category for Settlement
     */
    public void setSettlmtCollectionCategory( @Nullable final java.lang.String settlmtCollectionCategory )
    {
        rememberChangedField("SettlmtCollectionCategory", this.settlmtCollectionCategory);
        this.settlmtCollectionCategory = settlmtCollectionCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtProcTypeOfCollection</b>
     * </p>
     * 
     * @param settlmtProcTypeOfCollection
     *            Settlement Process Type for Collective Settlement
     */
    public void setSettlmtProcTypeOfCollection( @Nullable final java.lang.String settlmtProcTypeOfCollection )
    {
        rememberChangedField("SettlmtProcTypeOfCollection", this.settlmtProcTypeOfCollection);
        this.settlmtProcTypeOfCollection = settlmtProcTypeOfCollection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
     * </p>
     * 
     * @param settlmtDocTypeOfCollection
     *            Settlement Doc. Type for Collective Settlement
     */
    public void setSettlmtDocTypeOfCollection( @Nullable final java.lang.String settlmtDocTypeOfCollection )
    {
        rememberChangedField("SettlmtDocTypeOfCollection", this.settlmtDocTypeOfCollection);
        this.settlmtDocTypeOfCollection = settlmtDocTypeOfCollection;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SettlmtProcessType";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SettlmtProcessType", getSettlmtProcessType());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SettlmtProcessType", getSettlmtProcessType());
        values.put("SettlmtProcessCat", getSettlmtProcessCat());
        values.put("SettlmtPartnerCat", getSettlmtPartnerCat());
        values.put("CrsCoSettlmtCat", getCrsCoSettlmtCat());
        values.put("SettlmtBusProcVar", getSettlmtBusProcVar());
        values.put("LogisticsDataEntryCat", getLogisticsDataEntryCat());
        values.put("SettlmtHasFullOrglData", getSettlmtHasFullOrglData());
        values.put("SettlmtTxCodeDetnCat", getSettlmtTxCodeDetnCat());
        values.put("SettlmtNoTxCodeErrHndlgCat", getSettlmtNoTxCodeErrHndlgCat());
        values.put("SettlmtDocType", getSettlmtDocType());
        values.put("SettlmtCollectionCategory", getSettlmtCollectionCategory());
        values.put("SettlmtProcTypeOfCollection", getSettlmtProcTypeOfCollection());
        values.put("SettlmtDocTypeOfCollection", getSettlmtDocTypeOfCollection());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SettlmtProcessType") ) {
                final Object value = values.remove("SettlmtProcessType");
                if( (value == null) || (!value.equals(getSettlmtProcessType())) ) {
                    setSettlmtProcessType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtProcessCat") ) {
                final Object value = values.remove("SettlmtProcessCat");
                if( (value == null) || (!value.equals(getSettlmtProcessCat())) ) {
                    setSettlmtProcessCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtPartnerCat") ) {
                final Object value = values.remove("SettlmtPartnerCat");
                if( (value == null) || (!value.equals(getSettlmtPartnerCat())) ) {
                    setSettlmtPartnerCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("CrsCoSettlmtCat") ) {
                final Object value = values.remove("CrsCoSettlmtCat");
                if( (value == null) || (!value.equals(getCrsCoSettlmtCat())) ) {
                    setCrsCoSettlmtCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtBusProcVar") ) {
                final Object value = values.remove("SettlmtBusProcVar");
                if( (value == null) || (!value.equals(getSettlmtBusProcVar())) ) {
                    setSettlmtBusProcVar(((java.lang.String) value));
                }
            }
            if( values.containsKey("LogisticsDataEntryCat") ) {
                final Object value = values.remove("LogisticsDataEntryCat");
                if( (value == null) || (!value.equals(getLogisticsDataEntryCat())) ) {
                    setLogisticsDataEntryCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtHasFullOrglData") ) {
                final Object value = values.remove("SettlmtHasFullOrglData");
                if( (value == null) || (!value.equals(getSettlmtHasFullOrglData())) ) {
                    setSettlmtHasFullOrglData(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SettlmtTxCodeDetnCat") ) {
                final Object value = values.remove("SettlmtTxCodeDetnCat");
                if( (value == null) || (!value.equals(getSettlmtTxCodeDetnCat())) ) {
                    setSettlmtTxCodeDetnCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtNoTxCodeErrHndlgCat") ) {
                final Object value = values.remove("SettlmtNoTxCodeErrHndlgCat");
                if( (value == null) || (!value.equals(getSettlmtNoTxCodeErrHndlgCat())) ) {
                    setSettlmtNoTxCodeErrHndlgCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocType") ) {
                final Object value = values.remove("SettlmtDocType");
                if( (value == null) || (!value.equals(getSettlmtDocType())) ) {
                    setSettlmtDocType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtCollectionCategory") ) {
                final Object value = values.remove("SettlmtCollectionCategory");
                if( (value == null) || (!value.equals(getSettlmtCollectionCategory())) ) {
                    setSettlmtCollectionCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtProcTypeOfCollection") ) {
                final Object value = values.remove("SettlmtProcTypeOfCollection");
                if( (value == null) || (!value.equals(getSettlmtProcTypeOfCollection())) ) {
                    setSettlmtProcTypeOfCollection(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDocTypeOfCollection") ) {
                final Object value = values.remove("SettlmtDocTypeOfCollection");
                if( (value == null) || (!value.equals(getSettlmtDocTypeOfCollection())) ) {
                    setSettlmtDocTypeOfCollection(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SettlmtApplStsGrpStsAssgmt") ) {
                final Object value = (values).remove("_SettlmtApplStsGrpStsAssgmt");
                if( value instanceof Iterable ) {
                    if( to_SettlmtApplStsGrpStsAssgmt == null ) {
                        to_SettlmtApplStsGrpStsAssgmt = Lists.newArrayList();
                    } else {
                        to_SettlmtApplStsGrpStsAssgmt = Lists.newArrayList(to_SettlmtApplStsGrpStsAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SettlmtApplStsGrpStsAssgmt entity;
                        if( to_SettlmtApplStsGrpStsAssgmt.size() > i ) {
                            entity = to_SettlmtApplStsGrpStsAssgmt.get(i);
                        } else {
                            entity = new SettlmtApplStsGrpStsAssgmt();
                            to_SettlmtApplStsGrpStsAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SettlmtDocProcTypeAssgmt") ) {
                final Object value = (values).remove("_SettlmtDocProcTypeAssgmt");
                if( value instanceof Iterable ) {
                    if( to_SettlmtDocProcTypeAssgmt == null ) {
                        to_SettlmtDocProcTypeAssgmt = Lists.newArrayList();
                    } else {
                        to_SettlmtDocProcTypeAssgmt = Lists.newArrayList(to_SettlmtDocProcTypeAssgmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SettlmtDocProcTypeAssgmt entity;
                        if( to_SettlmtDocProcTypeAssgmt.size() > i ) {
                            entity = to_SettlmtDocProcTypeAssgmt.get(i);
                        } else {
                            entity = new SettlmtDocProcTypeAssgmt();
                            to_SettlmtDocProcTypeAssgmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SettlmtDocType") ) {
                final Object value = (values).remove("_SettlmtDocType");
                if( value instanceof Map ) {
                    if( to_SettlmtDocType == null ) {
                        to_SettlmtDocType = new SettlmtDocType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDocType.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_SettlmtDocTypeOfCollection") ) {
                final Object value = (values).remove("_SettlmtDocTypeOfCollection");
                if( value instanceof Map ) {
                    if( to_SettlmtDocTypeOfCollection == null ) {
                        to_SettlmtDocTypeOfCollection = new SettlmtDocType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtDocTypeOfCollection.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_SettlmtProcTypeOfCollection") ) {
                final Object value = (values).remove("_SettlmtProcTypeOfCollection");
                if( value instanceof Map ) {
                    if( to_SettlmtProcTypeOfCollection == null ) {
                        to_SettlmtProcTypeOfCollection = new SettlmtProcessType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SettlmtProcTypeOfCollection.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SettlementProcessTypeService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SettlmtApplStsGrpStsAssgmt != null ) {
            (values).put("_SettlmtApplStsGrpStsAssgmt", to_SettlmtApplStsGrpStsAssgmt);
        }
        if( to_SettlmtDocProcTypeAssgmt != null ) {
            (values).put("_SettlmtDocProcTypeAssgmt", to_SettlmtDocProcTypeAssgmt);
        }
        if( to_SettlmtDocType != null ) {
            (values).put("_SettlmtDocType", to_SettlmtDocType);
        }
        if( to_SettlmtDocTypeOfCollection != null ) {
            (values).put("_SettlmtDocTypeOfCollection", to_SettlmtDocTypeOfCollection);
        }
        if( to_SettlmtProcTypeOfCollection != null ) {
            (values).put("_SettlmtProcTypeOfCollection", to_SettlmtProcTypeOfCollection);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SettlmtApplStsGrpStsAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SettlmtApplStsGrpStsAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtProcessType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtApplStsGrpStsAssgmt</b> is already loaded, the
     *         result will contain the <b>SettlmtApplStsGrpStsAssgmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SettlmtApplStsGrpStsAssgmt>> getSettlmtApplStsGrpStsAssgmtIfPresent()
    {
        return Option.of(to_SettlmtApplStsGrpStsAssgmt);
    }

    /**
     * Overwrites the list of associated <b>SettlmtApplStsGrpStsAssgmt</b> entities for the loaded navigation property
     * <b>_SettlmtApplStsGrpStsAssgmt</b>.
     * <p>
     * If the navigation property <b>_SettlmtApplStsGrpStsAssgmt</b> of a queried <b>SettlmtProcessType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SettlmtApplStsGrpStsAssgmt</b> entities.
     */
    public void setSettlmtApplStsGrpStsAssgmt( @Nonnull final List<SettlmtApplStsGrpStsAssgmt> value )
    {
        if( to_SettlmtApplStsGrpStsAssgmt == null ) {
            to_SettlmtApplStsGrpStsAssgmt = Lists.newArrayList();
        }
        to_SettlmtApplStsGrpStsAssgmt.clear();
        to_SettlmtApplStsGrpStsAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SettlmtApplStsGrpStsAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>_SettlmtApplStsGrpStsAssgmt</b>.
     * <p>
     * If the navigation property <b>_SettlmtApplStsGrpStsAssgmt</b> of a queried <b>SettlmtProcessType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SettlmtApplStsGrpStsAssgmt</b> entities.
     */
    public void addSettlmtApplStsGrpStsAssgmt( SettlmtApplStsGrpStsAssgmt... entity )
    {
        if( to_SettlmtApplStsGrpStsAssgmt == null ) {
            to_SettlmtApplStsGrpStsAssgmt = Lists.newArrayList();
        }
        to_SettlmtApplStsGrpStsAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SettlmtDocProcTypeAssgmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SettlmtDocProcTypeAssgmt</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtProcessType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocProcTypeAssgmt</b> is already loaded, the result
     *         will contain the <b>SettlmtDocProcTypeAssgmt</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SettlmtDocProcTypeAssgmt>> getSettlmtDocProcTypeAssgmtIfPresent()
    {
        return Option.of(to_SettlmtDocProcTypeAssgmt);
    }

    /**
     * Overwrites the list of associated <b>SettlmtDocProcTypeAssgmt</b> entities for the loaded navigation property
     * <b>_SettlmtDocProcTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SettlmtDocProcTypeAssgmt</b> of a queried <b>SettlmtProcessType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SettlmtDocProcTypeAssgmt</b> entities.
     */
    public void setSettlmtDocProcTypeAssgmt( @Nonnull final List<SettlmtDocProcTypeAssgmt> value )
    {
        if( to_SettlmtDocProcTypeAssgmt == null ) {
            to_SettlmtDocProcTypeAssgmt = Lists.newArrayList();
        }
        to_SettlmtDocProcTypeAssgmt.clear();
        to_SettlmtDocProcTypeAssgmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SettlmtDocProcTypeAssgmt</b> entities. This corresponds to the OData
     * navigation property <b>_SettlmtDocProcTypeAssgmt</b>.
     * <p>
     * If the navigation property <b>_SettlmtDocProcTypeAssgmt</b> of a queried <b>SettlmtProcessType</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SettlmtDocProcTypeAssgmt</b> entities.
     */
    public void addSettlmtDocProcTypeAssgmt( SettlmtDocProcTypeAssgmt... entity )
    {
        if( to_SettlmtDocProcTypeAssgmt == null ) {
            to_SettlmtDocProcTypeAssgmt = Lists.newArrayList();
        }
        to_SettlmtDocProcTypeAssgmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SettlmtDocType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SettlmtDocType</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtProcessType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocType</b> is already loaded, the result will
     *         contain the <b>SettlmtDocType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SettlmtDocType> getSettlmtDocTypeIfPresent()
    {
        return Option.of(to_SettlmtDocType);
    }

    /**
     * Overwrites the associated <b>SettlmtDocType</b> entity for the loaded navigation property <b>_SettlmtDocType</b>.
     * 
     * @param value
     *            New <b>SettlmtDocType</b> entity.
     */
    public void setSettlmtDocType( final SettlmtDocType value )
    {
        to_SettlmtDocType = value;
    }

    /**
     * Retrieval of associated <b>SettlmtDocType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SettlmtDocTypeOfCollection</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtProcessType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtDocTypeOfCollection</b> is already loaded, the
     *         result will contain the <b>SettlmtDocType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SettlmtDocType> getSettlmtDocTypeOfCollectionIfPresent()
    {
        return Option.of(to_SettlmtDocTypeOfCollection);
    }

    /**
     * Overwrites the associated <b>SettlmtDocType</b> entity for the loaded navigation property
     * <b>_SettlmtDocTypeOfCollection</b>.
     * 
     * @param value
     *            New <b>SettlmtDocType</b> entity.
     */
    public void setSettlmtDocTypeOfCollection( final SettlmtDocType value )
    {
        to_SettlmtDocTypeOfCollection = value;
    }

    /**
     * Retrieval of associated <b>SettlmtProcessType</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SettlmtProcTypeOfCollection</b>.
     * <p>
     * If the navigation property for an entity <b>SettlmtProcessType</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SettlmtProcTypeOfCollection</b> is already loaded, the
     *         result will contain the <b>SettlmtProcessType</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SettlmtProcessType> getSettlmtProcTypeOfCollectionIfPresent()
    {
        return Option.of(to_SettlmtProcTypeOfCollection);
    }

    /**
     * Overwrites the associated <b>SettlmtProcessType</b> entity for the loaded navigation property
     * <b>_SettlmtProcTypeOfCollection</b>.
     * 
     * @param value
     *            New <b>SettlmtProcessType</b> entity.
     */
    public void setSettlmtProcTypeOfCollection( final SettlmtProcessType value )
    {
        to_SettlmtProcTypeOfCollection = value;
    }

    /**
     * Helper class to allow for fluent creation of SettlmtProcessType instances.
     * 
     */
    public final static class SettlmtProcessTypeBuilder
    {

        private List<SettlmtApplStsGrpStsAssgmt> to_SettlmtApplStsGrpStsAssgmt = Lists.newArrayList();
        private List<SettlmtDocProcTypeAssgmt> to_SettlmtDocProcTypeAssgmt = Lists.newArrayList();
        private SettlmtDocType to_SettlmtDocType;
        private java.lang.String settlmtDocType = null;
        private SettlmtDocType to_SettlmtDocTypeOfCollection;
        private java.lang.String settlmtDocTypeOfCollection = null;
        private SettlmtProcessType to_SettlmtProcTypeOfCollection;
        private java.lang.String settlmtProcTypeOfCollection = null;

        private SettlmtProcessType.SettlmtProcessTypeBuilder to_SettlmtApplStsGrpStsAssgmt(
            final List<SettlmtApplStsGrpStsAssgmt> value )
        {
            to_SettlmtApplStsGrpStsAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SettlmtApplStsGrpStsAssgmt</b> for <b>SettlmtProcessType</b> to multiple
         * <b>SettlmtApplStsGrpStsAssgmt</b>.
         * 
         * @param value
         *            The SettlmtApplStsGrpStsAssgmts to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtApplStsGrpStsAssgmt(
            SettlmtApplStsGrpStsAssgmt... value )
        {
            return to_SettlmtApplStsGrpStsAssgmt(Lists.newArrayList(value));
        }

        private SettlmtProcessType.SettlmtProcessTypeBuilder to_SettlmtDocProcTypeAssgmt(
            final List<SettlmtDocProcTypeAssgmt> value )
        {
            to_SettlmtDocProcTypeAssgmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocProcTypeAssgmt</b> for <b>SettlmtProcessType</b> to multiple
         * <b>SettlmtDocProcTypeAssgmt</b>.
         * 
         * @param value
         *            The SettlmtDocProcTypeAssgmts to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtDocProcTypeAssgmt(
            SettlmtDocProcTypeAssgmt... value )
        {
            return to_SettlmtDocProcTypeAssgmt(Lists.newArrayList(value));
        }

        private SettlmtProcessType.SettlmtProcessTypeBuilder to_SettlmtDocType( final SettlmtDocType value )
        {
            to_SettlmtDocType = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocType</b> for <b>SettlmtProcessType</b> to single <b>SettlmtDocType</b>.
         * 
         * @param value
         *            The SettlmtDocType to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtDocType( final SettlmtDocType value )
        {
            return to_SettlmtDocType(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDocType</b>
         * </p>
         * 
         * @param value
         *            The settlmtDocType to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtDocType( final java.lang.String value )
        {
            settlmtDocType = value;
            return this;
        }

        private SettlmtProcessType.SettlmtProcessTypeBuilder to_SettlmtDocTypeOfCollection( final SettlmtDocType value )
        {
            to_SettlmtDocTypeOfCollection = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtDocTypeOfCollection</b> for <b>SettlmtProcessType</b> to single
         * <b>SettlmtDocType</b>.
         * 
         * @param value
         *            The SettlmtDocType to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtDocTypeOfCollection( final SettlmtDocType value )
        {
            return to_SettlmtDocTypeOfCollection(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtDocTypeOfCollection</b>
         * </p>
         * 
         * @param value
         *            The settlmtDocTypeOfCollection to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtDocTypeOfCollection( final java.lang.String value )
        {
            settlmtDocTypeOfCollection = value;
            return this;
        }

        private SettlmtProcessType.SettlmtProcessTypeBuilder to_SettlmtProcTypeOfCollection(
            final SettlmtProcessType value )
        {
            to_SettlmtProcTypeOfCollection = value;
            return this;
        }

        /**
         * Navigation property <b>_SettlmtProcTypeOfCollection</b> for <b>SettlmtProcessType</b> to single
         * <b>SettlmtProcessType</b>.
         * 
         * @param value
         *            The SettlmtProcessType to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtProcTypeOfCollection(
            final SettlmtProcessType value )
        {
            return to_SettlmtProcTypeOfCollection(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 4
         * <p>
         * Original property name from the Odata EDM: <b>SettlmtProcTypeOfCollection</b>
         * </p>
         * 
         * @param value
         *            The settlmtProcTypeOfCollection to build this SettlmtProcessType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SettlmtProcessType.SettlmtProcessTypeBuilder settlmtProcTypeOfCollection( final java.lang.String value )
        {
            settlmtProcTypeOfCollection = value;
            return this;
        }

    }

}
