/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplieritem;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplierItemService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Supplier Item Details
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SupplierItemType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SupplierItem extends VdmEntity<SupplierItem> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_supplieritem.v0001.SupplierItemType";
    /**
     * Selector for all available fields of SupplierItem.
     * 
     */
    public final static SimpleProperty<SupplierItem> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemUUID</b>
     * </p>
     * 
     * @return Supplier Item UUID
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemUUID" )
    private UUID fldLogsSuplrItemUUID;
    public final static SimpleProperty.Guid<SupplierItem> FLD_LOGS_SUPLR_ITEM_UUID =
        new SimpleProperty.Guid<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemType</b>
     * </p>
     * 
     * @return Supplier Item Type
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemType" )
    private java.lang.String fldLogsSuplrItemType;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_TYPE =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmPackggTypeCode</b>
     * </p>
     * 
     * @return Supplier Item Packaging Type
     */
    @Nullable
    @ElementName( "FldLogsSuplrItmPackggTypeCode" )
    private java.lang.String fldLogsSuplrItmPackggTypeCode;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITM_PACKGG_TYPE_CODE =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItmPackggTypeCode");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrParentItemUUID</b>
     * </p>
     * 
     * @return Supplier Item UUID
     */
    @Nullable
    @ElementName( "FldLogsSuplrParentItemUUID" )
    private UUID fldLogsSuplrParentItemUUID;
    public final static SimpleProperty.Guid<SupplierItem> FLD_LOGS_SUPLR_PARENT_ITEM_UUID =
        new SimpleProperty.Guid<SupplierItem>(SupplierItem.class, "FldLogsSuplrParentItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemSerialNumber</b>
     * </p>
     * 
     * @return Manufacturer&apos;s Serial Number
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemSerialNumber" )
    private java.lang.String fldLogsSuplrItemSerialNumber;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_SERIAL_NUMBER =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemSerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemName</b>
     * </p>
     * 
     * @return Supplier Item Name
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemName" )
    private java.lang.String fldLogsSuplrItemName;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_NAME =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PreferredSupplier</b>
     * </p>
     * 
     * @return Account Number of Supplier
     */
    @Nullable
    @ElementName( "PreferredSupplier" )
    private java.lang.String preferredSupplier;
    public final static SimpleProperty.String<SupplierItem> PREFERRED_SUPPLIER =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "PreferredSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrBasePlant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "FldLogsSuplrBasePlant" )
    private java.lang.String fldLogsSuplrBasePlant;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_BASE_PLANT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrBasePlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsRemotePlant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "FldLogsRemotePlant" )
    private java.lang.String fldLogsRemotePlant;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_REMOTE_PLANT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsRemotePlant");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmPOItmUniqueID</b>
     * </p>
     * 
     * @return Purchase Order Item Unique ID
     */
    @Nullable
    @ElementName( "FldLogsSuplrItmPOItmUniqueID" )
    private java.lang.String fldLogsSuplrItmPOItmUniqueID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITM_PO_ITM_UNIQUE_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItmPOItmUniqueID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemVislInspCode</b>
     * </p>
     * 
     * @return Supplier Item Visual Inspection Code
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemVislInspCode" )
    private java.lang.String fldLogsSuplrItemVislInspCode;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_VISL_INSP_CODE =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemVislInspCode");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNetPriceAmount</b>
     * </p>
     * 
     * @return The purgDocNetPriceAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "PurgDocNetPriceAmount" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal purgDocNetPriceAmount;
    public final static SimpleProperty.NumericDecimal<SupplierItem> PURG_DOC_NET_PRICE_AMOUNT =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "PurgDocNetPriceAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemRateUnit</b>
     * </p>
     * 
     * @return Currency Key
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemRateUnit" )
    private java.lang.String fldLogsSuplrItemRateUnit;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_RATE_UNIT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemRateUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemQuantity</b>
     * </p>
     * 
     * @return The fldLogsSuplrItemQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal fldLogsSuplrItemQuantity;
    public final static SimpleProperty.NumericDecimal<SupplierItem> FLD_LOGS_SUPLR_ITEM_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemQuantityUnit</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemQuantityUnit" )
    private java.lang.String fldLogsSuplrItemQuantityUnit;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_QUANTITY_UNIT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemGrossVolume</b>
     * </p>
     * 
     * @return The fldLogsSuplrItemGrossVolume contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemGrossVolume" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal fldLogsSuplrItemGrossVolume;
    public final static SimpleProperty.NumericDecimal<SupplierItem> FLD_LOGS_SUPLR_ITEM_GROSS_VOLUME =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemGrossVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmGrossVolumeUnit</b>
     * </p>
     * 
     * @return Volume Unit
     */
    @Nullable
    @ElementName( "FldLogsSuplrItmGrossVolumeUnit" )
    private java.lang.String fldLogsSuplrItmGrossVolumeUnit;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITM_GROSS_VOLUME_UNIT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItmGrossVolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductGrossWeight</b>
     * </p>
     * 
     * @return The productGrossWeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ProductGrossWeight" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal productGrossWeight;
    public final static SimpleProperty.NumericDecimal<SupplierItem> PRODUCT_GROSS_WEIGHT =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "ProductGrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductWeightUnit</b>
     * </p>
     * 
     * @return Unit of Weight
     */
    @Nullable
    @ElementName( "ProductWeightUnit" )
    private java.lang.String productWeightUnit;
    public final static SimpleProperty.String<SupplierItem> PRODUCT_WEIGHT_UNIT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "ProductWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemLength</b>
     * </p>
     * 
     * @return The fldLogsSuplrItemLength contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemLength" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal fldLogsSuplrItemLength;
    public final static SimpleProperty.NumericDecimal<SupplierItem> FLD_LOGS_SUPLR_ITEM_LENGTH =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemLength");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemWidth</b>
     * </p>
     * 
     * @return The fldLogsSuplrItemWidth contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemWidth" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal fldLogsSuplrItemWidth;
    public final static SimpleProperty.NumericDecimal<SupplierItem> FLD_LOGS_SUPLR_ITEM_WIDTH =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemWidth");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemHeight</b>
     * </p>
     * 
     * @return The fldLogsSuplrItemHeight contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemHeight" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal fldLogsSuplrItemHeight;
    public final static SimpleProperty.NumericDecimal<SupplierItem> FLD_LOGS_SUPLR_ITEM_HEIGHT =
        new SimpleProperty.NumericDecimal<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemHeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemMeasureUnit</b>
     * </p>
     * 
     * @return Unit of Dimension for Length/Width/Height
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemMeasureUnit" )
    private java.lang.String fldLogsSuplrItemMeasureUnit;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_MEASURE_UNIT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemMeasureUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemStatusID</b>
     * </p>
     * 
     * @return Supplier Item Status ID
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemStatusID" )
    private java.lang.String fldLogsSuplrItemStatusID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITEM_STATUS_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemStatusID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsDangerousGood</b>
     * </p>
     * 
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @Nullable
    @ElementName( "ItemIsDangerousGood" )
    private java.lang.Boolean itemIsDangerousGood;
    public final static SimpleProperty.Boolean<SupplierItem> ITEM_IS_DANGEROUS_GOOD =
        new SimpleProperty.Boolean<SupplierItem>(SupplierItem.class, "ItemIsDangerousGood");
    /**
     * Constraints: Not nullable, Maximum length: 51
     * <p>
     * Original property name from the Odata EDM: <b>DangerousGoodsIdnNumberCnctntd</b>
     * </p>
     * 
     * @return Supplier Item DG ID Number Concatenated
     */
    @Nullable
    @ElementName( "DangerousGoodsIdnNumberCnctntd" )
    private java.lang.String dangerousGoodsIdnNumberCnctntd;
    public final static SimpleProperty.String<SupplierItem> DANGEROUS_GOODS_IDN_NUMBER_CNCTNTD =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "DangerousGoodsIdnNumberCnctntd");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsIsWorkOrderOnHold</b>
     * </p>
     * 
     * @return Work Order On Hold Indicator
     */
    @Nullable
    @ElementName( "FldLogsIsWorkOrderOnHold" )
    private java.lang.Boolean fldLogsIsWorkOrderOnHold;
    public final static SimpleProperty.Boolean<SupplierItem> FLD_LOGS_IS_WORK_ORDER_ON_HOLD =
        new SimpleProperty.Boolean<SupplierItem>(SupplierItem.class, "FldLogsIsWorkOrderOnHold");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     * 
     * @return Order Number
     */
    @Nullable
    @ElementName( "MaintenanceOrder" )
    private java.lang.String maintenanceOrder;
    public final static SimpleProperty.String<SupplierItem> MAINTENANCE_ORDER =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "MaintenanceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     * 
     * @return External Project ID
     */
    @Nullable
    @ElementName( "Project" )
    private java.lang.String project;
    public final static SimpleProperty.String<SupplierItem> PROJECT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "Project");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemand</b>
     * </p>
     * 
     * @return Project Demand ID
     */
    @Nullable
    @ElementName( "ProjectDemand" )
    private java.lang.String projectDemand;
    public final static SimpleProperty.String<SupplierItem> PROJECT_DEMAND =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "ProjectDemand");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     * 
     * @return Purchase Requisition Number
     */
    @Nullable
    @ElementName( "PurchaseRequisition" )
    private java.lang.String purchaseRequisition;
    public final static SimpleProperty.String<SupplierItem> PURCHASE_REQUISITION =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @return Purchasing Document Number
     */
    @Nullable
    @ElementName( "PurchaseContract" )
    private java.lang.String purchaseContract;
    public final static SimpleProperty.String<SupplierItem> PURCHASE_CONTRACT =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "PurchaseContract");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemPlndDelivDate</b>
     * </p>
     * 
     * @return Item delivery date
     */
    @Nullable
    @ElementName( "FldLogsSuplrItemPlndDelivDate" )
    private LocalDate fldLogsSuplrItemPlndDelivDate;
    public final static SimpleProperty.Date<SupplierItem> FLD_LOGS_SUPLR_ITEM_PLND_DELIV_DATE =
        new SimpleProperty.Date<SupplierItem>(SupplierItem.class, "FldLogsSuplrItemPlndDelivDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsPlndSrvcStartDate</b>
     * </p>
     * 
     * @return Date
     */
    @Nullable
    @ElementName( "FldLogsPlndSrvcStartDate" )
    private LocalDate fldLogsPlndSrvcStartDate;
    public final static SimpleProperty.Date<SupplierItem> FLD_LOGS_PLND_SRVC_START_DATE =
        new SimpleProperty.Date<SupplierItem>(SupplierItem.class, "FldLogsPlndSrvcStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsPlndSrvcEndDate</b>
     * </p>
     * 
     * @return Date
     */
    @Nullable
    @ElementName( "FldLogsPlndSrvcEndDate" )
    private LocalDate fldLogsPlndSrvcEndDate;
    public final static SimpleProperty.Date<SupplierItem> FLD_LOGS_PLND_SRVC_END_DATE =
        new SimpleProperty.Date<SupplierItem>(SupplierItem.class, "FldLogsPlndSrvcEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsActlSrvcStartDate</b>
     * </p>
     * 
     * @return Date
     */
    @Nullable
    @ElementName( "FldLogsActlSrvcStartDate" )
    private LocalDate fldLogsActlSrvcStartDate;
    public final static SimpleProperty.Date<SupplierItem> FLD_LOGS_ACTL_SRVC_START_DATE =
        new SimpleProperty.Date<SupplierItem>(SupplierItem.class, "FldLogsActlSrvcStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsActlSrvcEndDate</b>
     * </p>
     * 
     * @return Date
     */
    @Nullable
    @ElementName( "FldLogsActlSrvcEndDate" )
    private LocalDate fldLogsActlSrvcEndDate;
    public final static SimpleProperty.Date<SupplierItem> FLD_LOGS_ACTL_SRVC_END_DATE =
        new SimpleProperty.Date<SupplierItem>(SupplierItem.class, "FldLogsActlSrvcEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmChangeDateTime</b>
     * </p>
     * 
     * @return Changed On
     */
    @Nullable
    @ElementName( "FldLogsSuplrItmChangeDateTime" )
    private OffsetDateTime fldLogsSuplrItmChangeDateTime;
    public final static SimpleProperty.DateTime<SupplierItem> FLD_LOGS_SUPLR_ITM_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<SupplierItem>(SupplierItem.class, "FldLogsSuplrItmChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsLoadingPointID</b>
     * </p>
     * 
     * @return Unloading Point
     */
    @Nullable
    @ElementName( "FldLogsLoadingPointID" )
    private java.lang.String fldLogsLoadingPointID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_LOADING_POINT_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsLoadingPointID");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsUnloadingPointID</b>
     * </p>
     * 
     * @return Unloading Point
     */
    @Nullable
    @ElementName( "FldLogsUnloadingPointID" )
    private java.lang.String fldLogsUnloadingPointID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_UNLOADING_POINT_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsUnloadingPointID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsStorageLocationID</b>
     * </p>
     * 
     * @return Storage Location
     */
    @Nullable
    @ElementName( "FldLogsStorageLocationID" )
    private java.lang.String fldLogsStorageLocationID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_STORAGE_LOCATION_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsStorageLocationID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     * 
     * @return Storage Bin
     */
    @Nullable
    @ElementName( "StorageBin" )
    private java.lang.String storageBin;
    public final static SimpleProperty.String<SupplierItem> STORAGE_BIN =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsContainerID</b>
     * </p>
     * 
     * @return Container ID
     */
    @Nullable
    @ElementName( "FldLogsContainerID" )
    private java.lang.String fldLogsContainerID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_CONTAINER_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsContainerID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsTranspContainerID</b>
     * </p>
     * 
     * @return Container ID
     */
    @Nullable
    @ElementName( "FldLogsTranspContainerID" )
    private java.lang.String fldLogsTranspContainerID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_TRANSP_CONTAINER_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsTranspContainerID");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmGRDocID</b>
     * </p>
     * 
     * @return The fldLogsSuplrItmGRDocID contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "FldLogsSuplrItmGRDocID" )
    private java.lang.String fldLogsSuplrItmGRDocID;
    public final static SimpleProperty.String<SupplierItem> FLD_LOGS_SUPLR_ITM_GR_DOC_ID =
        new SimpleProperty.String<SupplierItem>(SupplierItem.class, "FldLogsSuplrItmGRDocID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SupplierItem, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SupplierItem, SAP__Message>(
            SupplierItem.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SupplierItem> getType()
    {
        return SupplierItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemUUID</b>
     * </p>
     * 
     * @param fldLogsSuplrItemUUID
     *            Supplier Item UUID
     */
    public void setFldLogsSuplrItemUUID( @Nullable final UUID fldLogsSuplrItemUUID )
    {
        rememberChangedField("FldLogsSuplrItemUUID", this.fldLogsSuplrItemUUID);
        this.fldLogsSuplrItemUUID = fldLogsSuplrItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemType</b>
     * </p>
     * 
     * @param fldLogsSuplrItemType
     *            Supplier Item Type
     */
    public void setFldLogsSuplrItemType( @Nullable final java.lang.String fldLogsSuplrItemType )
    {
        rememberChangedField("FldLogsSuplrItemType", this.fldLogsSuplrItemType);
        this.fldLogsSuplrItemType = fldLogsSuplrItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmPackggTypeCode</b>
     * </p>
     * 
     * @param fldLogsSuplrItmPackggTypeCode
     *            Supplier Item Packaging Type
     */
    public void setFldLogsSuplrItmPackggTypeCode( @Nullable final java.lang.String fldLogsSuplrItmPackggTypeCode )
    {
        rememberChangedField("FldLogsSuplrItmPackggTypeCode", this.fldLogsSuplrItmPackggTypeCode);
        this.fldLogsSuplrItmPackggTypeCode = fldLogsSuplrItmPackggTypeCode;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrParentItemUUID</b>
     * </p>
     * 
     * @param fldLogsSuplrParentItemUUID
     *            Supplier Item UUID
     */
    public void setFldLogsSuplrParentItemUUID( @Nullable final UUID fldLogsSuplrParentItemUUID )
    {
        rememberChangedField("FldLogsSuplrParentItemUUID", this.fldLogsSuplrParentItemUUID);
        this.fldLogsSuplrParentItemUUID = fldLogsSuplrParentItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemSerialNumber</b>
     * </p>
     * 
     * @param fldLogsSuplrItemSerialNumber
     *            Manufacturer&apos;s Serial Number
     */
    public void setFldLogsSuplrItemSerialNumber( @Nullable final java.lang.String fldLogsSuplrItemSerialNumber )
    {
        rememberChangedField("FldLogsSuplrItemSerialNumber", this.fldLogsSuplrItemSerialNumber);
        this.fldLogsSuplrItemSerialNumber = fldLogsSuplrItemSerialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemName</b>
     * </p>
     * 
     * @param fldLogsSuplrItemName
     *            Supplier Item Name
     */
    public void setFldLogsSuplrItemName( @Nullable final java.lang.String fldLogsSuplrItemName )
    {
        rememberChangedField("FldLogsSuplrItemName", this.fldLogsSuplrItemName);
        this.fldLogsSuplrItemName = fldLogsSuplrItemName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PreferredSupplier</b>
     * </p>
     * 
     * @param preferredSupplier
     *            Account Number of Supplier
     */
    public void setPreferredSupplier( @Nullable final java.lang.String preferredSupplier )
    {
        rememberChangedField("PreferredSupplier", this.preferredSupplier);
        this.preferredSupplier = preferredSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrBasePlant</b>
     * </p>
     * 
     * @param fldLogsSuplrBasePlant
     *            Plant
     */
    public void setFldLogsSuplrBasePlant( @Nullable final java.lang.String fldLogsSuplrBasePlant )
    {
        rememberChangedField("FldLogsSuplrBasePlant", this.fldLogsSuplrBasePlant);
        this.fldLogsSuplrBasePlant = fldLogsSuplrBasePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsRemotePlant</b>
     * </p>
     * 
     * @param fldLogsRemotePlant
     *            Plant
     */
    public void setFldLogsRemotePlant( @Nullable final java.lang.String fldLogsRemotePlant )
    {
        rememberChangedField("FldLogsRemotePlant", this.fldLogsRemotePlant);
        this.fldLogsRemotePlant = fldLogsRemotePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmPOItmUniqueID</b>
     * </p>
     * 
     * @param fldLogsSuplrItmPOItmUniqueID
     *            Purchase Order Item Unique ID
     */
    public void setFldLogsSuplrItmPOItmUniqueID( @Nullable final java.lang.String fldLogsSuplrItmPOItmUniqueID )
    {
        rememberChangedField("FldLogsSuplrItmPOItmUniqueID", this.fldLogsSuplrItmPOItmUniqueID);
        this.fldLogsSuplrItmPOItmUniqueID = fldLogsSuplrItmPOItmUniqueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemVislInspCode</b>
     * </p>
     * 
     * @param fldLogsSuplrItemVislInspCode
     *            Supplier Item Visual Inspection Code
     */
    public void setFldLogsSuplrItemVislInspCode( @Nullable final java.lang.String fldLogsSuplrItemVislInspCode )
    {
        rememberChangedField("FldLogsSuplrItemVislInspCode", this.fldLogsSuplrItemVislInspCode);
        this.fldLogsSuplrItemVislInspCode = fldLogsSuplrItemVislInspCode;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocNetPriceAmount</b>
     * </p>
     * 
     * @param purgDocNetPriceAmount
     *            The purgDocNetPriceAmount to set.
     */
    public void setPurgDocNetPriceAmount( @Nullable final BigDecimal purgDocNetPriceAmount )
    {
        rememberChangedField("PurgDocNetPriceAmount", this.purgDocNetPriceAmount);
        this.purgDocNetPriceAmount = purgDocNetPriceAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemRateUnit</b>
     * </p>
     * 
     * @param fldLogsSuplrItemRateUnit
     *            Currency Key
     */
    public void setFldLogsSuplrItemRateUnit( @Nullable final java.lang.String fldLogsSuplrItemRateUnit )
    {
        rememberChangedField("FldLogsSuplrItemRateUnit", this.fldLogsSuplrItemRateUnit);
        this.fldLogsSuplrItemRateUnit = fldLogsSuplrItemRateUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemQuantity</b>
     * </p>
     * 
     * @param fldLogsSuplrItemQuantity
     *            The fldLogsSuplrItemQuantity to set.
     */
    public void setFldLogsSuplrItemQuantity( @Nullable final BigDecimal fldLogsSuplrItemQuantity )
    {
        rememberChangedField("FldLogsSuplrItemQuantity", this.fldLogsSuplrItemQuantity);
        this.fldLogsSuplrItemQuantity = fldLogsSuplrItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemQuantityUnit</b>
     * </p>
     * 
     * @param fldLogsSuplrItemQuantityUnit
     *            Base Unit of Measure
     */
    public void setFldLogsSuplrItemQuantityUnit( @Nullable final java.lang.String fldLogsSuplrItemQuantityUnit )
    {
        rememberChangedField("FldLogsSuplrItemQuantityUnit", this.fldLogsSuplrItemQuantityUnit);
        this.fldLogsSuplrItemQuantityUnit = fldLogsSuplrItemQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemGrossVolume</b>
     * </p>
     * 
     * @param fldLogsSuplrItemGrossVolume
     *            The fldLogsSuplrItemGrossVolume to set.
     */
    public void setFldLogsSuplrItemGrossVolume( @Nullable final BigDecimal fldLogsSuplrItemGrossVolume )
    {
        rememberChangedField("FldLogsSuplrItemGrossVolume", this.fldLogsSuplrItemGrossVolume);
        this.fldLogsSuplrItemGrossVolume = fldLogsSuplrItemGrossVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmGrossVolumeUnit</b>
     * </p>
     * 
     * @param fldLogsSuplrItmGrossVolumeUnit
     *            Volume Unit
     */
    public void setFldLogsSuplrItmGrossVolumeUnit( @Nullable final java.lang.String fldLogsSuplrItmGrossVolumeUnit )
    {
        rememberChangedField("FldLogsSuplrItmGrossVolumeUnit", this.fldLogsSuplrItmGrossVolumeUnit);
        this.fldLogsSuplrItmGrossVolumeUnit = fldLogsSuplrItmGrossVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductGrossWeight</b>
     * </p>
     * 
     * @param productGrossWeight
     *            The productGrossWeight to set.
     */
    public void setProductGrossWeight( @Nullable final BigDecimal productGrossWeight )
    {
        rememberChangedField("ProductGrossWeight", this.productGrossWeight);
        this.productGrossWeight = productGrossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductWeightUnit</b>
     * </p>
     * 
     * @param productWeightUnit
     *            Unit of Weight
     */
    public void setProductWeightUnit( @Nullable final java.lang.String productWeightUnit )
    {
        rememberChangedField("ProductWeightUnit", this.productWeightUnit);
        this.productWeightUnit = productWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemLength</b>
     * </p>
     * 
     * @param fldLogsSuplrItemLength
     *            The fldLogsSuplrItemLength to set.
     */
    public void setFldLogsSuplrItemLength( @Nullable final BigDecimal fldLogsSuplrItemLength )
    {
        rememberChangedField("FldLogsSuplrItemLength", this.fldLogsSuplrItemLength);
        this.fldLogsSuplrItemLength = fldLogsSuplrItemLength;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemWidth</b>
     * </p>
     * 
     * @param fldLogsSuplrItemWidth
     *            The fldLogsSuplrItemWidth to set.
     */
    public void setFldLogsSuplrItemWidth( @Nullable final BigDecimal fldLogsSuplrItemWidth )
    {
        rememberChangedField("FldLogsSuplrItemWidth", this.fldLogsSuplrItemWidth);
        this.fldLogsSuplrItemWidth = fldLogsSuplrItemWidth;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemHeight</b>
     * </p>
     * 
     * @param fldLogsSuplrItemHeight
     *            The fldLogsSuplrItemHeight to set.
     */
    public void setFldLogsSuplrItemHeight( @Nullable final BigDecimal fldLogsSuplrItemHeight )
    {
        rememberChangedField("FldLogsSuplrItemHeight", this.fldLogsSuplrItemHeight);
        this.fldLogsSuplrItemHeight = fldLogsSuplrItemHeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemMeasureUnit</b>
     * </p>
     * 
     * @param fldLogsSuplrItemMeasureUnit
     *            Unit of Dimension for Length/Width/Height
     */
    public void setFldLogsSuplrItemMeasureUnit( @Nullable final java.lang.String fldLogsSuplrItemMeasureUnit )
    {
        rememberChangedField("FldLogsSuplrItemMeasureUnit", this.fldLogsSuplrItemMeasureUnit);
        this.fldLogsSuplrItemMeasureUnit = fldLogsSuplrItemMeasureUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemStatusID</b>
     * </p>
     * 
     * @param fldLogsSuplrItemStatusID
     *            Supplier Item Status ID
     */
    public void setFldLogsSuplrItemStatusID( @Nullable final java.lang.String fldLogsSuplrItemStatusID )
    {
        rememberChangedField("FldLogsSuplrItemStatusID", this.fldLogsSuplrItemStatusID);
        this.fldLogsSuplrItemStatusID = fldLogsSuplrItemStatusID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ItemIsDangerousGood</b>
     * </p>
     * 
     * @param itemIsDangerousGood
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setItemIsDangerousGood( @Nullable final java.lang.Boolean itemIsDangerousGood )
    {
        rememberChangedField("ItemIsDangerousGood", this.itemIsDangerousGood);
        this.itemIsDangerousGood = itemIsDangerousGood;
    }

    /**
     * Constraints: Not nullable, Maximum length: 51
     * <p>
     * Original property name from the Odata EDM: <b>DangerousGoodsIdnNumberCnctntd</b>
     * </p>
     * 
     * @param dangerousGoodsIdnNumberCnctntd
     *            Supplier Item DG ID Number Concatenated
     */
    public void setDangerousGoodsIdnNumberCnctntd( @Nullable final java.lang.String dangerousGoodsIdnNumberCnctntd )
    {
        rememberChangedField("DangerousGoodsIdnNumberCnctntd", this.dangerousGoodsIdnNumberCnctntd);
        this.dangerousGoodsIdnNumberCnctntd = dangerousGoodsIdnNumberCnctntd;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsIsWorkOrderOnHold</b>
     * </p>
     * 
     * @param fldLogsIsWorkOrderOnHold
     *            Work Order On Hold Indicator
     */
    public void setFldLogsIsWorkOrderOnHold( @Nullable final java.lang.Boolean fldLogsIsWorkOrderOnHold )
    {
        rememberChangedField("FldLogsIsWorkOrderOnHold", this.fldLogsIsWorkOrderOnHold);
        this.fldLogsIsWorkOrderOnHold = fldLogsIsWorkOrderOnHold;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceOrder</b>
     * </p>
     * 
     * @param maintenanceOrder
     *            Order Number
     */
    public void setMaintenanceOrder( @Nullable final java.lang.String maintenanceOrder )
    {
        rememberChangedField("MaintenanceOrder", this.maintenanceOrder);
        this.maintenanceOrder = maintenanceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     * 
     * @param project
     *            External Project ID
     */
    public void setProject( @Nullable final java.lang.String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDemand</b>
     * </p>
     * 
     * @param projectDemand
     *            Project Demand ID
     */
    public void setProjectDemand( @Nullable final java.lang.String projectDemand )
    {
        rememberChangedField("ProjectDemand", this.projectDemand);
        this.projectDemand = projectDemand;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     * 
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final java.lang.String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContract</b>
     * </p>
     * 
     * @param purchaseContract
     *            Purchasing Document Number
     */
    public void setPurchaseContract( @Nullable final java.lang.String purchaseContract )
    {
        rememberChangedField("PurchaseContract", this.purchaseContract);
        this.purchaseContract = purchaseContract;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItemPlndDelivDate</b>
     * </p>
     * 
     * @param fldLogsSuplrItemPlndDelivDate
     *            Item delivery date
     */
    public void setFldLogsSuplrItemPlndDelivDate( @Nullable final LocalDate fldLogsSuplrItemPlndDelivDate )
    {
        rememberChangedField("FldLogsSuplrItemPlndDelivDate", this.fldLogsSuplrItemPlndDelivDate);
        this.fldLogsSuplrItemPlndDelivDate = fldLogsSuplrItemPlndDelivDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsPlndSrvcStartDate</b>
     * </p>
     * 
     * @param fldLogsPlndSrvcStartDate
     *            Date
     */
    public void setFldLogsPlndSrvcStartDate( @Nullable final LocalDate fldLogsPlndSrvcStartDate )
    {
        rememberChangedField("FldLogsPlndSrvcStartDate", this.fldLogsPlndSrvcStartDate);
        this.fldLogsPlndSrvcStartDate = fldLogsPlndSrvcStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsPlndSrvcEndDate</b>
     * </p>
     * 
     * @param fldLogsPlndSrvcEndDate
     *            Date
     */
    public void setFldLogsPlndSrvcEndDate( @Nullable final LocalDate fldLogsPlndSrvcEndDate )
    {
        rememberChangedField("FldLogsPlndSrvcEndDate", this.fldLogsPlndSrvcEndDate);
        this.fldLogsPlndSrvcEndDate = fldLogsPlndSrvcEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsActlSrvcStartDate</b>
     * </p>
     * 
     * @param fldLogsActlSrvcStartDate
     *            Date
     */
    public void setFldLogsActlSrvcStartDate( @Nullable final LocalDate fldLogsActlSrvcStartDate )
    {
        rememberChangedField("FldLogsActlSrvcStartDate", this.fldLogsActlSrvcStartDate);
        this.fldLogsActlSrvcStartDate = fldLogsActlSrvcStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsActlSrvcEndDate</b>
     * </p>
     * 
     * @param fldLogsActlSrvcEndDate
     *            Date
     */
    public void setFldLogsActlSrvcEndDate( @Nullable final LocalDate fldLogsActlSrvcEndDate )
    {
        rememberChangedField("FldLogsActlSrvcEndDate", this.fldLogsActlSrvcEndDate);
        this.fldLogsActlSrvcEndDate = fldLogsActlSrvcEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmChangeDateTime</b>
     * </p>
     * 
     * @param fldLogsSuplrItmChangeDateTime
     *            Changed On
     */
    public void setFldLogsSuplrItmChangeDateTime( @Nullable final OffsetDateTime fldLogsSuplrItmChangeDateTime )
    {
        rememberChangedField("FldLogsSuplrItmChangeDateTime", this.fldLogsSuplrItmChangeDateTime);
        this.fldLogsSuplrItmChangeDateTime = fldLogsSuplrItmChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsLoadingPointID</b>
     * </p>
     * 
     * @param fldLogsLoadingPointID
     *            Unloading Point
     */
    public void setFldLogsLoadingPointID( @Nullable final java.lang.String fldLogsLoadingPointID )
    {
        rememberChangedField("FldLogsLoadingPointID", this.fldLogsLoadingPointID);
        this.fldLogsLoadingPointID = fldLogsLoadingPointID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsUnloadingPointID</b>
     * </p>
     * 
     * @param fldLogsUnloadingPointID
     *            Unloading Point
     */
    public void setFldLogsUnloadingPointID( @Nullable final java.lang.String fldLogsUnloadingPointID )
    {
        rememberChangedField("FldLogsUnloadingPointID", this.fldLogsUnloadingPointID);
        this.fldLogsUnloadingPointID = fldLogsUnloadingPointID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsStorageLocationID</b>
     * </p>
     * 
     * @param fldLogsStorageLocationID
     *            Storage Location
     */
    public void setFldLogsStorageLocationID( @Nullable final java.lang.String fldLogsStorageLocationID )
    {
        rememberChangedField("FldLogsStorageLocationID", this.fldLogsStorageLocationID);
        this.fldLogsStorageLocationID = fldLogsStorageLocationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     * 
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final java.lang.String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsContainerID</b>
     * </p>
     * 
     * @param fldLogsContainerID
     *            Container ID
     */
    public void setFldLogsContainerID( @Nullable final java.lang.String fldLogsContainerID )
    {
        rememberChangedField("FldLogsContainerID", this.fldLogsContainerID);
        this.fldLogsContainerID = fldLogsContainerID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsTranspContainerID</b>
     * </p>
     * 
     * @param fldLogsTranspContainerID
     *            Container ID
     */
    public void setFldLogsTranspContainerID( @Nullable final java.lang.String fldLogsTranspContainerID )
    {
        rememberChangedField("FldLogsTranspContainerID", this.fldLogsTranspContainerID);
        this.fldLogsTranspContainerID = fldLogsTranspContainerID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FldLogsSuplrItmGRDocID</b>
     * </p>
     * 
     * @param fldLogsSuplrItmGRDocID
     *            The fldLogsSuplrItmGRDocID to set.
     */
    public void setFldLogsSuplrItmGRDocID( @Nullable final java.lang.String fldLogsSuplrItmGRDocID )
    {
        rememberChangedField("FldLogsSuplrItmGRDocID", this.fldLogsSuplrItmGRDocID);
        this.fldLogsSuplrItmGRDocID = fldLogsSuplrItmGRDocID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SupplierItem";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("FldLogsSuplrItemUUID", getFldLogsSuplrItemUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("FldLogsSuplrItemUUID", getFldLogsSuplrItemUUID());
        values.put("FldLogsSuplrItemType", getFldLogsSuplrItemType());
        values.put("FldLogsSuplrItmPackggTypeCode", getFldLogsSuplrItmPackggTypeCode());
        values.put("FldLogsSuplrParentItemUUID", getFldLogsSuplrParentItemUUID());
        values.put("FldLogsSuplrItemSerialNumber", getFldLogsSuplrItemSerialNumber());
        values.put("FldLogsSuplrItemName", getFldLogsSuplrItemName());
        values.put("PreferredSupplier", getPreferredSupplier());
        values.put("FldLogsSuplrBasePlant", getFldLogsSuplrBasePlant());
        values.put("FldLogsRemotePlant", getFldLogsRemotePlant());
        values.put("FldLogsSuplrItmPOItmUniqueID", getFldLogsSuplrItmPOItmUniqueID());
        values.put("FldLogsSuplrItemVislInspCode", getFldLogsSuplrItemVislInspCode());
        values.put("PurgDocNetPriceAmount", getPurgDocNetPriceAmount());
        values.put("FldLogsSuplrItemRateUnit", getFldLogsSuplrItemRateUnit());
        values.put("FldLogsSuplrItemQuantity", getFldLogsSuplrItemQuantity());
        values.put("FldLogsSuplrItemQuantityUnit", getFldLogsSuplrItemQuantityUnit());
        values.put("FldLogsSuplrItemGrossVolume", getFldLogsSuplrItemGrossVolume());
        values.put("FldLogsSuplrItmGrossVolumeUnit", getFldLogsSuplrItmGrossVolumeUnit());
        values.put("ProductGrossWeight", getProductGrossWeight());
        values.put("ProductWeightUnit", getProductWeightUnit());
        values.put("FldLogsSuplrItemLength", getFldLogsSuplrItemLength());
        values.put("FldLogsSuplrItemWidth", getFldLogsSuplrItemWidth());
        values.put("FldLogsSuplrItemHeight", getFldLogsSuplrItemHeight());
        values.put("FldLogsSuplrItemMeasureUnit", getFldLogsSuplrItemMeasureUnit());
        values.put("FldLogsSuplrItemStatusID", getFldLogsSuplrItemStatusID());
        values.put("ItemIsDangerousGood", getItemIsDangerousGood());
        values.put("DangerousGoodsIdnNumberCnctntd", getDangerousGoodsIdnNumberCnctntd());
        values.put("FldLogsIsWorkOrderOnHold", getFldLogsIsWorkOrderOnHold());
        values.put("MaintenanceOrder", getMaintenanceOrder());
        values.put("Project", getProject());
        values.put("ProjectDemand", getProjectDemand());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseContract", getPurchaseContract());
        values.put("FldLogsSuplrItemPlndDelivDate", getFldLogsSuplrItemPlndDelivDate());
        values.put("FldLogsPlndSrvcStartDate", getFldLogsPlndSrvcStartDate());
        values.put("FldLogsPlndSrvcEndDate", getFldLogsPlndSrvcEndDate());
        values.put("FldLogsActlSrvcStartDate", getFldLogsActlSrvcStartDate());
        values.put("FldLogsActlSrvcEndDate", getFldLogsActlSrvcEndDate());
        values.put("FldLogsSuplrItmChangeDateTime", getFldLogsSuplrItmChangeDateTime());
        values.put("FldLogsLoadingPointID", getFldLogsLoadingPointID());
        values.put("FldLogsUnloadingPointID", getFldLogsUnloadingPointID());
        values.put("FldLogsStorageLocationID", getFldLogsStorageLocationID());
        values.put("StorageBin", getStorageBin());
        values.put("FldLogsContainerID", getFldLogsContainerID());
        values.put("FldLogsTranspContainerID", getFldLogsTranspContainerID());
        values.put("FldLogsSuplrItmGRDocID", getFldLogsSuplrItmGRDocID());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FldLogsSuplrItemUUID") ) {
                final Object value = values.remove("FldLogsSuplrItemUUID");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemUUID())) ) {
                    setFldLogsSuplrItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemType") ) {
                final Object value = values.remove("FldLogsSuplrItemType");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemType())) ) {
                    setFldLogsSuplrItemType(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItmPackggTypeCode") ) {
                final Object value = values.remove("FldLogsSuplrItmPackggTypeCode");
                if( (value == null) || (!value.equals(getFldLogsSuplrItmPackggTypeCode())) ) {
                    setFldLogsSuplrItmPackggTypeCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrParentItemUUID") ) {
                final Object value = values.remove("FldLogsSuplrParentItemUUID");
                if( (value == null) || (!value.equals(getFldLogsSuplrParentItemUUID())) ) {
                    setFldLogsSuplrParentItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemSerialNumber") ) {
                final Object value = values.remove("FldLogsSuplrItemSerialNumber");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemSerialNumber())) ) {
                    setFldLogsSuplrItemSerialNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemName") ) {
                final Object value = values.remove("FldLogsSuplrItemName");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemName())) ) {
                    setFldLogsSuplrItemName(((java.lang.String) value));
                }
            }
            if( values.containsKey("PreferredSupplier") ) {
                final Object value = values.remove("PreferredSupplier");
                if( (value == null) || (!value.equals(getPreferredSupplier())) ) {
                    setPreferredSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrBasePlant") ) {
                final Object value = values.remove("FldLogsSuplrBasePlant");
                if( (value == null) || (!value.equals(getFldLogsSuplrBasePlant())) ) {
                    setFldLogsSuplrBasePlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsRemotePlant") ) {
                final Object value = values.remove("FldLogsRemotePlant");
                if( (value == null) || (!value.equals(getFldLogsRemotePlant())) ) {
                    setFldLogsRemotePlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItmPOItmUniqueID") ) {
                final Object value = values.remove("FldLogsSuplrItmPOItmUniqueID");
                if( (value == null) || (!value.equals(getFldLogsSuplrItmPOItmUniqueID())) ) {
                    setFldLogsSuplrItmPOItmUniqueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemVislInspCode") ) {
                final Object value = values.remove("FldLogsSuplrItemVislInspCode");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemVislInspCode())) ) {
                    setFldLogsSuplrItemVislInspCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurgDocNetPriceAmount") ) {
                final Object value = values.remove("PurgDocNetPriceAmount");
                if( (value == null) || (!value.equals(getPurgDocNetPriceAmount())) ) {
                    setPurgDocNetPriceAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemRateUnit") ) {
                final Object value = values.remove("FldLogsSuplrItemRateUnit");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemRateUnit())) ) {
                    setFldLogsSuplrItemRateUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemQuantity") ) {
                final Object value = values.remove("FldLogsSuplrItemQuantity");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemQuantity())) ) {
                    setFldLogsSuplrItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemQuantityUnit") ) {
                final Object value = values.remove("FldLogsSuplrItemQuantityUnit");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemQuantityUnit())) ) {
                    setFldLogsSuplrItemQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemGrossVolume") ) {
                final Object value = values.remove("FldLogsSuplrItemGrossVolume");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemGrossVolume())) ) {
                    setFldLogsSuplrItemGrossVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItmGrossVolumeUnit") ) {
                final Object value = values.remove("FldLogsSuplrItmGrossVolumeUnit");
                if( (value == null) || (!value.equals(getFldLogsSuplrItmGrossVolumeUnit())) ) {
                    setFldLogsSuplrItmGrossVolumeUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGrossWeight") ) {
                final Object value = values.remove("ProductGrossWeight");
                if( (value == null) || (!value.equals(getProductGrossWeight())) ) {
                    setProductGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductWeightUnit") ) {
                final Object value = values.remove("ProductWeightUnit");
                if( (value == null) || (!value.equals(getProductWeightUnit())) ) {
                    setProductWeightUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemLength") ) {
                final Object value = values.remove("FldLogsSuplrItemLength");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemLength())) ) {
                    setFldLogsSuplrItemLength(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemWidth") ) {
                final Object value = values.remove("FldLogsSuplrItemWidth");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemWidth())) ) {
                    setFldLogsSuplrItemWidth(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemHeight") ) {
                final Object value = values.remove("FldLogsSuplrItemHeight");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemHeight())) ) {
                    setFldLogsSuplrItemHeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemMeasureUnit") ) {
                final Object value = values.remove("FldLogsSuplrItemMeasureUnit");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemMeasureUnit())) ) {
                    setFldLogsSuplrItemMeasureUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemStatusID") ) {
                final Object value = values.remove("FldLogsSuplrItemStatusID");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemStatusID())) ) {
                    setFldLogsSuplrItemStatusID(((java.lang.String) value));
                }
            }
            if( values.containsKey("ItemIsDangerousGood") ) {
                final Object value = values.remove("ItemIsDangerousGood");
                if( (value == null) || (!value.equals(getItemIsDangerousGood())) ) {
                    setItemIsDangerousGood(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("DangerousGoodsIdnNumberCnctntd") ) {
                final Object value = values.remove("DangerousGoodsIdnNumberCnctntd");
                if( (value == null) || (!value.equals(getDangerousGoodsIdnNumberCnctntd())) ) {
                    setDangerousGoodsIdnNumberCnctntd(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsIsWorkOrderOnHold") ) {
                final Object value = values.remove("FldLogsIsWorkOrderOnHold");
                if( (value == null) || (!value.equals(getFldLogsIsWorkOrderOnHold())) ) {
                    setFldLogsIsWorkOrderOnHold(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("MaintenanceOrder") ) {
                final Object value = values.remove("MaintenanceOrder");
                if( (value == null) || (!value.equals(getMaintenanceOrder())) ) {
                    setMaintenanceOrder(((java.lang.String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProjectDemand") ) {
                final Object value = values.remove("ProjectDemand");
                if( (value == null) || (!value.equals(getProjectDemand())) ) {
                    setProjectDemand(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchaseContract") ) {
                final Object value = values.remove("PurchaseContract");
                if( (value == null) || (!value.equals(getPurchaseContract())) ) {
                    setPurchaseContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItemPlndDelivDate") ) {
                final Object value = values.remove("FldLogsSuplrItemPlndDelivDate");
                if( (value == null) || (!value.equals(getFldLogsSuplrItemPlndDelivDate())) ) {
                    setFldLogsSuplrItemPlndDelivDate(((LocalDate) value));
                }
            }
            if( values.containsKey("FldLogsPlndSrvcStartDate") ) {
                final Object value = values.remove("FldLogsPlndSrvcStartDate");
                if( (value == null) || (!value.equals(getFldLogsPlndSrvcStartDate())) ) {
                    setFldLogsPlndSrvcStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("FldLogsPlndSrvcEndDate") ) {
                final Object value = values.remove("FldLogsPlndSrvcEndDate");
                if( (value == null) || (!value.equals(getFldLogsPlndSrvcEndDate())) ) {
                    setFldLogsPlndSrvcEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("FldLogsActlSrvcStartDate") ) {
                final Object value = values.remove("FldLogsActlSrvcStartDate");
                if( (value == null) || (!value.equals(getFldLogsActlSrvcStartDate())) ) {
                    setFldLogsActlSrvcStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("FldLogsActlSrvcEndDate") ) {
                final Object value = values.remove("FldLogsActlSrvcEndDate");
                if( (value == null) || (!value.equals(getFldLogsActlSrvcEndDate())) ) {
                    setFldLogsActlSrvcEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItmChangeDateTime") ) {
                final Object value = values.remove("FldLogsSuplrItmChangeDateTime");
                if( (value == null) || (!value.equals(getFldLogsSuplrItmChangeDateTime())) ) {
                    setFldLogsSuplrItmChangeDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("FldLogsLoadingPointID") ) {
                final Object value = values.remove("FldLogsLoadingPointID");
                if( (value == null) || (!value.equals(getFldLogsLoadingPointID())) ) {
                    setFldLogsLoadingPointID(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsUnloadingPointID") ) {
                final Object value = values.remove("FldLogsUnloadingPointID");
                if( (value == null) || (!value.equals(getFldLogsUnloadingPointID())) ) {
                    setFldLogsUnloadingPointID(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsStorageLocationID") ) {
                final Object value = values.remove("FldLogsStorageLocationID");
                if( (value == null) || (!value.equals(getFldLogsStorageLocationID())) ) {
                    setFldLogsStorageLocationID(((java.lang.String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsContainerID") ) {
                final Object value = values.remove("FldLogsContainerID");
                if( (value == null) || (!value.equals(getFldLogsContainerID())) ) {
                    setFldLogsContainerID(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsTranspContainerID") ) {
                final Object value = values.remove("FldLogsTranspContainerID");
                if( (value == null) || (!value.equals(getFldLogsTranspContainerID())) ) {
                    setFldLogsTranspContainerID(((java.lang.String) value));
                }
            }
            if( values.containsKey("FldLogsSuplrItmGRDocID") ) {
                final Object value = values.remove("FldLogsSuplrItmGRDocID");
                if( (value == null) || (!value.equals(getFldLogsSuplrItmGRDocID())) ) {
                    setFldLogsSuplrItmGRDocID(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SupplierItemService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param documentDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DocumentDate</b>
     *            </p>
     * @param fldLogsSuplrItemVislInspCode
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FldLogsSuplrItemVislInspCode</b>
     *            </p>
     * @param deliveryNote
     *            Constraints: Not nullable, Maximum length: 16
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DeliveryNote</b>
     *            </p>
     * @param fldLogsStorageLocationID
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FldLogsStorageLocationID</b>
     *            </p>
     * @param postingDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PostingDate</b>
     *            </p>
     * @param materialDocumentHeaderText
     *            Constraints: Not nullable, Maximum length: 25
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaterialDocumentHeaderText</b>
     *            </p>
     * @param fldLogsMilestoneEventID
     *            Constraints: Not nullable, Maximum length: 20
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FldLogsMilestoneEventID</b>
     *            </p>
     * @param fldLogsContainerID
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FldLogsContainerID</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SupplierItem, SupplierItem>
        processMilestoneEvent(
            @Nonnull final java.lang.String fldLogsMilestoneEventID,
            @Nonnull final java.lang.String fldLogsSuplrItemVislInspCode,
            @Nonnull final java.lang.String fldLogsContainerID,
            @Nonnull final java.lang.String deliveryNote,
            @Nonnull final LocalDate documentDate,
            @Nonnull final LocalDate postingDate,
            @Nonnull final java.lang.String fldLogsStorageLocationID,
            @Nonnull final java.lang.String materialDocumentHeaderText )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("FldLogsMilestoneEventID", fldLogsMilestoneEventID);
        parameters.put("FldLogsSuplrItemVislInspCode", fldLogsSuplrItemVislInspCode);
        parameters.put("FldLogsContainerID", fldLogsContainerID);
        parameters.put("DeliveryNote", deliveryNote);
        parameters.put("DocumentDate", documentDate);
        parameters.put("PostingDate", postingDate);
        parameters.put("FldLogsStorageLocationID", fldLogsStorageLocationID);
        parameters.put("MaterialDocumentHeaderText", materialDocumentHeaderText);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<SupplierItem, SupplierItem>(
            SupplierItem.class,
            SupplierItem.class,
            "com.sap.gateway.srvd_a2x.api_supplieritem.v0001.ProcessMilestoneEvent",
            parameters);
    }

}
