/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplyAvailabilityProtectionPlanService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Characteristic
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupProtCharacteristicType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SupProtCharacteristic extends VdmEntity<SupProtCharacteristic> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_supavailyprotplan.v0001.A_SupProtCharacteristicType";
    /**
     * Selector for all available fields of SupProtCharacteristic.
     * 
     */
    public final static SimpleProperty<SupProtCharacteristic> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharacteristicUUID</b>
     * </p>
     * 
     * @return Characteristic UUID
     */
    @Nullable
    @ElementName( "SupProtCharacteristicUUID" )
    private UUID supProtCharacteristicUUID;
    public final static SimpleProperty.Guid<SupProtCharacteristic> SUP_PROT_CHARACTERISTIC_UUID =
        new SimpleProperty.Guid<SupProtCharacteristic>(SupProtCharacteristic.class, "SupProtCharacteristicUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @return UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionUUID" )
    private UUID supplyProtectionUUID;
    public final static SimpleProperty.Guid<SupProtCharacteristic> SUPPLY_PROTECTION_UUID =
        new SimpleProperty.Guid<SupProtCharacteristic>(SupProtCharacteristic.class, "SupplyProtectionUUID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtOrdinalNumberValue</b>
     * </p>
     * 
     * @return Ordinal Number
     */
    @Nullable
    @ElementName( "SupProtOrdinalNumberValue" )
    private Short supProtOrdinalNumberValue;
    public final static SimpleProperty.NumericInteger<SupProtCharacteristic> SUP_PROT_ORDINAL_NUMBER_VALUE =
        new SimpleProperty.NumericInteger<SupProtCharacteristic>(
            SupProtCharacteristic.class,
            "SupProtOrdinalNumberValue");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharcName</b>
     * </p>
     * 
     * @return Characteristic Name
     */
    @Nullable
    @ElementName( "SupProtCharcName" )
    private java.lang.String supProtCharcName;
    public final static SimpleProperty.String<SupProtCharacteristic> SUP_PROT_CHARC_NAME =
        new SimpleProperty.String<SupProtCharacteristic>(SupProtCharacteristic.class, "SupProtCharcName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharcCtlgPathIntID</b>
     * </p>
     * 
     * @return Characteristic Catalog Path Internal ID
     */
    @Nullable
    @ElementName( "SupProtCharcCtlgPathIntID" )
    private byte[] supProtCharcCtlgPathIntID;
    public final static SimpleProperty.Binary<SupProtCharacteristic> SUP_PROT_CHARC_CTLG_PATH_INT_ID =
        new SimpleProperty.Binary<SupProtCharacteristic>(SupProtCharacteristic.class, "SupProtCharcCtlgPathIntID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<SupProtCharacteristic> CREATED_BY_USER =
        new SimpleProperty.String<SupProtCharacteristic>(SupProtCharacteristic.class, "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return Created On / At
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<SupProtCharacteristic> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<SupProtCharacteristic>(SupProtCharacteristic.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<SupProtCharacteristic> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<SupProtCharacteristic>(SupProtCharacteristic.class, "LastChangedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return Changed On / At
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<SupProtCharacteristic> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<SupProtCharacteristic>(SupProtCharacteristic.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     * 
     * @return Characteristic
     */
    @Nullable
    @ElementName( "Characteristic" )
    private java.lang.String characteristic;
    public final static SimpleProperty.String<SupProtCharacteristic> CHARACTERISTIC =
        new SimpleProperty.String<SupProtCharacteristic>(SupProtCharacteristic.class, "Characteristic");
    /**
     * Navigation property <b>_SupplyProtectionTP</b> for <b>SupProtCharacteristic</b> to single
     * <b>SupplyProtection</b>.
     * 
     */
    @ElementName( "_SupplyProtectionTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplyProtection to_SupplyProtectionTP;
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupProtCharacteristic, SupplyProtection> TO__SUPPLY_PROTECTION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupProtCharacteristic, SupplyProtection>(
            SupProtCharacteristic.class,
            "_SupplyProtectionTP",
            SupplyProtection.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SupProtCharacteristic> getType()
    {
        return SupProtCharacteristic.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharacteristicUUID</b>
     * </p>
     * 
     * @param supProtCharacteristicUUID
     *            Characteristic UUID
     */
    public void setSupProtCharacteristicUUID( @Nullable final UUID supProtCharacteristicUUID )
    {
        rememberChangedField("SupProtCharacteristicUUID", this.supProtCharacteristicUUID);
        this.supProtCharacteristicUUID = supProtCharacteristicUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @param supplyProtectionUUID
     *            UUID
     */
    public void setSupplyProtectionUUID( @Nullable final UUID supplyProtectionUUID )
    {
        rememberChangedField("SupplyProtectionUUID", this.supplyProtectionUUID);
        this.supplyProtectionUUID = supplyProtectionUUID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtOrdinalNumberValue</b>
     * </p>
     * 
     * @param supProtOrdinalNumberValue
     *            Ordinal Number
     */
    public void setSupProtOrdinalNumberValue( @Nullable final Short supProtOrdinalNumberValue )
    {
        rememberChangedField("SupProtOrdinalNumberValue", this.supProtOrdinalNumberValue);
        this.supProtOrdinalNumberValue = supProtOrdinalNumberValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharcName</b>
     * </p>
     * 
     * @param supProtCharcName
     *            Characteristic Name
     */
    public void setSupProtCharcName( @Nullable final java.lang.String supProtCharcName )
    {
        rememberChangedField("SupProtCharcName", this.supProtCharcName);
        this.supProtCharcName = supProtCharcName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharcCtlgPathIntID</b>
     * </p>
     * 
     * @param supProtCharcCtlgPathIntID
     *            Characteristic Catalog Path Internal ID
     */
    public void setSupProtCharcCtlgPathIntID( @Nullable final byte[] supProtCharcCtlgPathIntID )
    {
        rememberChangedField("SupProtCharcCtlgPathIntID", this.supProtCharcCtlgPathIntID);
        this.supProtCharcCtlgPathIntID = supProtCharcCtlgPathIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            Created On / At
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            Changed On / At
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     * 
     * @param characteristic
     *            Characteristic
     */
    public void setCharacteristic( @Nullable final java.lang.String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_SupProtCharacteristic";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SupProtCharacteristicUUID", getSupProtCharacteristicUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SupProtCharacteristicUUID", getSupProtCharacteristicUUID());
        values.put("SupplyProtectionUUID", getSupplyProtectionUUID());
        values.put("SupProtOrdinalNumberValue", getSupProtOrdinalNumberValue());
        values.put("SupProtCharcName", getSupProtCharcName());
        values.put("SupProtCharcCtlgPathIntID", getSupProtCharcCtlgPathIntID());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("Characteristic", getCharacteristic());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupProtCharacteristicUUID") ) {
                final Object value = values.remove("SupProtCharacteristicUUID");
                if( (value == null) || (!value.equals(getSupProtCharacteristicUUID())) ) {
                    setSupProtCharacteristicUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplyProtectionUUID") ) {
                final Object value = values.remove("SupplyProtectionUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionUUID())) ) {
                    setSupplyProtectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupProtOrdinalNumberValue") ) {
                final Object value = values.remove("SupProtOrdinalNumberValue");
                if( (value == null) || (!value.equals(getSupProtOrdinalNumberValue())) ) {
                    setSupProtOrdinalNumberValue(((Short) value));
                }
            }
            if( values.containsKey("SupProtCharcName") ) {
                final Object value = values.remove("SupProtCharcName");
                if( (value == null) || (!value.equals(getSupProtCharcName())) ) {
                    setSupProtCharcName(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharcCtlgPathIntID") ) {
                final Object value = values.remove("SupProtCharcCtlgPathIntID");
                if( (value == null) || (!value.equals(getSupProtCharcCtlgPathIntID())) ) {
                    setSupProtCharcCtlgPathIntID(((byte[]) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SupplyProtectionTP") ) {
                final Object value = (values).remove("_SupplyProtectionTP");
                if( value instanceof Map ) {
                    if( to_SupplyProtectionTP == null ) {
                        to_SupplyProtectionTP = new SupplyProtection();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SupplyProtectionTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SupplyAvailabilityProtectionPlanService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SupplyProtectionTP != null ) {
            (values).put("_SupplyProtectionTP", to_SupplyProtectionTP);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SupplyProtection</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SupplyProtectionTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupProtCharacteristic</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionTP</b> is already loaded, the result will
     *         contain the <b>SupplyProtection</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplyProtection> getSupplyProtectionTPIfPresent()
    {
        return Option.of(to_SupplyProtectionTP);
    }

    /**
     * Overwrites the associated <b>SupplyProtection</b> entity for the loaded navigation property
     * <b>_SupplyProtectionTP</b>.
     * 
     * @param value
     *            New <b>SupplyProtection</b> entity.
     */
    public void setSupplyProtectionTP( final SupplyProtection value )
    {
        to_SupplyProtectionTP = value;
    }

    /**
     * Helper class to allow for fluent creation of SupProtCharacteristic instances.
     * 
     */
    public final static class SupProtCharacteristicBuilder
    {

        private SupplyProtection to_SupplyProtectionTP;

        private SupProtCharacteristic.SupProtCharacteristicBuilder to_SupplyProtectionTP( final SupplyProtection value )
        {
            to_SupplyProtectionTP = value;
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionTP</b> for <b>SupProtCharacteristic</b> to single
         * <b>SupplyProtection</b>.
         * 
         * @param value
         *            The SupplyProtection to build this SupProtCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupProtCharacteristic.SupProtCharacteristicBuilder supplyProtectionTP( final SupplyProtection value )
        {
            return to_SupplyProtectionTP(value);
        }

    }

}
