/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplyAvailabilityProtectionPlanService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Supply Availability Protection Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplyProtectionType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SupplyProtection extends VdmEntity<SupplyProtection> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_supavailyprotplan.v0001.A_SupplyProtectionType";
    /**
     * Selector for all available fields of SupplyProtection.
     * 
     */
    public final static SimpleProperty<SupplyProtection> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @return UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionUUID" )
    private UUID supplyProtectionUUID;
    public final static SimpleProperty.Guid<SupplyProtection> SUPPLY_PROTECTION_UUID =
        new SimpleProperty.Guid<SupplyProtection>(SupplyProtection.class, "SupplyProtectionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionName</b>
     * </p>
     * 
     * @return Name
     */
    @Nullable
    @ElementName( "SupplyProtectionName" )
    private java.lang.String supplyProtectionName;
    public final static SimpleProperty.String<SupplyProtection> SUPPLY_PROTECTION_NAME =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupplyProtectionName");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @return Material Number
     */
    @Nullable
    @ElementName( "Material" )
    private java.lang.String material;
    public final static SimpleProperty.String<SupplyProtection> MATERIAL =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     * 
     * @return Material Description
     */
    @Nullable
    @ElementName( "MaterialName" )
    private java.lang.String materialName;
    public final static SimpleProperty.String<SupplyProtection> MATERIAL_NAME =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<SupplyProtection> PLANT =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     * 
     * @return Plant Name
     */
    @Nullable
    @ElementName( "PlantName" )
    private java.lang.String plantName;
    public final static SimpleProperty.String<SupplyProtection> PLANT_NAME =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "PlantName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupProtLifecycleStatus</b>
     * </p>
     * 
     * @return Status
     */
    @Nullable
    @ElementName( "SupProtLifecycleStatus" )
    private java.lang.String supProtLifecycleStatus;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_LIFECYCLE_STATUS =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtLifecycleStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupProtLifecycleStatusText</b>
     * </p>
     * 
     * @return Status
     */
    @Nullable
    @ElementName( "SupProtLifecycleStatusText" )
    private java.lang.String supProtLifecycleStatusText;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_LIFECYCLE_STATUS_TEXT =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtLifecycleStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodType</b>
     * </p>
     * 
     * @return Planning Period Type
     */
    @Nullable
    @ElementName( "SupProtPlanningPeriodType" )
    private java.lang.String supProtPlanningPeriodType;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_PLANNING_PERIOD_TYPE =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtPlanningPeriodType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodTypeText</b>
     * </p>
     * 
     * @return Planning Period Type Text
     */
    @Nullable
    @ElementName( "SupProtPlanningPeriodTypeText" )
    private java.lang.String supProtPlanningPeriodTypeText;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_PLANNING_PERIOD_TYPE_TEXT =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtPlanningPeriodTypeText");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodStartDate</b>
     * </p>
     * 
     * @return Planning Period Start Date
     */
    @Nullable
    @ElementName( "SupProtPlanningPeriodStartDate" )
    private LocalDate supProtPlanningPeriodStartDate;
    public final static SimpleProperty.Date<SupplyProtection> SUP_PROT_PLANNING_PERIOD_START_DATE =
        new SimpleProperty.Date<SupplyProtection>(SupplyProtection.class, "SupProtPlanningPeriodStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodEndDate</b>
     * </p>
     * 
     * @return Planning Period End Date
     */
    @Nullable
    @ElementName( "SupProtPlanningPeriodEndDate" )
    private LocalDate supProtPlanningPeriodEndDate;
    public final static SimpleProperty.Date<SupplyProtection> SUP_PROT_PLANNING_PERIOD_END_DATE =
        new SimpleProperty.Date<SupplyProtection>(SupplyProtection.class, "SupProtPlanningPeriodEndDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtIsPlanningContextSlsOrd</b>
     * </p>
     * 
     * @return Planning Context: Sales Order
     */
    @Nullable
    @ElementName( "SupProtIsPlanningContextSlsOrd" )
    private java.lang.Boolean supProtIsPlanningContextSlsOrd;
    public final static SimpleProperty.Boolean<SupplyProtection> SUP_PROT_IS_PLANNING_CONTEXT_SLS_ORD =
        new SimpleProperty.Boolean<SupplyProtection>(SupplyProtection.class, "SupProtIsPlanningContextSlsOrd");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtIsPlanningContextSTO</b>
     * </p>
     * 
     * @return Planning Context: Stock Transport Order
     */
    @Nullable
    @ElementName( "SupProtIsPlanningContextSTO" )
    private java.lang.Boolean supProtIsPlanningContextSTO;
    public final static SimpleProperty.Boolean<SupplyProtection> SUP_PROT_IS_PLANNING_CONTEXT_STO =
        new SimpleProperty.Boolean<SupplyProtection>(SupplyProtection.class, "SupProtIsPlanningContextSTO");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01Name</b>
     * </p>
     * 
     * @return Characteristic Name
     */
    @Nullable
    @ElementName( "SupProtCoreCharc01Name" )
    private java.lang.String supProtCoreCharc01Name;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC01_NAME =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc01Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CoreCharc01CtlgPathIntID</b>
     * </p>
     * 
     * @return Characteristic Catalog Path Internal ID
     */
    @Nullable
    @ElementName( "CoreCharc01CtlgPathIntID" )
    private byte[] coreCharc01CtlgPathIntID;
    public final static SimpleProperty.Binary<SupplyProtection> CORE_CHARC01_CTLG_PATH_INT_ID =
        new SimpleProperty.Binary<SupplyProtection>(SupplyProtection.class, "CoreCharc01CtlgPathIntID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01Text</b>
     * </p>
     * 
     * @return Characteristic
     */
    @Nullable
    @ElementName( "SupProtCoreCharc01Text" )
    private java.lang.String supProtCoreCharc01Text;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC01_TEXT =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc01Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCoreCharc01ValueID" )
    private java.lang.String supProtCoreCharc01ValueID;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC01_VALUE_ID =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc01ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02Name</b>
     * </p>
     * 
     * @return Characteristic Name
     */
    @Nullable
    @ElementName( "SupProtCoreCharc02Name" )
    private java.lang.String supProtCoreCharc02Name;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC02_NAME =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc02Name");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CoreCharc02CtlgPathIntID</b>
     * </p>
     * 
     * @return Characteristic Catalog Path Internal ID
     */
    @Nullable
    @ElementName( "CoreCharc02CtlgPathIntID" )
    private byte[] coreCharc02CtlgPathIntID;
    public final static SimpleProperty.Binary<SupplyProtection> CORE_CHARC02_CTLG_PATH_INT_ID =
        new SimpleProperty.Binary<SupplyProtection>(SupplyProtection.class, "CoreCharc02CtlgPathIntID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02Text</b>
     * </p>
     * 
     * @return Characteristic
     */
    @Nullable
    @ElementName( "SupProtCoreCharc02Text" )
    private java.lang.String supProtCoreCharc02Text;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC02_TEXT =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc02Text");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCoreCharc02ValueID" )
    private java.lang.String supProtCoreCharc02ValueID;
    public final static SimpleProperty.String<SupplyProtection> SUP_PROT_CORE_CHARC02_VALUE_ID =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "SupProtCoreCharc02ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "UnitOfMeasure" )
    private java.lang.String unitOfMeasure;
    public final static SimpleProperty.String<SupplyProtection> UNIT_OF_MEASURE =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "UnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @return The supProtProtectedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtProtectedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtProtectedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtection> SUP_PROT_PROTECTED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtection>(SupplyProtection.class, "SupProtProtectedQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @return The supProtConsumedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtConsumedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtConsumedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtection> SUP_PROT_CONSUMED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtection>(SupplyProtection.class, "SupProtConsumedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<SupplyProtection> CREATED_BY_USER =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return Created On / At
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<SupplyProtection> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtection>(SupplyProtection.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<SupplyProtection> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "LastChangedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return Changed On / At
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<SupplyProtection> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtection>(SupplyProtection.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     * 
     * @return Supply Protection Characteristic Value Authorization Group
     */
    @Nullable
    @ElementName( "CharcValAuthznGroup" )
    private java.lang.String charcValAuthznGroup;
    public final static SimpleProperty.String<SupplyProtection> CHARC_VAL_AUTHZN_GROUP =
        new SimpleProperty.String<SupplyProtection>(SupplyProtection.class, "CharcValAuthznGroup");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SupplyProtection, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<SupplyProtection, SAP__Message>(
            SupplyProtection.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_SupplyProtectionGroupTP</b> for <b>SupplyProtection</b> to multiple
     * <b>SupplyProtectionGroup</b>.
     * 
     */
    @ElementName( "_SupplyProtectionGroupTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplyProtectionGroup> to_SupplyProtectionGroupTP;
    /**
     * Navigation property <b>_SupProtCharacteristicTP</b> for <b>SupplyProtection</b> to multiple
     * <b>SupProtCharacteristic</b>.
     * 
     */
    @ElementName( "_SupProtCharacteristicTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupProtCharacteristic> to_SupProtCharacteristicTP;
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionGroupTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtection, SupplyProtectionGroup> TO__SUPPLY_PROTECTION_GROUP_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtection, SupplyProtectionGroup>(
            SupplyProtection.class,
            "_SupplyProtectionGroupTP",
            SupplyProtectionGroup.class);
    /**
     * Use with available request builders to apply the <b>_SupProtCharacteristicTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtection, SupProtCharacteristic> TO__SUP_PROT_CHARACTERISTIC_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtection, SupProtCharacteristic>(
            SupplyProtection.class,
            "_SupProtCharacteristicTP",
            SupProtCharacteristic.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SupplyProtection> getType()
    {
        return SupplyProtection.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @param supplyProtectionUUID
     *            UUID
     */
    public void setSupplyProtectionUUID( @Nullable final UUID supplyProtectionUUID )
    {
        rememberChangedField("SupplyProtectionUUID", this.supplyProtectionUUID);
        this.supplyProtectionUUID = supplyProtectionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionName</b>
     * </p>
     * 
     * @param supplyProtectionName
     *            Name
     */
    public void setSupplyProtectionName( @Nullable final java.lang.String supplyProtectionName )
    {
        rememberChangedField("SupplyProtectionName", this.supplyProtectionName);
        this.supplyProtectionName = supplyProtectionName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     * 
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final java.lang.String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     * 
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final java.lang.String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     * 
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final java.lang.String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SupProtLifecycleStatus</b>
     * </p>
     * 
     * @param supProtLifecycleStatus
     *            Status
     */
    public void setSupProtLifecycleStatus( @Nullable final java.lang.String supProtLifecycleStatus )
    {
        rememberChangedField("SupProtLifecycleStatus", this.supProtLifecycleStatus);
        this.supProtLifecycleStatus = supProtLifecycleStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupProtLifecycleStatusText</b>
     * </p>
     * 
     * @param supProtLifecycleStatusText
     *            Status
     */
    public void setSupProtLifecycleStatusText( @Nullable final java.lang.String supProtLifecycleStatusText )
    {
        rememberChangedField("SupProtLifecycleStatusText", this.supProtLifecycleStatusText);
        this.supProtLifecycleStatusText = supProtLifecycleStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodType</b>
     * </p>
     * 
     * @param supProtPlanningPeriodType
     *            Planning Period Type
     */
    public void setSupProtPlanningPeriodType( @Nullable final java.lang.String supProtPlanningPeriodType )
    {
        rememberChangedField("SupProtPlanningPeriodType", this.supProtPlanningPeriodType);
        this.supProtPlanningPeriodType = supProtPlanningPeriodType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodTypeText</b>
     * </p>
     * 
     * @param supProtPlanningPeriodTypeText
     *            Planning Period Type Text
     */
    public void setSupProtPlanningPeriodTypeText( @Nullable final java.lang.String supProtPlanningPeriodTypeText )
    {
        rememberChangedField("SupProtPlanningPeriodTypeText", this.supProtPlanningPeriodTypeText);
        this.supProtPlanningPeriodTypeText = supProtPlanningPeriodTypeText;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodStartDate</b>
     * </p>
     * 
     * @param supProtPlanningPeriodStartDate
     *            Planning Period Start Date
     */
    public void setSupProtPlanningPeriodStartDate( @Nullable final LocalDate supProtPlanningPeriodStartDate )
    {
        rememberChangedField("SupProtPlanningPeriodStartDate", this.supProtPlanningPeriodStartDate);
        this.supProtPlanningPeriodStartDate = supProtPlanningPeriodStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPlanningPeriodEndDate</b>
     * </p>
     * 
     * @param supProtPlanningPeriodEndDate
     *            Planning Period End Date
     */
    public void setSupProtPlanningPeriodEndDate( @Nullable final LocalDate supProtPlanningPeriodEndDate )
    {
        rememberChangedField("SupProtPlanningPeriodEndDate", this.supProtPlanningPeriodEndDate);
        this.supProtPlanningPeriodEndDate = supProtPlanningPeriodEndDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtIsPlanningContextSlsOrd</b>
     * </p>
     * 
     * @param supProtIsPlanningContextSlsOrd
     *            Planning Context: Sales Order
     */
    public void setSupProtIsPlanningContextSlsOrd( @Nullable final java.lang.Boolean supProtIsPlanningContextSlsOrd )
    {
        rememberChangedField("SupProtIsPlanningContextSlsOrd", this.supProtIsPlanningContextSlsOrd);
        this.supProtIsPlanningContextSlsOrd = supProtIsPlanningContextSlsOrd;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtIsPlanningContextSTO</b>
     * </p>
     * 
     * @param supProtIsPlanningContextSTO
     *            Planning Context: Stock Transport Order
     */
    public void setSupProtIsPlanningContextSTO( @Nullable final java.lang.Boolean supProtIsPlanningContextSTO )
    {
        rememberChangedField("SupProtIsPlanningContextSTO", this.supProtIsPlanningContextSTO);
        this.supProtIsPlanningContextSTO = supProtIsPlanningContextSTO;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01Name</b>
     * </p>
     * 
     * @param supProtCoreCharc01Name
     *            Characteristic Name
     */
    public void setSupProtCoreCharc01Name( @Nullable final java.lang.String supProtCoreCharc01Name )
    {
        rememberChangedField("SupProtCoreCharc01Name", this.supProtCoreCharc01Name);
        this.supProtCoreCharc01Name = supProtCoreCharc01Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CoreCharc01CtlgPathIntID</b>
     * </p>
     * 
     * @param coreCharc01CtlgPathIntID
     *            Characteristic Catalog Path Internal ID
     */
    public void setCoreCharc01CtlgPathIntID( @Nullable final byte[] coreCharc01CtlgPathIntID )
    {
        rememberChangedField("CoreCharc01CtlgPathIntID", this.coreCharc01CtlgPathIntID);
        this.coreCharc01CtlgPathIntID = coreCharc01CtlgPathIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01Text</b>
     * </p>
     * 
     * @param supProtCoreCharc01Text
     *            Characteristic
     */
    public void setSupProtCoreCharc01Text( @Nullable final java.lang.String supProtCoreCharc01Text )
    {
        rememberChangedField("SupProtCoreCharc01Text", this.supProtCoreCharc01Text);
        this.supProtCoreCharc01Text = supProtCoreCharc01Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc01ValueID</b>
     * </p>
     * 
     * @param supProtCoreCharc01ValueID
     *            Characteristic Value
     */
    public void setSupProtCoreCharc01ValueID( @Nullable final java.lang.String supProtCoreCharc01ValueID )
    {
        rememberChangedField("SupProtCoreCharc01ValueID", this.supProtCoreCharc01ValueID);
        this.supProtCoreCharc01ValueID = supProtCoreCharc01ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02Name</b>
     * </p>
     * 
     * @param supProtCoreCharc02Name
     *            Characteristic Name
     */
    public void setSupProtCoreCharc02Name( @Nullable final java.lang.String supProtCoreCharc02Name )
    {
        rememberChangedField("SupProtCoreCharc02Name", this.supProtCoreCharc02Name);
        this.supProtCoreCharc02Name = supProtCoreCharc02Name;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CoreCharc02CtlgPathIntID</b>
     * </p>
     * 
     * @param coreCharc02CtlgPathIntID
     *            Characteristic Catalog Path Internal ID
     */
    public void setCoreCharc02CtlgPathIntID( @Nullable final byte[] coreCharc02CtlgPathIntID )
    {
        rememberChangedField("CoreCharc02CtlgPathIntID", this.coreCharc02CtlgPathIntID);
        this.coreCharc02CtlgPathIntID = coreCharc02CtlgPathIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02Text</b>
     * </p>
     * 
     * @param supProtCoreCharc02Text
     *            Characteristic
     */
    public void setSupProtCoreCharc02Text( @Nullable final java.lang.String supProtCoreCharc02Text )
    {
        rememberChangedField("SupProtCoreCharc02Text", this.supProtCoreCharc02Text);
        this.supProtCoreCharc02Text = supProtCoreCharc02Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCoreCharc02ValueID</b>
     * </p>
     * 
     * @param supProtCoreCharc02ValueID
     *            Characteristic Value
     */
    public void setSupProtCoreCharc02ValueID( @Nullable final java.lang.String supProtCoreCharc02ValueID )
    {
        rememberChangedField("SupProtCoreCharc02ValueID", this.supProtCoreCharc02ValueID);
        this.supProtCoreCharc02ValueID = supProtCoreCharc02ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final java.lang.String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @param supProtProtectedQuantity
     *            The supProtProtectedQuantity to set.
     */
    public void setSupProtProtectedQuantity( @Nullable final BigDecimal supProtProtectedQuantity )
    {
        rememberChangedField("SupProtProtectedQuantity", this.supProtProtectedQuantity);
        this.supProtProtectedQuantity = supProtProtectedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @param supProtConsumedQuantity
     *            The supProtConsumedQuantity to set.
     */
    public void setSupProtConsumedQuantity( @Nullable final BigDecimal supProtConsumedQuantity )
    {
        rememberChangedField("SupProtConsumedQuantity", this.supProtConsumedQuantity);
        this.supProtConsumedQuantity = supProtConsumedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            Created On / At
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            Changed On / At
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     * 
     * @param charcValAuthznGroup
     *            Supply Protection Characteristic Value Authorization Group
     */
    public void setCharcValAuthznGroup( @Nullable final java.lang.String charcValAuthznGroup )
    {
        rememberChangedField("CharcValAuthznGroup", this.charcValAuthznGroup);
        this.charcValAuthznGroup = charcValAuthznGroup;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_SupplyProtection";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SupplyProtectionUUID", getSupplyProtectionUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SupplyProtectionUUID", getSupplyProtectionUUID());
        values.put("SupplyProtectionName", getSupplyProtectionName());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("Plant", getPlant());
        values.put("PlantName", getPlantName());
        values.put("SupProtLifecycleStatus", getSupProtLifecycleStatus());
        values.put("SupProtLifecycleStatusText", getSupProtLifecycleStatusText());
        values.put("SupProtPlanningPeriodType", getSupProtPlanningPeriodType());
        values.put("SupProtPlanningPeriodTypeText", getSupProtPlanningPeriodTypeText());
        values.put("SupProtPlanningPeriodStartDate", getSupProtPlanningPeriodStartDate());
        values.put("SupProtPlanningPeriodEndDate", getSupProtPlanningPeriodEndDate());
        values.put("SupProtIsPlanningContextSlsOrd", getSupProtIsPlanningContextSlsOrd());
        values.put("SupProtIsPlanningContextSTO", getSupProtIsPlanningContextSTO());
        values.put("SupProtCoreCharc01Name", getSupProtCoreCharc01Name());
        values.put("CoreCharc01CtlgPathIntID", getCoreCharc01CtlgPathIntID());
        values.put("SupProtCoreCharc01Text", getSupProtCoreCharc01Text());
        values.put("SupProtCoreCharc01ValueID", getSupProtCoreCharc01ValueID());
        values.put("SupProtCoreCharc02Name", getSupProtCoreCharc02Name());
        values.put("CoreCharc02CtlgPathIntID", getCoreCharc02CtlgPathIntID());
        values.put("SupProtCoreCharc02Text", getSupProtCoreCharc02Text());
        values.put("SupProtCoreCharc02ValueID", getSupProtCoreCharc02ValueID());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("SupProtProtectedQuantity", getSupProtProtectedQuantity());
        values.put("SupProtConsumedQuantity", getSupProtConsumedQuantity());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CharcValAuthznGroup", getCharcValAuthznGroup());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplyProtectionUUID") ) {
                final Object value = values.remove("SupplyProtectionUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionUUID())) ) {
                    setSupplyProtectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplyProtectionName") ) {
                final Object value = values.remove("SupplyProtectionName");
                if( (value == null) || (!value.equals(getSupplyProtectionName())) ) {
                    setSupplyProtectionName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtLifecycleStatus") ) {
                final Object value = values.remove("SupProtLifecycleStatus");
                if( (value == null) || (!value.equals(getSupProtLifecycleStatus())) ) {
                    setSupProtLifecycleStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtLifecycleStatusText") ) {
                final Object value = values.remove("SupProtLifecycleStatusText");
                if( (value == null) || (!value.equals(getSupProtLifecycleStatusText())) ) {
                    setSupProtLifecycleStatusText(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtPlanningPeriodType") ) {
                final Object value = values.remove("SupProtPlanningPeriodType");
                if( (value == null) || (!value.equals(getSupProtPlanningPeriodType())) ) {
                    setSupProtPlanningPeriodType(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtPlanningPeriodTypeText") ) {
                final Object value = values.remove("SupProtPlanningPeriodTypeText");
                if( (value == null) || (!value.equals(getSupProtPlanningPeriodTypeText())) ) {
                    setSupProtPlanningPeriodTypeText(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtPlanningPeriodStartDate") ) {
                final Object value = values.remove("SupProtPlanningPeriodStartDate");
                if( (value == null) || (!value.equals(getSupProtPlanningPeriodStartDate())) ) {
                    setSupProtPlanningPeriodStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("SupProtPlanningPeriodEndDate") ) {
                final Object value = values.remove("SupProtPlanningPeriodEndDate");
                if( (value == null) || (!value.equals(getSupProtPlanningPeriodEndDate())) ) {
                    setSupProtPlanningPeriodEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("SupProtIsPlanningContextSlsOrd") ) {
                final Object value = values.remove("SupProtIsPlanningContextSlsOrd");
                if( (value == null) || (!value.equals(getSupProtIsPlanningContextSlsOrd())) ) {
                    setSupProtIsPlanningContextSlsOrd(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SupProtIsPlanningContextSTO") ) {
                final Object value = values.remove("SupProtIsPlanningContextSTO");
                if( (value == null) || (!value.equals(getSupProtIsPlanningContextSTO())) ) {
                    setSupProtIsPlanningContextSTO(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc01Name") ) {
                final Object value = values.remove("SupProtCoreCharc01Name");
                if( (value == null) || (!value.equals(getSupProtCoreCharc01Name())) ) {
                    setSupProtCoreCharc01Name(((java.lang.String) value));
                }
            }
            if( values.containsKey("CoreCharc01CtlgPathIntID") ) {
                final Object value = values.remove("CoreCharc01CtlgPathIntID");
                if( (value == null) || (!value.equals(getCoreCharc01CtlgPathIntID())) ) {
                    setCoreCharc01CtlgPathIntID(((byte[]) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc01Text") ) {
                final Object value = values.remove("SupProtCoreCharc01Text");
                if( (value == null) || (!value.equals(getSupProtCoreCharc01Text())) ) {
                    setSupProtCoreCharc01Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc01ValueID") ) {
                final Object value = values.remove("SupProtCoreCharc01ValueID");
                if( (value == null) || (!value.equals(getSupProtCoreCharc01ValueID())) ) {
                    setSupProtCoreCharc01ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc02Name") ) {
                final Object value = values.remove("SupProtCoreCharc02Name");
                if( (value == null) || (!value.equals(getSupProtCoreCharc02Name())) ) {
                    setSupProtCoreCharc02Name(((java.lang.String) value));
                }
            }
            if( values.containsKey("CoreCharc02CtlgPathIntID") ) {
                final Object value = values.remove("CoreCharc02CtlgPathIntID");
                if( (value == null) || (!value.equals(getCoreCharc02CtlgPathIntID())) ) {
                    setCoreCharc02CtlgPathIntID(((byte[]) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc02Text") ) {
                final Object value = values.remove("SupProtCoreCharc02Text");
                if( (value == null) || (!value.equals(getSupProtCoreCharc02Text())) ) {
                    setSupProtCoreCharc02Text(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCoreCharc02ValueID") ) {
                final Object value = values.remove("SupProtCoreCharc02ValueID");
                if( (value == null) || (!value.equals(getSupProtCoreCharc02ValueID())) ) {
                    setSupProtCoreCharc02ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtProtectedQuantity") ) {
                final Object value = values.remove("SupProtProtectedQuantity");
                if( (value == null) || (!value.equals(getSupProtProtectedQuantity())) ) {
                    setSupProtProtectedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupProtConsumedQuantity") ) {
                final Object value = values.remove("SupProtConsumedQuantity");
                if( (value == null) || (!value.equals(getSupProtConsumedQuantity())) ) {
                    setSupProtConsumedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CharcValAuthznGroup") ) {
                final Object value = values.remove("CharcValAuthznGroup");
                if( (value == null) || (!value.equals(getCharcValAuthznGroup())) ) {
                    setCharcValAuthznGroup(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_SupplyProtectionGroupTP") ) {
                final Object value = (values).remove("_SupplyProtectionGroupTP");
                if( value instanceof Iterable ) {
                    if( to_SupplyProtectionGroupTP == null ) {
                        to_SupplyProtectionGroupTP = Lists.newArrayList();
                    } else {
                        to_SupplyProtectionGroupTP = Lists.newArrayList(to_SupplyProtectionGroupTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplyProtectionGroup entity;
                        if( to_SupplyProtectionGroupTP.size() > i ) {
                            entity = to_SupplyProtectionGroupTP.get(i);
                        } else {
                            entity = new SupplyProtectionGroup();
                            to_SupplyProtectionGroupTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SupProtCharacteristicTP") ) {
                final Object value = (values).remove("_SupProtCharacteristicTP");
                if( value instanceof Iterable ) {
                    if( to_SupProtCharacteristicTP == null ) {
                        to_SupProtCharacteristicTP = Lists.newArrayList();
                    } else {
                        to_SupProtCharacteristicTP = Lists.newArrayList(to_SupProtCharacteristicTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupProtCharacteristic entity;
                        if( to_SupProtCharacteristicTP.size() > i ) {
                            entity = to_SupProtCharacteristicTP.get(i);
                        } else {
                            entity = new SupProtCharacteristic();
                            to_SupProtCharacteristicTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SupplyAvailabilityProtectionPlanService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SupplyProtectionGroupTP != null ) {
            (values).put("_SupplyProtectionGroupTP", to_SupplyProtectionGroupTP);
        }
        if( to_SupProtCharacteristicTP != null ) {
            (values).put("_SupProtCharacteristicTP", to_SupProtCharacteristicTP);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SupplyProtectionGroup</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SupplyProtectionGroupTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtection</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionGroupTP</b> is already loaded, the result
     *         will contain the <b>SupplyProtectionGroup</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplyProtectionGroup>> getSupplyProtectionGroupTPIfPresent()
    {
        return Option.of(to_SupplyProtectionGroupTP);
    }

    /**
     * Overwrites the list of associated <b>SupplyProtectionGroup</b> entities for the loaded navigation property
     * <b>_SupplyProtectionGroupTP</b>.
     * <p>
     * If the navigation property <b>_SupplyProtectionGroupTP</b> of a queried <b>SupplyProtection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SupplyProtectionGroup</b> entities.
     */
    public void setSupplyProtectionGroupTP( @Nonnull final List<SupplyProtectionGroup> value )
    {
        if( to_SupplyProtectionGroupTP == null ) {
            to_SupplyProtectionGroupTP = Lists.newArrayList();
        }
        to_SupplyProtectionGroupTP.clear();
        to_SupplyProtectionGroupTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplyProtectionGroup</b> entities. This corresponds to the OData
     * navigation property <b>_SupplyProtectionGroupTP</b>.
     * <p>
     * If the navigation property <b>_SupplyProtectionGroupTP</b> of a queried <b>SupplyProtection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SupplyProtectionGroup</b> entities.
     */
    public void addSupplyProtectionGroupTP( SupplyProtectionGroup... entity )
    {
        if( to_SupplyProtectionGroupTP == null ) {
            to_SupplyProtectionGroupTP = Lists.newArrayList();
        }
        to_SupplyProtectionGroupTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SupProtCharacteristic</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SupProtCharacteristicTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtection</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupProtCharacteristicTP</b> is already loaded, the result
     *         will contain the <b>SupProtCharacteristic</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupProtCharacteristic>> getSupProtCharacteristicTPIfPresent()
    {
        return Option.of(to_SupProtCharacteristicTP);
    }

    /**
     * Overwrites the list of associated <b>SupProtCharacteristic</b> entities for the loaded navigation property
     * <b>_SupProtCharacteristicTP</b>.
     * <p>
     * If the navigation property <b>_SupProtCharacteristicTP</b> of a queried <b>SupplyProtection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SupProtCharacteristic</b> entities.
     */
    public void setSupProtCharacteristicTP( @Nonnull final List<SupProtCharacteristic> value )
    {
        if( to_SupProtCharacteristicTP == null ) {
            to_SupProtCharacteristicTP = Lists.newArrayList();
        }
        to_SupProtCharacteristicTP.clear();
        to_SupProtCharacteristicTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupProtCharacteristic</b> entities. This corresponds to the OData
     * navigation property <b>_SupProtCharacteristicTP</b>.
     * <p>
     * If the navigation property <b>_SupProtCharacteristicTP</b> of a queried <b>SupplyProtection</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SupProtCharacteristic</b> entities.
     */
    public void addSupProtCharacteristicTP( SupProtCharacteristic... entity )
    {
        if( to_SupProtCharacteristicTP == null ) {
            to_SupProtCharacteristicTP = Lists.newArrayList();
        }
        to_SupProtCharacteristicTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SupplyProtection instances.
     * 
     */
    public final static class SupplyProtectionBuilder
    {

        private List<SupplyProtectionGroup> to_SupplyProtectionGroupTP = Lists.newArrayList();
        private List<SupProtCharacteristic> to_SupProtCharacteristicTP = Lists.newArrayList();

        private SupplyProtection.SupplyProtectionBuilder to_SupplyProtectionGroupTP(
            final List<SupplyProtectionGroup> value )
        {
            to_SupplyProtectionGroupTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionGroupTP</b> for <b>SupplyProtection</b> to multiple
         * <b>SupplyProtectionGroup</b>.
         * 
         * @param value
         *            The SupplyProtectionGroups to build this SupplyProtection with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtection.SupplyProtectionBuilder supplyProtectionGroupTP( SupplyProtectionGroup... value )
        {
            return to_SupplyProtectionGroupTP(Lists.newArrayList(value));
        }

        private SupplyProtection.SupplyProtectionBuilder to_SupProtCharacteristicTP(
            final List<SupProtCharacteristic> value )
        {
            to_SupProtCharacteristicTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SupProtCharacteristicTP</b> for <b>SupplyProtection</b> to multiple
         * <b>SupProtCharacteristic</b>.
         * 
         * @param value
         *            The SupProtCharacteristics to build this SupplyProtection with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtection.SupplyProtectionBuilder supProtCharacteristicTP( SupProtCharacteristic... value )
        {
            return to_SupProtCharacteristicTP(Lists.newArrayList(value));
        }

    }

}
