/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplyAvailabilityProtectionPlanService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Protection Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplyProtectionGroupType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SupplyProtectionGroup extends VdmEntity<SupplyProtectionGroup> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_supavailyprotplan.v0001.A_SupplyProtectionGroupType";
    /**
     * Selector for all available fields of SupplyProtectionGroup.
     * 
     */
    public final static SimpleProperty<SupplyProtectionGroup> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionGroupUUID</b>
     * </p>
     * 
     * @return Characteristic Value Combination UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionGroupUUID" )
    private UUID supplyProtectionGroupUUID;
    public final static SimpleProperty.Guid<SupplyProtectionGroup> SUPPLY_PROTECTION_GROUP_UUID =
        new SimpleProperty.Guid<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupplyProtectionGroupUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @return UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionUUID" )
    private UUID supplyProtectionUUID;
    public final static SimpleProperty.Guid<SupplyProtectionGroup> SUPPLY_PROTECTION_UUID =
        new SimpleProperty.Guid<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupplyProtectionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc01ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc01ValueID" )
    private java.lang.String supProtCharc01ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC01_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc01ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc02ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc02ValueID" )
    private java.lang.String supProtCharc02ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC02_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc02ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc03ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc03ValueID" )
    private java.lang.String supProtCharc03ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC03_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc03ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc04ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc04ValueID" )
    private java.lang.String supProtCharc04ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC04_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc04ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc05ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc05ValueID" )
    private java.lang.String supProtCharc05ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC05_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc05ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc06ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc06ValueID" )
    private java.lang.String supProtCharc06ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC06_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc06ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc07ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc07ValueID" )
    private java.lang.String supProtCharc07ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC07_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc07ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc08ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc08ValueID" )
    private java.lang.String supProtCharc08ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC08_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc08ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc09ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc09ValueID" )
    private java.lang.String supProtCharc09ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC09_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc09ValueID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc10ValueID</b>
     * </p>
     * 
     * @return Characteristic Value
     */
    @Nullable
    @ElementName( "SupProtCharc10ValueID" )
    private java.lang.String supProtCharc10ValueID;
    public final static SimpleProperty.String<SupplyProtectionGroup> SUP_PROT_CHARC10_VALUE_ID =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "SupProtCharc10ValueID");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtGroupPriorityValue</b>
     * </p>
     * 
     * @return Priority
     */
    @Nullable
    @ElementName( "SupProtGroupPriorityValue" )
    private Integer supProtGroupPriorityValue;
    public final static SimpleProperty.NumericInteger<SupplyProtectionGroup> SUP_PROT_GROUP_PRIORITY_VALUE =
        new SimpleProperty.NumericInteger<SupplyProtectionGroup>(
            SupplyProtectionGroup.class,
            "SupProtGroupPriorityValue");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<SupplyProtectionGroup> CREATED_BY_USER =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return Created On / At
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionGroup> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionGroup>(SupplyProtectionGroup.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<SupplyProtectionGroup> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "LastChangedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return Changed On / At
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionGroup> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionGroup>(SupplyProtectionGroup.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     * 
     * @return Supply Protection Characteristic Value Authorization Group
     */
    @Nullable
    @ElementName( "CharcValAuthznGroup" )
    private java.lang.String charcValAuthznGroup;
    public final static SimpleProperty.String<SupplyProtectionGroup> CHARC_VAL_AUTHZN_GROUP =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "CharcValAuthznGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "UnitOfMeasure" )
    private java.lang.String unitOfMeasure;
    public final static SimpleProperty.String<SupplyProtectionGroup> UNIT_OF_MEASURE =
        new SimpleProperty.String<SupplyProtectionGroup>(SupplyProtectionGroup.class, "UnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @return The supProtProtectedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtProtectedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtProtectedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtectionGroup> SUP_PROT_PROTECTED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtectionGroup>(
            SupplyProtectionGroup.class,
            "SupProtProtectedQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @return The supProtConsumedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtConsumedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtConsumedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtectionGroup> SUP_PROT_CONSUMED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtectionGroup>(
            SupplyProtectionGroup.class,
            "SupProtConsumedQuantity");
    /**
     * Navigation property <b>_SupplyProtectionTimeBucketTP</b> for <b>SupplyProtectionGroup</b> to multiple
     * <b>SupplyProtectionTimeBucket</b>.
     * 
     */
    @ElementName( "_SupplyProtectionTimeBucketTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplyProtectionTimeBucket> to_SupplyProtectionTimeBucketTP;
    /**
     * Navigation property <b>_SupplyProtectionTP</b> for <b>SupplyProtectionGroup</b> to single
     * <b>SupplyProtection</b>.
     * 
     */
    @ElementName( "_SupplyProtectionTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplyProtection to_SupplyProtectionTP;
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionTimeBucketTP</b> navigation property to
     * query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtectionGroup, SupplyProtectionTimeBucket> TO__SUPPLY_PROTECTION_TIME_BUCKET_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SupplyProtectionGroup, SupplyProtectionTimeBucket>(
            SupplyProtectionGroup.class,
            "_SupplyProtectionTimeBucketTP",
            SupplyProtectionTimeBucket.class);
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionGroup, SupplyProtection> TO__SUPPLY_PROTECTION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionGroup, SupplyProtection>(
            SupplyProtectionGroup.class,
            "_SupplyProtectionTP",
            SupplyProtection.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SupplyProtectionGroup> getType()
    {
        return SupplyProtectionGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionGroupUUID</b>
     * </p>
     * 
     * @param supplyProtectionGroupUUID
     *            Characteristic Value Combination UUID
     */
    public void setSupplyProtectionGroupUUID( @Nullable final UUID supplyProtectionGroupUUID )
    {
        rememberChangedField("SupplyProtectionGroupUUID", this.supplyProtectionGroupUUID);
        this.supplyProtectionGroupUUID = supplyProtectionGroupUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @param supplyProtectionUUID
     *            UUID
     */
    public void setSupplyProtectionUUID( @Nullable final UUID supplyProtectionUUID )
    {
        rememberChangedField("SupplyProtectionUUID", this.supplyProtectionUUID);
        this.supplyProtectionUUID = supplyProtectionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc01ValueID</b>
     * </p>
     * 
     * @param supProtCharc01ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc01ValueID( @Nullable final java.lang.String supProtCharc01ValueID )
    {
        rememberChangedField("SupProtCharc01ValueID", this.supProtCharc01ValueID);
        this.supProtCharc01ValueID = supProtCharc01ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc02ValueID</b>
     * </p>
     * 
     * @param supProtCharc02ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc02ValueID( @Nullable final java.lang.String supProtCharc02ValueID )
    {
        rememberChangedField("SupProtCharc02ValueID", this.supProtCharc02ValueID);
        this.supProtCharc02ValueID = supProtCharc02ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc03ValueID</b>
     * </p>
     * 
     * @param supProtCharc03ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc03ValueID( @Nullable final java.lang.String supProtCharc03ValueID )
    {
        rememberChangedField("SupProtCharc03ValueID", this.supProtCharc03ValueID);
        this.supProtCharc03ValueID = supProtCharc03ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc04ValueID</b>
     * </p>
     * 
     * @param supProtCharc04ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc04ValueID( @Nullable final java.lang.String supProtCharc04ValueID )
    {
        rememberChangedField("SupProtCharc04ValueID", this.supProtCharc04ValueID);
        this.supProtCharc04ValueID = supProtCharc04ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc05ValueID</b>
     * </p>
     * 
     * @param supProtCharc05ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc05ValueID( @Nullable final java.lang.String supProtCharc05ValueID )
    {
        rememberChangedField("SupProtCharc05ValueID", this.supProtCharc05ValueID);
        this.supProtCharc05ValueID = supProtCharc05ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc06ValueID</b>
     * </p>
     * 
     * @param supProtCharc06ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc06ValueID( @Nullable final java.lang.String supProtCharc06ValueID )
    {
        rememberChangedField("SupProtCharc06ValueID", this.supProtCharc06ValueID);
        this.supProtCharc06ValueID = supProtCharc06ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc07ValueID</b>
     * </p>
     * 
     * @param supProtCharc07ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc07ValueID( @Nullable final java.lang.String supProtCharc07ValueID )
    {
        rememberChangedField("SupProtCharc07ValueID", this.supProtCharc07ValueID);
        this.supProtCharc07ValueID = supProtCharc07ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc08ValueID</b>
     * </p>
     * 
     * @param supProtCharc08ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc08ValueID( @Nullable final java.lang.String supProtCharc08ValueID )
    {
        rememberChangedField("SupProtCharc08ValueID", this.supProtCharc08ValueID);
        this.supProtCharc08ValueID = supProtCharc08ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc09ValueID</b>
     * </p>
     * 
     * @param supProtCharc09ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc09ValueID( @Nullable final java.lang.String supProtCharc09ValueID )
    {
        rememberChangedField("SupProtCharc09ValueID", this.supProtCharc09ValueID);
        this.supProtCharc09ValueID = supProtCharc09ValueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SupProtCharc10ValueID</b>
     * </p>
     * 
     * @param supProtCharc10ValueID
     *            Characteristic Value
     */
    public void setSupProtCharc10ValueID( @Nullable final java.lang.String supProtCharc10ValueID )
    {
        rememberChangedField("SupProtCharc10ValueID", this.supProtCharc10ValueID);
        this.supProtCharc10ValueID = supProtCharc10ValueID;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtGroupPriorityValue</b>
     * </p>
     * 
     * @param supProtGroupPriorityValue
     *            Priority
     */
    public void setSupProtGroupPriorityValue( @Nullable final Integer supProtGroupPriorityValue )
    {
        rememberChangedField("SupProtGroupPriorityValue", this.supProtGroupPriorityValue);
        this.supProtGroupPriorityValue = supProtGroupPriorityValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            Created On / At
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            Changed On / At
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CharcValAuthznGroup</b>
     * </p>
     * 
     * @param charcValAuthznGroup
     *            Supply Protection Characteristic Value Authorization Group
     */
    public void setCharcValAuthznGroup( @Nullable final java.lang.String charcValAuthznGroup )
    {
        rememberChangedField("CharcValAuthznGroup", this.charcValAuthznGroup);
        this.charcValAuthznGroup = charcValAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final java.lang.String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @param supProtProtectedQuantity
     *            The supProtProtectedQuantity to set.
     */
    public void setSupProtProtectedQuantity( @Nullable final BigDecimal supProtProtectedQuantity )
    {
        rememberChangedField("SupProtProtectedQuantity", this.supProtProtectedQuantity);
        this.supProtProtectedQuantity = supProtProtectedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @param supProtConsumedQuantity
     *            The supProtConsumedQuantity to set.
     */
    public void setSupProtConsumedQuantity( @Nullable final BigDecimal supProtConsumedQuantity )
    {
        rememberChangedField("SupProtConsumedQuantity", this.supProtConsumedQuantity);
        this.supProtConsumedQuantity = supProtConsumedQuantity;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_SupplyProtectionGroup";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SupplyProtectionGroupUUID", getSupplyProtectionGroupUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SupplyProtectionGroupUUID", getSupplyProtectionGroupUUID());
        values.put("SupplyProtectionUUID", getSupplyProtectionUUID());
        values.put("SupProtCharc01ValueID", getSupProtCharc01ValueID());
        values.put("SupProtCharc02ValueID", getSupProtCharc02ValueID());
        values.put("SupProtCharc03ValueID", getSupProtCharc03ValueID());
        values.put("SupProtCharc04ValueID", getSupProtCharc04ValueID());
        values.put("SupProtCharc05ValueID", getSupProtCharc05ValueID());
        values.put("SupProtCharc06ValueID", getSupProtCharc06ValueID());
        values.put("SupProtCharc07ValueID", getSupProtCharc07ValueID());
        values.put("SupProtCharc08ValueID", getSupProtCharc08ValueID());
        values.put("SupProtCharc09ValueID", getSupProtCharc09ValueID());
        values.put("SupProtCharc10ValueID", getSupProtCharc10ValueID());
        values.put("SupProtGroupPriorityValue", getSupProtGroupPriorityValue());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CharcValAuthznGroup", getCharcValAuthznGroup());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("SupProtProtectedQuantity", getSupProtProtectedQuantity());
        values.put("SupProtConsumedQuantity", getSupProtConsumedQuantity());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupplyProtectionGroupUUID") ) {
                final Object value = values.remove("SupplyProtectionGroupUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionGroupUUID())) ) {
                    setSupplyProtectionGroupUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplyProtectionUUID") ) {
                final Object value = values.remove("SupplyProtectionUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionUUID())) ) {
                    setSupplyProtectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupProtCharc01ValueID") ) {
                final Object value = values.remove("SupProtCharc01ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc01ValueID())) ) {
                    setSupProtCharc01ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc02ValueID") ) {
                final Object value = values.remove("SupProtCharc02ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc02ValueID())) ) {
                    setSupProtCharc02ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc03ValueID") ) {
                final Object value = values.remove("SupProtCharc03ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc03ValueID())) ) {
                    setSupProtCharc03ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc04ValueID") ) {
                final Object value = values.remove("SupProtCharc04ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc04ValueID())) ) {
                    setSupProtCharc04ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc05ValueID") ) {
                final Object value = values.remove("SupProtCharc05ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc05ValueID())) ) {
                    setSupProtCharc05ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc06ValueID") ) {
                final Object value = values.remove("SupProtCharc06ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc06ValueID())) ) {
                    setSupProtCharc06ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc07ValueID") ) {
                final Object value = values.remove("SupProtCharc07ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc07ValueID())) ) {
                    setSupProtCharc07ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc08ValueID") ) {
                final Object value = values.remove("SupProtCharc08ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc08ValueID())) ) {
                    setSupProtCharc08ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc09ValueID") ) {
                final Object value = values.remove("SupProtCharc09ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc09ValueID())) ) {
                    setSupProtCharc09ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtCharc10ValueID") ) {
                final Object value = values.remove("SupProtCharc10ValueID");
                if( (value == null) || (!value.equals(getSupProtCharc10ValueID())) ) {
                    setSupProtCharc10ValueID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtGroupPriorityValue") ) {
                final Object value = values.remove("SupProtGroupPriorityValue");
                if( (value == null) || (!value.equals(getSupProtGroupPriorityValue())) ) {
                    setSupProtGroupPriorityValue(((Integer) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("CharcValAuthznGroup") ) {
                final Object value = values.remove("CharcValAuthznGroup");
                if( (value == null) || (!value.equals(getCharcValAuthznGroup())) ) {
                    setCharcValAuthznGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtProtectedQuantity") ) {
                final Object value = values.remove("SupProtProtectedQuantity");
                if( (value == null) || (!value.equals(getSupProtProtectedQuantity())) ) {
                    setSupProtProtectedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupProtConsumedQuantity") ) {
                final Object value = values.remove("SupProtConsumedQuantity");
                if( (value == null) || (!value.equals(getSupProtConsumedQuantity())) ) {
                    setSupProtConsumedQuantity(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SupplyProtectionTimeBucketTP") ) {
                final Object value = (values).remove("_SupplyProtectionTimeBucketTP");
                if( value instanceof Iterable ) {
                    if( to_SupplyProtectionTimeBucketTP == null ) {
                        to_SupplyProtectionTimeBucketTP = Lists.newArrayList();
                    } else {
                        to_SupplyProtectionTimeBucketTP = Lists.newArrayList(to_SupplyProtectionTimeBucketTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplyProtectionTimeBucket entity;
                        if( to_SupplyProtectionTimeBucketTP.size() > i ) {
                            entity = to_SupplyProtectionTimeBucketTP.get(i);
                        } else {
                            entity = new SupplyProtectionTimeBucket();
                            to_SupplyProtectionTimeBucketTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SupplyProtectionTP") ) {
                final Object value = (values).remove("_SupplyProtectionTP");
                if( value instanceof Map ) {
                    if( to_SupplyProtectionTP == null ) {
                        to_SupplyProtectionTP = new SupplyProtection();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SupplyProtectionTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SupplyAvailabilityProtectionPlanService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SupplyProtectionTimeBucketTP != null ) {
            (values).put("_SupplyProtectionTimeBucketTP", to_SupplyProtectionTimeBucketTP);
        }
        if( to_SupplyProtectionTP != null ) {
            (values).put("_SupplyProtectionTP", to_SupplyProtectionTP);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SupplyProtectionTimeBucket</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SupplyProtectionTimeBucketTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtectionGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionTimeBucketTP</b> is already loaded, the
     *         result will contain the <b>SupplyProtectionTimeBucket</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplyProtectionTimeBucket>> getSupplyProtectionTimeBucketTPIfPresent()
    {
        return Option.of(to_SupplyProtectionTimeBucketTP);
    }

    /**
     * Overwrites the list of associated <b>SupplyProtectionTimeBucket</b> entities for the loaded navigation property
     * <b>_SupplyProtectionTimeBucketTP</b>.
     * <p>
     * If the navigation property <b>_SupplyProtectionTimeBucketTP</b> of a queried <b>SupplyProtectionGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SupplyProtectionTimeBucket</b> entities.
     */
    public void setSupplyProtectionTimeBucketTP( @Nonnull final List<SupplyProtectionTimeBucket> value )
    {
        if( to_SupplyProtectionTimeBucketTP == null ) {
            to_SupplyProtectionTimeBucketTP = Lists.newArrayList();
        }
        to_SupplyProtectionTimeBucketTP.clear();
        to_SupplyProtectionTimeBucketTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplyProtectionTimeBucket</b> entities. This corresponds to the OData
     * navigation property <b>_SupplyProtectionTimeBucketTP</b>.
     * <p>
     * If the navigation property <b>_SupplyProtectionTimeBucketTP</b> of a queried <b>SupplyProtectionGroup</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SupplyProtectionTimeBucket</b> entities.
     */
    public void addSupplyProtectionTimeBucketTP( SupplyProtectionTimeBucket... entity )
    {
        if( to_SupplyProtectionTimeBucketTP == null ) {
            to_SupplyProtectionTimeBucketTP = Lists.newArrayList();
        }
        to_SupplyProtectionTimeBucketTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SupplyProtection</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SupplyProtectionTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtectionGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionTP</b> is already loaded, the result will
     *         contain the <b>SupplyProtection</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplyProtection> getSupplyProtectionTPIfPresent()
    {
        return Option.of(to_SupplyProtectionTP);
    }

    /**
     * Overwrites the associated <b>SupplyProtection</b> entity for the loaded navigation property
     * <b>_SupplyProtectionTP</b>.
     * 
     * @param value
     *            New <b>SupplyProtection</b> entity.
     */
    public void setSupplyProtectionTP( final SupplyProtection value )
    {
        to_SupplyProtectionTP = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplyProtectionGroup instances.
     * 
     */
    public final static class SupplyProtectionGroupBuilder
    {

        private List<SupplyProtectionTimeBucket> to_SupplyProtectionTimeBucketTP = Lists.newArrayList();
        private SupplyProtection to_SupplyProtectionTP;

        private SupplyProtectionGroup.SupplyProtectionGroupBuilder to_SupplyProtectionTimeBucketTP(
            final List<SupplyProtectionTimeBucket> value )
        {
            to_SupplyProtectionTimeBucketTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionTimeBucketTP</b> for <b>SupplyProtectionGroup</b> to multiple
         * <b>SupplyProtectionTimeBucket</b>.
         * 
         * @param value
         *            The SupplyProtectionTimeBuckets to build this SupplyProtectionGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtectionGroup.SupplyProtectionGroupBuilder supplyProtectionTimeBucketTP(
            SupplyProtectionTimeBucket... value )
        {
            return to_SupplyProtectionTimeBucketTP(Lists.newArrayList(value));
        }

        private SupplyProtectionGroup.SupplyProtectionGroupBuilder to_SupplyProtectionTP( final SupplyProtection value )
        {
            to_SupplyProtectionTP = value;
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionTP</b> for <b>SupplyProtectionGroup</b> to single
         * <b>SupplyProtection</b>.
         * 
         * @param value
         *            The SupplyProtection to build this SupplyProtectionGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtectionGroup.SupplyProtectionGroupBuilder supplyProtectionTP( final SupplyProtection value )
        {
            return to_SupplyProtectionTP(value);
        }

    }

}
