/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.SupplyAvailabilityProtectionPlanService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Time Bucket
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SupplyProtectionTimeBucketType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SupplyProtectionTimeBucket extends VdmEntity<SupplyProtectionTimeBucket> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_supavailyprotplan.v0001.A_SupplyProtectionTimeBucketType";
    /**
     * Selector for all available fields of SupplyProtectionTimeBucket.
     * 
     */
    public final static SimpleProperty<SupplyProtectionTimeBucket> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtTimeBucketUUID</b>
     * </p>
     * 
     * @return Time Bucket UUID
     */
    @Nullable
    @ElementName( "SupProtTimeBucketUUID" )
    private UUID supProtTimeBucketUUID;
    public final static SimpleProperty.Guid<SupplyProtectionTimeBucket> SUP_PROT_TIME_BUCKET_UUID =
        new SimpleProperty.Guid<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "SupProtTimeBucketUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @return UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionUUID" )
    private UUID supplyProtectionUUID;
    public final static SimpleProperty.Guid<SupplyProtectionTimeBucket> SUPPLY_PROTECTION_UUID =
        new SimpleProperty.Guid<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "SupplyProtectionUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionGroupUUID</b>
     * </p>
     * 
     * @return Characteristic Value Combination UUID
     */
    @Nullable
    @ElementName( "SupplyProtectionGroupUUID" )
    private UUID supplyProtectionGroupUUID;
    public final static SimpleProperty.Guid<SupplyProtectionTimeBucket> SUPPLY_PROTECTION_GROUP_UUID =
        new SimpleProperty.Guid<SupplyProtectionTimeBucket>(
            SupplyProtectionTimeBucket.class,
            "SupplyProtectionGroupUUID");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPeriodStartUTCDateTime</b>
     * </p>
     * 
     * @return Period Start Timestamp (UTC)
     */
    @Nullable
    @ElementName( "SupProtPeriodStartUTCDateTime" )
    private OffsetDateTime supProtPeriodStartUTCDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionTimeBucket> SUP_PROT_PERIOD_START_UTC_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionTimeBucket>(
            SupplyProtectionTimeBucket.class,
            "SupProtPeriodStartUTCDateTime");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPeriodEndUTCDateTime</b>
     * </p>
     * 
     * @return Period End Timestamp (UTC)
     */
    @Nullable
    @ElementName( "SupProtPeriodEndUTCDateTime" )
    private OffsetDateTime supProtPeriodEndUTCDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionTimeBucket> SUP_PROT_PERIOD_END_UTC_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionTimeBucket>(
            SupplyProtectionTimeBucket.class,
            "SupProtPeriodEndUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "UnitOfMeasure" )
    private java.lang.String unitOfMeasure;
    public final static SimpleProperty.String<SupplyProtectionTimeBucket> UNIT_OF_MEASURE =
        new SimpleProperty.String<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "UnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @return The supProtProtectedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtProtectedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtProtectedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtectionTimeBucket> SUP_PROT_PROTECTED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtectionTimeBucket>(
            SupplyProtectionTimeBucket.class,
            "SupProtProtectedQuantity");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @return The supProtConsumedQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SupProtConsumedQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal supProtConsumedQuantity;
    public final static SimpleProperty.NumericDecimal<SupplyProtectionTimeBucket> SUP_PROT_CONSUMED_QUANTITY =
        new SimpleProperty.NumericDecimal<SupplyProtectionTimeBucket>(
            SupplyProtectionTimeBucket.class,
            "SupProtConsumedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By User
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<SupplyProtectionTimeBucket> CREATED_BY_USER =
        new SimpleProperty.String<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "CreatedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return Created On / At
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionTimeBucket> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Last Changed By User
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<SupplyProtectionTimeBucket> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "LastChangedByUser");
    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return Changed On / At
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<SupplyProtectionTimeBucket> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<SupplyProtectionTimeBucket>(SupplyProtectionTimeBucket.class, "LastChangeDateTime");
    /**
     * Navigation property <b>_SupplyProtectionGroupTP</b> for <b>SupplyProtectionTimeBucket</b> to single
     * <b>SupplyProtectionGroup</b>.
     * 
     */
    @ElementName( "_SupplyProtectionGroupTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplyProtectionGroup to_SupplyProtectionGroupTP;
    /**
     * Navigation property <b>_SupplyProtectionTP</b> for <b>SupplyProtectionTimeBucket</b> to single
     * <b>SupplyProtection</b>.
     * 
     */
    @ElementName( "_SupplyProtectionTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SupplyProtection to_SupplyProtectionTP;
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionGroupTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionTimeBucket, SupplyProtectionGroup> TO__SUPPLY_PROTECTION_GROUP_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionTimeBucket, SupplyProtectionGroup>(
            SupplyProtectionTimeBucket.class,
            "_SupplyProtectionGroupTP",
            SupplyProtectionGroup.class);
    /**
     * Use with available request builders to apply the <b>_SupplyProtectionTP</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionTimeBucket, SupplyProtection> TO__SUPPLY_PROTECTION_TP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SupplyProtectionTimeBucket, SupplyProtection>(
            SupplyProtectionTimeBucket.class,
            "_SupplyProtectionTP",
            SupplyProtection.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SupplyProtectionTimeBucket> getType()
    {
        return SupplyProtectionTimeBucket.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupProtTimeBucketUUID</b>
     * </p>
     * 
     * @param supProtTimeBucketUUID
     *            Time Bucket UUID
     */
    public void setSupProtTimeBucketUUID( @Nullable final UUID supProtTimeBucketUUID )
    {
        rememberChangedField("SupProtTimeBucketUUID", this.supProtTimeBucketUUID);
        this.supProtTimeBucketUUID = supProtTimeBucketUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionUUID</b>
     * </p>
     * 
     * @param supplyProtectionUUID
     *            UUID
     */
    public void setSupplyProtectionUUID( @Nullable final UUID supplyProtectionUUID )
    {
        rememberChangedField("SupplyProtectionUUID", this.supplyProtectionUUID);
        this.supplyProtectionUUID = supplyProtectionUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SupplyProtectionGroupUUID</b>
     * </p>
     * 
     * @param supplyProtectionGroupUUID
     *            Characteristic Value Combination UUID
     */
    public void setSupplyProtectionGroupUUID( @Nullable final UUID supplyProtectionGroupUUID )
    {
        rememberChangedField("SupplyProtectionGroupUUID", this.supplyProtectionGroupUUID);
        this.supplyProtectionGroupUUID = supplyProtectionGroupUUID;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPeriodStartUTCDateTime</b>
     * </p>
     * 
     * @param supProtPeriodStartUTCDateTime
     *            Period Start Timestamp (UTC)
     */
    public void setSupProtPeriodStartUTCDateTime( @Nullable final OffsetDateTime supProtPeriodStartUTCDateTime )
    {
        rememberChangedField("SupProtPeriodStartUTCDateTime", this.supProtPeriodStartUTCDateTime);
        this.supProtPeriodStartUTCDateTime = supProtPeriodStartUTCDateTime;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SupProtPeriodEndUTCDateTime</b>
     * </p>
     * 
     * @param supProtPeriodEndUTCDateTime
     *            Period End Timestamp (UTC)
     */
    public void setSupProtPeriodEndUTCDateTime( @Nullable final OffsetDateTime supProtPeriodEndUTCDateTime )
    {
        rememberChangedField("SupProtPeriodEndUTCDateTime", this.supProtPeriodEndUTCDateTime);
        this.supProtPeriodEndUTCDateTime = supProtPeriodEndUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final java.lang.String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtProtectedQuantity</b>
     * </p>
     * 
     * @param supProtProtectedQuantity
     *            The supProtProtectedQuantity to set.
     */
    public void setSupProtProtectedQuantity( @Nullable final BigDecimal supProtProtectedQuantity )
    {
        rememberChangedField("SupProtProtectedQuantity", this.supProtProtectedQuantity);
        this.supProtProtectedQuantity = supProtProtectedQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SupProtConsumedQuantity</b>
     * </p>
     * 
     * @param supProtConsumedQuantity
     *            The supProtConsumedQuantity to set.
     */
    public void setSupProtConsumedQuantity( @Nullable final BigDecimal supProtConsumedQuantity )
    {
        rememberChangedField("SupProtConsumedQuantity", this.supProtConsumedQuantity);
        this.supProtConsumedQuantity = supProtConsumedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By User
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            Created On / At
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Last Changed By User
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            Changed On / At
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_SupplyProtectionTimeBucket";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("SupProtTimeBucketUUID", getSupProtTimeBucketUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("SupProtTimeBucketUUID", getSupProtTimeBucketUUID());
        values.put("SupplyProtectionUUID", getSupplyProtectionUUID());
        values.put("SupplyProtectionGroupUUID", getSupplyProtectionGroupUUID());
        values.put("SupProtPeriodStartUTCDateTime", getSupProtPeriodStartUTCDateTime());
        values.put("SupProtPeriodEndUTCDateTime", getSupProtPeriodEndUTCDateTime());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("SupProtProtectedQuantity", getSupProtProtectedQuantity());
        values.put("SupProtConsumedQuantity", getSupProtConsumedQuantity());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SupProtTimeBucketUUID") ) {
                final Object value = values.remove("SupProtTimeBucketUUID");
                if( (value == null) || (!value.equals(getSupProtTimeBucketUUID())) ) {
                    setSupProtTimeBucketUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplyProtectionUUID") ) {
                final Object value = values.remove("SupplyProtectionUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionUUID())) ) {
                    setSupplyProtectionUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupplyProtectionGroupUUID") ) {
                final Object value = values.remove("SupplyProtectionGroupUUID");
                if( (value == null) || (!value.equals(getSupplyProtectionGroupUUID())) ) {
                    setSupplyProtectionGroupUUID(((UUID) value));
                }
            }
            if( values.containsKey("SupProtPeriodStartUTCDateTime") ) {
                final Object value = values.remove("SupProtPeriodStartUTCDateTime");
                if( (value == null) || (!value.equals(getSupProtPeriodStartUTCDateTime())) ) {
                    setSupProtPeriodStartUTCDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("SupProtPeriodEndUTCDateTime") ) {
                final Object value = values.remove("SupProtPeriodEndUTCDateTime");
                if( (value == null) || (!value.equals(getSupProtPeriodEndUTCDateTime())) ) {
                    setSupProtPeriodEndUTCDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupProtProtectedQuantity") ) {
                final Object value = values.remove("SupProtProtectedQuantity");
                if( (value == null) || (!value.equals(getSupProtProtectedQuantity())) ) {
                    setSupProtProtectedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("SupProtConsumedQuantity") ) {
                final Object value = values.remove("SupProtConsumedQuantity");
                if( (value == null) || (!value.equals(getSupProtConsumedQuantity())) ) {
                    setSupProtConsumedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SupplyProtectionGroupTP") ) {
                final Object value = (values).remove("_SupplyProtectionGroupTP");
                if( value instanceof Map ) {
                    if( to_SupplyProtectionGroupTP == null ) {
                        to_SupplyProtectionGroupTP = new SupplyProtectionGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SupplyProtectionGroupTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_SupplyProtectionTP") ) {
                final Object value = (values).remove("_SupplyProtectionTP");
                if( value instanceof Map ) {
                    if( to_SupplyProtectionTP == null ) {
                        to_SupplyProtectionTP = new SupplyProtection();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SupplyProtectionTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return SupplyAvailabilityProtectionPlanService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SupplyProtectionGroupTP != null ) {
            (values).put("_SupplyProtectionGroupTP", to_SupplyProtectionGroupTP);
        }
        if( to_SupplyProtectionTP != null ) {
            (values).put("_SupplyProtectionTP", to_SupplyProtectionTP);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SupplyProtectionGroup</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SupplyProtectionGroupTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtectionTimeBucket</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionGroupTP</b> is already loaded, the result
     *         will contain the <b>SupplyProtectionGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplyProtectionGroup> getSupplyProtectionGroupTPIfPresent()
    {
        return Option.of(to_SupplyProtectionGroupTP);
    }

    /**
     * Overwrites the associated <b>SupplyProtectionGroup</b> entity for the loaded navigation property
     * <b>_SupplyProtectionGroupTP</b>.
     * 
     * @param value
     *            New <b>SupplyProtectionGroup</b> entity.
     */
    public void setSupplyProtectionGroupTP( final SupplyProtectionGroup value )
    {
        to_SupplyProtectionGroupTP = value;
    }

    /**
     * Retrieval of associated <b>SupplyProtection</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SupplyProtectionTP</b>.
     * <p>
     * If the navigation property for an entity <b>SupplyProtectionTimeBucket</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SupplyProtectionTP</b> is already loaded, the result will
     *         contain the <b>SupplyProtection</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SupplyProtection> getSupplyProtectionTPIfPresent()
    {
        return Option.of(to_SupplyProtectionTP);
    }

    /**
     * Overwrites the associated <b>SupplyProtection</b> entity for the loaded navigation property
     * <b>_SupplyProtectionTP</b>.
     * 
     * @param value
     *            New <b>SupplyProtection</b> entity.
     */
    public void setSupplyProtectionTP( final SupplyProtection value )
    {
        to_SupplyProtectionTP = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplyProtectionTimeBucket instances.
     * 
     */
    public final static class SupplyProtectionTimeBucketBuilder
    {

        private SupplyProtectionGroup to_SupplyProtectionGroupTP;
        private SupplyProtection to_SupplyProtectionTP;

        private SupplyProtectionTimeBucket.SupplyProtectionTimeBucketBuilder to_SupplyProtectionGroupTP(
            final SupplyProtectionGroup value )
        {
            to_SupplyProtectionGroupTP = value;
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionGroupTP</b> for <b>SupplyProtectionTimeBucket</b> to single
         * <b>SupplyProtectionGroup</b>.
         * 
         * @param value
         *            The SupplyProtectionGroup to build this SupplyProtectionTimeBucket with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtectionTimeBucket.SupplyProtectionTimeBucketBuilder supplyProtectionGroupTP(
            final SupplyProtectionGroup value )
        {
            return to_SupplyProtectionGroupTP(value);
        }

        private SupplyProtectionTimeBucket.SupplyProtectionTimeBucketBuilder to_SupplyProtectionTP(
            final SupplyProtection value )
        {
            to_SupplyProtectionTP = value;
            return this;
        }

        /**
         * Navigation property <b>_SupplyProtectionTP</b> for <b>SupplyProtectionTimeBucket</b> to single
         * <b>SupplyProtection</b>.
         * 
         * @param value
         *            The SupplyProtection to build this SupplyProtectionTimeBucket with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplyProtectionTimeBucket.SupplyProtectionTimeBucketBuilder supplyProtectionTP(
            final SupplyProtection value )
        {
            return to_SupplyProtectionTP(value);
        }

    }

}
