/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.TimeDependentStockLevelService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProdTimeDepdntStockLvlType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class ProdTimeDepdntStockLvl extends VdmEntity<ProdTimeDepdntStockLvl> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_prod_timedpdntstck_srv.v0001.A_ProdTimeDepdntStockLvlType";
    /**
     * Selector for all available fields of ProdTimeDepdntStockLvl.
     * 
     */
    public final static SimpleProperty<ProdTimeDepdntStockLvl> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Material Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> PRODUCT =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> PLANT =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     * 
     * @return MRP Area
     */
    @Nullable
    @ElementName( "MRPArea" )
    private java.lang.String mRPArea;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> MRP_AREA =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "MRPArea");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelValidityStartDate</b>
     * </p>
     * 
     * @return Valid-From Date
     */
    @Nullable
    @ElementName( "StockLevelValidityStartDate" )
    private LocalDate stockLevelValidityStartDate;
    public final static SimpleProperty.Date<ProdTimeDepdntStockLvl> STOCK_LEVEL_VALIDITY_START_DATE =
        new SimpleProperty.Date<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "StockLevelValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelValidityEndDate</b>
     * </p>
     * 
     * @return Valid-To Date
     */
    @Nullable
    @ElementName( "StockLevelValidityEndDate" )
    private LocalDate stockLevelValidityEndDate;
    public final static SimpleProperty.Date<ProdTimeDepdntStockLvl> STOCK_LEVEL_VALIDITY_END_DATE =
        new SimpleProperty.Date<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "StockLevelValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductSafetyStockLvlQuantity</b>
     * </p>
     * 
     * @return The productSafetyStockLvlQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ProductSafetyStockLvlQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal productSafetyStockLvlQuantity;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> PRODUCT_SAFETY_STOCK_LVL_QUANTITY =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "ProductSafetyStockLvlQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     * 
     * @return The reorderThresholdQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ReorderThresholdQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal reorderThresholdQuantity;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> REORDER_THRESHOLD_QUANTITY =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "ReorderThresholdQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductMaxStockLevelQuantity</b>
     * </p>
     * 
     * @return The productMaxStockLevelQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ProductMaxStockLevelQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal productMaxStockLevelQuantity;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> PRODUCT_MAX_STOCK_LEVEL_QUANTITY =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "ProductMaxStockLevelQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductTargetStockLvlQuantity</b>
     * </p>
     * 
     * @return The productTargetStockLvlQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ProductTargetStockLvlQuantity" )
    @DecimalDescriptor( precision = 13, scale = 3 )
    private BigDecimal productTargetStockLvlQuantity;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> PRODUCT_TARGET_STOCK_LVL_QUANTITY =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "ProductTargetStockLvlQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @return Base Unit of Measure
     */
    @Nullable
    @ElementName( "UnitOfMeasure" )
    private java.lang.String unitOfMeasure;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> UNIT_OF_MEASURE =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "UnitOfMeasure");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     * 
     * @return ISO code for unit of measurement
     */
    @Nullable
    @ElementName( "UnitOfMeasureISOCode" )
    private java.lang.String unitOfMeasureISOCode;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> UNIT_OF_MEASURE_ISO_CODE =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "UnitOfMeasureISOCode");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TargetSupplyDurationInDays</b>
     * </p>
     * 
     * @return Target Days of Supply in Workdays
     */
    @Nullable
    @ElementName( "TargetSupplyDurationInDays" )
    @DecimalDescriptor( precision = 6, scale = 2 )
    private BigDecimal targetSupplyDurationInDays;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> TARGET_SUPPLY_DURATION_IN_DAYS =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "TargetSupplyDurationInDays");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaxSupplyDurationInDays</b>
     * </p>
     * 
     * @return Maximum Days of Supply in Workdays
     */
    @Nullable
    @ElementName( "MaxSupplyDurationInDays" )
    @DecimalDescriptor( precision = 6, scale = 2 )
    private BigDecimal maxSupplyDurationInDays;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> MAX_SUPPLY_DURATION_IN_DAYS =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "MaxSupplyDurationInDays");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetySupplyDurationInDays</b>
     * </p>
     * 
     * @return Safety Days of Supply in Workdays
     */
    @Nullable
    @ElementName( "SafetySupplyDurationInDays" )
    @DecimalDescriptor( precision = 6, scale = 2 )
    private BigDecimal safetySupplyDurationInDays;
    public final static SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl> SAFETY_SUPPLY_DURATION_IN_DAYS =
        new SimpleProperty.NumericDecimal<ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            "SafetySupplyDurationInDays");
    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     * 
     * @return Proposal Id
     */
    @Nullable
    @ElementName( "StockLevelProposalID" )
    private java.lang.String stockLevelProposalID;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> STOCK_LEVEL_PROPOSAL_ID =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "StockLevelProposalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     * 
     * @return Proposal Version
     */
    @Nullable
    @ElementName( "ProposalVersion" )
    private java.lang.String proposalVersion;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> PROPOSAL_VERSION =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "ProposalVersion");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     * 
     * @return Proposal Validity From Date
     */
    @Nullable
    @ElementName( "ProposalStartDate" )
    private LocalDate proposalStartDate;
    public final static SimpleProperty.Date<ProdTimeDepdntStockLvl> PROPOSAL_START_DATE =
        new SimpleProperty.Date<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "ProposalStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Name of Person Who Created Object
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> CREATED_BY_USER =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Name of Person who Changed Object
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<ProdTimeDepdntStockLvl> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "LastChangedByUser");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @Nullable
    @ElementName( "CreationDateTime" )
    private OffsetDateTime creationDateTime;
    public final static SimpleProperty.DateTime<ProdTimeDepdntStockLvl> CREATION_DATE_TIME =
        new SimpleProperty.DateTime<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "CreationDateTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @Nullable
    @ElementName( "LastChangeDateTime" )
    private OffsetDateTime lastChangeDateTime;
    public final static SimpleProperty.DateTime<ProdTimeDepdntStockLvl> LAST_CHANGE_DATE_TIME =
        new SimpleProperty.DateTime<ProdTimeDepdntStockLvl>(ProdTimeDepdntStockLvl.class, "LastChangeDateTime");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ProdTimeDepdntStockLvl, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<ProdTimeDepdntStockLvl, SAP__Message>(
            ProdTimeDepdntStockLvl.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<ProdTimeDepdntStockLvl> getType()
    {
        return ProdTimeDepdntStockLvl.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     * 
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final java.lang.String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelValidityStartDate</b>
     * </p>
     * 
     * @param stockLevelValidityStartDate
     *            Valid-From Date
     */
    public void setStockLevelValidityStartDate( @Nullable final LocalDate stockLevelValidityStartDate )
    {
        rememberChangedField("StockLevelValidityStartDate", this.stockLevelValidityStartDate);
        this.stockLevelValidityStartDate = stockLevelValidityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelValidityEndDate</b>
     * </p>
     * 
     * @param stockLevelValidityEndDate
     *            Valid-To Date
     */
    public void setStockLevelValidityEndDate( @Nullable final LocalDate stockLevelValidityEndDate )
    {
        rememberChangedField("StockLevelValidityEndDate", this.stockLevelValidityEndDate);
        this.stockLevelValidityEndDate = stockLevelValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductSafetyStockLvlQuantity</b>
     * </p>
     * 
     * @param productSafetyStockLvlQuantity
     *            The productSafetyStockLvlQuantity to set.
     */
    public void setProductSafetyStockLvlQuantity( @Nullable final BigDecimal productSafetyStockLvlQuantity )
    {
        rememberChangedField("ProductSafetyStockLvlQuantity", this.productSafetyStockLvlQuantity);
        this.productSafetyStockLvlQuantity = productSafetyStockLvlQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     * </p>
     * 
     * @param reorderThresholdQuantity
     *            The reorderThresholdQuantity to set.
     */
    public void setReorderThresholdQuantity( @Nullable final BigDecimal reorderThresholdQuantity )
    {
        rememberChangedField("ReorderThresholdQuantity", this.reorderThresholdQuantity);
        this.reorderThresholdQuantity = reorderThresholdQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductMaxStockLevelQuantity</b>
     * </p>
     * 
     * @param productMaxStockLevelQuantity
     *            The productMaxStockLevelQuantity to set.
     */
    public void setProductMaxStockLevelQuantity( @Nullable final BigDecimal productMaxStockLevelQuantity )
    {
        rememberChangedField("ProductMaxStockLevelQuantity", this.productMaxStockLevelQuantity);
        this.productMaxStockLevelQuantity = productMaxStockLevelQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductTargetStockLvlQuantity</b>
     * </p>
     * 
     * @param productTargetStockLvlQuantity
     *            The productTargetStockLvlQuantity to set.
     */
    public void setProductTargetStockLvlQuantity( @Nullable final BigDecimal productTargetStockLvlQuantity )
    {
        rememberChangedField("ProductTargetStockLvlQuantity", this.productTargetStockLvlQuantity);
        this.productTargetStockLvlQuantity = productTargetStockLvlQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasure</b>
     * </p>
     * 
     * @param unitOfMeasure
     *            Base Unit of Measure
     */
    public void setUnitOfMeasure( @Nullable final java.lang.String unitOfMeasure )
    {
        rememberChangedField("UnitOfMeasure", this.unitOfMeasure);
        this.unitOfMeasure = unitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     * </p>
     * 
     * @param unitOfMeasureISOCode
     *            ISO code for unit of measurement
     */
    public void setUnitOfMeasureISOCode( @Nullable final java.lang.String unitOfMeasureISOCode )
    {
        rememberChangedField("UnitOfMeasureISOCode", this.unitOfMeasureISOCode);
        this.unitOfMeasureISOCode = unitOfMeasureISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>TargetSupplyDurationInDays</b>
     * </p>
     * 
     * @param targetSupplyDurationInDays
     *            Target Days of Supply in Workdays
     */
    public void setTargetSupplyDurationInDays( @Nullable final BigDecimal targetSupplyDurationInDays )
    {
        rememberChangedField("TargetSupplyDurationInDays", this.targetSupplyDurationInDays);
        this.targetSupplyDurationInDays = targetSupplyDurationInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaxSupplyDurationInDays</b>
     * </p>
     * 
     * @param maxSupplyDurationInDays
     *            Maximum Days of Supply in Workdays
     */
    public void setMaxSupplyDurationInDays( @Nullable final BigDecimal maxSupplyDurationInDays )
    {
        rememberChangedField("MaxSupplyDurationInDays", this.maxSupplyDurationInDays);
        this.maxSupplyDurationInDays = maxSupplyDurationInDays;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>SafetySupplyDurationInDays</b>
     * </p>
     * 
     * @param safetySupplyDurationInDays
     *            Safety Days of Supply in Workdays
     */
    public void setSafetySupplyDurationInDays( @Nullable final BigDecimal safetySupplyDurationInDays )
    {
        rememberChangedField("SafetySupplyDurationInDays", this.safetySupplyDurationInDays);
        this.safetySupplyDurationInDays = safetySupplyDurationInDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 75
     * <p>
     * Original property name from the Odata EDM: <b>StockLevelProposalID</b>
     * </p>
     * 
     * @param stockLevelProposalID
     *            Proposal Id
     */
    public void setStockLevelProposalID( @Nullable final java.lang.String stockLevelProposalID )
    {
        rememberChangedField("StockLevelProposalID", this.stockLevelProposalID);
        this.stockLevelProposalID = stockLevelProposalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProposalVersion</b>
     * </p>
     * 
     * @param proposalVersion
     *            Proposal Version
     */
    public void setProposalVersion( @Nullable final java.lang.String proposalVersion )
    {
        rememberChangedField("ProposalVersion", this.proposalVersion);
        this.proposalVersion = proposalVersion;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProposalStartDate</b>
     * </p>
     * 
     * @param proposalStartDate
     *            Proposal Validity From Date
     */
    public void setProposalStartDate( @Nullable final LocalDate proposalStartDate )
    {
        rememberChangedField("ProposalStartDate", this.proposalStartDate);
        this.proposalStartDate = proposalStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Name of Person who Changed Object
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     * 
     * @param creationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setCreationDateTime( @Nullable final OffsetDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * 
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final OffsetDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "A_ProdTimeDepdntStockLvl";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Product", getProduct());
        entityKey.addKeyProperty("Plant", getPlant());
        entityKey.addKeyProperty("MRPArea", getMRPArea());
        entityKey.addKeyProperty("StockLevelValidityStartDate", getStockLevelValidityStartDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("MRPArea", getMRPArea());
        values.put("StockLevelValidityStartDate", getStockLevelValidityStartDate());
        values.put("StockLevelValidityEndDate", getStockLevelValidityEndDate());
        values.put("ProductSafetyStockLvlQuantity", getProductSafetyStockLvlQuantity());
        values.put("ReorderThresholdQuantity", getReorderThresholdQuantity());
        values.put("ProductMaxStockLevelQuantity", getProductMaxStockLevelQuantity());
        values.put("ProductTargetStockLvlQuantity", getProductTargetStockLvlQuantity());
        values.put("UnitOfMeasure", getUnitOfMeasure());
        values.put("UnitOfMeasureISOCode", getUnitOfMeasureISOCode());
        values.put("TargetSupplyDurationInDays", getTargetSupplyDurationInDays());
        values.put("MaxSupplyDurationInDays", getMaxSupplyDurationInDays());
        values.put("SafetySupplyDurationInDays", getSafetySupplyDurationInDays());
        values.put("StockLevelProposalID", getStockLevelProposalID());
        values.put("ProposalVersion", getProposalVersion());
        values.put("ProposalStartDate", getProposalStartDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((java.lang.String) value));
                }
            }
            if( values.containsKey("StockLevelValidityStartDate") ) {
                final Object value = values.remove("StockLevelValidityStartDate");
                if( (value == null) || (!value.equals(getStockLevelValidityStartDate())) ) {
                    setStockLevelValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("StockLevelValidityEndDate") ) {
                final Object value = values.remove("StockLevelValidityEndDate");
                if( (value == null) || (!value.equals(getStockLevelValidityEndDate())) ) {
                    setStockLevelValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ProductSafetyStockLvlQuantity") ) {
                final Object value = values.remove("ProductSafetyStockLvlQuantity");
                if( (value == null) || (!value.equals(getProductSafetyStockLvlQuantity())) ) {
                    setProductSafetyStockLvlQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReorderThresholdQuantity") ) {
                final Object value = values.remove("ReorderThresholdQuantity");
                if( (value == null) || (!value.equals(getReorderThresholdQuantity())) ) {
                    setReorderThresholdQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductMaxStockLevelQuantity") ) {
                final Object value = values.remove("ProductMaxStockLevelQuantity");
                if( (value == null) || (!value.equals(getProductMaxStockLevelQuantity())) ) {
                    setProductMaxStockLevelQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductTargetStockLvlQuantity") ) {
                final Object value = values.remove("ProductTargetStockLvlQuantity");
                if( (value == null) || (!value.equals(getProductTargetStockLvlQuantity())) ) {
                    setProductTargetStockLvlQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("UnitOfMeasure") ) {
                final Object value = values.remove("UnitOfMeasure");
                if( (value == null) || (!value.equals(getUnitOfMeasure())) ) {
                    setUnitOfMeasure(((java.lang.String) value));
                }
            }
            if( values.containsKey("UnitOfMeasureISOCode") ) {
                final Object value = values.remove("UnitOfMeasureISOCode");
                if( (value == null) || (!value.equals(getUnitOfMeasureISOCode())) ) {
                    setUnitOfMeasureISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("TargetSupplyDurationInDays") ) {
                final Object value = values.remove("TargetSupplyDurationInDays");
                if( (value == null) || (!value.equals(getTargetSupplyDurationInDays())) ) {
                    setTargetSupplyDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaxSupplyDurationInDays") ) {
                final Object value = values.remove("MaxSupplyDurationInDays");
                if( (value == null) || (!value.equals(getMaxSupplyDurationInDays())) ) {
                    setMaxSupplyDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("SafetySupplyDurationInDays") ) {
                final Object value = values.remove("SafetySupplyDurationInDays");
                if( (value == null) || (!value.equals(getSafetySupplyDurationInDays())) ) {
                    setSafetySupplyDurationInDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("StockLevelProposalID") ) {
                final Object value = values.remove("StockLevelProposalID");
                if( (value == null) || (!value.equals(getStockLevelProposalID())) ) {
                    setStockLevelProposalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProposalVersion") ) {
                final Object value = values.remove("ProposalVersion");
                if( (value == null) || (!value.equals(getProposalVersion())) ) {
                    setProposalVersion(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProposalStartDate") ) {
                final Object value = values.remove("ProposalStartDate");
                if( (value == null) || (!value.equals(getProposalStartDate())) ) {
                    setProposalStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((OffsetDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((OffsetDateTime) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return TimeDependentStockLevelService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param targetSupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSupplyDurationInDays</b>
     *            </p>
     * @param product
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Product</b>
     *            </p>
     * @param mRPArea
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param unitOfMeasure
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasure</b>
     *            </p>
     * @param stockLevelValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StockLevelValidityStartDate</b>
     *            </p>
     * @param stockLevelValidityEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StockLevelValidityEndDate</b>
     *            </p>
     * @param safetySupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SafetySupplyDurationInDays</b>
     *            </p>
     * @param productMaxStockLevelQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductMaxStockLevelQuantity</b>
     *            </p>
     * @param productSafetyStockLvlQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductSafetyStockLvlQuantity</b>
     *            </p>
     * @param maxSupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaxSupplyDurationInDays</b>
     *            </p>
     * @param unitOfMeasureISOCode
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     *            </p>
     * @param productTargetStockLvlQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductTargetStockLvlQuantity</b>
     *            </p>
     * @param plant
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param reorderThresholdQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<ProdTimeDepdntStockLvl, ProdTimeDepdntStockLvl>
        insertAndAdjustStkLvlInterval(
            @Nonnull final java.lang.String product,
            @Nonnull final java.lang.String plant,
            @Nonnull final java.lang.String mRPArea,
            @Nonnull final LocalDate stockLevelValidityStartDate,
            @Nonnull final LocalDate stockLevelValidityEndDate,
            @Nonnull final BigDecimal productSafetyStockLvlQuantity,
            @Nonnull final BigDecimal reorderThresholdQuantity,
            @Nonnull final BigDecimal productMaxStockLevelQuantity,
            @Nonnull final BigDecimal productTargetStockLvlQuantity,
            @Nonnull final java.lang.String unitOfMeasure,
            @Nonnull final java.lang.String unitOfMeasureISOCode,
            @Nonnull final BigDecimal targetSupplyDurationInDays,
            @Nonnull final BigDecimal maxSupplyDurationInDays,
            @Nonnull final BigDecimal safetySupplyDurationInDays )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("Product", product);
        parameters.put("Plant", plant);
        parameters.put("MRPArea", mRPArea);
        parameters.put("StockLevelValidityStartDate", stockLevelValidityStartDate);
        parameters.put("StockLevelValidityEndDate", stockLevelValidityEndDate);
        parameters.put("ProductSafetyStockLvlQuantity", productSafetyStockLvlQuantity);
        parameters.put("ReorderThresholdQuantity", reorderThresholdQuantity);
        parameters.put("ProductMaxStockLevelQuantity", productMaxStockLevelQuantity);
        parameters.put("ProductTargetStockLvlQuantity", productTargetStockLvlQuantity);
        parameters.put("UnitOfMeasure", unitOfMeasure);
        parameters.put("UnitOfMeasureISOCode", unitOfMeasureISOCode);
        parameters.put("TargetSupplyDurationInDays", targetSupplyDurationInDays);
        parameters.put("MaxSupplyDurationInDays", maxSupplyDurationInDays);
        parameters.put("SafetySupplyDurationInDays", safetySupplyDurationInDays);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<ProdTimeDepdntStockLvl, ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            ProdTimeDepdntStockLvl.class,
            "com.sap.gateway.srvd_a2x.api_prod_timedpdntstck_srv.v0001.InsertAndAdjustStkLvlInterval",
            parameters);
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param targetSupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TargetSupplyDurationInDays</b>
     *            </p>
     * @param product
     *            Constraints: Not nullable, Maximum length: 40
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Product</b>
     *            </p>
     * @param mRPArea
     *            Constraints: Not nullable, Maximum length: 10
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MRPArea</b>
     *            </p>
     * @param unitOfMeasure
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasure</b>
     *            </p>
     * @param stockLevelValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StockLevelValidityStartDate</b>
     *            </p>
     * @param stockLevelValidityEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StockLevelValidityEndDate</b>
     *            </p>
     * @param safetySupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SafetySupplyDurationInDays</b>
     *            </p>
     * @param productMaxStockLevelQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductMaxStockLevelQuantity</b>
     *            </p>
     * @param productSafetyStockLvlQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductSafetyStockLvlQuantity</b>
     *            </p>
     * @param maxSupplyDurationInDays
     *            Constraints: Not nullable, Precision: 6, Scale: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaxSupplyDurationInDays</b>
     *            </p>
     * @param unitOfMeasureISOCode
     *            Constraints: Not nullable, Maximum length: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>UnitOfMeasureISOCode</b>
     *            </p>
     * @param productTargetStockLvlQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProductTargetStockLvlQuantity</b>
     *            </p>
     * @param plant
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Plant</b>
     *            </p>
     * @param reorderThresholdQuantity
     *            Constraints: Not nullable, Precision: 13, Scale: 3
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ReorderThresholdQuantity</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<ProdTimeDepdntStockLvl, ProdTimeDepdntStockLvl>
        splitStockLevelInterval(
            @Nonnull final java.lang.String product,
            @Nonnull final java.lang.String plant,
            @Nonnull final java.lang.String mRPArea,
            @Nonnull final LocalDate stockLevelValidityStartDate,
            @Nonnull final LocalDate stockLevelValidityEndDate,
            @Nonnull final BigDecimal productSafetyStockLvlQuantity,
            @Nonnull final BigDecimal reorderThresholdQuantity,
            @Nonnull final BigDecimal productMaxStockLevelQuantity,
            @Nonnull final BigDecimal productTargetStockLvlQuantity,
            @Nonnull final java.lang.String unitOfMeasure,
            @Nonnull final java.lang.String unitOfMeasureISOCode,
            @Nonnull final BigDecimal targetSupplyDurationInDays,
            @Nonnull final BigDecimal maxSupplyDurationInDays,
            @Nonnull final BigDecimal safetySupplyDurationInDays )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("Product", product);
        parameters.put("Plant", plant);
        parameters.put("MRPArea", mRPArea);
        parameters.put("StockLevelValidityStartDate", stockLevelValidityStartDate);
        parameters.put("StockLevelValidityEndDate", stockLevelValidityEndDate);
        parameters.put("ProductSafetyStockLvlQuantity", productSafetyStockLvlQuantity);
        parameters.put("ReorderThresholdQuantity", reorderThresholdQuantity);
        parameters.put("ProductMaxStockLevelQuantity", productMaxStockLevelQuantity);
        parameters.put("ProductTargetStockLvlQuantity", productTargetStockLvlQuantity);
        parameters.put("UnitOfMeasure", unitOfMeasure);
        parameters.put("UnitOfMeasureISOCode", unitOfMeasureISOCode);
        parameters.put("TargetSupplyDurationInDays", targetSupplyDurationInDays);
        parameters.put("MaxSupplyDurationInDays", maxSupplyDurationInDays);
        parameters.put("SafetySupplyDurationInDays", safetySupplyDurationInDays);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<ProdTimeDepdntStockLvl, ProdTimeDepdntStockLvl>(
            ProdTimeDepdntStockLvl.class,
            ProdTimeDepdntStockLvl.class,
            "com.sap.gateway.srvd_a2x.api_prod_timedpdntstck_srv.v0001.SplitStockLevelInterval",
            parameters);
    }

}
