/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail;

/**
 * <p>
 * 
 * The service contains a list of security deposits. With this service you can create, read, update cash security
 * deposits. You can change header information, add request documents, reverse, clear, release or reset the release of
 * specific cash security deposits.
 * 
 * After a request to fetch security deposits is sent, all filtered security deposits are returned.
 * 
 * After a security deposit has been created using the Create operation a new security deposit number and the message
 * header are returned.
 * 
 * After a security deposit has been revised, for example, by using the Change or Create Request Operation operation,
 * the number of that revised security deposit and the message header are returned..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/9c/9d40cd785b4317a85fd3d8e6c3a26e/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CASECURITYDEPOSIT_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CASECURITYDEPOSIT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting Security Deposits Integration (SAP_COM_0380)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2UJ'>Contract Accounting - Open Item Management (2UJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_CASECURITYDEPOSIT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ContrAcctgSecurityDeposit</td>
 * </tr>
 * </table>
 * 
 */
public interface CashSecurityDepositService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_casecuritydeposit/srvd_a2x/sap/casecuritydeposit/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CashSecurityDepositService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     * CAScrtyDepDocumentFlow} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     *         CAScrtyDepDocumentFlow} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<CAScrtyDepDocumentFlow> getAllCAScrtyDepDocumentFlow();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     * CAScrtyDepDocumentFlow} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     *         CAScrtyDepDocumentFlow} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<CAScrtyDepDocumentFlow> countCAScrtyDepDocumentFlow();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     * CAScrtyDepDocumentFlow} entity using key fields.
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param cAScrtyDepositClearedDocument
     *            Number of Cleared Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param cADocumentNumber
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow
     *         CAScrtyDepDocumentFlow} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CAScrtyDepDocumentFlow>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<CAScrtyDepDocumentFlow> getCAScrtyDepDocumentFlowByKey(
        @Nonnull final String cASecurityDeposit,
        @Nonnull final String cADocumentNumber,
        @Nonnull final String cAScrtyDepositClearedDocument );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     * CASecurityDeposit} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     *         CASecurityDeposit} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<CASecurityDeposit> getAllCASecurityDeposit();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     * CASecurityDeposit} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     *         CASecurityDeposit} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<CASecurityDeposit> countCASecurityDeposit();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     * CASecurityDeposit} entity using key fields.
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     *         CASecurityDeposit} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<CASecurityDeposit> getCASecurityDepositByKey( @Nonnull final String cASecurityDeposit );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     * CASecurityDeposit} entity and save it to the S/4HANA system.
     * 
     * @param cASecurityDeposit
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     *            CASecurityDeposit} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit
     *         CASecurityDeposit} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDeposit>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<CASecurityDeposit>
        createCASecurityDeposit( @Nonnull final CASecurityDeposit cASecurityDeposit );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     * CASecurityDepositReqDetail} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     *         CASecurityDepositReqDetail} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<CASecurityDepositReqDetail> getAllCASecurityDepositReqDetail();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     * CASecurityDepositReqDetail} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     *         CASecurityDepositReqDetail} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<CASecurityDepositReqDetail> countCASecurityDepositReqDetail();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     * CASecurityDepositReqDetail} entity using key fields.
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param cADocumentNumber
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     *         CASecurityDepositReqDetail} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<CASecurityDepositReqDetail> getCASecurityDepositReqDetailByKey(
        @Nonnull final String cASecurityDeposit,
        @Nonnull final String cADocumentNumber );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     * CASecurityDepositReqDetail} entity and save it to the S/4HANA system.
     * 
     * @param cASecurityDepositReqDetail
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     *            CASecurityDepositReqDetail} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail
     *         CASecurityDepositReqDetail} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit.CASecurityDepositReqDetail>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<CASecurityDepositReqDetail>
        createCASecurityDepositReqDetail( @Nonnull final CASecurityDepositReqDetail cASecurityDepositReqDetail );

}
