/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode;

/**
 * <p>
 * 
 * This service contains catalog groups and codes that belong to catalog type B which is Object Parts. The catalog type
 * Object Parts is used in maintenance notification item level to record the object parts. The information is sent in
 * the request as a payload.
 * 
 * The request payload contains all information required to read the catalog type Object Parts. All the information in
 * the payload is used to read Object Parts as a catalog type and includes appropriate checks for restricted values and
 * authorizations. Once the object parts have been read, the response with the data is included.
 * 
 * If the input in the request is not as expected when you read the catalog type Object Parts, the system displays
 * appropriate error or warning messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/ed/6fe185ade647078c9a0c00b576e047/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/OBJECTPART_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>OBJECTPART_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Maintenance Processing Integration (SAP_COM_0397)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance (4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance (4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance (4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance (4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance (BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance (BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance (BJ2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_OBJECTPART</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>MaintenanceNotification</td>
 * </tr>
 * </table>
 * 
 */
public interface CatalogTypeObjectPartService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_objectpart/srvd_a2x/sap/objectpart/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    CatalogTypeObjectPartService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     * MaintNotifObjPrtCode} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     *         MaintNotifObjPrtCode} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintNotifObjPrtCode> getAllMaintNotifObjPrtCode();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     * MaintNotifObjPrtCode} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     *         MaintNotifObjPrtCode} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintNotifObjPrtCode> countMaintNotifObjPrtCode();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     * MaintNotifObjPrtCode} entity using key fields.
     * 
     * @param maintNotifObjPartCode
     *            Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param maintNotifObjPartCodeGroup
     *            Code Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param maintNotifObjPartCatalog
     *            Catalog
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode
     *         MaintNotifObjPrtCode} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart.MaintNotifObjPrtCode>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintNotifObjPrtCode> getMaintNotifObjPrtCodeByKey(
        @Nonnull final String maintNotifObjPartCatalog,
        @Nonnull final String maintNotifObjPartCodeGroup,
        @Nonnull final String maintNotifObjPartCode );

}
