/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceItemParameters;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceParameters;

/**
 * <p>
 * 
 * Read invoice items for a business partner and read the corresponding invoice headers with this service. For each
 * invoice you can read correspondence data including the printed document. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/6e/c0cd0d9806492695c7e3354fe54d24/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CABUSPARTINVOICE_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CABUSPARTINVOICE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting Open Item Management Integration (SAP_COM_0361)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2UJ'>Contract Accounting - Open Item Management (2UJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_CABUSPARTINVOICE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ContrAcctgDocContainer</td>
 * </tr>
 * </table>
 * 
 */
public interface ContractAccountingBusinessPartnerInvoiceService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_cabuspartinvoice/srvd_a2x/sap/api_cabuspartinvoice/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ContractAccountingBusinessPartnerInvoiceService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceParameters
     * BusPartInvoiceParameters} entity using key fields.
     * 
     * @param p_DisplayCurrency
     *            Currency Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceParameters
     *         BusPartInvoiceParameters} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceParameters>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartInvoiceParameters> getBusPartInvoiceByKey( @Nonnull final String p_DisplayCurrency );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     * BusPartInvoiceCorrespnc} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     *         BusPartInvoiceCorrespnc} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<BusPartInvoiceCorrespnc> getAllBusPartInvoiceCorrespnc();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     * BusPartInvoiceCorrespnc} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     *         BusPartInvoiceCorrespnc} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<BusPartInvoiceCorrespnc> countBusPartInvoiceCorrespnc();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     * BusPartInvoiceCorrespnc} entity using key fields.
     * 
     * @param cADocumentContainerUUID
     *            Document Container ID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param cACorrespondenceType
     *            Correspondence Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param cACorrespondence
     *            Correspondence key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 36
     *            </p>
     * @param cADocCtnCorrespncSqncNumber
     *            Sequence Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc
     *         BusPartInvoiceCorrespnc} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceCorrespnc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartInvoiceCorrespnc> getBusPartInvoiceCorrespncByKey(
        @Nonnull final UUID cADocumentContainerUUID,
        @Nonnull final String cACorrespondenceType,
        @Nonnull final String cACorrespondence,
        @Nonnull final String cADocCtnCorrespncSqncNumber );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceItemParameters
     * BusPartInvoiceItemParameters} entity using key fields.
     * 
     * @param p_DisplayCurrency
     *            Currency Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceItemParameters
     *         BusPartInvoiceItemParameters} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerinvoice.BusPartInvoiceItemParameters>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartInvoiceItemParameters>
        getBusPartInvoiceItemByKey( @Nonnull final String p_DisplayCurrency );

}
