/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentItemParameters;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentParameters;

/**
 * <p>
 * 
 * Retrieve a list of payments and make, release or withdraw payments. Read payment items and corresponding payment
 * headers for a business partner. Payment items are either document items which are cleared by payments, payments on
 * account or released payments. Post or release payments for an invoice or an open document item. A released payment
 * can also be withdrawn until the corresponding items are not cleared..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/f8/8e28496bfa4bd281ea7054049ce341/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_CABUSPARTPAYMENT_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_CABUSPARTPAYMENT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting Open Item Management Integration (SAP_COM_0361)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2UJ'>Contract Accounting - Open Item Management (2UJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_CABUSPARTPAYMENT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ContrAcctgDocContainer</td>
 * </tr>
 * </table>
 * 
 */
public interface ContractAccountingBusinessPartnerPaymentService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_cabuspartpayment/srvd_a2x/sap/api_cabuspartpayment/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ContractAccountingBusinessPartnerPaymentService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentParameters
     * BusPartPaymentParameters} entity using key fields.
     * 
     * @param p_DisplayCurrency
     *            Currency Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentParameters
     *         BusPartPaymentParameters} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentParameters>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartPaymentParameters> getBusPartPaymentByKey( @Nonnull final String p_DisplayCurrency );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     * BusPartPaymentHeader} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     *         BusPartPaymentHeader} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<BusPartPaymentHeader> getAllBusPartPaymentHeader();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     * BusPartPaymentHeader} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     *         BusPartPaymentHeader} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<BusPartPaymentHeader> countBusPartPaymentHeader();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     * BusPartPaymentHeader} entity using key fields.
     * 
     * @param cADocumentContainerPaymentUUID
     *            Document Container ID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     *         BusPartPaymentHeader} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartPaymentHeader>
        getBusPartPaymentHeaderByKey( @Nonnull final UUID cADocumentContainerPaymentUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     * BusPartPaymentHeader} entity and save it to the S/4HANA system.
     * 
     * @param busPartPaymentHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     *            BusPartPaymentHeader} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader
     *         BusPartPaymentHeader} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentHeader>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<BusPartPaymentHeader>
        createBusPartPaymentHeader( @Nonnull final BusPartPaymentHeader busPartPaymentHeader );

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentItemParameters
     * BusPartPaymentItemParameters} entity using key fields.
     * 
     * @param p_DisplayCurrency
     *            Currency Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentItemParameters
     *         BusPartPaymentItemParameters} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingbusinesspartnerpayment.BusPartPaymentItemParameters>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<BusPartPaymentItemParameters>
        getBusPartPaymentItemByKey( @Nonnull final String p_DisplayCurrency );

}
