/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject;

/**
 * <p>
 * 
 * Create a dispute case with dispute case objects and assign attachments and notes to it. A dispute case object could
 * be a business partner, contract account, contract or FI-CA documents. Using the copy action, an existing dispute case
 * can be used as a template for the creation of a new dispute case.
 * 
 * # .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/df/664ece25244b07ae7fff6d20d658c9/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/CADISPUTECASE_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>CADISPUTECASE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Contract Accounting Integration (SAP_COM_0731)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/2UJ'>Contract Accounting - Open Item Management (2UJ)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_CADISPUTECASE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ContrAcctgDisputeCase</td>
 * </tr>
 * </table>
 * 
 */
public interface ContractAccountingDisputeCaseService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_cadisputecase/srvd_a2x/sap/cadisputecase/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ContractAccountingDisputeCaseService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     * DisputeCase} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     *         DisputeCase} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<DisputeCase> getAllDisputeCase();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     * DisputeCase} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     *         DisputeCase} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<DisputeCase> countDisputeCase();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     * DisputeCase} entity using key fields.
     * 
     * @param caseUUID
     *            UUID in Character Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     *         DisputeCase} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<DisputeCase> getDisputeCaseByKey( @Nonnull final UUID caseUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     * DisputeCase} entity and save it to the S/4HANA system.
     * 
     * @param disputeCase
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     *            DisputeCase} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase
     *         DisputeCase} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCase>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<DisputeCase> createDisputeCase( @Nonnull final DisputeCase disputeCase );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     * DisputeCaseObject} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     *         DisputeCaseObject} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<DisputeCaseObject> getAllDisputeCaseObject();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     * DisputeCaseObject} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     *         DisputeCaseObject} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<DisputeCaseObject> countDisputeCaseObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     * DisputeCaseObject} entity using key fields.
     * 
     * @param objectKey
     *            Object key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param caseUUID
     *            UUID in Character Format
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param objectType
     *            Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     *         DisputeCaseObject} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<DisputeCaseObject> getDisputeCaseObjectByKey(
        @Nonnull final UUID caseUUID,
        @Nonnull final String objectType,
        @Nonnull final String objectKey );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     * DisputeCaseObject} entity and save it to the S/4HANA system.
     * 
     * @param disputeCaseObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     *            DisputeCaseObject} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject
     *         DisputeCaseObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.contractaccountingdisputecase.DisputeCaseObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<DisputeCaseObject>
        createDisputeCaseObject( @Nonnull final DisputeCaseObject disputeCaseObject );

}
