/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal;

import lombok.Getter;

/**
 * <p>
 * 
 * This service contains the following nodes that are necessary for a usage object, including: usage object, usage
 * object total units, and usage object period units.
 * 
 * Please note: You only use this service if you use the units-of-production method of depreciation..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/aa/8804b87fef4d9b82e887f509e41d65/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/FIXEDASSETUSAGEOBJECT_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>FIXEDASSETUSAGEOBJECT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Fixed Asset Integration (SAP_COM_0563)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J62'>Asset Accounting (J62)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_FIXEDASSETUSAGEOBJECT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FixedAssetUsageObject</td>
 * </tr>
 * </table>
 * 
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultFixedAssetUsageObjectForUoPDepreciationService" )
public class DefaultFixedAssetUsageObjectForUoPDepreciationService
    implements
    ServiceWithNavigableEntities,
    FixedAssetUsageObjectForUoPDepreciationService
{

    @Nonnull
    @Getter
    private final String servicePath;

    /**
     * Creates a service using {@link FixedAssetUsageObjectForUoPDepreciationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     * 
     */
    public DefaultFixedAssetUsageObjectForUoPDepreciationService()
    {
        servicePath = FixedAssetUsageObjectForUoPDepreciationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     * 
     */
    private DefaultFixedAssetUsageObjectForUoPDepreciationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultFixedAssetUsageObjectForUoPDepreciationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultFixedAssetUsageObjectForUoPDepreciationService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch()
    {
        return new BatchRequestBuilder(servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<FixedAssetUsageObject> getAllFixedAssetUsageObject()
    {
        return new GetAllRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            FixedAssetUsageObject.class,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<FixedAssetUsageObject> countFixedAssetUsageObject()
    {
        return new CountRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            FixedAssetUsageObject.class,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public
        GetByKeyRequestBuilder<FixedAssetUsageObject>
        getFixedAssetUsageObjectByKey( @Nonnull final String companyCode, @Nonnull final String fixedAssetUsageObject )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("CompanyCode", companyCode);
        key.put("FixedAssetUsageObject", fixedAssetUsageObject);
        return new GetByKeyRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            FixedAssetUsageObject.class,
            key,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<FixedAssetUsageObject> createFixedAssetUsageObject(
        @Nonnull final FixedAssetUsageObject fixedAssetUsageObject )
    {
        return new CreateRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            fixedAssetUsageObject,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<FixedAssetUsageObject> updateFixedAssetUsageObject(
        @Nonnull final FixedAssetUsageObject fixedAssetUsageObject )
    {
        return new UpdateRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            fixedAssetUsageObject,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<FixedAssetUsageObject> deleteFixedAssetUsageObject(
        @Nonnull final FixedAssetUsageObject fixedAssetUsageObject )
    {
        return new DeleteRequestBuilder<FixedAssetUsageObject>(
            servicePath,
            fixedAssetUsageObject,
            "FixedAssetUsageObject");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<FixedAssetUsageObjectPeriod> getAllFixedAssetUsageObjectPeriod()
    {
        return new GetAllRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            FixedAssetUsageObjectPeriod.class,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<FixedAssetUsageObjectPeriod> countFixedAssetUsageObjectPeriod()
    {
        return new CountRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            FixedAssetUsageObjectPeriod.class,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<FixedAssetUsageObjectPeriod> getFixedAssetUsageObjectPeriodByKey(
        @Nonnull final String companyCode,
        @Nonnull final String fixedAssetUsageObject,
        @Nonnull final LocalDate validityEndDate )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("CompanyCode", companyCode);
        key.put("FixedAssetUsageObject", fixedAssetUsageObject);
        key.put("ValidityEndDate", validityEndDate);
        return new GetByKeyRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            FixedAssetUsageObjectPeriod.class,
            key,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<FixedAssetUsageObjectPeriod> createFixedAssetUsageObjectPeriod(
        @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod )
    {
        return new CreateRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            fixedAssetUsageObjectPeriod,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<FixedAssetUsageObjectPeriod> updateFixedAssetUsageObjectPeriod(
        @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod )
    {
        return new UpdateRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            fixedAssetUsageObjectPeriod,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<FixedAssetUsageObjectPeriod> deleteFixedAssetUsageObjectPeriod(
        @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod )
    {
        return new DeleteRequestBuilder<FixedAssetUsageObjectPeriod>(
            servicePath,
            fixedAssetUsageObjectPeriod,
            "FixedAssetUsageObjectPeriod");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<FixedAssetUsageObjectTotal> getAllFixedAssetUsageObjectTotal()
    {
        return new GetAllRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            FixedAssetUsageObjectTotal.class,
            "FixedAssetUsageObjectTotal");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<FixedAssetUsageObjectTotal> countFixedAssetUsageObjectTotal()
    {
        return new CountRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            FixedAssetUsageObjectTotal.class,
            "FixedAssetUsageObjectTotal");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<FixedAssetUsageObjectTotal> getFixedAssetUsageObjectTotalByKey(
        @Nonnull final String companyCode,
        @Nonnull final String fixedAssetUsageObject,
        @Nonnull final String fixedAssetUsageObjectDeprArea,
        @Nonnull final LocalDate validityEndDate )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("CompanyCode", companyCode);
        key.put("FixedAssetUsageObject", fixedAssetUsageObject);
        key.put("FixedAssetUsageObjectDeprArea", fixedAssetUsageObjectDeprArea);
        key.put("ValidityEndDate", validityEndDate);
        return new GetByKeyRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            FixedAssetUsageObjectTotal.class,
            key,
            "FixedAssetUsageObjectTotal");
    }

    @Override
    @Nonnull
    public CreateRequestBuilder<FixedAssetUsageObjectTotal> createFixedAssetUsageObjectTotal(
        @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal )
    {
        return new CreateRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            fixedAssetUsageObjectTotal,
            "FixedAssetUsageObjectTotal");
    }

    @Override
    @Nonnull
    public UpdateRequestBuilder<FixedAssetUsageObjectTotal> updateFixedAssetUsageObjectTotal(
        @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal )
    {
        return new UpdateRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            fixedAssetUsageObjectTotal,
            "FixedAssetUsageObjectTotal");
    }

    @Override
    @Nonnull
    public DeleteRequestBuilder<FixedAssetUsageObjectTotal> deleteFixedAssetUsageObjectTotal(
        @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal )
    {
        return new DeleteRequestBuilder<FixedAssetUsageObjectTotal>(
            servicePath,
            fixedAssetUsageObjectTotal,
            "FixedAssetUsageObjectTotal");
    }

}
