/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes;

import lombok.Getter;

/**
 * <p>
 * 
 * You can read team categories, team types, responsibility attributes, functions assigned to team categories, and
 * responsibility attributes and functions assigned to team types. Each of these entities supports filtering of their
 * properties and the properties of their associations. If you have any problems trying to read these entities because
 * of authorizations or the given filter criteria, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/fd/fc60cb8a5f40bcaa56a1c65acc8b28/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RESPYM_TEAM_CONFIG_SRV_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RESPYM_TEAM_CONFIG_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Responsibility Management Team Integration (SAP_COM_0560)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_RESPYMGMT_CONFIG_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ResponsibilityManagementTeam</td>
 * </tr>
 * </table>
 * 
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultResponsibilityManagementTeamConfigurationService" )
public class DefaultResponsibilityManagementTeamConfigurationService
    implements
    ServiceWithNavigableEntities,
    ResponsibilityManagementTeamConfigurationService
{

    @Nonnull
    @Getter
    private final String servicePath;

    /**
     * Creates a service using {@link ResponsibilityManagementTeamConfigurationService#DEFAULT_SERVICE_PATH} to send the
     * requests.
     * 
     */
    public DefaultResponsibilityManagementTeamConfigurationService()
    {
        servicePath = ResponsibilityManagementTeamConfigurationService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     * 
     */
    private DefaultResponsibilityManagementTeamConfigurationService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultResponsibilityManagementTeamConfigurationService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultResponsibilityManagementTeamConfigurationService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch()
    {
        return new BatchRequestBuilder(servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategories> getAllTeamCategories()
    {
        return new GetAllRequestBuilder<TeamCategories>(servicePath, TeamCategories.class, "TeamCategories");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategories> countTeamCategories()
    {
        return new CountRequestBuilder<TeamCategories>(servicePath, TeamCategories.class, "TeamCategories");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamCategories> getTeamCategoriesByKey( @Nonnull final String respyMgmtTeamCategory )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        return new GetByKeyRequestBuilder<TeamCategories>(servicePath, TeamCategories.class, key, "TeamCategories");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategoryFunctions> getAllTeamCategoryFunctions()
    {
        return new GetAllRequestBuilder<TeamCategoryFunctions>(
            servicePath,
            TeamCategoryFunctions.class,
            "TeamCategoryFunctions");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategoryFunctions> countTeamCategoryFunctions()
    {
        return new CountRequestBuilder<TeamCategoryFunctions>(
            servicePath,
            TeamCategoryFunctions.class,
            "TeamCategoryFunctions");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamCategoryFunctions> getTeamCategoryFunctionsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtFunction )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        key.put("RespyMgmtFunction", respyMgmtFunction);
        return new GetByKeyRequestBuilder<TeamCategoryFunctions>(
            servicePath,
            TeamCategoryFunctions.class,
            key,
            "TeamCategoryFunctions");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategoryFunctionTexts> getAllTeamCategoryFunctionTexts()
    {
        return new GetAllRequestBuilder<TeamCategoryFunctionTexts>(
            servicePath,
            TeamCategoryFunctionTexts.class,
            "TeamCategoryFunctionTexts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategoryFunctionTexts> countTeamCategoryFunctionTexts()
    {
        return new CountRequestBuilder<TeamCategoryFunctionTexts>(
            servicePath,
            TeamCategoryFunctionTexts.class,
            "TeamCategoryFunctionTexts");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamCategoryFunctionTexts> getTeamCategoryFunctionTextsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtFunction,
        @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        key.put("RespyMgmtFunction", respyMgmtFunction);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamCategoryFunctionTexts>(
            servicePath,
            TeamCategoryFunctionTexts.class,
            key,
            "TeamCategoryFunctionTexts");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategoryRespyAttributes> getAllTeamCategoryRespyAttributes()
    {
        return new GetAllRequestBuilder<TeamCategoryRespyAttributes>(
            servicePath,
            TeamCategoryRespyAttributes.class,
            "TeamCategoryRespyAttributes");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategoryRespyAttributes> countTeamCategoryRespyAttributes()
    {
        return new CountRequestBuilder<TeamCategoryRespyAttributes>(
            servicePath,
            TeamCategoryRespyAttributes.class,
            "TeamCategoryRespyAttributes");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamCategoryRespyAttributes> getTeamCategoryRespyAttributesByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtAttributeName )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        key.put("RespyMgmtAttributeName", respyMgmtAttributeName);
        return new GetByKeyRequestBuilder<TeamCategoryRespyAttributes>(
            servicePath,
            TeamCategoryRespyAttributes.class,
            key,
            "TeamCategoryRespyAttributes");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategoryRespyAttributeTxts> getAllTeamCategoryRespyAttributeTxts()
    {
        return new GetAllRequestBuilder<TeamCategoryRespyAttributeTxts>(
            servicePath,
            TeamCategoryRespyAttributeTxts.class,
            "TeamCategoryRespyAttributeTxts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategoryRespyAttributeTxts> countTeamCategoryRespyAttributeTxts()
    {
        return new CountRequestBuilder<TeamCategoryRespyAttributeTxts>(
            servicePath,
            TeamCategoryRespyAttributeTxts.class,
            "TeamCategoryRespyAttributeTxts");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamCategoryRespyAttributeTxts> getTeamCategoryRespyAttributeTxtsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtAttributeName,
        @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        key.put("RespyMgmtAttributeName", respyMgmtAttributeName);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamCategoryRespyAttributeTxts>(
            servicePath,
            TeamCategoryRespyAttributeTxts.class,
            key,
            "TeamCategoryRespyAttributeTxts");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamCategoryTexts> getAllTeamCategoryTexts()
    {
        return new GetAllRequestBuilder<TeamCategoryTexts>(servicePath, TeamCategoryTexts.class, "TeamCategoryTexts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamCategoryTexts> countTeamCategoryTexts()
    {
        return new CountRequestBuilder<TeamCategoryTexts>(servicePath, TeamCategoryTexts.class, "TeamCategoryTexts");
    }

    @Override
    @Nonnull
    public
        GetByKeyRequestBuilder<TeamCategoryTexts>
        getTeamCategoryTextsByKey( @Nonnull final String respyMgmtTeamCategory, @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamCategory", respyMgmtTeamCategory);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamCategoryTexts>(
            servicePath,
            TeamCategoryTexts.class,
            key,
            "TeamCategoryTexts");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypeFunctions> getAllTeamTypeFunctions()
    {
        return new GetAllRequestBuilder<TeamTypeFunctions>(servicePath, TeamTypeFunctions.class, "TeamTypeFunctions");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypeFunctions> countTeamTypeFunctions()
    {
        return new CountRequestBuilder<TeamTypeFunctions>(servicePath, TeamTypeFunctions.class, "TeamTypeFunctions");
    }

    @Override
    @Nonnull
    public
        GetByKeyRequestBuilder<TeamTypeFunctions>
        getTeamTypeFunctionsByKey( @Nonnull final String respyMgmtTeamType, @Nonnull final String respyMgmtFunction )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        key.put("RespyMgmtFunction", respyMgmtFunction);
        return new GetByKeyRequestBuilder<TeamTypeFunctions>(
            servicePath,
            TeamTypeFunctions.class,
            key,
            "TeamTypeFunctions");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypeFunctionTexts> getAllTeamTypeFunctionTexts()
    {
        return new GetAllRequestBuilder<TeamTypeFunctionTexts>(
            servicePath,
            TeamTypeFunctionTexts.class,
            "TeamTypeFunctionTexts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypeFunctionTexts> countTeamTypeFunctionTexts()
    {
        return new CountRequestBuilder<TeamTypeFunctionTexts>(
            servicePath,
            TeamTypeFunctionTexts.class,
            "TeamTypeFunctionTexts");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamTypeFunctionTexts> getTeamTypeFunctionTextsByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtFunction,
        @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        key.put("RespyMgmtFunction", respyMgmtFunction);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamTypeFunctionTexts>(
            servicePath,
            TeamTypeFunctionTexts.class,
            key,
            "TeamTypeFunctionTexts");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypeRespyAttributes> getAllTeamTypeRespyAttributes()
    {
        return new GetAllRequestBuilder<TeamTypeRespyAttributes>(
            servicePath,
            TeamTypeRespyAttributes.class,
            "TeamTypeRespyAttributes");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypeRespyAttributes> countTeamTypeRespyAttributes()
    {
        return new CountRequestBuilder<TeamTypeRespyAttributes>(
            servicePath,
            TeamTypeRespyAttributes.class,
            "TeamTypeRespyAttributes");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamTypeRespyAttributes> getTeamTypeRespyAttributesByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtAttributeName )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        key.put("RespyMgmtAttributeName", respyMgmtAttributeName);
        return new GetByKeyRequestBuilder<TeamTypeRespyAttributes>(
            servicePath,
            TeamTypeRespyAttributes.class,
            key,
            "TeamTypeRespyAttributes");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypeRespyAttributeTexts> getAllTeamTypeRespyAttributeTexts()
    {
        return new GetAllRequestBuilder<TeamTypeRespyAttributeTexts>(
            servicePath,
            TeamTypeRespyAttributeTexts.class,
            "TeamTypeRespyAttributeTexts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypeRespyAttributeTexts> countTeamTypeRespyAttributeTexts()
    {
        return new CountRequestBuilder<TeamTypeRespyAttributeTexts>(
            servicePath,
            TeamTypeRespyAttributeTexts.class,
            "TeamTypeRespyAttributeTexts");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamTypeRespyAttributeTexts> getTeamTypeRespyAttributeTextsByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtAttributeName,
        @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        key.put("RespyMgmtAttributeName", respyMgmtAttributeName);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamTypeRespyAttributeTexts>(
            servicePath,
            TeamTypeRespyAttributeTexts.class,
            key,
            "TeamTypeRespyAttributeTexts");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypes> getAllTeamTypes()
    {
        return new GetAllRequestBuilder<TeamTypes>(servicePath, TeamTypes.class, "TeamTypes");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypes> countTeamTypes()
    {
        return new CountRequestBuilder<TeamTypes>(servicePath, TeamTypes.class, "TeamTypes");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<TeamTypes> getTeamTypesByKey( @Nonnull final String respyMgmtTeamType )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        return new GetByKeyRequestBuilder<TeamTypes>(servicePath, TeamTypes.class, key, "TeamTypes");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<TeamTypeTexts> getAllTeamTypeTexts()
    {
        return new GetAllRequestBuilder<TeamTypeTexts>(servicePath, TeamTypeTexts.class, "TeamTypeTexts");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<TeamTypeTexts> countTeamTypeTexts()
    {
        return new CountRequestBuilder<TeamTypeTexts>(servicePath, TeamTypeTexts.class, "TeamTypeTexts");
    }

    @Override
    @Nonnull
    public
        GetByKeyRequestBuilder<TeamTypeTexts>
        getTeamTypeTextsByKey( @Nonnull final String respyMgmtTeamType, @Nonnull final String language )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("RespyMgmtTeamType", respyMgmtTeamType);
        key.put("Language", language);
        return new GetByKeyRequestBuilder<TeamTypeTexts>(servicePath, TeamTypeTexts.class, key, "TeamTypeTexts");
    }

}
