/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;

import lombok.Getter;

/**
 * <p>
 * 
 * To retrieve sales prices, consumers of this service must specify sales organizational data as well as one or more
 * sold-to parties and product (that is, material) IDs in the service request. Additional criteria can also be applied.
 * In response, the service sends the corresponding sales prices, along with the associated price elements. If any
 * issues occur during sales price retrieval, the response also provides the relevant error messages..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/06/a16320cb994e7ea203fb7f7106f306/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/SALESPRICE_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>SALESPRICE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Sales Price Integration (SAP_COM_0702)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Z6'>External Billing (1Z6)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SALESPRICE</td>
 * </tr>
 * </table>
 * 
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultSalesPriceService" )
public class DefaultSalesPriceService implements ServiceWithNavigableEntities, SalesPriceService
{

    @Nonnull
    @Getter
    private final String servicePath;

    /**
     * Creates a service using {@link SalesPriceService#DEFAULT_SERVICE_PATH} to send the requests.
     * 
     */
    public DefaultSalesPriceService()
    {
        servicePath = SalesPriceService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     * 
     */
    private DefaultSalesPriceService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSalesPriceService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSalesPriceService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch()
    {
        return new BatchRequestBuilder(servicePath);
    }

}
