/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.inject.Named;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.ServiceWithNavigableEntities;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType;

import lombok.Getter;

/**
 * <p>
 * 
 * You retrieve the following data using this OData based service:
 * 
 * You can read the Settlement Document Types and related information.
 * 
 * You can navigate to the Header Text Object Type Assignment for a Settlement Document Type and read the assigned Text
 * Determination Procedure and all the possible Text Object Types linked to it on header level.
 * 
 * You can navigate to the Item Text Object Type Assignment for a Settlement Document Type and read the assigned Text
 * Determination Procedure and all the possible Text Object Types linked to it on item level..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/e0/26c31fb2d0451781b8c4c6e6054aea/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/SETTLMTDOCTYPE_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>SETTLMTDOCTYPE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Settlement Document Type Integration (SAP_COM_0709)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing (1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing (2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative (2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3TD'>Internal Commissions Settlement with SAP Sales Cloud
 * (3TD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SETTLMT_DOC_TYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SettlementDocumentType</td>
 * </tr>
 * </table>
 * 
 */
@Named( "com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.DefaultSettlementDocumentTypeService" )
public class DefaultSettlementDocumentTypeService implements ServiceWithNavigableEntities, SettlementDocumentTypeService
{

    @Nonnull
    @Getter
    private final String servicePath;

    /**
     * Creates a service using {@link SettlementDocumentTypeService#DEFAULT_SERVICE_PATH} to send the requests.
     * 
     */
    public DefaultSettlementDocumentTypeService()
    {
        servicePath = SettlementDocumentTypeService.DEFAULT_SERVICE_PATH;
    }

    /**
     * Creates a service using the provided service path to send the requests.
     * <p>
     * Used by the fluent {@link #withServicePath(String)} method.
     * 
     */
    private DefaultSettlementDocumentTypeService( @Nonnull final String servicePath )
    {
        this.servicePath = servicePath;
    }

    @Override
    @Nonnull
    public DefaultSettlementDocumentTypeService withServicePath( @Nonnull final String servicePath )
    {
        return new DefaultSettlementDocumentTypeService(servicePath);
    }

    @Override
    @Nonnull
    public BatchRequestBuilder batch()
    {
        return new BatchRequestBuilder(servicePath);
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> getAllSetlMgmtHdrTxtObjTypeAssgmt()
    {
        return new GetAllRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtHdrTxtObjTypeAssgmt.class,
            "SetlMgmtHdrTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> countSetlMgmtHdrTxtObjTypeAssgmt()
    {
        return new CountRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtHdrTxtObjTypeAssgmt.class,
            "SetlMgmtHdrTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> getSetlMgmtHdrTxtObjTypeAssgmtByKey(
        @Nonnull final String settlmtHdrTxtDetnProced,
        @Nonnull final String settlmtMgmtHdrTxtObjType )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("SettlmtHdrTxtDetnProced", settlmtHdrTxtDetnProced);
        key.put("SettlmtMgmtHdrTxtObjType", settlmtMgmtHdrTxtObjType);
        return new GetByKeyRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtHdrTxtObjTypeAssgmt.class,
            key,
            "SetlMgmtHdrTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> getAllSetlMgmtItmTxtObjTypeAssgmt()
    {
        return new GetAllRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtItmTxtObjTypeAssgmt.class,
            "SetlMgmtItmTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> countSetlMgmtItmTxtObjTypeAssgmt()
    {
        return new CountRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtItmTxtObjTypeAssgmt.class,
            "SetlMgmtItmTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> getSetlMgmtItmTxtObjTypeAssgmtByKey(
        @Nonnull final String settlmtItmTxtDetnProced,
        @Nonnull final String settlmtMgmtItmTxtObjType )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("SettlmtItmTxtDetnProced", settlmtItmTxtDetnProced);
        key.put("SettlmtMgmtItmTxtObjType", settlmtMgmtItmTxtObjType);
        return new GetByKeyRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt>(
            servicePath,
            SetlMgmtItmTxtObjTypeAssgmt.class,
            key,
            "SetlMgmtItmTxtObjTypeAssgmt");
    }

    @Override
    @Nonnull
    public GetAllRequestBuilder<SettlmtDocType> getAllSettlmtDocType()
    {
        return new GetAllRequestBuilder<SettlmtDocType>(servicePath, SettlmtDocType.class, "SettlmtDocType");
    }

    @Override
    @Nonnull
    public CountRequestBuilder<SettlmtDocType> countSettlmtDocType()
    {
        return new CountRequestBuilder<SettlmtDocType>(servicePath, SettlmtDocType.class, "SettlmtDocType");
    }

    @Override
    @Nonnull
    public GetByKeyRequestBuilder<SettlmtDocType> getSettlmtDocTypeByKey( @Nonnull final String settlmtDocType )
    {
        final Map<String, Object> key = new HashMap<String, Object>();
        key.put("SettlmtDocType", settlmtDocType);
        return new GetByKeyRequestBuilder<SettlmtDocType>(servicePath, SettlmtDocType.class, key, "SettlmtDocType");
    }

}
