/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource;

/**
 * <p>
 * 
 * This service enables you to read available External Source IDs and send amounts to the system. You can send multiple
 * amounts via a changeset..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/a6/54bb3526e34b7abf4450d08eb4ca50/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/EHSAMOUNTEXTERNALSRCE_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>EHSAMOUNTEXTERNALSRCE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Environment, Health, and Safety - Automatic Data Collection Integration (SAP_COM_0747)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/4XD'>Emissions Management (4XD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_EHSAMOUNTEXTERNALSRCE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>EHSDataCollection</td>
 * </tr>
 * </table>
 * 
 */
public interface EnvironmentHealthAndSafetyExternalSourceService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH =
        "/sap/opu/odata4/sap/api_ehsamountexternalsrce/srvd_a2x/sap/ehsamountexternalsrce/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    EnvironmentHealthAndSafetyExternalSourceService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     * EHSAmountExternalSource} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     *         EHSAmountExternalSource} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<EHSAmountExternalSource> getAllEHSAmountExternalSource();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     * EHSAmountExternalSource} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     *         EHSAmountExternalSource} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<EHSAmountExternalSource> countEHSAmountExternalSource();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     * EHSAmountExternalSource} entity using key fields.
     * 
     * @param eHSAmountExternalSource
     *            External Source
     *            <p>
     *            Constraints: Not nullable, Maximum length: 80
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource
     *         EHSAmountExternalSource} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.environmenthealthandsafetyexternalsource.EHSAmountExternalSource>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<EHSAmountExternalSource>
        getEHSAmountExternalSourceByKey( @Nonnull final String eHSAmountExternalSource );

}
