/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.time.LocalDate;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal;

/**
 * <p>
 * 
 * This service contains the following nodes that are necessary for a usage object, including: usage object, usage
 * object total units, and usage object period units.
 * 
 * Please note: You only use this service if you use the units-of-production method of depreciation..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/aa/8804b87fef4d9b82e887f509e41d65/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/FIXEDASSETUSAGEOBJECT_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>FIXEDASSETUSAGEOBJECT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Finance - Fixed Asset Integration (SAP_COM_0563)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/J62'>Asset Accounting (J62)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_FIXEDASSETUSAGEOBJECT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>FixedAssetUsageObject</td>
 * </tr>
 * </table>
 * 
 */
public interface FixedAssetUsageObjectForUoPDepreciationService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH =
        "/sap/opu/odata4/sap/api_fixedassetusageobject/srvd_a2x/sap/fixedassetusageobject/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    FixedAssetUsageObjectForUoPDepreciationService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<FixedAssetUsageObject> getAllFixedAssetUsageObject();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<FixedAssetUsageObject> countFixedAssetUsageObject();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fixedAssetUsageObject
     *            Usage Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<FixedAssetUsageObject>
        getFixedAssetUsageObjectByKey( @Nonnull final String companyCode, @Nonnull final String fixedAssetUsageObject );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *            FixedAssetUsageObject} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<FixedAssetUsageObject>
        createFixedAssetUsageObject( @Nonnull final FixedAssetUsageObject fixedAssetUsageObject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *            FixedAssetUsageObject} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<FixedAssetUsageObject>
        updateFixedAssetUsageObject( @Nonnull final FixedAssetUsageObject fixedAssetUsageObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     * FixedAssetUsageObject} entity in the S/4HANA system.
     * 
     * @param fixedAssetUsageObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *            FixedAssetUsageObject} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject
     *         FixedAssetUsageObject} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObject>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<FixedAssetUsageObject>
        deleteFixedAssetUsageObject( @Nonnull final FixedAssetUsageObject fixedAssetUsageObject );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<FixedAssetUsageObjectPeriod> getAllFixedAssetUsageObjectPeriod();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<FixedAssetUsageObjectPeriod> countFixedAssetUsageObjectPeriod();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fixedAssetUsageObject
     *            Usage Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param validityEndDate
     *            Date Validity Ends
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<FixedAssetUsageObjectPeriod> getFixedAssetUsageObjectPeriodByKey(
        @Nonnull final String companyCode,
        @Nonnull final String fixedAssetUsageObject,
        @Nonnull final LocalDate validityEndDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *            FixedAssetUsageObjectPeriod} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<FixedAssetUsageObjectPeriod>
        createFixedAssetUsageObjectPeriod( @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *            FixedAssetUsageObjectPeriod} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<FixedAssetUsageObjectPeriod>
        updateFixedAssetUsageObjectPeriod( @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     * FixedAssetUsageObjectPeriod} entity in the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectPeriod
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *            FixedAssetUsageObjectPeriod} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod
     *         FixedAssetUsageObjectPeriod} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectPeriod>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<FixedAssetUsageObjectPeriod>
        deleteFixedAssetUsageObjectPeriod( @Nonnull final FixedAssetUsageObjectPeriod fixedAssetUsageObjectPeriod );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<FixedAssetUsageObjectTotal> getAllFixedAssetUsageObjectTotal();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<FixedAssetUsageObjectTotal> countFixedAssetUsageObjectTotal();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entity using key fields.
     * 
     * @param companyCode
     *            Fixed Asset Usage Object Projection View
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fixedAssetUsageObject
     *            Usage Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param fixedAssetUsageObjectDeprArea
     *            Depreciation Area (incl. Generic Entry)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param validityEndDate
     *            Date Validity Ends
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<FixedAssetUsageObjectTotal> getFixedAssetUsageObjectTotalByKey(
        @Nonnull final String companyCode,
        @Nonnull final String fixedAssetUsageObject,
        @Nonnull final String fixedAssetUsageObjectDeprArea,
        @Nonnull final LocalDate validityEndDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectTotal
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *            FixedAssetUsageObjectTotal} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<FixedAssetUsageObjectTotal>
        createFixedAssetUsageObjectTotal( @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entity and save it to the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectTotal
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *            FixedAssetUsageObjectTotal} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<FixedAssetUsageObjectTotal>
        updateFixedAssetUsageObjectTotal( @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     * FixedAssetUsageObjectTotal} entity in the S/4HANA system.
     * 
     * @param fixedAssetUsageObjectTotal
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *            FixedAssetUsageObjectTotal} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal
     *         FixedAssetUsageObjectTotal} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.fixedassetusageobjectforuopdepreciation.FixedAssetUsageObjectTotal>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<FixedAssetUsageObjectTotal>
        deleteFixedAssetUsageObjectTotal( @Nonnull final FixedAssetUsageObjectTotal fixedAssetUsageObjectTotal );

}
