/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem;

/**
 * <p>
 * 
 * The service enables you to initiate the in-house repair process from an external system. You can create in-house
 * repairs and add repair objects. You can also read and update in-house repairs..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/40/347a9ad1b54a4b931ea07b54faa42d/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/INHOUSEREPAIR_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>INHOUSEREPAIR_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Service - In-House Repair OData Integration (SAP_COM_0717)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair (3XK)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_INHOUSEREPAIR</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>InHouseRepair</td>
 * </tr>
 * </table>
 * 
 */
public interface InHouseRepairService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_inhouserepair/srvd_a2x/sap/inhouserepair/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    InHouseRepairService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     * InHouseRepair} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<InHouseRepair> getAllInHouseRepair();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair} entity
     * collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<InHouseRepair> countInHouseRepair();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     * InHouseRepair} entity using key fields.
     * 
     * @param inHouseRepair
     *            In-House Repair ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair}
     *         entity using key fields. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<InHouseRepair> getInHouseRepairByKey( @Nonnull final String inHouseRepair );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     * InHouseRepair} entity and save it to the S/4HANA system.
     * 
     * @param inHouseRepair
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     *            InHouseRepair} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<InHouseRepair> createInHouseRepair( @Nonnull final InHouseRepair inHouseRepair );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     * InHouseRepair} entity and save it to the S/4HANA system.
     * 
     * @param inHouseRepair
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair
     *            InHouseRepair} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair InHouseRepair}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepair>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<InHouseRepair> updateInHouseRepair( @Nonnull final InHouseRepair inHouseRepair );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     * InHouseRepairItem} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *         InHouseRepairItem} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<InHouseRepairItem> getAllInHouseRepairItem();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem InHouseRepairItem}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *         InHouseRepairItem} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<InHouseRepairItem> countInHouseRepairItem();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     * InHouseRepairItem} entity using key fields.
     * 
     * @param inHouseRepairItem
     *            Repair Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param inHouseRepair
     *            In-House Repair ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *         InHouseRepairItem} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<InHouseRepairItem>
        getInHouseRepairItemByKey( @Nonnull final String inHouseRepair, @Nonnull final String inHouseRepairItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     * InHouseRepairItem} entity and save it to the S/4HANA system.
     * 
     * @param inHouseRepairItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *            InHouseRepairItem} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *         InHouseRepairItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<InHouseRepairItem>
        createInHouseRepairItem( @Nonnull final InHouseRepairItem inHouseRepairItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     * InHouseRepairItem} entity in the S/4HANA system.
     * 
     * @param inHouseRepairItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *            InHouseRepairItem} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem
     *         InHouseRepairItem} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.inhouserepair.InHouseRepairItem>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<InHouseRepairItem>
        deleteInHouseRepairItem( @Nonnull final InHouseRepairItem inHouseRepairItem );

}
