/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText;

/**
 * <p>
 * The service contains Joint Operating Agreement, Description, Equity Group, Penalty Category Recovery Percentage and
 * Partner Share nodes. The information is sent in the request as a payload, which is used in creating or updating a
 * Joint Operating Agreement, including appropriate checks for restricted values and authorizations. If there are any
 * issues when the Joint Operating Agreement is created, updated or deleted, the system displays error messages in the
 * response.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/84/4ec46a9ed5480cbde49aec559c37ff/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_JNTOPGAGRMT_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_JNTOPGAGRMT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Joint Venture Accounting API Integration (SAP_COM_0383)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3F7'>Joint Venture Accounting (3F7)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_JNTOPGAGRMT</td>
 * </tr>
 * </table>
 * 
 */
public interface JointOperatingAgreementService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_jntopgagrmt/srvd_a2x/sap/api_jntopgagrmt/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    JointOperatingAgreementService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     * JntOpgAgrmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<JntOpgAgrmt> getAllJntOpgAgrmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt JntOpgAgrmt}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<JntOpgAgrmt> countJntOpgAgrmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     * JntOpgAgrmt} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<JntOpgAgrmt>
        getJntOpgAgrmtByKey( @Nonnull final String companyCode, @Nonnull final String jntOpgAgrmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     * JntOpgAgrmt} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *            JntOpgAgrmt} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<JntOpgAgrmt> createJntOpgAgrmt( @Nonnull final JntOpgAgrmt jntOpgAgrmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt JntOpgAgrmt}
     * entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *            JntOpgAgrmt} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<JntOpgAgrmt> updateJntOpgAgrmt( @Nonnull final JntOpgAgrmt jntOpgAgrmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt JntOpgAgrmt}
     * entity in the S/4HANA system.
     * 
     * @param jntOpgAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *            JntOpgAgrmt} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt
     *         JntOpgAgrmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<JntOpgAgrmt> deleteJntOpgAgrmt( @Nonnull final JntOpgAgrmt jntOpgAgrmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<JntOpgAgrmtEquityTypeGrp> getAllJntOpgAgrmtEquityTypeGrp();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<JntOpgAgrmtEquityTypeGrp> countJntOpgAgrmtEquityTypeGrp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group - JOA level
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<JntOpgAgrmtEquityTypeGrp> getJntOpgAgrmtEquityTypeGrpByKey(
        @Nonnull final String companyCode,
        @Nonnull final String jntOpgAgrmt,
        @Nonnull final String jntOpgAgrmtEquityGrp );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtEquityTypeGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *            JntOpgAgrmtEquityTypeGrp} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<JntOpgAgrmtEquityTypeGrp>
        createJntOpgAgrmtEquityTypeGrp( @Nonnull final JntOpgAgrmtEquityTypeGrp jntOpgAgrmtEquityTypeGrp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtEquityTypeGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *            JntOpgAgrmtEquityTypeGrp} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<JntOpgAgrmtEquityTypeGrp>
        updateJntOpgAgrmtEquityTypeGrp( @Nonnull final JntOpgAgrmtEquityTypeGrp jntOpgAgrmtEquityTypeGrp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     * JntOpgAgrmtEquityTypeGrp} entity in the S/4HANA system.
     * 
     * @param jntOpgAgrmtEquityTypeGrp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *            JntOpgAgrmtEquityTypeGrp} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp
     *         JntOpgAgrmtEquityTypeGrp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtEquityTypeGrp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<JntOpgAgrmtEquityTypeGrp>
        deleteJntOpgAgrmtEquityTypeGrp( @Nonnull final JntOpgAgrmtEquityTypeGrp jntOpgAgrmtEquityTypeGrp );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<JntOpgAgrmtPartShr> getAllJntOpgAgrmtPartShr();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<JntOpgAgrmtPartShr> countJntOpgAgrmtPartShr();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jntOpgAgrmtEquityGrp
     *            Equity Group - JOA level
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param jointVenturePartner
     *            JV partner
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<JntOpgAgrmtPartShr> getJntOpgAgrmtPartShrByKey(
        @Nonnull final String companyCode,
        @Nonnull final String jntOpgAgrmt,
        @Nonnull final String jntOpgAgrmtEquityGrp,
        @Nonnull final String jointVenturePartner );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtPartShr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *            JntOpgAgrmtPartShr} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<JntOpgAgrmtPartShr>
        createJntOpgAgrmtPartShr( @Nonnull final JntOpgAgrmtPartShr jntOpgAgrmtPartShr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtPartShr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *            JntOpgAgrmtPartShr} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<JntOpgAgrmtPartShr>
        updateJntOpgAgrmtPartShr( @Nonnull final JntOpgAgrmtPartShr jntOpgAgrmtPartShr );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     * JntOpgAgrmtPartShr} entity in the S/4HANA system.
     * 
     * @param jntOpgAgrmtPartShr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *            JntOpgAgrmtPartShr} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr
     *         JntOpgAgrmtPartShr} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPartShr>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<JntOpgAgrmtPartShr>
        deleteJntOpgAgrmtPartShr( @Nonnull final JntOpgAgrmtPartShr jntOpgAgrmtPartShr );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<JntOpgAgrmtPnltyCatRcvry> getAllJntOpgAgrmtPnltyCatRcvry();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<JntOpgAgrmtPnltyCatRcvry> countJntOpgAgrmtPnltyCatRcvry();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param jntVntrPenaltyCategory
     *            Penalty Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<JntOpgAgrmtPnltyCatRcvry> getJntOpgAgrmtPnltyCatRcvryByKey(
        @Nonnull final String companyCode,
        @Nonnull final String jntOpgAgrmt,
        @Nonnull final String jntVntrPenaltyCategory );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtPnltyCatRcvry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *            JntOpgAgrmtPnltyCatRcvry} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<JntOpgAgrmtPnltyCatRcvry>
        createJntOpgAgrmtPnltyCatRcvry( @Nonnull final JntOpgAgrmtPnltyCatRcvry jntOpgAgrmtPnltyCatRcvry );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtPnltyCatRcvry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *            JntOpgAgrmtPnltyCatRcvry} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<JntOpgAgrmtPnltyCatRcvry>
        updateJntOpgAgrmtPnltyCatRcvry( @Nonnull final JntOpgAgrmtPnltyCatRcvry jntOpgAgrmtPnltyCatRcvry );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     * JntOpgAgrmtPnltyCatRcvry} entity in the S/4HANA system.
     * 
     * @param jntOpgAgrmtPnltyCatRcvry
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *            JntOpgAgrmtPnltyCatRcvry} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry
     *         JntOpgAgrmtPnltyCatRcvry} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtPnltyCatRcvry>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<JntOpgAgrmtPnltyCatRcvry>
        deleteJntOpgAgrmtPnltyCatRcvry( @Nonnull final JntOpgAgrmtPnltyCatRcvry jntOpgAgrmtPnltyCatRcvry );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<JntOpgAgrmtText> getAllJntOpgAgrmtText();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<JntOpgAgrmtText> countJntOpgAgrmtText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entity using key fields.
     * 
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param jntOpgAgrmt
     *            Joint Operating Agreement
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<JntOpgAgrmtText> getJntOpgAgrmtTextByKey(
        @Nonnull final String companyCode,
        @Nonnull final String language,
        @Nonnull final String jntOpgAgrmt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *            JntOpgAgrmtText} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<JntOpgAgrmtText> createJntOpgAgrmtText( @Nonnull final JntOpgAgrmtText jntOpgAgrmtText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entity and save it to the S/4HANA system.
     * 
     * @param jntOpgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *            JntOpgAgrmtText} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<JntOpgAgrmtText> updateJntOpgAgrmtText( @Nonnull final JntOpgAgrmtText jntOpgAgrmtText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     * JntOpgAgrmtText} entity in the S/4HANA system.
     * 
     * @param jntOpgAgrmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *            JntOpgAgrmtText} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText
     *         JntOpgAgrmtText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.jointoperatingagreement.JntOpgAgrmtText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<JntOpgAgrmtText> deleteJntOpgAgrmtText( @Nonnull final JntOpgAgrmtText jntOpgAgrmtText );

}
