/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp;

/**
 * <p>
 * 
 * The service describes the sequence of individual maintenance activities that must be performed repeatedly within a
 * company. There are three types of task list. The task list comprises equipment task list, functional location task
 * list, and general maintenance task list. The payload used to create a task list through this API is sent in JSON
 * format as a request object. The long text of the task list is included within the payload as a nested object. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/21/d658b2c6e7444f87d0cef5cdd40b7f/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/MAINTENANCETASKLIST_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>MAINTENANCETASKLIST_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration (SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring (3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management (3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair (3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service Management
 * (49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation (4GA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance (4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance (4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance (4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance (4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance (BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance (BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance (BJ2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_MAINTENANCETASKLIST</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>MaintenanceTaskList</td>
 * </tr>
 * </table>
 * 
 */
public interface MaintenanceTasklistService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_maintenancetasklist/srvd_a2x/sap/maintenancetasklist/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MaintenanceTasklistService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     * MaintenanceTaskList} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *         MaintenanceTaskList} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskList> getAllMaintenanceTaskList();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     * MaintenanceTaskList} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *         MaintenanceTaskList} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskList> countMaintenanceTaskList();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     * MaintenanceTaskList} entity using key fields.
     * 
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *         MaintenanceTaskList} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskList> getMaintenanceTaskListByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListVersionCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     * MaintenanceTaskList} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *            MaintenanceTaskList} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *         MaintenanceTaskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskList>
        createMaintenanceTaskList( @Nonnull final MaintenanceTaskList maintenanceTaskList );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     * MaintenanceTaskList} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *            MaintenanceTaskList} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList
     *         MaintenanceTaskList} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskList>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskList>
        updateMaintenanceTaskList( @Nonnull final MaintenanceTaskList maintenanceTaskList );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     * MaintenanceTaskListLongText} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *         MaintenanceTaskListLongText} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListLongText> getAllMaintenanceTaskListLongText();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     * MaintenanceTaskListLongText} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *         MaintenanceTaskListLongText} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListLongText> countMaintenanceTaskListLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     * MaintenanceTaskListLongText} entity using key fields.
     * 
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListVersionCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *         MaintenanceTaskListLongText} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListLongText> getMaintenanceTaskListLongTextByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListVersionCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     * MaintenanceTaskListLongText} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *            MaintenanceTaskListLongText} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *         MaintenanceTaskListLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListLongText>
        createMaintenanceTaskListLongText( @Nonnull final MaintenanceTaskListLongText maintenanceTaskListLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     * MaintenanceTaskListLongText} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *            MaintenanceTaskListLongText} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText
     *         MaintenanceTaskListLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListLongText>
        updateMaintenanceTaskListLongText( @Nonnull final MaintenanceTaskListLongText maintenanceTaskListLongText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     * MaintenanceTaskListOperation} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *         MaintenanceTaskListOperation} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListOperation> getAllMaintenanceTaskListOperation();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     * MaintenanceTaskListOperation} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *         MaintenanceTaskListOperation} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListOperation> countMaintenanceTaskListOperation();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     * MaintenanceTaskListOperation} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *         MaintenanceTaskListOperation} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListOperation> getMaintenanceTaskListOperationByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String taskListOpBOMItmIntVersCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     * MaintenanceTaskListOperation} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *            MaintenanceTaskListOperation} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *         MaintenanceTaskListOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListOperation>
        createMaintenanceTaskListOperation( @Nonnull final MaintenanceTaskListOperation maintenanceTaskListOperation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     * MaintenanceTaskListOperation} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOperation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *            MaintenanceTaskListOperation} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation
     *         MaintenanceTaskListOperation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOperation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListOperation>
        updateMaintenanceTaskListOperation( @Nonnull final MaintenanceTaskListOperation maintenanceTaskListOperation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     * MaintenanceTaskListOpLongText} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *         MaintenanceTaskListOpLongText} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListOpLongText> getAllMaintenanceTaskListOpLongText();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     * MaintenanceTaskListOpLongText} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *         MaintenanceTaskListOpLongText} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListOpLongText> countMaintenanceTaskListOpLongText();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     * MaintenanceTaskListOpLongText} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *         MaintenanceTaskListOpLongText} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListOpLongText> getMaintenanceTaskListOpLongTextByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String taskListOpBOMItmIntVersCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     * MaintenanceTaskListOpLongText} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *            MaintenanceTaskListOpLongText} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *         MaintenanceTaskListOpLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListOpLongText> createMaintenanceTaskListOpLongText(
        @Nonnull final MaintenanceTaskListOpLongText maintenanceTaskListOpLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     * MaintenanceTaskListOpLongText} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *            MaintenanceTaskListOpLongText} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText
     *         MaintenanceTaskListOpLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListOpLongText> updateMaintenanceTaskListOpLongText(
        @Nonnull final MaintenanceTaskListOpLongText maintenanceTaskListOpLongText );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     * MaintenanceTaskListOpMat} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *         MaintenanceTaskListOpMat} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListOpMat> getAllMaintenanceTaskListOpMat();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     * MaintenanceTaskListOpMat} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *         MaintenanceTaskListOpMat} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListOpMat> countMaintenanceTaskListOpMat();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     * MaintenanceTaskListOpMat} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmInternalID
     *            No. for material comp. allocation to task list
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Task list node number for operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *         MaintenanceTaskListOpMat} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListOpMat> getMaintenanceTaskListOpMatByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String taskListOpBOMItmInternalID,
        @Nonnull final String taskListOpBOMItmIntVersCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     * MaintenanceTaskListOpMat} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *            MaintenanceTaskListOpMat} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *         MaintenanceTaskListOpMat} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListOpMat>
        createMaintenanceTaskListOpMat( @Nonnull final MaintenanceTaskListOpMat maintenanceTaskListOpMat );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     * MaintenanceTaskListOpMat} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpMat
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *            MaintenanceTaskListOpMat} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat
     *         MaintenanceTaskListOpMat} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpMat>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListOpMat>
        updateMaintenanceTaskListOpMat( @Nonnull final MaintenanceTaskListOpMat maintenanceTaskListOpMat );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     * MaintenanceTaskListOpReltnshp} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *         MaintenanceTaskListOpReltnshp} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListOpReltnshp> getAllMaintenanceTaskListOpReltnshp();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     * MaintenanceTaskListOpReltnshp} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *         MaintenanceTaskListOpReltnshp} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListOpReltnshp> countMaintenanceTaskListOpReltnshp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     * MaintenanceTaskListOpReltnshp} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Number of the Standard Network
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *         MaintenanceTaskListOpReltnshp} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListOpReltnshp> getMaintenanceTaskListOpReltnshpByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String taskListOpBOMItmIntVersCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     * MaintenanceTaskListOpReltnshp} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpReltnshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *            MaintenanceTaskListOpReltnshp} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *         MaintenanceTaskListOpReltnshp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListOpReltnshp> createMaintenanceTaskListOpReltnshp(
        @Nonnull final MaintenanceTaskListOpReltnshp maintenanceTaskListOpReltnshp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     * MaintenanceTaskListOpReltnshp} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListOpReltnshp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *            MaintenanceTaskListOpReltnshp} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp
     *         MaintenanceTaskListOpReltnshp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListOpReltnshp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListOpReltnshp> updateMaintenanceTaskListOpReltnshp(
        @Nonnull final MaintenanceTaskListOpReltnshp maintenanceTaskListOpReltnshp );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     * MaintenanceTaskListStrtgyPckg} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *         MaintenanceTaskListStrtgyPckg} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListStrtgyPckg> getAllMaintenanceTaskListStrtgyPckg();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     * MaintenanceTaskListStrtgyPckg} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *         MaintenanceTaskListStrtgyPckg} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListStrtgyPckg> countMaintenanceTaskListStrtgyPckg();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     * MaintenanceTaskListStrtgyPckg} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param maintenancePackage
     *            Maintenance Package Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param maintPckgTskListOpAllocIntNmbr
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *         MaintenanceTaskListStrtgyPckg} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListStrtgyPckg> getMaintenanceTaskListStrtgyPckgByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String maintenancePackage,
        @Nonnull final String maintPckgTskListOpAllocIntNmbr );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     * MaintenanceTaskListStrtgyPckg} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListStrtgyPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *            MaintenanceTaskListStrtgyPckg} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *         MaintenanceTaskListStrtgyPckg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListStrtgyPckg> createMaintenanceTaskListStrtgyPckg(
        @Nonnull final MaintenanceTaskListStrtgyPckg maintenanceTaskListStrtgyPckg );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     * MaintenanceTaskListStrtgyPckg} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListStrtgyPckg
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *            MaintenanceTaskListStrtgyPckg} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg
     *         MaintenanceTaskListStrtgyPckg} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListStrtgyPckg>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListStrtgyPckg> updateMaintenanceTaskListStrtgyPckg(
        @Nonnull final MaintenanceTaskListStrtgyPckg maintenanceTaskListStrtgyPckg );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     * MaintenanceTaskListSubOp} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *         MaintenanceTaskListSubOp} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MaintenanceTaskListSubOp> getAllMaintenanceTaskListSubOp();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     * MaintenanceTaskListSubOp} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *         MaintenanceTaskListSubOp} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MaintenanceTaskListSubOp> countMaintenanceTaskListSubOp();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     * MaintenanceTaskListSubOp} entity using key fields.
     * 
     * @param taskListSequence
     *            Sequence
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param taskListType
     *            Task List Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param taskListGroupCounter
     *            Group Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param taskListGroup
     *            Key for Task List Group
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOpBOMItmIntVersCounter
     *            Internal counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param taskListOperationInternalId
     *            Number of the Task List Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *         MaintenanceTaskListSubOp} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MaintenanceTaskListSubOp> getMaintenanceTaskListSubOpByKey(
        @Nonnull final String taskListType,
        @Nonnull final String taskListGroup,
        @Nonnull final String taskListGroupCounter,
        @Nonnull final String taskListSequence,
        @Nonnull final String taskListOperationInternalId,
        @Nonnull final String taskListOpBOMItmIntVersCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     * MaintenanceTaskListSubOp} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListSubOp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *            MaintenanceTaskListSubOp} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *         MaintenanceTaskListSubOp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MaintenanceTaskListSubOp>
        createMaintenanceTaskListSubOp( @Nonnull final MaintenanceTaskListSubOp maintenanceTaskListSubOp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     * MaintenanceTaskListSubOp} entity and save it to the S/4HANA system.
     * 
     * @param maintenanceTaskListSubOp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *            MaintenanceTaskListSubOp} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp
     *         MaintenanceTaskListSubOp} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.maintenancetasklist.MaintenanceTaskListSubOp>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MaintenanceTaskListSubOp>
        updateMaintenanceTaskListSubOp( @Nonnull final MaintenanceTaskListSubOp maintenanceTaskListSubOp );

}
