/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText;

/**
 * <p>
 * 
 * In Plant Maintenance, measuring points are located on technical objects such as pieces of equipment or at functional
 * locations. The payload used to create a measuring point through this API is sent in JSON format as a request object.
 * The long text for the measuring point is included within as a nested object. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/8c/dfef769b2b4f7195a5f296982e2fe6/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/MEASURINGPOINT_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>MEASURINGPOINT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Asset Management Master Data Integration (SAP_COM_0395)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/3D2'>Service Order Management and Monitoring (3D2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3MO'>Service Contract Management (3MO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3XK'>In-House Repair (3XK)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/49X'>Service Order Processing with SAP Field Service Management
 * (49X)</a>, <a href='https://rapid.sap.com/bp/#/scopeitems/4GA'>Service Quotation (4GA)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HH'>Reactive Maintenance (4HH)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4HI'>Proactive Maintenance (4HI)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4VT'>Improvement Maintenance (4VT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/4WM'>Operational and Overhead Maintenance (4WM)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH1'>Corrective Maintenance (BH1)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BH2'>Emergency Maintenance (BH2)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/BJ2'>Preventive Maintenance (BJ2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_MEASURINGPOINT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>MeasuringPoint</td>
 * </tr>
 * </table>
 * 
 */
public interface MeasuringPointService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_measuringpoint/srvd_a2x/sap/measuringpoint/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    MeasuringPointService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     * MeasuringPoint} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *         MeasuringPoint} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MeasuringPoint> getAllMeasuringPoint();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint MeasuringPoint} entity
     * collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *         MeasuringPoint} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MeasuringPoint> countMeasuringPoint();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     * MeasuringPoint} entity using key fields.
     * 
     * @param measuringPoint
     *            Measuring Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *         MeasuringPoint} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MeasuringPoint> getMeasuringPointByKey( @Nonnull final String measuringPoint );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     * MeasuringPoint} entity and save it to the S/4HANA system.
     * 
     * @param measuringPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *            MeasuringPoint} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *         MeasuringPoint} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MeasuringPoint> createMeasuringPoint( @Nonnull final MeasuringPoint measuringPoint );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     * MeasuringPoint} entity and save it to the S/4HANA system.
     * 
     * @param measuringPoint
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *            MeasuringPoint} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint
     *         MeasuringPoint} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPoint>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MeasuringPoint> updateMeasuringPoint( @Nonnull final MeasuringPoint measuringPoint );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     * MeasuringPointLongText} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *         MeasuringPointLongText} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<MeasuringPointLongText> getAllMeasuringPointLongText();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     * MeasuringPointLongText} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *         MeasuringPointLongText} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<MeasuringPointLongText> countMeasuringPointLongText();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     * MeasuringPointLongText} entity using key fields.
     * 
     * @param measuringPoint
     *            Measuring Point
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *         MeasuringPointLongText} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<MeasuringPointLongText>
        getMeasuringPointLongTextByKey( @Nonnull final String measuringPoint );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     * MeasuringPointLongText} entity and save it to the S/4HANA system.
     * 
     * @param measuringPointLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *            MeasuringPointLongText} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *         MeasuringPointLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<MeasuringPointLongText>
        createMeasuringPointLongText( @Nonnull final MeasuringPointLongText measuringPointLongText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     * MeasuringPointLongText} entity and save it to the S/4HANA system.
     * 
     * @param measuringPointLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *            MeasuringPointLongText} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText
     *         MeasuringPointLongText} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.measuringpoint.MeasuringPointLongText>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<MeasuringPointLongText>
        updateMeasuringPointLongText( @Nonnull final MeasuringPointLongText measuringPointLongText );

}
