/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn;

/**
 * <p>
 * This service enables you to create product exclusions based on various factors like time range validities,
 * plant-specific, and application-specific. Additionally, predefined groups can be applied on these product exclusions.
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/98/013b603ed54532a5a6c3ea7cd975be/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/PRODUCTEXCLUSION_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>PRODUCTEXCLUSION_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Master Data - Product Exclusion Integration (SAP_COM_0708)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing (1JW)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_PRODSUBSTNEXCLSN</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ProductExclusion</td>
 * </tr>
 * </table>
 * 
 */
public interface ProductExclusionService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_prodsubstnexclsn/srvd_a2x/sap/productexclusion/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductExclusionService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     * ProdSubstnExclsn} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<ProdSubstnExclsn> getAllProdSubstnExclsn();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn ProdSubstnExclsn}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<ProdSubstnExclsn> countProdSubstnExclsn();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     * ProdSubstnExclsn} entity using key fields.
     * 
     * @param mDSubstnUUID
     *            Substitution UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<ProdSubstnExclsn> getProdSubstnExclsnByKey( @Nonnull final UUID mDSubstnUUID );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     * ProdSubstnExclsn} entity and save it to the S/4HANA system.
     * 
     * @param prodSubstnExclsn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *            ProdSubstnExclsn} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<ProdSubstnExclsn> createProdSubstnExclsn( @Nonnull final ProdSubstnExclsn prodSubstnExclsn );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     * ProdSubstnExclsn} entity and save it to the S/4HANA system.
     * 
     * @param prodSubstnExclsn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *            ProdSubstnExclsn} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<ProdSubstnExclsn> updateProdSubstnExclsn( @Nonnull final ProdSubstnExclsn prodSubstnExclsn );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn ProdSubstnExclsn}
     * entity in the S/4HANA system.
     * 
     * @param prodSubstnExclsn
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *            ProdSubstnExclsn} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn
     *         ProdSubstnExclsn} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.productexclusion.ProdSubstnExclsn>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<ProdSubstnExclsn> deleteProdSubstnExclsn( @Nonnull final ProdSubstnExclsn prodSubstnExclsn );

}
