/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.time.LocalDate;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy;

/**
 * <p>
 * 
 * This synchronous inbound OData service enables external systems and other consumers to read currently active version
 * for a given Hierarchy ID, or the version with a specified validity date.
 * 
 * You can also use this service to read the details of a particular hierarchy, such as the node, its parent, its
 * children and other attributes of a node, and so on. This information is used in the processes related to sales and
 * distribution..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/ce/d04ba703d248f88b862e22cb3b536b/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/PRODHIERNODES_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>PRODHIERNODES_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Product Integration (SAP_COM_0009)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1RO'>Master Data Integration (1RO)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/1VP'>Opportunity-to-Order with SAP Cloud for Customer (1VP)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_PROD_HIER_NODES_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 * 
 */
public interface ProductHierarchyNodeService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_prod_hier_nodes_srv/srvd_a2x/sap/prodhiernodes/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ProductHierarchyNodeService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     * ProdUniversalHierarchy} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     *         ProdUniversalHierarchy} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<ProdUniversalHierarchy> getAllProdUniversalHierarchy();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     * ProdUniversalHierarchy} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     *         ProdUniversalHierarchy} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<ProdUniversalHierarchy> countProdUniversalHierarchy();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     * ProdUniversalHierarchy} entity using key fields.
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param prodUnivHierarchy
     *            Product Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy
     *         ProdUniversalHierarchy} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUniversalHierarchy>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<ProdUniversalHierarchy> getProdUniversalHierarchyByKey(
        @Nonnull final String prodUnivHierarchy,
        @Nonnull final LocalDate prodHierarchyValidityEndDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     * ProdUnivHierNodeByHierID} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     *         ProdUnivHierNodeByHierID} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<ProdUnivHierNodeByHierID> getAllProdUnivHierNodeByHierID();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     * ProdUnivHierNodeByHierID} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     *         ProdUnivHierNodeByHierID} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<ProdUnivHierNodeByHierID> countProdUnivHierNodeByHierID();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     * ProdUnivHierNodeByHierID} entity using key fields.
     * 
     * @param prodHierarchyValidityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param prodUnivHierarchy
     *            Product Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID
     *         ProdUnivHierNodeByHierID} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.producthierarchynode.ProdUnivHierNodeByHierID>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<ProdUnivHierNodeByHierID> getProdUnivHierNodeByHierIDByKey(
        @Nonnull final String prodUnivHierarchy,
        @Nonnull final String hierarchyNode,
        @Nonnull final LocalDate prodHierarchyValidityEndDate );

}
