/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.time.LocalDate;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract;

/**
 * <p>
 * 
 * The service contains contract header and sub nodes for managing the contract process. These child objects are
 * Business Partner Assignments, Object Assignments, Posting, Rhythm, Adjustment, Renewal, Notice and Organizational
 * Assignment Terms, Conditions, Reminder Rules and Dates, Valuation Rules and Condition Valuation Assignments. The
 * contract header can be read, created and updated, additionally all child objects can be deleted using the service.
 * The contract header numbers (InternalRealEstateNumber and RealEstateContract) must be fetched via read request after
 * creating due to late numbering mechanism. If there are any issues when the contract header or any object is created,
 * updated or deleted, the system displays error messages in the response. .
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/1f/9493a0f6824ca89ca3fd458e0ceaa2/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RECONTRACT_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RECONTRACT_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>SAP Real Estate Contract API Integration (SAP_COM_0393)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1T6'>Lease-In Accounting (1T6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21Q'>Lease-Out Accounting (21Q)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/21R'>Service Contract (21R)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_REAL_ESTATE_CONTRACT</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>RealEstateContract</td>
 * </tr>
 * </table>
 * 
 */
public interface RealEstateContractService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_real_estate_contract/srvd_a2x/sap/api_recontract/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    RealEstateContractService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract
     * REContract} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContract> getAllREContract();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract} entity
     * collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContract> countREContract();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract
     * REContract} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *         entity using key fields. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContract> getREContractByKey( @Nonnull final String internalRealEstateNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract
     * REContract} entity and save it to the S/4HANA system.
     * 
     * @param rEContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *            entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContract> createREContract( @Nonnull final REContract rEContract );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract
     * REContract} entity and save it to the S/4HANA system.
     * 
     * @param rEContract
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *            entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract REContract}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContract>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContract> updateREContract( @Nonnull final REContract rEContract );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrAdjustmentTerm> getAllREContrAdjustmentTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrAdjustmentTerm> countREContrAdjustmentTerm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entity using key fields.
     * 
     * @param rEAdjustmentRule
     *            Adjustment Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEAdjustmentElementaryRule
     *            Elementary Adjustment Rule (Part of Comb. Rule)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrAdjustmentTerm> getREContrAdjustmentTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermNumber,
        @Nonnull final String rEAdjustmentRule,
        @Nonnull final String rEAdjustmentElementaryRule,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrAdjustmentTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *            REContrAdjustmentTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrAdjustmentTerm>
        createREContrAdjustmentTerm( @Nonnull final REContrAdjustmentTerm rEContrAdjustmentTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrAdjustmentTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *            REContrAdjustmentTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrAdjustmentTerm>
        updateREContrAdjustmentTerm( @Nonnull final REContrAdjustmentTerm rEContrAdjustmentTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     * REContrAdjustmentTerm} entity in the S/4HANA system.
     * 
     * @param rEContrAdjustmentTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *            REContrAdjustmentTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm
     *         REContrAdjustmentTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrAdjustmentTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrAdjustmentTerm>
        deleteREContrAdjustmentTerm( @Nonnull final REContrAdjustmentTerm rEContrAdjustmentTerm );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrCondition> getAllREContrCondition();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrCondition> countREContrCondition();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entity using key fields.
     * 
     * @param rEStatusObjectCalculation
     *            Object Number for Calculation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEConditionType
     *            Condition Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rEExtConditionPurpose
     *            Conditions - External Purpose
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrCondition> getREContrConditionByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rEStatusObjectCalculation,
        @Nonnull final String rEConditionType,
        @Nonnull final String rEExtConditionPurpose,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entity and save it to the S/4HANA system.
     * 
     * @param rEContrCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *            REContrCondition} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrCondition> createREContrCondition( @Nonnull final REContrCondition rEContrCondition );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entity and save it to the S/4HANA system.
     * 
     * @param rEContrCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *            REContrCondition} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrCondition> updateREContrCondition( @Nonnull final REContrCondition rEContrCondition );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     * REContrCondition} entity in the S/4HANA system.
     * 
     * @param rEContrCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *            REContrCondition} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition
     *         REContrCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrCondition> deleteREContrCondition( @Nonnull final REContrCondition rEContrCondition );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrNoticeTerm> getAllREContrNoticeTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrNoticeTerm> countREContrNoticeTerm();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rENoticeRule
     *            Notice rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param rENoticeSequenceNo
     *            Sequence Number for Description of Notice Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrNoticeTerm> getREContrNoticeTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rETermNumber,
        @Nonnull final String rENoticeRule,
        @Nonnull final String rENoticeSequenceNo );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrNoticeTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *            REContrNoticeTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrNoticeTerm>
        createREContrNoticeTerm( @Nonnull final REContrNoticeTerm rEContrNoticeTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrNoticeTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *            REContrNoticeTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrNoticeTerm>
        updateREContrNoticeTerm( @Nonnull final REContrNoticeTerm rEContrNoticeTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     * REContrNoticeTerm} entity in the S/4HANA system.
     * 
     * @param rEContrNoticeTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *            REContrNoticeTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm
     *         REContrNoticeTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrNoticeTerm>
        deleteREContrNoticeTerm( @Nonnull final REContrNoticeTerm rEContrNoticeTerm );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrNoticeTermForObj> getAllREContrNoticeTermForObj();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrNoticeTermForObj> countREContrNoticeTermForObj();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Real Estate Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rEStatusObject
     *            Object Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rENoticeRule
     *            Notice rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param rENoticeSequenceNo
     *            Sequence Number for Description of Notice Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrNoticeTermForObj> getREContrNoticeTermForObjByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rEStatusObject,
        @Nonnull final String rETermNumber,
        @Nonnull final String rENoticeRule,
        @Nonnull final String rENoticeSequenceNo );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entity and save it to the S/4HANA system.
     * 
     * @param rEContrNoticeTermForObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *            REContrNoticeTermForObj} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrNoticeTermForObj>
        createREContrNoticeTermForObj( @Nonnull final REContrNoticeTermForObj rEContrNoticeTermForObj );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entity and save it to the S/4HANA system.
     * 
     * @param rEContrNoticeTermForObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *            REContrNoticeTermForObj} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrNoticeTermForObj>
        updateREContrNoticeTermForObj( @Nonnull final REContrNoticeTermForObj rEContrNoticeTermForObj );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     * REContrNoticeTermForObj} entity in the S/4HANA system.
     * 
     * @param rEContrNoticeTermForObj
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *            REContrNoticeTermForObj} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj
     *         REContrNoticeTermForObj} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrNoticeTermForObj>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrNoticeTermForObj>
        deleteREContrNoticeTermForObj( @Nonnull final REContrNoticeTermForObj rEContrNoticeTermForObj );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrObjAssgmt> getAllREContrObjAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrObjAssgmt> countREContrObjAssgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEObjectAssignmentType
     *            Type of Object Assignment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param rEStatusObjectTarget
     *            Object Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @param rEStatusObjectSource
     *            Object Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrObjAssgmt> getREContrObjAssgmtByKey(
        @Nonnull final String rEStatusObjectSource,
        @Nonnull final String rEObjectAssignmentType,
        @Nonnull final String rEStatusObjectTarget,
        @Nonnull final String validityStartEndDateValue,
        @Nonnull final String internalRealEstateNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entity and save it to the S/4HANA system.
     * 
     * @param rEContrObjAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *            REContrObjAssgmt} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrObjAssgmt> createREContrObjAssgmt( @Nonnull final REContrObjAssgmt rEContrObjAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entity and save it to the S/4HANA system.
     * 
     * @param rEContrObjAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *            REContrObjAssgmt} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrObjAssgmt> updateREContrObjAssgmt( @Nonnull final REContrObjAssgmt rEContrObjAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     * REContrObjAssgmt} entity in the S/4HANA system.
     * 
     * @param rEContrObjAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *            REContrObjAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt
     *         REContrObjAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrObjAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrObjAssgmt> deleteREContrObjAssgmt( @Nonnull final REContrObjAssgmt rEContrObjAssgmt );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrOrglAssgmtTerm> getAllREContrOrglAssgmtTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrOrglAssgmtTerm> countREContrOrglAssgmtTerm();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrOrglAssgmtTerm> getREContrOrglAssgmtTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rETermNumber,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrOrglAssgmtTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *            REContrOrglAssgmtTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrOrglAssgmtTerm>
        createREContrOrglAssgmtTerm( @Nonnull final REContrOrglAssgmtTerm rEContrOrglAssgmtTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrOrglAssgmtTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *            REContrOrglAssgmtTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrOrglAssgmtTerm>
        updateREContrOrglAssgmtTerm( @Nonnull final REContrOrglAssgmtTerm rEContrOrglAssgmtTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     * REContrOrglAssgmtTerm} entity in the S/4HANA system.
     * 
     * @param rEContrOrglAssgmtTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *            REContrOrglAssgmtTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm
     *         REContrOrglAssgmtTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrOrglAssgmtTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrOrglAssgmtTerm>
        deleteREContrOrglAssgmtTerm( @Nonnull final REContrOrglAssgmtTerm rEContrOrglAssgmtTerm );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrPartAssgmt> getAllREContrPartAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrPartAssgmt> countREContrPartAssgmt();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param businessPartnerRole
     *            Business Partner: Role
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrPartAssgmt> getREContrPartAssgmtByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String businessPartner,
        @Nonnull final String businessPartnerRole,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entity and save it to the S/4HANA system.
     * 
     * @param rEContrPartAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *            REContrPartAssgmt} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrPartAssgmt>
        createREContrPartAssgmt( @Nonnull final REContrPartAssgmt rEContrPartAssgmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entity and save it to the S/4HANA system.
     * 
     * @param rEContrPartAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *            REContrPartAssgmt} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrPartAssgmt>
        updateREContrPartAssgmt( @Nonnull final REContrPartAssgmt rEContrPartAssgmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     * REContrPartAssgmt} entity in the S/4HANA system.
     * 
     * @param rEContrPartAssgmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *            REContrPartAssgmt} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt
     *         REContrPartAssgmt} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPartAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrPartAssgmt>
        deleteREContrPartAssgmt( @Nonnull final REContrPartAssgmt rEContrPartAssgmt );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrPostingTerm> getAllREContrPostingTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrPostingTerm> countREContrPostingTerm();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrPostingTerm> getREContrPostingTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rETermNumber,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrPostingTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *            REContrPostingTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrPostingTerm>
        createREContrPostingTerm( @Nonnull final REContrPostingTerm rEContrPostingTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrPostingTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *            REContrPostingTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrPostingTerm>
        updateREContrPostingTerm( @Nonnull final REContrPostingTerm rEContrPostingTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     * REContrPostingTerm} entity in the S/4HANA system.
     * 
     * @param rEContrPostingTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *            REContrPostingTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm
     *         REContrPostingTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrPostingTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrPostingTerm>
        deleteREContrPostingTerm( @Nonnull final REContrPostingTerm rEContrPostingTerm );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     * REContrReminderDate} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     *         REContrReminderDate} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrReminderDate> getAllREContrReminderDate();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     * REContrReminderDate} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     *         REContrReminderDate} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrReminderDate> countREContrReminderDate();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     * REContrReminderDate} entity using key fields.
     * 
     * @param rEReminderNumber
     *            Identification Number of Reminder Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEReminderDate
     *            Reminder Date
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     *         REContrReminderDate} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrReminderDate> getREContrReminderDateByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rEReminderNumber,
        @Nonnull final LocalDate rEReminderDate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     * REContrReminderDate} entity and save it to the S/4HANA system.
     * 
     * @param rEContrReminderDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     *            REContrReminderDate} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate
     *         REContrReminderDate} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderDate>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrReminderDate>
        updateREContrReminderDate( @Nonnull final REContrReminderDate rEContrReminderDate );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrReminderRule> getAllREContrReminderRule();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrReminderRule> countREContrReminderRule();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entity using key fields.
     * 
     * @param rEReminderNumber
     *            Identification Number of Reminder Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEReminderRuleParamNumber
     *            Number of Parameter of Reminder Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrReminderRule> getREContrReminderRuleByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rEReminderNumber,
        @Nonnull final String rEReminderRuleParamNumber );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entity and save it to the S/4HANA system.
     * 
     * @param rEContrReminderRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *            REContrReminderRule} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrReminderRule>
        createREContrReminderRule( @Nonnull final REContrReminderRule rEContrReminderRule );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entity and save it to the S/4HANA system.
     * 
     * @param rEContrReminderRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *            REContrReminderRule} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrReminderRule>
        updateREContrReminderRule( @Nonnull final REContrReminderRule rEContrReminderRule );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     * REContrReminderRule} entity in the S/4HANA system.
     * 
     * @param rEContrReminderRule
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *            REContrReminderRule} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule
     *         REContrReminderRule} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrReminderRule>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrReminderRule>
        deleteREContrReminderRule( @Nonnull final REContrReminderRule rEContrReminderRule );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrRenewalTerm> getAllREContrRenewalTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrRenewalTerm> countREContrRenewalTerm();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entity using key fields.
     * 
     * @param rERenewalSequenceNumber
     *            Sequence Number of Extension Period
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rERenewalRuleType
     *            Type of Renewal Rule
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rERenewalType
     *            Type of Renewal of Real Estate Contract
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrRenewalTerm> getREContrRenewalTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rETermNumber,
        @Nonnull final String rERenewalType,
        @Nonnull final String rERenewalSequenceNumber,
        @Nonnull final String rERenewalRuleType );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrRenewalTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *            REContrRenewalTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrRenewalTerm>
        createREContrRenewalTerm( @Nonnull final REContrRenewalTerm rEContrRenewalTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrRenewalTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *            REContrRenewalTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrRenewalTerm>
        updateREContrRenewalTerm( @Nonnull final REContrRenewalTerm rEContrRenewalTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     * REContrRenewalTerm} entity in the S/4HANA system.
     * 
     * @param rEContrRenewalTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *            REContrRenewalTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm
     *         REContrRenewalTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRenewalTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrRenewalTerm>
        deleteREContrRenewalTerm( @Nonnull final REContrRenewalTerm rEContrRenewalTerm );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrRhythmTerm> getAllREContrRhythmTerm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrRhythmTerm> countREContrRhythmTerm();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermType
     *            Term Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrRhythmTerm> getREContrRhythmTermByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermType,
        @Nonnull final String rETermNumber,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrRhythmTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *            REContrRhythmTerm} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrRhythmTerm>
        createREContrRhythmTerm( @Nonnull final REContrRhythmTerm rEContrRhythmTerm );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entity and save it to the S/4HANA system.
     * 
     * @param rEContrRhythmTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *            REContrRhythmTerm} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrRhythmTerm>
        updateREContrRhythmTerm( @Nonnull final REContrRhythmTerm rEContrRhythmTerm );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     * REContrRhythmTerm} entity in the S/4HANA system.
     * 
     * @param rEContrRhythmTerm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *            REContrRhythmTerm} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm
     *         REContrRhythmTerm} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrRhythmTerm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrRhythmTerm>
        deleteREContrRhythmTerm( @Nonnull final REContrRhythmTerm rEContrRhythmTerm );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrValuation> getAllREContrValuation();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrValuation> countREContrValuation();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entity using key fields.
     * 
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrValuation> getREContrValuationByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermNumber,
        @Nonnull final String validityStartEndDateValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entity and save it to the S/4HANA system.
     * 
     * @param rEContrValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *            REContrValuation} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrValuation> createREContrValuation( @Nonnull final REContrValuation rEContrValuation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entity and save it to the S/4HANA system.
     * 
     * @param rEContrValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *            REContrValuation} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrValuation> updateREContrValuation( @Nonnull final REContrValuation rEContrValuation );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     * REContrValuation} entity in the S/4HANA system.
     * 
     * @param rEContrValuation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *            REContrValuation} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation
     *         REContrValuation} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuation>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrValuation> deleteREContrValuation( @Nonnull final REContrValuation rEContrValuation );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<REContrValuationCondition> getAllREContrValuationCondition();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<REContrValuationCondition> countREContrValuationCondition();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entity using key fields.
     * 
     * @param rEConditionValidityStartDate
     *            Validity Start Date
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param rEStatusObjectCalculation
     *            Object Number for Calculation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 22
     *            </p>
     * @param internalRealEstateNumber
     *            Internal Key of Real Estate Object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 13
     *            </p>
     * @param rEConditionType
     *            Condition Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rETermNumber
     *            Term Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param rEExtConditionPurpose
     *            Conditions - External Purpose
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityStartEndDateValue
     *            Date from to (RAP Key)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<REContrValuationCondition> getREContrValuationConditionByKey(
        @Nonnull final String internalRealEstateNumber,
        @Nonnull final String rETermNumber,
        @Nonnull final String validityStartEndDateValue,
        @Nonnull final String rEConditionType,
        @Nonnull final LocalDate rEConditionValidityStartDate,
        @Nonnull final String rEExtConditionPurpose,
        @Nonnull final String rEStatusObjectCalculation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entity and save it to the S/4HANA system.
     * 
     * @param rEContrValuationCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *            REContrValuationCondition} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<REContrValuationCondition>
        createREContrValuationCondition( @Nonnull final REContrValuationCondition rEContrValuationCondition );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entity and save it to the S/4HANA system.
     * 
     * @param rEContrValuationCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *            REContrValuationCondition} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<REContrValuationCondition>
        updateREContrValuationCondition( @Nonnull final REContrValuationCondition rEContrValuationCondition );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     * REContrValuationCondition} entity in the S/4HANA system.
     * 
     * @param rEContrValuationCondition
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *            REContrValuationCondition} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition
     *         REContrValuationCondition} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.realestatecontract.REContrValuationCondition>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<REContrValuationCondition>
        deleteREContrValuationCondition( @Nonnull final REContrValuationCondition rEContrValuationCondition );

}
