/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes;

/**
 * <p>
 * 
 * You can read team categories, team types, responsibility attributes, functions assigned to team categories, and
 * responsibility attributes and functions assigned to team types. Each of these entities supports filtering of their
 * properties and the properties of their associations. If you have any problems trying to read these entities because
 * of authorizations or the given filter criteria, the system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/fd/fc60cb8a5f40bcaa56a1c65acc8b28/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RESPYM_TEAM_CONFIG_SRV_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RESPYM_TEAM_CONFIG_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Responsibility Management Team Integration (SAP_COM_0560)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_RESPYMGMT_CONFIG_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ResponsibilityManagementTeam</td>
 * </tr>
 * </table>
 * 
 */
public interface ResponsibilityManagementTeamConfigurationService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH =
        "/sap/opu/odata4/sap/api_respymgmt_config_srv/srvd_a2x/sap/api_respym_team_config_srv/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ResponsibilityManagementTeamConfigurationService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     * TeamCategories} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     *         TeamCategories} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategories> getAllTeamCategories();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     * TeamCategories} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     *         TeamCategories} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategories> countTeamCategories();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     * TeamCategories} entity using key fields.
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories
     *         TeamCategories} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategories> getTeamCategoriesByKey( @Nonnull final String respyMgmtTeamCategory );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     * TeamCategoryFunctions} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     *         TeamCategoryFunctions} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryFunctions> getAllTeamCategoryFunctions();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     * TeamCategoryFunctions} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     *         TeamCategoryFunctions} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryFunctions> countTeamCategoryFunctions();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     * TeamCategoryFunctions} entity using key fields.
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param respyMgmtFunction
     *            Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions
     *         TeamCategoryFunctions} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryFunctions> getTeamCategoryFunctionsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtFunction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     * TeamCategoryFunctionTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     *         TeamCategoryFunctionTexts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryFunctionTexts> getAllTeamCategoryFunctionTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     * TeamCategoryFunctionTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     *         TeamCategoryFunctionTexts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryFunctionTexts> countTeamCategoryFunctionTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     * TeamCategoryFunctionTexts} entity using key fields.
     * 
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param respyMgmtFunction
     *            Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts
     *         TeamCategoryFunctionTexts} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryFunctionTexts> getTeamCategoryFunctionTextsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtFunction,
        @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     * TeamCategoryRespyAttributes} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     *         TeamCategoryRespyAttributes} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryRespyAttributes> getAllTeamCategoryRespyAttributes();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     * TeamCategoryRespyAttributes} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     *         TeamCategoryRespyAttributes} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryRespyAttributes> countTeamCategoryRespyAttributes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     * TeamCategoryRespyAttributes} entity using key fields.
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes
     *         TeamCategoryRespyAttributes} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryRespyAttributes> getTeamCategoryRespyAttributesByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtAttributeName );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     * TeamCategoryRespyAttributeTxts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     *         TeamCategoryRespyAttributeTxts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryRespyAttributeTxts> getAllTeamCategoryRespyAttributeTxts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     * TeamCategoryRespyAttributeTxts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     *         TeamCategoryRespyAttributeTxts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryRespyAttributeTxts> countTeamCategoryRespyAttributeTxts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     * TeamCategoryRespyAttributeTxts} entity using key fields.
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts
     *         TeamCategoryRespyAttributeTxts} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryRespyAttributeTxts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryRespyAttributeTxts> getTeamCategoryRespyAttributeTxtsByKey(
        @Nonnull final String respyMgmtTeamCategory,
        @Nonnull final String respyMgmtAttributeName,
        @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     * TeamCategoryTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     *         TeamCategoryTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryTexts> getAllTeamCategoryTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     * TeamCategoryTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     *         TeamCategoryTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryTexts> countTeamCategoryTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     * TeamCategoryTexts} entity using key fields.
     * 
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts
     *         TeamCategoryTexts} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryTexts>
        getTeamCategoryTextsByKey( @Nonnull final String respyMgmtTeamCategory, @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     * TeamTypeFunctions} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     *         TeamTypeFunctions} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeFunctions> getAllTeamTypeFunctions();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     * TeamTypeFunctions} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     *         TeamTypeFunctions} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeFunctions> countTeamTypeFunctions();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     * TeamTypeFunctions} entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param respyMgmtFunction
     *            Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions
     *         TeamTypeFunctions} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeFunctions>
        getTeamTypeFunctionsByKey( @Nonnull final String respyMgmtTeamType, @Nonnull final String respyMgmtFunction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     * TeamTypeFunctionTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     *         TeamTypeFunctionTexts} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeFunctionTexts> getAllTeamTypeFunctionTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     * TeamTypeFunctionTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     *         TeamTypeFunctionTexts} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeFunctionTexts> countTeamTypeFunctionTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     * TeamTypeFunctionTexts} entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtFunction
     *            Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts
     *         TeamTypeFunctionTexts} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeFunctionTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeFunctionTexts> getTeamTypeFunctionTextsByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtFunction,
        @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     * TeamTypeRespyAttributes} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     *         TeamTypeRespyAttributes} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeRespyAttributes> getAllTeamTypeRespyAttributes();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     * TeamTypeRespyAttributes} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     *         TeamTypeRespyAttributes} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeRespyAttributes> countTeamTypeRespyAttributes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     * TeamTypeRespyAttributes} entity using key fields.
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes
     *         TeamTypeRespyAttributes} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeRespyAttributes> getTeamTypeRespyAttributesByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtAttributeName );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     * TeamTypeRespyAttributeTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     *         TeamTypeRespyAttributeTexts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeRespyAttributeTexts> getAllTeamTypeRespyAttributeTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     * TeamTypeRespyAttributeTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     *         TeamTypeRespyAttributeTexts} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeRespyAttributeTexts> countTeamTypeRespyAttributeTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     * TeamTypeRespyAttributeTexts} entity using key fields.
     * 
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts
     *         TeamTypeRespyAttributeTexts} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeRespyAttributeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeRespyAttributeTexts> getTeamTypeRespyAttributeTextsByKey(
        @Nonnull final String respyMgmtTeamType,
        @Nonnull final String respyMgmtAttributeName,
        @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     * TeamTypes} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     *         TeamTypes} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypes> getAllTeamTypes();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     * TeamTypes} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     *         TeamTypes} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypes> countTeamTypes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     * TeamTypes} entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes
     *         TeamTypes} entity using key fields. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypes> getTeamTypesByKey( @Nonnull final String respyMgmtTeamType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     * TeamTypeTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     *         TeamTypeTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeTexts> getAllTeamTypeTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     * TeamTypeTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     *         TeamTypeTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeTexts> countTeamTypeTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     * TeamTypeTexts} entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts
     *         TeamTypeTexts} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteamconfiguration.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeTexts>
        getTeamTypeTextsByKey( @Nonnull final String respyMgmtTeamType, @Nonnull final String language );

}
