/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes;

/**
 * <p>
 * 
 * You can read team headers, team owners, responsibility definitions, team members, and the functions assigned to team
 * members. Each of these entities supports filtering of their properties and the properties of their associations. If
 * you have any problems trying to read these entities because of authorizations or the given filter criteria, the
 * system displays error messages in the response..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/ce/db8a76b15e49c29b1d79d421e4b57c/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_RESPYM_TEAM_SRV_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_RESPYM_TEAM_SRV_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Responsibility Management Team Integration (SAP_COM_0560)</td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_RESPYMGMT_TEAM_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>ResponsibilityManagementTeam</td>
 * </tr>
 * </table>
 * 
 */
public interface ResponsibilityManagementTeamService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_respymgmt_team_srv/srvd_a2x/sap/api_respym_team_srv/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    ResponsibilityManagementTeamService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     * TeamAttributes} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     *         TeamAttributes} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamAttributes> getAllTeamAttributes();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     * TeamAttributes} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     *         TeamAttributes} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamAttributes> countTeamAttributes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     * TeamAttributes} entity using key fields.
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param respyMgmtAttributeSign
     *            Type of SIGN component in row type of a Ranges type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param respyMgmtAttributeName
     *            Responsibility Definition Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 30
     *            </p>
     * @param respyMgmtAttributeHighValue
     *            End Value of Selection Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param respyMgmtAttributeOption
     *            Type of OPTION component in row type of a Ranges type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtAttributeLowValue
     *            Start Value of Selection Criteria
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes
     *         TeamAttributes} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamAttributes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamAttributes> getTeamAttributesByKey(
        @Nonnull final String respyMgmtGlobalTeamID,
        @Nonnull final String respyMgmtAttributeName,
        @Nonnull final String respyMgmtAttributeSign,
        @Nonnull final String respyMgmtAttributeOption,
        @Nonnull final String respyMgmtAttributeLowValue,
        @Nonnull final String respyMgmtAttributeHighValue );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     * TeamCategories} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     *         TeamCategories} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategories> getAllTeamCategories();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     * TeamCategories} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     *         TeamCategories} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategories> countTeamCategories();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     * TeamCategories} entity using key fields.
     * 
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories
     *         TeamCategories} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategories>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategories> getTeamCategoriesByKey( @Nonnull final String respyMgmtTeamCategory );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     * TeamCategoryTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     *         TeamCategoryTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamCategoryTexts> getAllTeamCategoryTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     * TeamCategoryTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     *         TeamCategoryTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamCategoryTexts> countTeamCategoryTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     * TeamCategoryTexts} entity using key fields.
     * 
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param respyMgmtTeamCategory
     *            Team Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts
     *         TeamCategoryTexts} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamCategoryTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamCategoryTexts>
        getTeamCategoryTextsByKey( @Nonnull final String respyMgmtTeamCategory, @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     * TeamHeaders} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     *         TeamHeaders} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamHeaders> getAllTeamHeaders();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     * TeamHeaders} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     *         TeamHeaders} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamHeaders> countTeamHeaders();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     * TeamHeaders} entity using key fields.
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders
     *         TeamHeaders} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamHeaders>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamHeaders> getTeamHeadersByKey( @Nonnull final String respyMgmtGlobalTeamID );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     * TeamMemberFunctions} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     *         TeamMemberFunctions} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamMemberFunctions> getAllTeamMemberFunctions();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     * TeamMemberFunctions} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     *         TeamMemberFunctions} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamMemberFunctions> countTeamMemberFunctions();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     * TeamMemberFunctions} entity using key fields.
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param respyMgmtTeamMemberType
     *            Team Member Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param responsibilityTeamMember
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param respyMgmtFunction
     *            Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions
     *         TeamMemberFunctions} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMemberFunctions>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamMemberFunctions> getTeamMemberFunctionsByKey(
        @Nonnull final String respyMgmtGlobalTeamID,
        @Nonnull final String respyMgmtTeamMemberType,
        @Nonnull final String responsibilityTeamMember,
        @Nonnull final String respyMgmtFunction );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     * TeamMembers} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     *         TeamMembers} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamMembers> getAllTeamMembers();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     * TeamMembers} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     *         TeamMembers} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamMembers> countTeamMembers();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     * TeamMembers} entity using key fields.
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param respyMgmtTeamMemberType
     *            Team Member Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param responsibilityTeamMember
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers
     *         TeamMembers} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamMembers>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamMembers> getTeamMembersByKey(
        @Nonnull final String respyMgmtGlobalTeamID,
        @Nonnull final String respyMgmtTeamMemberType,
        @Nonnull final String responsibilityTeamMember );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners TeamOwners}
     * entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners
     *         TeamOwners} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamOwners> getAllTeamOwners();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners TeamOwners}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners
     *         TeamOwners} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamOwners> countTeamOwners();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners TeamOwners}
     * entity using key fields.
     * 
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param responsibilityTeamOwner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param respyMgmtTeamOwnerType
     *            Team Owner Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners
     *         TeamOwners} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamOwners>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamOwners> getTeamOwnersByKey(
        @Nonnull final String respyMgmtGlobalTeamID,
        @Nonnull final String respyMgmtTeamOwnerType,
        @Nonnull final String responsibilityTeamOwner );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     * TeamStatusTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     *         TeamStatusTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamStatusTexts> getAllTeamStatusTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     * TeamStatusTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     *         TeamStatusTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamStatusTexts> countTeamStatusTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     * TeamStatusTexts} entity using key fields.
     * 
     * @param respyMgmtTeamStatus
     *            Values for Domains: Single Value/Lower Limit
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts
     *         TeamStatusTexts} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamStatusTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamStatusTexts>
        getTeamStatusTextsByKey( @Nonnull final String respyMgmtTeamStatus, @Nonnull final String language );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes TeamTypes}
     * entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes
     *         TeamTypes} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypes> getAllTeamTypes();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes TeamTypes}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes
     *         TeamTypes} entities. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypes> countTeamTypes();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes TeamTypes}
     * entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes
     *         TeamTypes} entity using key fields. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypes>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypes> getTeamTypesByKey( @Nonnull final String respyMgmtTeamType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     * TeamTypeTexts} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     *         TeamTypeTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<TeamTypeTexts> getAllTeamTypeTexts();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     * TeamTypeTexts} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     *         TeamTypeTexts} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<TeamTypeTexts> countTeamTypeTexts();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     * TeamTypeTexts} entity using key fields.
     * 
     * @param respyMgmtTeamType
     *            Team Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts
     *         TeamTypeTexts} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.responsibilitymanagementteam.TeamTypeTexts>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<TeamTypeTexts>
        getTeamTypeTextsByKey( @Nonnull final String respyMgmtTeamType, @Nonnull final String language );

}
