/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement;

/**
 * <p>
 * 
 * You retrieve the following data using this OData based service:
 * 
 * You can read the Settlement Documents on header and item level.
 * 
 * You can release Settlement Documents which were blocked to accounting and where the application status was not set.
 * 
 * You can reverse Settlement Documents.
 * 
 * You can read the relevant pricing elements for the Settlement Document header and item level.
 * 
 * You can complete Settlement Documents.
 * 
 * You can revoke the completion of Settlement Documents..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/bf/855abdfc6045c0a7aa2536781917ec/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference:
 * <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/SETTLMTDOC_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>SETTLMTDOC_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Settlement Document Integration (SAP_COM_0714)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing (1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing (2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative (2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/55I'>Royalties Settlement for Sales (55I)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SETTLMT_DOC</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SettlementDocument</td>
 * </tr>
 * </table>
 * 
 */
public interface SettlementDocumentService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_settlmt_doc/srvd_a2x/sap/settlmtdoc/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SettlementDocumentService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     * CustItmPricingElement} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     *         CustItmPricingElement} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<CustItmPricingElement> getAllCustItmPricingElement();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     * CustItmPricingElement} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     *         CustItmPricingElement} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<CustItmPricingElement> countCustItmPricingElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     * CustItmPricingElement} entity using key fields.
     * 
     * @param pricingProcedureCounter
     *            Pricing Procedure Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param settlmtDocItem
     *            Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     *         CustItmPricingElement} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<CustItmPricingElement> getCustItmPricingElementByKey(
        @Nonnull final String settlmtDoc,
        @Nonnull final String settlmtDocItem,
        @Nonnull final String pricingProcedureStep,
        @Nonnull final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     * CustItmPricingElement} entity and save it to the S/4HANA system.
     * 
     * @param custItmPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     *            CustItmPricingElement} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement
     *         CustItmPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<CustItmPricingElement>
        createCustItmPricingElement( @Nonnull final CustItmPricingElement custItmPricingElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     * CustPricingElement} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     *         CustPricingElement} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<CustPricingElement> getAllCustPricingElement();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     * CustPricingElement} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     *         CustPricingElement} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<CustPricingElement> countCustPricingElement();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     * CustPricingElement} entity using key fields.
     * 
     * @param pricingProcedureCounter
     *            Pricing Procedure Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     *         CustPricingElement} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<CustPricingElement> getCustPricingElementByKey(
        @Nonnull final String settlmtDoc,
        @Nonnull final String pricingProcedureStep,
        @Nonnull final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     * CustPricingElement} entity and save it to the S/4HANA system.
     * 
     * @param custPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     *            CustPricingElement} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement
     *         CustPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.CustPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<CustPricingElement>
        createCustPricingElement( @Nonnull final CustPricingElement custPricingElement );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     * entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SetlDoc> getAllSetlDoc();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc} entity
     * collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SetlDoc> countSetlDoc();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     * entity using key fields.
     * 
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc} entity
     *         using key fields. This request builder allows methods which modify the underlying query to be called
     *         before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SetlDoc> getSetlDocByKey( @Nonnull final String settlmtDoc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     * entity and save it to the S/4HANA system.
     * 
     * @param setlDoc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc}
     *            entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc SetlDoc} entity.
     *         To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDoc>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<SetlDoc> createSetlDoc( @Nonnull final SetlDoc setlDoc );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm
     * SetlDocItm} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SetlDocItm> getAllSetlDocItm();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm} entity
     * collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm}
     *         entities. This request builder allows methods which modify the underlying query to be called before
     *         executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SetlDocItm> countSetlDocItm();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm
     * SetlDocItm} entity using key fields.
     * 
     * @param settlmtDocItem
     *            Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm}
     *         entity using key fields. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SetlDocItm>
        getSetlDocItmByKey( @Nonnull final String settlmtDoc, @Nonnull final String settlmtDocItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm
     * SetlDocItm} entity and save it to the S/4HANA system.
     * 
     * @param setlDocItm
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm}
     *            entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm SetlDocItm}
     *         entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SetlDocItm>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<SetlDocItm> createSetlDocItm( @Nonnull final SetlDocItm setlDocItm );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     * SuplrItmPricingElement} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     *         SuplrItmPricingElement} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SuplrItmPricingElement> getAllSuplrItmPricingElement();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     * SuplrItmPricingElement} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     *         SuplrItmPricingElement} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SuplrItmPricingElement> countSuplrItmPricingElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     * SuplrItmPricingElement} entity using key fields.
     * 
     * @param pricingProcedureCounter
     *            Pricing Procedure Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param settlmtDocItem
     *            Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     *         SuplrItmPricingElement} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SuplrItmPricingElement> getSuplrItmPricingElementByKey(
        @Nonnull final String settlmtDoc,
        @Nonnull final String settlmtDocItem,
        @Nonnull final String pricingProcedureStep,
        @Nonnull final String pricingProcedureCounter );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     * SuplrItmPricingElement} entity and save it to the S/4HANA system.
     * 
     * @param suplrItmPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     *            SuplrItmPricingElement} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement
     *         SuplrItmPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrItmPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<SuplrItmPricingElement>
        createSuplrItmPricingElement( @Nonnull final SuplrItmPricingElement suplrItmPricingElement );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     * SuplrPricingElement} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     *         SuplrPricingElement} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SuplrPricingElement> getAllSuplrPricingElement();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     * SuplrPricingElement} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     *         SuplrPricingElement} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SuplrPricingElement> countSuplrPricingElement();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     * SuplrPricingElement} entity using key fields.
     * 
     * @param pricingProcedureCounter
     *            Pricing Procedure Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param settlmtDoc
     *            Settlement Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     *         SuplrPricingElement} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SuplrPricingElement> getSuplrPricingElementByKey(
        @Nonnull final String settlmtDoc,
        @Nonnull final String pricingProcedureStep,
        @Nonnull final String pricingProcedureCounter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     * SuplrPricingElement} entity and save it to the S/4HANA system.
     * 
     * @param suplrPricingElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     *            SuplrPricingElement} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement
     *         SuplrPricingElement} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocument.SuplrPricingElement>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<SuplrPricingElement>
        createSuplrPricingElement( @Nonnull final SuplrPricingElement suplrPricingElement );

}
