/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType;

/**
 * <p>
 * 
 * You retrieve the following data using this OData based service:
 * 
 * You can read the Settlement Document Types and related information.
 * 
 * You can navigate to the Header Text Object Type Assignment for a Settlement Document Type and read the assigned Text
 * Determination Procedure and all the possible Text Object Types linked to it on header level.
 * 
 * You can navigate to the Item Text Object Type Assignment for a Settlement Document Type and read the assigned Text
 * Determination Procedure and all the possible Text Object Types linked to it on item level..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/e0/26c31fb2d0451781b8c4c6e6054aea/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/SETTLMTDOCTYPE_0001?section=OVERVIEW'>SAP API
 * Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>SETTLMTDOCTYPE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Settlement Document Type Integration (SAP_COM_0709)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing (1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing (2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative (2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3TD'>Internal Commissions Settlement with SAP Sales Cloud
 * (3TD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SETTLMT_DOC_TYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SettlementDocumentType</td>
 * </tr>
 * </table>
 * 
 */
public interface SettlementDocumentTypeService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_settlmt_doc_type/srvd_a2x/sap/settlmtdoctype/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SettlementDocumentTypeService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     * SetlMgmtHdrTxtObjTypeAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     *         SetlMgmtHdrTxtObjTypeAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> getAllSetlMgmtHdrTxtObjTypeAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     * SetlMgmtHdrTxtObjTypeAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     *         SetlMgmtHdrTxtObjTypeAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> countSetlMgmtHdrTxtObjTypeAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     * SetlMgmtHdrTxtObjTypeAssgmt} entity using key fields.
     * 
     * @param settlmtMgmtHdrTxtObjType
     *            Specific Text ID for a Settlement Management Document Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param settlmtHdrTxtDetnProced
     *            Text Determination Procedure for Header
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt
     *         SetlMgmtHdrTxtObjTypeAssgmt} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtHdrTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SetlMgmtHdrTxtObjTypeAssgmt> getSetlMgmtHdrTxtObjTypeAssgmtByKey(
        @Nonnull final String settlmtHdrTxtDetnProced,
        @Nonnull final String settlmtMgmtHdrTxtObjType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     * SetlMgmtItmTxtObjTypeAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     *         SetlMgmtItmTxtObjTypeAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> getAllSetlMgmtItmTxtObjTypeAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     * SetlMgmtItmTxtObjTypeAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     *         SetlMgmtItmTxtObjTypeAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> countSetlMgmtItmTxtObjTypeAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     * SetlMgmtItmTxtObjTypeAssgmt} entity using key fields.
     * 
     * @param settlmtMgmtItmTxtObjType
     *            Specific Text ID for a Settlement Management Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param settlmtItmTxtDetnProced
     *            Text Determination Procedure for Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt
     *         SetlMgmtItmTxtObjTypeAssgmt} entity using key fields. This request builder allows methods which modify
     *         the underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SetlMgmtItmTxtObjTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SetlMgmtItmTxtObjTypeAssgmt> getSetlMgmtItmTxtObjTypeAssgmtByKey(
        @Nonnull final String settlmtItmTxtDetnProced,
        @Nonnull final String settlmtMgmtItmTxtObjType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     * SettlmtDocType} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     *         SettlmtDocType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SettlmtDocType> getAllSettlmtDocType();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     * SettlmtDocType} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     *         SettlmtDocType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SettlmtDocType> countSettlmtDocType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     * SettlmtDocType} entity using key fields.
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType
     *         SettlmtDocType} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementdocumenttype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SettlmtDocType> getSettlmtDocTypeByKey( @Nonnull final String settlmtDocType );

}
