/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType;

/**
 * <p>
 * 
 * You retrieve the following data using this OData based service:
 * 
 * You can read the Settlement Process Types and related information.
 * 
 * You can navigate to the Application Status Assignment for a Settlement Process Type and read the assigned Application
 * Status Group and all the possible Application Statuses linked to it.
 * 
 * You can navigate to the Settlement Document Type Assignment for a Settlement Process Type and read the assigned
 * Settlement Document Types for the relevant Settlement Process Type. You can also read further information regarding
 * the Settlement Document Types..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/7d/dd5319e58546d5b44a2f263eaf3e01/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/SETTLMTPROCESSTYPE_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>SETTLMTPROCESSTYPE_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Logistics - Settlement Process Type Integration (SAP_COM_0710)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1B6'>Sales Rebate Processing (1B6)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2R7'>Purchasing Rebate Processing (2R7)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/2TT'>Sales Commissions - External Sales Representative (2TT)</a>,
 * <a href='https://rapid.sap.com/bp/#/scopeitems/3TD'>Internal Commissions Settlement with SAP Sales Cloud
 * (3TD)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SETTLMT_PROC_TYPE</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SettlementProcessType</td>
 * </tr>
 * </table>
 * 
 */
public interface SettlementProcessTypeService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_settlmt_proc_type/srvd_a2x/sap/settlmtprocesstype/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SettlementProcessTypeService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     * SettlmtApplStsGrpStsAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     *         SettlmtApplStsGrpStsAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SettlmtApplStsGrpStsAssgmt> getAllSettlmtApplStsGrpStsAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     * SettlmtApplStsGrpStsAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     *         SettlmtApplStsGrpStsAssgmt} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SettlmtApplStsGrpStsAssgmt> countSettlmtApplStsGrpStsAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     * SettlmtApplStsGrpStsAssgmt} entity using key fields.
     * 
     * @param settlmtApplStsGrp
     *            Status Group for Settlement Management Documents
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param settlmtApplSts
     *            Application Status for a Settlement Management Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt
     *         SettlmtApplStsGrpStsAssgmt} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtApplStsGrpStsAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SettlmtApplStsGrpStsAssgmt> getSettlmtApplStsGrpStsAssgmtByKey(
        @Nonnull final String settlmtApplStsGrp,
        @Nonnull final String settlmtApplSts );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     * SettlmtDocProcTypeAssgmt} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     *         SettlmtDocProcTypeAssgmt} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SettlmtDocProcTypeAssgmt> getAllSettlmtDocProcTypeAssgmt();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     * SettlmtDocProcTypeAssgmt} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     *         SettlmtDocProcTypeAssgmt} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SettlmtDocProcTypeAssgmt> countSettlmtDocProcTypeAssgmt();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     * SettlmtDocProcTypeAssgmt} entity using key fields.
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param settlmtProcessType
     *            Settlement Process Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt
     *         SettlmtDocProcTypeAssgmt} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocProcTypeAssgmt>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SettlmtDocProcTypeAssgmt> getSettlmtDocProcTypeAssgmtByKey(
        @Nonnull final String settlmtProcessType,
        @Nonnull final String settlmtDocType );

    /**
     * Fetch multiple {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType
     * SettlmtDocType} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType
     *         SettlmtDocType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SettlmtDocType> getAllSettlmtDocType();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType SettlmtDocType}
     * entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType
     *         SettlmtDocType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SettlmtDocType> countSettlmtDocType();

    /**
     * Fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType
     * SettlmtDocType} entity using key fields.
     * 
     * @param settlmtDocType
     *            Settlement Document Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType
     *         SettlmtDocType} entity using key fields. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtDocType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SettlmtDocType> getSettlmtDocTypeByKey( @Nonnull final String settlmtDocType );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     * SettlmtProcessType} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     *         SettlmtProcessType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SettlmtProcessType> getAllSettlmtProcessType();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     * SettlmtProcessType} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     *         SettlmtProcessType} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SettlmtProcessType> countSettlmtProcessType();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     * SettlmtProcessType} entity using key fields.
     * 
     * @param settlmtProcessType
     *            Settlement Process Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType
     *         SettlmtProcessType} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.settlementprocesstype.SettlmtProcessType>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SettlmtProcessType> getSettlmtProcessTypeByKey( @Nonnull final String settlmtProcessType );

}
