/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.util.UUID;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket;

/**
 * <p>
 * 
 * The service contains the supply protection object, the characteristics, the supply protection groups and the time
 * buckets. Once the supply availability protection plan has been created, the response contains the created object with
 * comprehensive information including UUIDs of the objects as well as error messages for the case that the creation was
 * not successful..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/ce/d8d281241040358bc54ba57baae01d/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/API_SUPAVAILYPROTPLAN_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>API_SUPAVAILYPROTPLAN_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Supply Availability Protection Plan Integration (SAP_COM_0384)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1JW'>Advanced Available-to-Promise Processing (1JW)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509, OAuth2</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_SUPAVAILYPROTPLAN</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>SupAvailabilityProtectionPlan</td>
 * </tr>
 * </table>
 * 
 */
public interface SupplyAvailabilityProtectionPlanService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_supavailyprotplan/srvd_a2x/sap/api_supavailyprotplan/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    SupplyAvailabilityProtectionPlanService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SupplyProtection> getAllSupplyProtection();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entities. This request builder allows methods which modify the underlying query to be
     *         called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SupplyProtection> countSupplyProtection();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entity using key fields.
     * 
     * @param supplyProtectionUUID
     *            UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SupplyProtection> getSupplyProtectionByKey( @Nonnull final UUID supplyProtectionUUID );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entity and save it to the S/4HANA system.
     * 
     * @param supplyProtection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *            SupplyProtection} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<SupplyProtection> createSupplyProtection( @Nonnull final SupplyProtection supplyProtection );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entity and save it to the S/4HANA system.
     * 
     * @param supplyProtection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *            SupplyProtection} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<SupplyProtection> updateSupplyProtection( @Nonnull final SupplyProtection supplyProtection );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     * SupplyProtection} entity in the S/4HANA system.
     * 
     * @param supplyProtection
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *            SupplyProtection} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection
     *         SupplyProtection} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtection>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<SupplyProtection> deleteSupplyProtection( @Nonnull final SupplyProtection supplyProtection );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     * SupplyProtectionGroup} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *         SupplyProtectionGroup} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SupplyProtectionGroup> getAllSupplyProtectionGroup();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     * SupplyProtectionGroup} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *         SupplyProtectionGroup} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SupplyProtectionGroup> countSupplyProtectionGroup();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     * SupplyProtectionGroup} entity using key fields.
     * 
     * @param supplyProtectionGroupUUID
     *            Characteristic Value Combination UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *         SupplyProtectionGroup} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SupplyProtectionGroup>
        getSupplyProtectionGroupByKey( @Nonnull final UUID supplyProtectionGroupUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     * SupplyProtectionGroup} entity and save it to the S/4HANA system.
     * 
     * @param supplyProtectionGroup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *            SupplyProtectionGroup} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *         SupplyProtectionGroup} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<SupplyProtectionGroup>
        updateSupplyProtectionGroup( @Nonnull final SupplyProtectionGroup supplyProtectionGroup );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     * SupplyProtectionGroup} entity in the S/4HANA system.
     * 
     * @param supplyProtectionGroup
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *            SupplyProtectionGroup} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup
     *         SupplyProtectionGroup} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionGroup>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<SupplyProtectionGroup>
        deleteSupplyProtectionGroup( @Nonnull final SupplyProtectionGroup supplyProtectionGroup );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     * SupplyProtectionTimeBucket} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *         SupplyProtectionTimeBucket} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SupplyProtectionTimeBucket> getAllSupplyProtectionTimeBucket();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     * SupplyProtectionTimeBucket} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *         SupplyProtectionTimeBucket} entities. This request builder allows methods which modify the underlying
     *         query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SupplyProtectionTimeBucket> countSupplyProtectionTimeBucket();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     * SupplyProtectionTimeBucket} entity using key fields.
     * 
     * @param supProtTimeBucketUUID
     *            Time Bucket UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *         SupplyProtectionTimeBucket} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SupplyProtectionTimeBucket>
        getSupplyProtectionTimeBucketByKey( @Nonnull final UUID supProtTimeBucketUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     * SupplyProtectionTimeBucket} entity and save it to the S/4HANA system.
     * 
     * @param supplyProtectionTimeBucket
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *            SupplyProtectionTimeBucket} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *         SupplyProtectionTimeBucket} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<SupplyProtectionTimeBucket>
        updateSupplyProtectionTimeBucket( @Nonnull final SupplyProtectionTimeBucket supplyProtectionTimeBucket );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     * SupplyProtectionTimeBucket} entity in the S/4HANA system.
     * 
     * @param supplyProtectionTimeBucket
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *            SupplyProtectionTimeBucket} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket
     *         SupplyProtectionTimeBucket} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupplyProtectionTimeBucket>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<SupplyProtectionTimeBucket>
        deleteSupplyProtectionTimeBucket( @Nonnull final SupplyProtectionTimeBucket supplyProtectionTimeBucket );

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     * SupProtCharacteristic} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *         SupProtCharacteristic} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<SupProtCharacteristic> getAllSupProtCharacteristic();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     * SupProtCharacteristic} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *         SupProtCharacteristic} entities. This request builder allows methods which modify the underlying query to
     *         be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<SupProtCharacteristic> countSupProtCharacteristic();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     * SupProtCharacteristic} entity using key fields.
     * 
     * @param supProtCharacteristicUUID
     *            Characteristic UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *         SupProtCharacteristic} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<SupProtCharacteristic>
        getSupProtCharacteristicByKey( @Nonnull final UUID supProtCharacteristicUUID );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     * SupProtCharacteristic} entity and save it to the S/4HANA system.
     * 
     * @param supProtCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *            SupProtCharacteristic} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *         SupProtCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<SupProtCharacteristic>
        updateSupProtCharacteristic( @Nonnull final SupProtCharacteristic supProtCharacteristic );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     * SupProtCharacteristic} entity in the S/4HANA system.
     * 
     * @param supProtCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *            SupProtCharacteristic} entity object that will be deleted in the S/4HANA system.
     * @return A request builder to delete an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic
     *         SupProtCharacteristic} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.DeleteRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.supplyavailabilityprotectionplan.SupProtCharacteristic>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    DeleteRequestBuilder<SupProtCharacteristic>
        deleteSupProtCharacteristic( @Nonnull final SupProtCharacteristic supProtCharacteristic );

}
