/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.services;

import java.time.LocalDate;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder;
import com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl;

/**
 * <p>
 * 
 * You can create, read and update the time dependent stock levels such as max stock, reorder point and safety stock.
 * You can also split and merge the stock validity intervals..
 * </p>
 * <p>
 * <a href=
 * 'https://help.sap.com:00443/http.svc/ahp2/SAP_S4HANA_CLOUD/latest/EN/dd/c1e3b71636456b898eff6b8c6abd8a/frameset.htm'>Business
 * Documentation</a>
 * </p>
 * <p>
 * Reference: <a href=
 * 'https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/PRODTIMEDPDNTSTCK_0001?section=OVERVIEW'>SAP
 * API Business Hub</a>
 * </p>
 * <h3>Details:</h3>
 * <table summary='Details'>
 * <tr>
 * <td align='right'>OData Service:</td>
 * <td>PRODTIMEDPDNTSTCK_0001</td>
 * </tr>
 * <tr>
 * <td align='right'>API Version:</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td align='right'>Communication Scenario:</td>
 * <td>Buffer Sizing Integration (SAP_COM_0359)</td>
 * </tr>
 * <tr>
 * <td align='right'>Scope Items:</td>
 * <td><a href='https://rapid.sap.com/bp/#/scopeitems/1Y2'>Demand-Driven Buffer Level Management (1Y2)</a></td>
 * </tr>
 * <tr>
 * <td align='right'>Authentication Methods:</td>
 * <td>Basic, x509</td>
 * </tr>
 * <tr>
 * <td align='right'>Service Group Name:</td>
 * <td>API_PROD_TIMEDPDNTSTCK_SRV</td>
 * </tr>
 * <tr>
 * <td align='right'>Business Object:</td>
 * <td>Product</td>
 * </tr>
 * </table>
 * 
 */
public interface TimeDependentStockLevelService
{

    /**
     * If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path
     * used to access the endpoint.
     * 
     */
    String DEFAULT_SERVICE_PATH = "/sap/opu/odata4/sap/api_prod_timedpdntstck_srv/srvd_a2x/sap/prodtimedpdntstck/0001";

    /**
     * Overrides the default service path and returns a new service instance with the specified service path. Also
     * adjusts the respective entity URLs.
     * 
     * @param servicePath
     *            Service path that will override the default.
     * @return A new service instance with the specified service path.
     */
    @Nonnull
    TimeDependentStockLevelService withServicePath( @Nonnull final String servicePath );

    /**
     * Creates a batch request builder object.
     * 
     * @return A request builder to handle batch operation on this service. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.BatchRequestBuilder#execute(HttpDestinationProperties)
     *         execute} method on the request builder object.
     */
    @Nonnull
    BatchRequestBuilder batch();

    /**
     * Fetch multiple
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     * ProdTimeDepdntStockLvl} entities.
     * 
     * @return A request builder to fetch multiple
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *         ProdTimeDepdntStockLvl} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetAllRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetAllRequestBuilder<ProdTimeDepdntStockLvl> getAllProdTimeDepdntStockLvl();

    /**
     * Fetch the number of entries from the
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     * ProdTimeDepdntStockLvl} entity collection matching the filter and search expressions.
     * 
     * @return A request builder to fetch the count of
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *         ProdTimeDepdntStockLvl} entities. This request builder allows methods which modify the underlying query
     *         to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CountRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CountRequestBuilder<ProdTimeDepdntStockLvl> countProdTimeDepdntStockLvl();

    /**
     * Fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     * ProdTimeDepdntStockLvl} entity using key fields.
     * 
     * @param product
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param mRPArea
     *            MRP Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param stockLevelValidityStartDate
     *            Valid-From Date
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @return A request builder to fetch a single
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *         ProdTimeDepdntStockLvl} entity using key fields. This request builder allows methods which modify the
     *         underlying query to be called before executing the query itself. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.GetByKeyRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    GetByKeyRequestBuilder<ProdTimeDepdntStockLvl> getProdTimeDepdntStockLvlByKey(
        @Nonnull final String product,
        @Nonnull final String plant,
        @Nonnull final String mRPArea,
        @Nonnull final LocalDate stockLevelValidityStartDate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     * ProdTimeDepdntStockLvl} entity and save it to the S/4HANA system.
     * 
     * @param prodTimeDepdntStockLvl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *            ProdTimeDepdntStockLvl} entity object that will be created in the S/4HANA system.
     * @return A request builder to create a new
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *         ProdTimeDepdntStockLvl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.CreateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    CreateRequestBuilder<ProdTimeDepdntStockLvl>
        createProdTimeDepdntStockLvl( @Nonnull final ProdTimeDepdntStockLvl prodTimeDepdntStockLvl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     * ProdTimeDepdntStockLvl} entity and save it to the S/4HANA system.
     * 
     * @param prodTimeDepdntStockLvl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *            ProdTimeDepdntStockLvl} entity object that will be updated in the S/4HANA system.
     * @return A request builder to update an existing
     *         {@link com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl
     *         ProdTimeDepdntStockLvl} entity. To perform execution, call the
     *         {@link com.sap.cloud.sdk.datamodel.odatav4.core.UpdateRequestBuilder<com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.timedependentstocklevel.ProdTimeDepdntStockLvl>#execute
     *         execute} method on the request builder object.
     */
    @Nonnull
    UpdateRequestBuilder<ProdTimeDepdntStockLvl>
        updateProdTimeDepdntStockLvl( @Nonnull final ProdTimeDepdntStockLvl prodTimeDepdntStockLvl );

}
